#!/usr/bin/perl

use strict;
use warnings;
use encoding 'utf8';
use VASM::Message;
local $\ = "\n";

# For convenience
package VASM::Message;

# identifyQuantity
print identifyQuantity(4, Paucal => qr/[2-4]$/);

# validateProperties
print validateProperties(Locale =>
                           { Language => 'hi',
                             Country => 'IN',
                             Quantity => 'Plural' });
print validateProperties(Locale =>
                           { Language => 'th',
                             Quantity => 'Singular' },
                         Fields =>
                           { Language => 1,
                             Quantity => undef });

# orderLocale
print join(' ', orderLocale(Quantity => 'Plural',
                            Language => 'hi'));

# findLocale
print findLocale;
