# -*- project-name: VASM -*-
package VASM::Resources::Actions;

use strict;
use warnings;
use base qw/Exporter/;
use VASM::Actions;
use VASM::Resources qw/findConfigResource/;

our @EXPORT_OK = qw/findActionsCatalog/;
our $VERSION = '1.0';
my $prefix = 'Actions';
my $catalogName = 'Actions.xml';

sub findActionsCatalog {
  # We need a full MIME type, at least. An action may follow
  return unless @_ >= 2; # e.g., qw/text html/

  # This is set up a little differently from VASM::Resources::Messages.
  # Whereas that module looks under an arbitrary resource path followed by a
  # suffix, here we use a prefix, whose following elements are a MIME type,
  # and, optionally, an action.
  my @path = ($prefix, @_);

  # Now look for the first file that matches this resource configuration. The
  # limit is 3, taking into account the prefix and the mime type. The search
  # for a given mime type and action will fall back on 
  my $file = (findConfigResource(Path => [ @path ],
                                 Limit => 3,
                                 File => $catalogName))[0];
  
  return unless $file; # Return nothing unless a file was found, otherwise:
  return VASM::Actions->new($file); # Digest file and return the new catalog
}

1;

__END__
