# -*- project-name: VASM -*-
package VASM::Error;

use strict;
use warnings;
use base qw/VASM::Message/;
use Carp qw/cluck/;
$Carp::CarpLevel = 1;

sub Croak {
  my ($self, %args) = @_;

  croak $self->Render(%args);
}

sub Confess {
  my ($self, %args) = @_;
  
  confess $self->Render(%args);
}

sub Carp {
  my ($self, %args) = @_;
  
  carp $self->Render(%args);

  return;
}

sub Cluck {
  my ($self, %args) = @_;
  
  cluck $self->Render(%args);

  return;
}

1;

__END__

=head1 NAME

VASM::Error - an object-oriented vene^H^H^H^Hwrapper for Carp

=head1 SYNOPSIS

=head1 DESCRIPTION

VASM::Error inherits from VASM::Message, inheriting the same facilities for
i18n-ized message translation for use in error reporting with the venerable
Carp module. All methods are, therefore, essentially the same, but Croak,
Confess, Carp, and Cluck, which correspond to the traditional procedural
functions of the same name in Carp.

=head1 METHODS

=head1 AUTHORS

hanumizzle L<mailto:hanumizzle@gmail.com> wrote VASM::Error.

=cut
