# -*- project-name: VASM -*-
package VASM::Actions;

use strict;
use warnings;
use XML::Parser;

our $VERSION = '1.0';

sub new {
  my ($self) = @_;
  my $instance = []; # Commands pushed and popped using arrayref

  return bless $instance, $self;
}

# Add another command string to the end of the actions list
sub Push {
  my ($self, $command) = @_;

  push @{ $self }, $command;
  return;
}

# Remove a command string from the end of the actions list
sub Pop {
  my ($self) = @_;
  
  pop @{ $self };
  return;
}

# It is expected that each string in the actions catalog will receive the same
# arguments, in the same order. It is not the job of Render to check the
# veracity of command lines it generates, just to produce them. 
sub Render {
  my ($self, @args) = @_;

  # Render each command string, assuming some exist!
  return map { sprintf $_, @args } @{ $self }
    if scalar @{ $self };

  return;
}

# Just return the contents of the instance
sub Dump {
  my ($self) = @_;
  
  return @{ $self };
}

sub Parse {
  my ($self, $file) = @_;
  # If this fails, XML::Parser will emit an error message and end the program.
  # Unfortunately, this message is always English. :( There is at least an
  # error context, which can be universally understood by the programmer.
  my $parser = XML::Parser->new(Style => 'Tree', ErrorContext => 3);
  my $tree = $parser->parsefile($file); my $tags = $tree->[1];
  
  # Iterate through tags under <actions>
  for my $index (grep { $_ % 2 } (0..$#{ $tags })) {
    next if $tags->[$index] eq '0'; # Skip text elements 

    # Otherwise, it /has to be/ a command string. Return if it does not
    # contain a text string or holds no content
    return unless $tags->[$index + 1]->[1] eq '0'
      and defined $tags->[$index + 1]->[2];

    # Push the new member then
    $self->Push($tags->[$index + 1]->[2]);
  }

  return 1; # Success!
}

1;

__END__

=head1 NAME

VASM::Actions

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head1 AUTHORS

hanumizzle L<hanumizzle@gmail.com> wrote VASM::Actions.

=cut

