# -*- project-name: VASM -*-
package VASM::Tree;

use strict;
use warnings;
# use encoding 'utf8';
use Tie::Hash::Indexed;

sub new {
  my ($self) = @_;
  
  my $root = {}; tie %{ $root }, 'Tie::Hash::Indexed';
  return bless { Root => $root }, $self;
}

sub Store {
  # Indices should be self-explanatory be now; $datum is the object to be
  # stored.
  my ($self, $datum, @indices) = (shift, pop, @_);

  scalar @indices
    and nodeTraverse($self->{Root}, @indices)->{Datum} = $datum;
  
  return; # This is a true subroutine...
}

sub Retrieve {
  my ($self, @indices) = @_;

  scalar @indices # Just run through @indices and return the datum
    and return nodeTraverse($self->{Root}, @indices)->{Datum};

  return; # Return nothing if the above falls through.
}

sub Delete {
  my ($self, @indices) = @_;

  undef %{ nodeTraverse($self->{Root}, @indices) };

  return; # Likewise a subroutine...
}

# "Do I want one? God forbiddee!" -- Ogden Nash
sub Children {
  my ($self, @indices) = @_;

  # If @indices is empty, this gets the children at the root 
  return keys %{ nodeTraverse($self->{Root}, @indices)->{Children} };
}

sub nodeTraverse {
  my ($node, @indices) = @_;    # The @indices through which we will traverse

  # If there were no arguments, just return the node that was passed in.
  return $node unless @indices;

  # Traverse through the tree of nodes, dynamically creating new ones if
  # necessary.
  for my $index (@indices) {
    # Create a new Children node if necessary, but make it an instance of
    # Tie::Hash::Indexed
    tie %{ $node->{Children} = {} }, 'Tie::Hash::Indexed'
      unless defined $node->{Children};
    # Also create a new container node
    $node->{Children}->{$index} = {}
      unless defined $node->{Children}->{$index};
    
    $node = $node->{Children}->{$index};
  }

  return $node;
}

1;

__END__

=head1 NAME

VASM::Tree - simple abstracted support for trees of hashrefs

=head1 SYNOPSIS

(Write me.)

=head1 DESCRIPTION

An instance of VASM::Tree defines a tree of hashrefs in which one may
transparently store and retrieve elements with no direct obligation to
allocate new nodes in the tree. Moreover, VASM::Tree uses nodes tied to
Tie::Hash::Indexed, so the trees maintains the order of itse elements at any
given level in the tree.

=cut
