#!/bin/bash

### gentags.sh generates an Emacs tags file for all of the Perl files under a
### given directory, ensuring that all pathnames are absolute for easy use
### throughout a system.

### Establish some defaults
PREDICATE_DIR=$(pwd)            # The directory containing the Perl project
TAGS_FILE=TAGS                  # The name of the output tags file

### Use `getopts' to process command line
while getopts ":o:C:" option; do
  case $option in
    o) TAGS_FILE=$OPTARG ;;     # 'o' for 'output'
    C) PREDICATE_DIR=$OPTARG ;; # 'C' for 'Change directory'
    \?)                         # A shit option was given to gentags.sh
      echo "$0: Invalid argument to gentags.sh!"
      echo "$0: usage: gentags.sh [-o OutputTagsFile] [-C TagsDirectory]"
      exit 1 ;;
  esac
done

### Sanity checks 'n' processing

## Make sure $PREDICATE_DIR exists
if [[ ! -d $PREDICATE_DIR ]]; then
  echo "$0: Directory does not exist or file is not a directory!"
fi

# Now make sure the directory component of the new $TAGS_FILE exists and is
# writable
if [[ ! -d $(dirname $TAGS_FILE) ]]; then
  echo "$0: Destination directory for tags file does not exist!"
fi

if [[ ! -w $(dirname $TAGS_FILE) ]]; then
  echo "$0: Destination directory for tags file is not writable!"
fi

## Rewrite $PREDICATE_DIR so that it is an absolute pathname, if necessary
if [[ ! $PREDICATE_DIR =~ "^/" ]]; then
  export PREDICATE_DIR                    # To use PREDICATE_DIR in a subshell
  PREDICATE_DIR=$(cd $PREDICATE_DIR; pwd) # pwnt
fi

### Make the tags file now. I configured it to match global variables defined
### with 'our' because etags is apparently outdated. :evil:
etags --regex='{perl}/our[ \t]*[\$@%]\([^ \t]*\)/\1/' \
  -o $TAGS_FILE \
  $(find $PREDICATE_DIR | perl -wnle 'print if m!\.(?:xs|pm|pl)$!i')
