/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.limewire.listener.Event;
import org.limewire.listener.EventListener;
import org.limewire.listener.WeakEventListenerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakEventListenerList<E extends Event>
implements WeakEventListenerSupport<E> {
    private final Map<Object, List<EventListener<E>>> listenerMap = new WeakHashMap<Object, List<EventListener<E>>>();

    @Override
    public void addListener(Object object, EventListener<E> eventListener) {
        List<EventListener<EventListener<E>>> list = this.listenerMap.get(object);
        if (list == null) {
            list = new ArrayList<EventListener<E>>();
        }
        list.add(eventListener);
    }

    @Override
    public boolean removeListener(Object object, EventListener<E> eventListener) {
        List<EventListener<E>> list = this.listenerMap.get(object);
        if (list != null) {
            list.remove(eventListener);
            if (list.isEmpty()) {
                this.listenerMap.remove(object);
            }
            return true;
        }
        return false;
    }

    public void broadcast(E e) {
        for (List<EventListener<E>> list : this.listenerMap.values()) {
            if (list == null) continue;
            for (EventListener<E> eventListener : list) {
                eventListener.handleEvent(e);
            }
        }
    }
}

