/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import org.apache.commons.logging.Log;
import org.limewire.listener.BroadcastPolicy;
import org.limewire.listener.CachingEventMulticaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingEventMulticasterImpl<E>
implements CachingEventMulticaster<E> {
    private final EventListenerList.EventListenerListContext listenerContext;
    private final EventMulticaster<E> multicaster;
    private final BroadcastPolicy broadcastPolicy;
    private final Object LOCK = new Object();
    private volatile E cachedEvent;

    public CachingEventMulticasterImpl() {
        this(BroadcastPolicy.ALWAYS, new EventMulticasterImpl());
    }

    public CachingEventMulticasterImpl(Log log) {
        this(BroadcastPolicy.ALWAYS, log);
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy) {
        this(broadcastPolicy, new EventMulticasterImpl());
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy, Log log) {
        this(broadcastPolicy, new EventMulticasterImpl(log));
    }

    public CachingEventMulticasterImpl(BroadcastPolicy broadcastPolicy, EventMulticaster<E> eventMulticaster) {
        this.broadcastPolicy = broadcastPolicy;
        this.multicaster = eventMulticaster;
        this.listenerContext = eventMulticaster.getListenerContext();
    }

    @Override
    public void addListener(EventListener<E> eventListener) {
        E e = this.cachedEvent;
        if (e != null) {
            EventListenerList.dispatch(eventListener, e, this.listenerContext);
        }
        this.multicaster.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.multicaster.removeListener(eventListener);
    }

    @Override
    public void handleEvent(E e) {
        this.broadcast(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(E e) {
        assert (this.eventConsistentWithBroadcastPolicy(e));
        boolean bl = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cachedEvent == null || this.broadcastPolicy == BroadcastPolicy.ALWAYS || !this.cachedEvent.equals(e)) {
                this.cachedEvent = e;
                bl = true;
            }
        }
        if (bl) {
            this.multicaster.broadcast(e);
        }
    }

    private boolean eventConsistentWithBroadcastPolicy(E e) {
        return this.broadcastPolicy == BroadcastPolicy.ALWAYS || e.getClass().isEnum() || System.identityHashCode(e) != e.hashCode();
    }

    @Override
    public E getLastEvent() {
        return this.cachedEvent;
    }

    @Override
    public EventListenerList.EventListenerListContext getListenerContext() {
        return this.listenerContext;
    }
}

