/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListeningFutureDelegator<S, R>
implements ListeningFuture<R> {
    private final ListeningFuture<S> delegate;
    private final EventListenerList.EventListenerListContext listenerContext;

    public ListeningFutureDelegator(ListeningFuture<S> listeningFuture) {
        this.delegate = listeningFuture;
        this.listenerContext = new EventListenerList.EventListenerListContext();
    }

    @Override
    public void addFutureListener(final EventListener<FutureEvent<R>> eventListener) {
        if (this.isDone()) {
            EventListenerList.dispatch(eventListener, FutureEvent.createEvent(this), this.listenerContext);
        } else {
            this.delegate.addFutureListener(new EventListener<FutureEvent<S>>(){

                @Override
                public void handleEvent(FutureEvent<S> futureEvent) {
                    EventListenerList.dispatch(eventListener, FutureEvent.createEvent(ListeningFutureDelegator.this), ListeningFutureDelegator.this.listenerContext);
                }
            });
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.delegate.cancel(bl);
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        Object v;
        try {
            v = this.delegate.get();
        }
        catch (ExecutionException executionException) {
            return this.convertException(executionException);
        }
        return this.convertSource(v);
    }

    @Override
    public R get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object v;
        try {
            v = this.delegate.get(l, timeUnit);
        }
        catch (ExecutionException executionException) {
            return this.convertException(executionException);
        }
        return this.convertSource(v);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    protected abstract R convertSource(S var1) throws ExecutionException;

    protected abstract R convertException(ExecutionException var1) throws ExecutionException;
}

