/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.handler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.http.handler.MimeTypeProvider;

public class BasicMimeTypeProvider
implements MimeTypeProvider {
    private final Map<String, String> mimeTypeByExtension = Collections.synchronizedMap(new HashMap());
    private final String defaultMimeType;

    public BasicMimeTypeProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMimeType = string;
        this.addMimeTypeByExtension("css", "text/css");
        this.addMimeTypeByExtension("gif", "image/gif");
        this.addMimeTypeByExtension("ico", "image/x-icon");
        this.addMimeTypeByExtension("jpg", "image/jpg");
        this.addMimeTypeByExtension("png", "image/png");
        this.addMimeTypeByExtension("htm", "text/html");
        this.addMimeTypeByExtension("html", "text/html");
        this.addMimeTypeByExtension("img", "image/gif");
        this.addMimeTypeByExtension("js", "application/x-javascript");
    }

    public BasicMimeTypeProvider() {
        this("application/octet-stream");
    }

    public void addMimeTypeByExtension(String string, String string2) {
        this.mimeTypeByExtension.put(string, string2);
    }

    public void removeMimeTypeByExtension(String string) {
        this.mimeTypeByExtension.remove(string);
    }

    public String getMimeType(File file) {
        String string = this.mimeTypeByExtension.get(this.getExtension(file));
        return string != null ? string : this.defaultMimeType;
    }

    private String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        return n != -1 ? string.substring(n + 1) : string;
    }
}

