/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.limewire.util.BufferUtils;

public class ByteBufferInputStream
extends InputStream {
    private static final ByteBuffer[] EMPTY = new ByteBuffer[0];
    protected int index = 0;
    protected int mark = -1;
    protected ByteBuffer[] buffers;

    public ByteBufferInputStream(ByteBuffer ... byteBufferArray) {
        this.buffers = byteBufferArray;
    }

    public ByteBuffer[] getBuffers() {
        if (this.buffers == EMPTY) {
            throw new IllegalStateException("InputStream is closed");
        }
        return this.buffers;
    }

    public int available() {
        int n = 0;
        for (int i = this.buffers.length - 1; i >= this.index; --i) {
            n += this.buffers[i].remaining();
        }
        return n;
    }

    public void close() {
        this.index = 0;
        this.mark = -1;
        this.buffers = EMPTY;
    }

    public void mark(int n) {
        if (this.index < this.buffers.length) {
            this.mark = this.index;
            for (int i = this.buffers.length - 1; i >= this.mark; --i) {
                this.buffers[i].mark();
            }
        }
    }

    public void reset() {
        if (this.mark != -1) {
            this.index = this.mark;
            for (int i = this.buffers.length - 1; i >= this.index; --i) {
                this.buffers[i].reset();
            }
            this.mark = -1;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        while (this.index < this.buffers.length) {
            ByteBuffer byteBuffer = this.buffers[this.index];
            if (byteBuffer.hasRemaining()) {
                return byteBuffer.get() & 0xFF;
            }
            ++this.index;
        }
        return -1;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.index >= this.buffers.length) {
            return -1;
        }
        if (this.index == this.buffers.length - 1 && !this.buffers[this.index].hasRemaining()) {
            return -1;
        }
        if (n2 == 0 || byArray.length == 0) {
            return this.available() > 0 ? 0 : -1;
        }
        int n3 = 0;
        while (this.index < this.buffers.length) {
            ByteBuffer byteBuffer = this.buffers[this.index];
            int n4 = Math.min(byteBuffer.remaining(), n2 - n3);
            byteBuffer.get(byArray, n + n3, n4);
            if ((n3 += n4) == n2) break;
            ++this.index;
        }
        return n3 > 0 ? n3 : -1;
    }

    public long skip(long l) {
        long l2 = 0L;
        while (this.index < this.buffers.length) {
            ByteBuffer byteBuffer = this.buffers[this.index];
            long l3 = Math.min((long)byteBuffer.remaining(), l - l2);
            byteBuffer.position(byteBuffer.position() + (int)l3);
            if ((l2 += l3) == l) break;
            ++this.index;
        }
        return l2;
    }

    public long read(ByteBuffer byteBuffer) {
        long l = 0L;
        while (this.index < this.buffers.length) {
            ByteBuffer byteBuffer2 = this.buffers[this.index];
            if (byteBuffer2.hasRemaining()) {
                l += (long)BufferUtils.transfer((ByteBuffer)byteBuffer2, (ByteBuffer)byteBuffer, (boolean)false);
            }
            if (!byteBuffer.hasRemaining()) break;
            ++this.index;
        }
        return l;
    }

    public ByteBuffer bufferFor(int n) {
        ByteBuffer byteBuffer = null;
        while (this.index < this.buffers.length && !this.buffers[this.index].hasRemaining()) {
            ++this.index;
        }
        if (this.index < this.buffers.length) {
            n = Math.min(n, this.available());
            ByteBuffer byteBuffer2 = this.buffers[this.index];
            if (byteBuffer2.remaining() >= n) {
                int n2 = byteBuffer2.limit();
                byteBuffer2.limit(byteBuffer2.position() + n);
                byteBuffer = byteBuffer2.slice();
                byteBuffer2.limit(n2);
                byteBuffer2.position(byteBuffer2.position() + n);
            } else {
                byteBuffer = ByteBuffer.allocate(n);
                this.read(byteBuffer);
                byteBuffer.flip();
            }
        } else {
            byteBuffer = BufferUtils.getEmptyBuffer();
        }
        return byteBuffer;
    }
}

