/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

public class BandwidthThrottle {
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int _bytesPerTick;
    private volatile boolean _switching = false;
    private int _availableBytes;
    private long _nextTickTime;

    public BandwidthThrottle(float f) {
        this.setRate(f);
    }

    public BandwidthThrottle(float f, boolean bl) {
        this.setRate(f);
        this.setSwitching(bl);
    }

    public void setRate(float f) {
        this._bytesPerTick = (int)(f / 10.0f);
        if (this._switching) {
            this.fixBytesPerTick(true);
        }
    }

    public void setSwitching(boolean bl) {
        if (this._switching != bl) {
            this.fixBytesPerTick(bl);
        }
        this._switching = bl;
    }

    private void fixBytesPerTick(boolean bl) {
        int n = this._bytesPerTick;
        n = bl ? (n *= 2) : (n /= 2);
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        this._bytesPerTick = n;
    }

    public synchronized int request(int n) {
        this.waitForBandwidth();
        int n2 = Math.min(n, this._availableBytes);
        this._availableBytes -= n2;
        return n2;
    }

    private void waitForBandwidth() {
        while (true) {
            long l = System.currentTimeMillis();
            this.updateWindow(l);
            if (this._availableBytes != 0) break;
            try {
                Thread.sleep(this._nextTickTime - l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateWindow(long l) {
        if (l >= this._nextTickTime) {
            if (!this._switching || l / 1000L % 2L == 0L) {
                this._availableBytes = this._bytesPerTick;
                this._nextTickTime = l + 100L;
            } else {
                this._availableBytes = 0;
                long l2 = 1000L - l % 1000L;
                this._nextTickTime = l + l2;
            }
        }
    }
}

