/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.pf.file.FileHandler;
import org.pf.file.FileLocator;
import org.pf.file.FileWalker;

public class FileFinder
implements FileHandler {
    private List collectedFiles = null;

    protected List getCollectedFiles() {
        return this.collectedFiles;
    }

    protected void setCollectedFiles(List list) {
        this.collectedFiles = list;
    }

    protected FileFinder() {
        this.setCollectedFiles(new ArrayList());
    }

    public static File findFileOnClasspath(String string) {
        ClassLoader classLoader = null;
        File file = null;
        URL uRL = null;
        try {
            classLoader = FileFinder.class.getClassLoader();
            if (classLoader == null) {
                return null;
            }
            uRL = classLoader.getResource(string);
            if (uRL != null && !FileFinder.fileExists(file = new File(uRL.getFile()))) {
                file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static File findFile(String string) {
        File file = null;
        file = new File(string);
        if (FileFinder.fileExists(file)) {
            return file;
        }
        file = FileFinder.findFileOnClasspath(string);
        return file;
    }

    public static File[] findFiles(String string, String string2) {
        return FileFinder.findFiles(string, string2, true);
    }

    public static File[] findFiles(String string, String string2, boolean bl) {
        return FileFinder.findFiles(string, string2, bl, '\u0000');
    }

    public static File[] findFiles(String string, String string2, boolean bl, char c) {
        Character c2 = null;
        if (string == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): dir is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): pattern is null");
        }
        if (c > '\u0000') {
            c2 = new Character(c);
        }
        FileFinder fileFinder = new FileFinder();
        return fileFinder.collectFiles(string, string2, bl, c2);
    }

    private static boolean fileExists(File file) {
        boolean bl = false;
        if (file != null) {
            try {
                FileLocator fileLocator = FileLocator.create(file);
                bl = fileLocator.exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean handleFile(File file) {
        this.getCollectedFiles().add(file);
        return true;
    }

    public boolean handleException(Exception exception, File file) {
        return false;
    }

    public boolean directoryEnd(File file) {
        return true;
    }

    public boolean directoryStart(File file, int n) {
        return true;
    }

    protected File[] collectFiles(String string, String string2, boolean bl, Character c) {
        FileWalker fileWalker = new FileWalker(this);
        if (c != null) {
            fileWalker.setDigitWildcardChar(c.charValue());
        }
        fileWalker.walkThrough(string, string2, bl);
        List list = this.getCollectedFiles();
        return list.toArray(new File[list.size()]);
    }
}

