/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import com.aelitis.azureus.core.AzureusCore;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.utils.security.CertificateListener;
import org.gudy.azureus2.plugins.utils.security.PasswordListener;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SEPublicKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESTSConnectionImpl;

public class SESecurityManagerImpl
implements org.gudy.azureus2.plugins.utils.security.SESecurityManager {
    private AzureusCore core;
    private Map password_listeners = new HashMap();
    private Map certificate_listeners = new HashMap();

    public SESecurityManagerImpl(AzureusCore azureusCore) {
        this.core = azureusCore;
    }

    public byte[] calculateSHA1(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        SHA1Hasher sHA1Hasher = new SHA1Hasher();
        return sHA1Hasher.calculateHash(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithAuthenticator(Authenticator authenticator, Runnable runnable) {
        try {
            Authenticator.setDefault(authenticator);
            runnable.run();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SESecurityManager.installAuthenticator();
            throw throwable;
        }
        SESecurityManager.installAuthenticator();
    }

    public void addPasswordListener(final PasswordListener passwordListener) {
        SEPasswordListener sEPasswordListener = new SEPasswordListener(){

            public PasswordAuthentication getAuthentication(String string, URL uRL) {
                return passwordListener.getAuthentication(string, uRL);
            }

            public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
                passwordListener.setAuthenticationOutcome(string, uRL, bl);
            }

            public void clearPasswords() {
            }
        };
        this.password_listeners.put(passwordListener, sEPasswordListener);
        SESecurityManager.addPasswordListener(sEPasswordListener);
    }

    public void removePasswordListener(PasswordListener passwordListener) {
        SEPasswordListener sEPasswordListener = (SEPasswordListener)this.password_listeners.get(passwordListener);
        if (sEPasswordListener != null) {
            SESecurityManager.removePasswordListener(sEPasswordListener);
        }
    }

    public void addCertificateListener(final CertificateListener certificateListener) {
        SECertificateListener sECertificateListener = new SECertificateListener(){

            public boolean trustCertificate(String string, X509Certificate x509Certificate) {
                return certificateListener.trustCertificate(string, x509Certificate);
            }
        };
        this.certificate_listeners.put(certificateListener, sECertificateListener);
        SESecurityManager.addCertificateListener(sECertificateListener);
    }

    public void removeCertificateListener(CertificateListener certificateListener) {
        SECertificateListener sECertificateListener = (SECertificateListener)this.certificate_listeners.get(certificateListener);
        if (sECertificateListener != null) {
            SESecurityManager.removeCertificateListener(sECertificateListener);
        }
    }

    public SSLSocketFactory installServerCertificate(URL uRL) {
        return SESecurityManager.installServerCertificates(uRL);
    }

    public KeyStore getKeyStore() throws Exception {
        return SESecurityManager.getKeyStore();
    }

    public KeyStore getTrustStore() throws Exception {
        return SESecurityManager.getTrustStore();
    }

    public Certificate createSelfSignedCertificate(String string, String string2, int n) throws Exception {
        return SESecurityManager.createSelfSignedCertificate(string, string2, n);
    }

    public byte[] getIdentity() {
        return this.core.getCryptoManager().getSecureID();
    }

    public SEPublicKey getPublicKey(int n, String string) throws Exception {
        byte[] byArray = this.core.getCryptoManager().getECCHandler().getPublicKey(string);
        return new SEPublicKeyImpl(n, byArray);
    }

    public SEPublicKey decodePublicKey(byte[] byArray) {
        return SEPublicKeyImpl.decode(byArray);
    }

    public GenericMessageConnection getSTSConnection(GenericMessageConnection genericMessageConnection, SEPublicKey sEPublicKey, SEPublicKeyLocator sEPublicKeyLocator, String string, int n) throws Exception {
        return new SESTSConnectionImpl(this.core, (GenericMessageConnectionImpl)genericMessageConnection, sEPublicKey, sEPublicKeyLocator, string, n);
    }
}

