/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.LocaleDecoder;
import org.gudy.azureus2.plugins.utils.LocaleListener;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleDecoderImpl;

public class LocaleUtilitiesImpl
implements LocaleUtilities {
    private PluginInterface pi;
    private List listeners;

    public LocaleUtilitiesImpl(PluginInterface pluginInterface) {
        this.pi = pluginInterface;
    }

    public void integrateLocalisedMessageBundle(String string) {
        MessageText.integratePluginMessages(string, this.pi.getPluginClassLoader());
    }

    public void integrateLocalisedMessageBundle(ResourceBundle resourceBundle) {
        MessageText.integratePluginMessages(resourceBundle);
    }

    public void integrateLocalisedMessageBundle(Properties properties) {
        PropertyResourceBundle propertyResourceBundle = null;
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            properties.store(pipedOutputStream, "");
            pipedOutputStream.close();
            propertyResourceBundle = new PropertyResourceBundle(pipedInputStream);
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        this.integrateLocalisedMessageBundle(propertyResourceBundle);
    }

    public String getLocalisedMessageText(String string) {
        return MessageText.getString(string);
    }

    public String getLocalisedMessageText(String string, String[] stringArray) {
        return MessageText.getString(string, stringArray);
    }

    public boolean hasLocalisedMessageText(String string) {
        return MessageText.keyExists(string);
    }

    public String localise(String string) {
        String string2 = MessageText.getString(string);
        if (string2.charAt(0) == '!' && !MessageText.keyExists(string)) {
            return null;
        }
        return string2;
    }

    public Locale getCurrentLocale() {
        return MessageText.getCurrentLocale();
    }

    public LocaleDecoder[] getDecoders() {
        LocaleUtilDecoder[] localeUtilDecoderArray = LocaleUtil.getSingleton().getDecoders();
        LocaleDecoder[] localeDecoderArray = new LocaleDecoder[localeUtilDecoderArray.length];
        for (int i = 0; i < localeDecoderArray.length; ++i) {
            localeDecoderArray[i] = new LocaleDecoderImpl(localeUtilDecoderArray[i]);
        }
        return localeDecoderArray;
    }

    public void addListener(LocaleListener localeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            COConfigurationManager.addParameterListener("locale.set.complete.count", new ParameterListener(){

                public void parameterChanged(String string) {
                    for (int i = 0; i < LocaleUtilitiesImpl.this.listeners.size(); ++i) {
                        try {
                            ((LocaleListener)LocaleUtilitiesImpl.this.listeners.get(i)).localeChanged(MessageText.getCurrentLocale());
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            });
        }
        this.listeners.add(localeListener);
    }

    public void removeListener(LocaleListener localeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(localeListener);
    }
}

