/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;

public class ShareTester
implements Plugin,
PluginListener,
ShareManagerListener {
    protected static AESemaphore init_sem = new AESemaphore("ShareTester");
    private static AEMonitor class_mon = new AEMonitor("ShareTester");
    protected static ShareTester singleton;
    protected Map seed_transport_map = new HashMap();
    protected PluginInterface plugin_interface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareTester getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser "){

                    public void runSupport() {
                        PluginManager.registerPlugin(ShareTester.class);
                        Properties properties = new Properties();
                        properties.put("MULTI_INSTANCE", "true");
                        PluginManager.startAzureus(1, properties);
                    }
                }.start();
                init_sem.reserve();
            }
            ShareTester shareTester = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return shareTester;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        singleton = this;
        init_sem.release();
        LoggerChannel loggerChannel = this.plugin_interface.getLogger().getChannel("Plugin Test");
        loggerChannel.log(1, "Plugin Initialised");
        this.plugin_interface.addListener(this);
    }

    public void initializationComplete() {
        try {
            DownloadManager downloadManager = this.plugin_interface.getDownloadManager();
            downloadManager.addListener(new DownloadManagerListener(){

                public void downloadAdded(final Download download) {
                    System.out.println("downloadAdded: " + download);
                    download.addListener(new DownloadListener(){

                        public void stateChanged(Download download2, int n, int n2) {
                            System.out.println("statechange:" + n + "-> " + n2 + "  (" + download + ")");
                        }

                        public void positionChanged(Download download2, int n, int n2) {
                            System.out.println("statechange:" + n + "-> " + n2 + "  (" + download2 + ")");
                        }
                    });
                    download.addTrackerListener(new DownloadTrackerListener(){

                        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
                            System.out.println("scrapeResult:" + downloadScrapeResult.getSeedCount() + "/" + downloadScrapeResult.getNonSeedCount());
                        }

                        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
                            if (downloadAnnounceResult.getResponseType() == 1) {
                                System.out.println("announceResult:" + downloadAnnounceResult.getReportedPeerCount() + "/" + downloadAnnounceResult.getSeedCount() + "/" + downloadAnnounceResult.getNonSeedCount());
                            } else {
                                System.out.println("announceResult:" + downloadAnnounceResult.getError());
                            }
                        }
                    });
                    download.addPeerListener(new DownloadPeerListener(){

                        public void peerManagerAdded(Download download, PeerManager peerManager) {
                            peerManager.addListener(new PeerManagerListener(){

                                public void peerAdded(PeerManager peerManager, Peer peer) {
                                    System.out.println("peerAdded:" + peer.getIp());
                                }

                                public void peerRemoved(PeerManager peerManager, Peer peer) {
                                    System.out.println("peerRemoved:" + peer.getIp());
                                }
                            });
                        }

                        public void peerManagerRemoved(Download download, PeerManager peerManager) {
                        }
                    });
                }

                public void downloadRemoved(Download download) {
                    System.out.println("downloadRemoved" + download);
                }
            });
            ShareManager shareManager = this.plugin_interface.getShareManager();
            shareManager.addListener(this);
            shareManager.initialise();
        }
        catch (ShareException shareException) {
            Debug.printStackTrace(shareException);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }

    public void resourceAdded(ShareResource shareResource) {
        System.out.println("resource added:" + shareResource.getName());
        if (shareResource.getType() == 3) {
            ShareResourceDirContents shareResourceDirContents = (ShareResourceDirContents)shareResource;
            ShareResource[] shareResourceArray = shareResourceDirContents.getChildren();
            for (int i = 0; i < shareResourceArray.length; ++i) {
                System.out.println("\t" + shareResourceArray[i].getName());
            }
        }
    }

    public void resourceModified(ShareResource shareResource, ShareResource shareResource2) {
        System.out.println("resource modified:" + shareResource.getName());
    }

    public void resourceDeleted(ShareResource shareResource) {
        System.out.println("resource deleted:" + shareResource.getName());
    }

    public void reportProgress(int n) {
    }

    public void reportCurrentTask(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        ShareTester.getSingleton();
    }
}

