/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.nat.NATTraverser;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMessageConnectionIndirect
implements GenericMessageConnectionAdapter {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final boolean TRACE = false;
    public static final int MAX_MESSAGE_SIZE = 32768;
    private static final int MESSAGE_TYPE_CONNECT = 1;
    private static final int MESSAGE_TYPE_ERROR = 2;
    private static final int MESSAGE_TYPE_DATA = 3;
    private static final int MESSAGE_TYPE_DISCONNECT = 4;
    private static final int TICK_PERIOD = 5000;
    private static final int KEEP_ALIVE_CHECK_PERIOD = 5000;
    private static final int KEEP_ALIVE_MIN = 10000;
    private static final int STATS_PERIOD = 60000;
    private static final int KEEP_ALIVE_CHECK_TICKS = 1;
    private static final int STATS_TICKS = 12;
    private static final int MAX_REMOTE_CONNECTIONS = 1024;
    private static final int MAX_REMOTE_CONNECTIONS_PER_IP = 32;
    private static long connection_id_next = new Random().nextLong();
    private static Map local_connections = new HashMap();
    private static Map remote_connections = new HashMap();
    private static ThreadPool keep_alive_pool = new ThreadPool("GenericMessageConnectionIndirect:keepAlive", 8, true);
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpoint endpoint;
    private NATTraverser nat_traverser;
    private GenericMessageConnectionImpl owner;
    private InetSocketAddress rendezvous;
    private InetSocketAddress target;
    private long connection_id;
    private boolean incoming;
    private boolean closed;
    private LinkedList<byte[]> send_queue = new LinkedList();
    private AESemaphore send_queue_sem = new AESemaphore("GenericMessageConnectionIndirect:sendq");
    private volatile long last_message_sent;
    private volatile long last_message_received;
    private volatile boolean keep_alive_in_progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map receive(MessageManagerImpl messageManagerImpl, InetSocketAddress inetSocketAddress, Map map) {
        GenericMessageConnectionIndirect genericMessageConnectionIndirect;
        if (!map.containsKey("type")) {
            return null;
        }
        int n = ((Long)map.get("type")).intValue();
        if (n == 1) {
            String string = new String((byte[])map.get("msg_id"));
            String string2 = new String((byte[])map.get("msg_desc"));
            GenericMessageEndpointImpl genericMessageEndpointImpl = new GenericMessageEndpointImpl(inetSocketAddress);
            genericMessageEndpointImpl.addUDP(inetSocketAddress);
            GenericMessageHandler genericMessageHandler = messageManagerImpl.getHandler(string);
            if (genericMessageHandler == null) {
                Debug.out("No message handler registered for '" + string + "'");
                return null;
            }
            try {
                Long l;
                Object object = remote_connections;
                synchronized (object) {
                    if (remote_connections.size() >= 1024) {
                        Debug.out("Maximum remote connections exceeded - request from " + inetSocketAddress + " denied [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                        return null;
                    }
                    int n2 = 0;
                    for (Object object2 : remote_connections.values()) {
                        if (!((GenericMessageConnectionIndirect)object2).getEndpoint().getNotionalAddress().getAddress().equals(inetSocketAddress.getAddress())) continue;
                        ++n2;
                    }
                    if (n2 >= 32) {
                        Debug.out("Maximum remote connections per-ip exceeded - request from " + inetSocketAddress + " denied [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                        return null;
                    }
                    l = new Long(connection_id_next++);
                }
                object = new GenericMessageConnectionIndirect(messageManagerImpl, string, string2, genericMessageEndpointImpl, l);
                GenericMessageConnectionImpl genericMessageConnectionImpl = new GenericMessageConnectionImpl(messageManagerImpl, (GenericMessageConnectionAdapter)object);
                if (genericMessageHandler.accept(genericMessageConnectionImpl)) {
                    Object object2;
                    genericMessageConnectionImpl.accepted();
                    List<byte[]> list = remote_connections;
                    synchronized (list) {
                        remote_connections.put(l, object);
                    }
                    list = ((GenericMessageConnectionIndirect)object).receive((List)map.get("data"));
                    object2 = new HashMap();
                    object2.put("type", new Long(1L));
                    object2.put("con_id", l);
                    object2.put("data", list);
                    return object2;
                }
                return null;
            }
            catch (MessageException messageException) {
                Debug.out("Error accepting message", messageException);
                return null;
            }
        }
        if (n == 3) {
            GenericMessageConnectionIndirect genericMessageConnectionIndirect2;
            Long l = (Long)map.get("con_id");
            HashMap<String, Object> hashMap = remote_connections;
            synchronized (hashMap) {
                genericMessageConnectionIndirect2 = (GenericMessageConnectionIndirect)remote_connections.get(l);
            }
            if (genericMessageConnectionIndirect2 == null) {
                return null;
            }
            hashMap = new HashMap<String, Object>();
            if (genericMessageConnectionIndirect2.isClosed()) {
                hashMap.put("type", new Long(4L));
            } else {
                List<byte[]> list = genericMessageConnectionIndirect2.receive((List)map.get("data"));
                hashMap.put("type", new Long(3L));
                hashMap.put("data", list);
                if (genericMessageConnectionIndirect2.receiveIncomplete()) {
                    hashMap.put("more_data", new Long(1L));
                }
            }
            return hashMap;
        }
        Long l = (Long)map.get("con_id");
        Map map2 = remote_connections;
        synchronized (map2) {
            genericMessageConnectionIndirect = (GenericMessageConnectionIndirect)remote_connections.get(l);
        }
        if (genericMessageConnectionIndirect != null) {
            try {
                genericMessageConnectionIndirect.close(new Throwable("Remote closed connection"));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    protected static String getRemoteConnectionStatus() {
        return GenericMessageConnectionIndirect.getConnectionStatus(remote_connections);
    }

    protected static String getLocalConnectionStatus() {
        return GenericMessageConnectionIndirect.getConnectionStatus(local_connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getConnectionStatus(Map map) {
        HashMap<InetAddress, Integer> hashMap = new HashMap<InetAddress, Integer>();
        Object object = map;
        synchronized (object) {
            for (GenericMessageConnectionIndirect object2 : map.values()) {
                InetAddress inetAddress = object2.getEndpoint().getNotionalAddress().getAddress();
                Integer n = (Integer)hashMap.get(inetAddress);
                n = n == null ? new Integer(1) : new Integer(n + 1);
                hashMap.put(inetAddress, n);
            }
        }
        object = "";
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)object + (((String)object).length() == 0 ? "" : ",") + entry.getKey() + ":" + entry.getValue();
        }
        return object;
    }

    protected GenericMessageConnectionIndirect(MessageManagerImpl messageManagerImpl, String string, String string2, GenericMessageEndpoint genericMessageEndpoint, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        this.message_manager = messageManagerImpl;
        this.msg_id = string;
        this.msg_desc = string2;
        this.endpoint = genericMessageEndpoint;
        this.rendezvous = inetSocketAddress;
        this.target = inetSocketAddress2;
        this.nat_traverser = this.message_manager.getNATTraverser();
        GenericMessageConnectionIndirect.log("outgoing connection to " + this.endpoint.getNotionalAddress());
    }

    protected GenericMessageConnectionIndirect(MessageManagerImpl messageManagerImpl, String string, String string2, GenericMessageEndpoint genericMessageEndpoint, long l) {
        this.message_manager = messageManagerImpl;
        this.msg_id = string;
        this.msg_desc = string2;
        this.endpoint = genericMessageEndpoint;
        this.connection_id = l;
        this.incoming = true;
        this.last_message_received = SystemTime.getCurrentTime();
        GenericMessageConnectionIndirect.log("incoming connection from " + this.endpoint.getNotionalAddress());
    }

    @Override
    public void setOwner(GenericMessageConnectionImpl genericMessageConnectionImpl) {
        this.owner = genericMessageConnectionImpl;
    }

    @Override
    public int getMaximumMessageSize() {
        return 32768;
    }

    @Override
    public String getType() {
        return "Tunnel";
    }

    @Override
    public int getTransportType() {
        return 0;
    }

    public long getLastMessageReceivedTime() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_message_received) {
            this.last_message_received = l;
        }
        return this.last_message_received;
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void addInboundRateLimiter(RateLimiter rateLimiter) {
    }

    @Override
    public void removeInboundRateLimiter(RateLimiter rateLimiter) {
    }

    @Override
    public void addOutboundRateLimiter(RateLimiter rateLimiter) {
    }

    @Override
    public void removeOutboundRateLimiter(RateLimiter rateLimiter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ByteBuffer byteBuffer, GenericMessageConnectionAdapter.ConnectionListener connectionListener) {
        block10: {
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                arrayList.add(byArray);
                hashMap.put("type", new Long(1L));
                hashMap.put("msg_id", this.msg_id);
                hashMap.put("msg_desc", this.msg_desc);
                hashMap.put("data", arrayList);
                Map map = this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, hashMap);
                this.last_message_sent = SystemTime.getCurrentTime();
                if (map == null || !map.containsKey("type")) {
                    connectionListener.connectFailure(new Throwable("Indirect connect failed (response=" + map + ")"));
                    break block10;
                }
                int n = ((Long)map.get("type")).intValue();
                if (n == 2) {
                    connectionListener.connectFailure(new Throwable(new String((byte[])map.get("error"))));
                    break block10;
                }
                if (n == 4) {
                    connectionListener.connectFailure(new Throwable("Disconnected"));
                    break block10;
                }
                if (n == 1) {
                    this.connection_id = (Long)map.get("con_id");
                    Object object = local_connections;
                    synchronized (object) {
                        local_connections.put(new Long(this.connection_id), this);
                    }
                    connectionListener.connectSuccess();
                    object = (List)map.get("data");
                    for (int i = 0; i < object.size(); ++i) {
                        this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap((byte[])object.get(i))), false));
                    }
                    break block10;
                }
                Debug.out("Unexpected reply type - " + n);
                connectionListener.connectFailure(new Throwable("Unexpected reply type - " + n));
            }
            catch (Throwable throwable) {
                connectionListener.connectFailure(throwable);
            }
        }
    }

    @Override
    public void accepted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(PooledByteBuffer pooledByteBuffer) throws MessageException {
        byte[] byArray = pooledByteBuffer.toByteArray();
        if (this.incoming) {
            LinkedList<byte[]> linkedList = this.send_queue;
            synchronized (linkedList) {
                if (this.send_queue.size() > 64) {
                    throw new MessageException("Send queue limit exceeded");
                }
                this.send_queue.add(byArray);
            }
            this.send_queue_sem.release();
        } else {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            arrayList.add(byArray);
            this.send(arrayList);
        }
    }

    protected void send(List list) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("con_id", new Long(this.connection_id));
            hashMap.put("type", new Long(3L));
            hashMap.put("data", list);
            Map map = this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, hashMap);
            this.last_message_sent = SystemTime.getCurrentTime();
            if (map == null || !map.containsKey("type")) {
                this.owner.reportFailed(new Throwable("Indirect message send failed (response=" + map + ")"));
            } else {
                int n = ((Long)map.get("type")).intValue();
                if (n == 2) {
                    this.owner.reportFailed(new Throwable(new String((byte[])map.get("error"))));
                } else if (n == 3) {
                    List list2 = (List)map.get("data");
                    for (int i = 0; i < list2.size(); ++i) {
                        this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap((byte[])list2.get(i))), false));
                    }
                    if (map.get("more_data") != null) {
                        new DelayedEvent("GenMsg:kap", 500L, new AERunnable(){

                            public void runSupport() {
                                if (GenericMessageConnectionIndirect.this.prepareForKeepAlive(true)) {
                                    keep_alive_pool.run(new AERunnable(){

                                        public void runSupport() {
                                            GenericMessageConnectionIndirect.this.keepAlive();
                                        }
                                    });
                                }
                            }
                        });
                    }
                } else if (n == 4) {
                    this.owner.reportFailed(new Throwable("Disconnected"));
                }
            }
        }
        catch (Throwable throwable) {
            this.owner.reportFailed(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<byte[]> receive(List<byte[]> list) {
        this.last_message_received = SystemTime.getCurrentTime();
        for (int i = 0; i < list.size(); ++i) {
            this.owner.receive(new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(ByteBuffer.wrap(list.get(i))), false));
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (this.send_queue_sem.reserve(2500L)) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = this.getMaximumMessageSize();
            int n2 = 0;
            LinkedList<byte[]> linkedList = this.send_queue;
            synchronized (linkedList) {
                while (this.send_queue.size() > 0) {
                    byte[] byArray = this.send_queue.getFirst();
                    if (n2 > 0 && n2 + byArray.length > n) break;
                    arrayList.add(this.send_queue.removeFirst());
                    n2 += byArray.length;
                }
            }
            if (arrayList.size() == 0) {
                this.send_queue_sem.release();
            } else {
                for (int i = 1; i < arrayList.size(); ++i) {
                    this.send_queue_sem.reserve();
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean receiveIncomplete() {
        LinkedList<byte[]> linkedList = this.send_queue;
        synchronized (linkedList) {
            return this.send_queue.size() > 0;
        }
    }

    @Override
    public void close() throws MessageException {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Throwable throwable) throws MessageException {
        if (this.closed) {
            return;
        }
        GenericMessageConnectionIndirect.log("connection to " + this.endpoint.getNotionalAddress() + " closed" + (throwable == null ? "" : " (" + throwable + ")"));
        try {
            this.closed = true;
            if (this.incoming) {
                Map map = remote_connections;
                synchronized (map) {
                    remote_connections.remove(new Long(this.connection_id));
                }
            }
            HashMap<String, Long> hashMap = local_connections;
            synchronized (hashMap) {
                local_connections.remove(new Long(this.connection_id));
            }
            hashMap = new HashMap<String, Long>();
            hashMap.put("con_id", new Long(this.connection_id));
            hashMap.put("type", new Long(4L));
            try {
                this.nat_traverser.sendMessage(this.message_manager, this.rendezvous, this.target, hashMap);
                this.last_message_sent = SystemTime.getCurrentTime();
            }
            catch (Throwable throwable2) {
                throw new MessageException("Close operation failed", throwable2);
            }
            Object var6_7 = null;
            if (throwable != null) {
                this.owner.reportFailed(throwable);
            }
        }
        catch (Throwable throwable3) {
            Object var6_8 = null;
            if (throwable != null) {
                this.owner.reportFailed(throwable);
            }
            throw throwable3;
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected boolean prepareForKeepAlive(boolean bl) {
        if (this.keep_alive_in_progress) {
            return false;
        }
        long l = SystemTime.getCurrentTime();
        if (bl || l < this.last_message_sent || l - this.last_message_sent > 10000L) {
            this.keep_alive_in_progress = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepAlive() {
        try {
            this.send(new ArrayList());
            Object var2_1 = null;
            this.keep_alive_in_progress = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.keep_alive_in_progress = false;
            throw throwable;
        }
    }

    protected static void log(String string) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "GenericMessaging (indirect):" + string));
        }
    }

    protected void trace(String string) {
    }

    static {
        SimpleTimer.addPeriodicEvent("DDBTorrent:timeout2", 5000L, new TimerEventPerformer(){
            private int tick_count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                Object object2;
                ++this.tick_count;
                if (this.tick_count % 12 == 0 && Logger.isEnabled()) {
                    int n;
                    int n2;
                    object2 = local_connections;
                    synchronized (object2) {
                        n2 = local_connections.size();
                    }
                    object2 = remote_connections;
                    synchronized (object2) {
                        n = remote_connections.size();
                    }
                    if (n2 + n > 0) {
                        GenericMessageConnectionIndirect.log("local=" + n2 + " [" + GenericMessageConnectionIndirect.getLocalConnectionStatus() + "], remote=" + n + " [" + GenericMessageConnectionIndirect.getRemoteConnectionStatus() + "]");
                    }
                }
                if (this.tick_count % 1 == 0) {
                    Map map = local_connections;
                    synchronized (map) {
                        for (Object object2 : local_connections.values()) {
                            if (!((GenericMessageConnectionIndirect)object2).prepareForKeepAlive(false)) continue;
                            keep_alive_pool.run(new AERunnable((GenericMessageConnectionIndirect)object2){
                                final /* synthetic */ GenericMessageConnectionIndirect val$con;
                                {
                                    this.val$con = genericMessageConnectionIndirect;
                                }

                                public void runSupport() {
                                    this.val$con.keepAlive();
                                }
                            });
                        }
                    }
                    long l = SystemTime.getCurrentTime();
                    object2 = remote_connections;
                    synchronized (object2) {
                        if (remote_connections.size() > 0) {
                            for (GenericMessageConnectionIndirect genericMessageConnectionIndirect : new ArrayList(remote_connections.values())) {
                                long l2 = genericMessageConnectionIndirect.getLastMessageReceivedTime();
                                if (l - l2 <= 30000L) continue;
                                try {
                                    genericMessageConnectionIndirect.close(new Throwable("Timeout"));
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                            }
                        }
                    }
                }
            }
        });
    }
}

