/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class GenericMessageConnectionImpl
implements GenericMessageConnection {
    private static final boolean TRACE = false;
    private static final boolean TEST_TUNNEL = false;
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpointImpl endpoint;
    private int stream_crypto;
    byte[][] shared_secrets;
    private boolean incoming;
    private volatile GenericMessageConnectionAdapter delegate;
    private volatile boolean closing;
    private volatile boolean closed;
    private volatile boolean connecting;
    private List listeners = new ArrayList();
    private int connect_method_count;
    private List inbound_rls;
    private List outbound_rls;

    protected GenericMessageConnectionImpl(MessageManagerImpl messageManagerImpl, GenericMessageConnectionAdapter genericMessageConnectionAdapter) {
        this.message_manager = messageManagerImpl;
        this.delegate = genericMessageConnectionAdapter;
        this.incoming = true;
        this.connect_method_count = 1;
        this.delegate.setOwner(this);
    }

    protected GenericMessageConnectionImpl(MessageManagerImpl messageManagerImpl, String string, String string2, GenericMessageEndpointImpl genericMessageEndpointImpl, int n, byte[][] byArray) {
        this.message_manager = messageManagerImpl;
        this.msg_id = string;
        this.msg_desc = string2;
        this.endpoint = genericMessageEndpointImpl;
        this.stream_crypto = n;
        this.shared_secrets = byArray;
        this.connect_method_count = this.endpoint.getConnectionEndpoint().getProtocols().length;
        this.incoming = false;
    }

    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint == null ? this.delegate.getEndpoint() : this.endpoint;
    }

    public int getMaximumMessageSize() {
        return this.delegate == null ? 32768 : this.delegate.getMaximumMessageSize();
    }

    public String getType() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.getType();
    }

    public int getTransportType() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getTransportType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addInboundRateLimiter(rateLimiter);
            } else {
                if (this.inbound_rls == null) {
                    this.inbound_rls = new ArrayList();
                }
                this.inbound_rls.add(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeInboundRateLimiter(rateLimiter);
            } else if (this.inbound_rls != null) {
                this.inbound_rls.remove(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addOutboundRateLimiter(rateLimiter);
            } else {
                if (this.outbound_rls == null) {
                    this.outbound_rls = new ArrayList();
                }
                this.outbound_rls.add(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeOutboundRateLimiter(rateLimiter);
            } else if (this.outbound_rls != null) {
                this.outbound_rls.remove(rateLimiter);
            }
        }
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public int getConnectMethodCount() {
        return this.connect_method_count;
    }

    public void connect() throws MessageException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDelegate(GenericMessageConnectionAdapter genericMessageConnectionAdapter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            int n;
            this.delegate = genericMessageConnectionAdapter;
            if (this.inbound_rls != null) {
                for (n = 0; n < this.inbound_rls.size(); ++n) {
                    this.delegate.addInboundRateLimiter((RateLimiter)this.inbound_rls.get(n));
                }
                this.inbound_rls = null;
            }
            if (this.outbound_rls != null) {
                for (n = 0; n < this.outbound_rls.size(); ++n) {
                    this.delegate.addOutboundRateLimiter((RateLimiter)this.outbound_rls.get(n));
                }
                this.inbound_rls = null;
            }
        }
    }

    public void connect(ByteBuffer byteBuffer) throws MessageException {
        if (this.incoming) {
            throw new MessageException("Already connected");
        }
        if (this.connecting) {
            throw new MessageException("Connect already performed");
        }
        this.connecting = true;
        if (this.closed) {
            throw new MessageException("Connection has been closed");
        }
        InetSocketAddress inetSocketAddress = this.endpoint.getTCP();
        if (inetSocketAddress != null) {
            this.connectTCP(byteBuffer, inetSocketAddress);
        } else {
            InetSocketAddress inetSocketAddress2 = this.endpoint.getUDP();
            if (inetSocketAddress2 != null) {
                this.connectUDP(byteBuffer, inetSocketAddress2, false);
            } else {
                throw new MessageException("No protocols availabld");
            }
        }
    }

    protected void connectTCP(final ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        GenericMessageEndpointImpl genericMessageEndpointImpl = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        genericMessageEndpointImpl.addTCP(inetSocketAddress);
        final GenericMessageConnectionDirect genericMessageConnectionDirect = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, genericMessageEndpointImpl, this.stream_crypto, this.shared_secrets);
        genericMessageConnectionDirect.setOwner(this);
        genericMessageConnectionDirect.connect(byteBuffer, new GenericMessageConnectionAdapter.ConnectionListener(){
            private boolean connected;

            public void connectSuccess() {
                this.connected = true;
                GenericMessageConnectionImpl.this.setDelegate(genericMessageConnectionDirect);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            public void connectFailure(Throwable throwable) {
                InetSocketAddress inetSocketAddress = GenericMessageConnectionImpl.this.endpoint.getUDP();
                if (inetSocketAddress != null && !this.connected) {
                    byteBuffer.rewind();
                    GenericMessageConnectionImpl.this.connectUDP(byteBuffer, inetSocketAddress, false);
                } else {
                    GenericMessageConnectionImpl.this.reportFailed(throwable);
                }
            }
        });
    }

    protected void connectUDP(final ByteBuffer byteBuffer, final InetSocketAddress inetSocketAddress, boolean bl) {
        final GenericMessageEndpointImpl genericMessageEndpointImpl = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        genericMessageEndpointImpl.addUDP(inetSocketAddress);
        final GenericMessageConnectionDirect genericMessageConnectionDirect = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, genericMessageEndpointImpl, this.stream_crypto, this.shared_secrets);
        genericMessageConnectionDirect.setOwner(this);
        if (bl) {
            NATTraverser nATTraverser = this.message_manager.getNATTraverser();
            HashMap hashMap = new HashMap();
            nATTraverser.attemptTraversal(this.message_manager, inetSocketAddress, hashMap, false, new NATTraversalObserver(){

                public void succeeded(final InetSocketAddress inetSocketAddress, final InetSocketAddress inetSocketAddress2, Map map) {
                    if (GenericMessageConnectionImpl.this.closed) {
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.connect_method_count++;
                        genericMessageConnectionDirect.connect(byteBuffer, new GenericMessageConnectionAdapter.ConnectionListener(){
                            private boolean connected;

                            public void connectSuccess() {
                                this.connected = true;
                                GenericMessageConnectionImpl.this.setDelegate(genericMessageConnectionDirect);
                                if (GenericMessageConnectionImpl.this.closed) {
                                    try {
                                        GenericMessageConnectionImpl.this.delegate.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                                } else {
                                    GenericMessageConnectionImpl.this.reportConnected();
                                }
                            }

                            public void connectFailure(Throwable throwable) {
                                if (this.connected) {
                                    GenericMessageConnectionImpl.this.reportFailed(throwable);
                                } else {
                                    byteBuffer.rewind();
                                    GenericMessageConnectionImpl.this.connectTunnel(byteBuffer, genericMessageEndpointImpl, inetSocketAddress, inetSocketAddress2);
                                }
                            }
                        });
                    }
                }

                public void failed(int n) {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed - NAT traversal failed (" + NATTraversalObserver.FT_STRINGS[n] + ")"));
                }

                public void failed(Throwable throwable) {
                    GenericMessageConnectionImpl.this.reportFailed(throwable);
                }

                public void disabled() {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed as DDB is disabled"));
                }
            });
        } else {
            genericMessageConnectionDirect.connect(byteBuffer, new GenericMessageConnectionAdapter.ConnectionListener(){
                private boolean connected;

                public void connectSuccess() {
                    this.connected = true;
                    GenericMessageConnectionImpl.this.setDelegate(genericMessageConnectionDirect);
                    if (GenericMessageConnectionImpl.this.closed) {
                        try {
                            GenericMessageConnectionImpl.this.delegate.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.reportConnected();
                    }
                }

                public void connectFailure(Throwable throwable) {
                    if (this.connected) {
                        GenericMessageConnectionImpl.this.reportFailed(throwable);
                    } else {
                        byteBuffer.rewind();
                        GenericMessageConnectionImpl.this.connectUDP(byteBuffer, inetSocketAddress, true);
                    }
                }
            });
        }
    }

    protected void connectTunnel(ByteBuffer byteBuffer, GenericMessageEndpoint genericMessageEndpoint, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        final GenericMessageConnectionIndirect genericMessageConnectionIndirect = new GenericMessageConnectionIndirect(this.message_manager, this.msg_id, this.msg_desc, genericMessageEndpoint, inetSocketAddress, inetSocketAddress2);
        genericMessageConnectionIndirect.setOwner(this);
        genericMessageConnectionIndirect.connect(byteBuffer, new GenericMessageConnectionAdapter.ConnectionListener(){

            public void connectSuccess() {
                GenericMessageConnectionImpl.this.setDelegate(genericMessageConnectionIndirect);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            public void connectFailure(Throwable throwable) {
                GenericMessageConnectionImpl.this.reportFailed(throwable);
            }
        });
    }

    protected void accepted() {
        this.delegate.accepted();
    }

    public void send(PooledByteBuffer pooledByteBuffer) throws MessageException {
        int n = ((PooledByteBufferImpl)pooledByteBuffer).getBuffer().remaining((byte)1);
        if (n > this.getMaximumMessageSize()) {
            throw new MessageException("Message is too large: supplied is " + n + ", maximum is " + this.getMaximumMessageSize());
        }
        this.delegate.send(pooledByteBuffer);
    }

    protected void receive(GenericMessage genericMessage) {
        boolean bl = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            PooledByteBufferImpl pooledByteBufferImpl = new PooledByteBufferImpl(genericMessage.getPayload());
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).receive(this, pooledByteBufferImpl);
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                pooledByteBufferImpl.returnToPool();
                if (throwable instanceof MessageException) continue;
                Debug.printStackTrace(throwable);
            }
        }
        if (!(bl || this.closed || this.closing)) {
            Debug.out("GenericMessage: incoming message not handled");
        }
    }

    public void closing() {
        this.closing = true;
    }

    public void close() throws MessageException {
        this.closed = true;
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected void reportConnected() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).connected(this);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void reportFailed(Throwable throwable) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).failed(this, throwable);
                continue;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }
    }

    public void addListener(GenericMessageConnectionListener genericMessageConnectionListener) {
        this.listeners.add(genericMessageConnectionListener);
    }

    public void removeListener(GenericMessageConnectionListener genericMessageConnectionListener) {
        this.listeners.remove(genericMessageConnectionListener);
    }
}

