/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.logging.impl.FileLoggingAdapter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.FileLoggerAdapter;
import org.gudy.azureus2.plugins.logging.LogAlertListener;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerAlertListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerChannelImpl;

public class LoggerImpl
implements Logger {
    private PluginInterface pi;
    private List channels = new ArrayList();
    private Map alert_listeners_map = new HashMap();
    private Map alert_listeners_map2 = new HashMap();

    public LoggerImpl(PluginInterface pluginInterface) {
        this.pi = pluginInterface;
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public LoggerChannel getChannel(String string) {
        LoggerChannelImpl loggerChannelImpl = new LoggerChannelImpl(this, string, false, false);
        this.channels.add(loggerChannelImpl);
        return loggerChannelImpl;
    }

    public LoggerChannel getTimeStampedChannel(String string) {
        LoggerChannelImpl loggerChannelImpl = new LoggerChannelImpl(this, string, true, false);
        this.channels.add(loggerChannelImpl);
        return loggerChannelImpl;
    }

    public LoggerChannel getNullChannel(String string) {
        LoggerChannelImpl loggerChannelImpl = new LoggerChannelImpl(this, string, true, true);
        this.channels.add(loggerChannelImpl);
        return loggerChannelImpl;
    }

    public LoggerChannel[] getChannels() {
        LoggerChannel[] loggerChannelArray = new LoggerChannel[this.channels.size()];
        this.channels.toArray(loggerChannelArray);
        return loggerChannelArray;
    }

    public void addAlertListener(final LoggerAlertListener loggerAlertListener) {
        ILogAlertListener iLogAlertListener = new ILogAlertListener(){

            public void alertRaised(LogAlert logAlert) {
                if (logAlert.err == null) {
                    int n = logAlert.entryType == 0 ? 1 : (logAlert.entryType == 1 ? 2 : 3);
                    loggerAlertListener.alertLogged(n, logAlert.text, logAlert.repeatable);
                } else {
                    loggerAlertListener.alertLogged(logAlert.text, logAlert.err, logAlert.repeatable);
                }
            }
        };
        this.alert_listeners_map.put(loggerAlertListener, iLogAlertListener);
        org.gudy.azureus2.core3.logging.Logger.addListener(iLogAlertListener);
    }

    public void removeAlertListener(LoggerAlertListener loggerAlertListener) {
        ILogAlertListener iLogAlertListener = (ILogAlertListener)this.alert_listeners_map.remove(loggerAlertListener);
        if (iLogAlertListener != null) {
            org.gudy.azureus2.core3.logging.Logger.removeListener(iLogAlertListener);
        }
    }

    public void addAlertListener(final LogAlertListener logAlertListener) {
        ILogAlertListener iLogAlertListener = new ILogAlertListener(){
            private HashSet set = new HashSet();

            public void alertRaised(LogAlert logAlert) {
                if (!logAlert.repeatable) {
                    if (this.set.contains(logAlert.text)) {
                        return;
                    }
                    this.set.add(logAlert.text);
                }
                logAlertListener.alertRaised(logAlert);
            }
        };
        this.alert_listeners_map2.put(logAlertListener, iLogAlertListener);
        org.gudy.azureus2.core3.logging.Logger.addListener(iLogAlertListener);
    }

    public void removeAlertListener(LogAlertListener logAlertListener) {
        ILogAlertListener iLogAlertListener = (ILogAlertListener)this.alert_listeners_map2.remove(logAlertListener);
        if (iLogAlertListener != null) {
            org.gudy.azureus2.core3.logging.Logger.removeListener(iLogAlertListener);
        }
    }

    public void addFileLoggingListener(FileLoggerAdapter fileLoggerAdapter) {
        FileLogging fileLogging = org.gudy.azureus2.core3.logging.Logger.getFileLoggingInstance();
        if (fileLogging == null) {
            return;
        }
        fileLogging.addListener(new PluginFileLoggerAdapater(fileLogging, fileLoggerAdapter));
    }

    public void removeFileLoggingListener(FileLoggerAdapter fileLoggerAdapter) {
        FileLogging fileLogging = org.gudy.azureus2.core3.logging.Logger.getFileLoggingInstance();
        if (fileLogging == null) {
            return;
        }
        Object[] objectArray = fileLogging.getListeners().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof PluginFileLoggerAdapater)) continue;
            PluginFileLoggerAdapater pluginFileLoggerAdapater = (PluginFileLoggerAdapater)objectArray[i];
            if (pluginFileLoggerAdapater.listener != fileLoggerAdapter) continue;
            fileLogging.removeListener(pluginFileLoggerAdapater);
        }
    }

    private class PluginFileLoggerAdapater
    extends FileLoggingAdapter {
        public FileLoggerAdapter listener;

        public PluginFileLoggerAdapater(FileLogging fileLogging, FileLoggerAdapter fileLoggerAdapter) {
            fileLogging.addListener(this);
            this.listener = fileLoggerAdapter;
        }

        public boolean logToFile(LogEvent logEvent, StringBuffer stringBuffer) {
            return this.listener.logToFile(stringBuffer);
        }
    }
}

