/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipfilter;

import java.io.File;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.plugins.ipfilter.IPBanned;
import org.gudy.azureus2.plugins.ipfilter.IPBlocked;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPFilterException;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBannedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBlockedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPRangeImpl;

public class IPFilterImpl
implements IPFilter {
    protected IpFilter filter = IpFilterManagerFactory.getSingleton().getIPFilter();

    public File getFile() {
        return this.filter.getFile();
    }

    public void reload() throws IPFilterException {
        try {
            this.filter.reload();
        }
        catch (Throwable throwable) {
            throw new IPFilterException("IPFilter::reload fails", throwable);
        }
    }

    public void save() throws IPFilterException {
        try {
            this.filter.save();
        }
        catch (Throwable throwable) {
            throw new IPFilterException("IPFilter::reload fails", throwable);
        }
    }

    public IPRange[] getRanges() {
        IpRange[] ipRangeArray = this.filter.getRanges();
        IPRange[] iPRangeArray = new IPRange[ipRangeArray.length];
        for (int i = 0; i < ipRangeArray.length; ++i) {
            iPRangeArray[i] = new IPRangeImpl(this, ipRangeArray[i]);
        }
        return iPRangeArray;
    }

    public int getNumberOfRanges() {
        return this.filter.getNbRanges();
    }

    public int getNumberOfBlockedIPs() {
        return this.filter.getNbIpsBlocked();
    }

    public int getNumberOfBannedIPs() {
        return this.filter.getNbBannedIps();
    }

    public boolean isInRange(String string) {
        return this.filter.isInRange(string);
    }

    public IPRange createRange(boolean bl) {
        return new IPRangeImpl(this, this.filter.createRange(bl));
    }

    public void addRange(IPRange iPRange) {
        if (!(iPRange instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.addRange(((IPRangeImpl)iPRange).getRange());
    }

    public IPRange createAndAddRange(String string, String string2, String string3, boolean bl) {
        IPRange iPRange = this.createRange(bl);
        iPRange.setDescription(string);
        iPRange.setStartIP(string2);
        iPRange.setEndIP(string3);
        iPRange.checkValid();
        if (iPRange.isValid()) {
            this.addRange(iPRange);
            return iPRange;
        }
        return null;
    }

    public void removeRange(IPRange iPRange) {
        if (!(iPRange instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.removeRange(((IPRangeImpl)iPRange).getRange());
    }

    public IPBlocked[] getBlockedIPs() {
        BlockedIp[] blockedIpArray = this.filter.getBlockedIps();
        IPBlocked[] iPBlockedArray = new IPBlocked[blockedIpArray.length];
        for (int i = 0; i < blockedIpArray.length; ++i) {
            iPBlockedArray[i] = new IPBlockedImpl(this, blockedIpArray[i]);
        }
        return iPBlockedArray;
    }

    public void block(String string) {
        this.filter.ban(string, "<plugin>", false);
    }

    public IPBanned[] getBannedIPs() {
        BannedIp[] bannedIpArray = this.filter.getBannedIps();
        IPBanned[] iPBannedArray = new IPBanned[bannedIpArray.length];
        for (int i = 0; i < bannedIpArray.length; ++i) {
            iPBannedArray[i] = new IPBannedImpl(bannedIpArray[i]);
        }
        return iPBannedArray;
    }

    public void ban(String string, String string2) {
        this.filter.ban(string, string2, false);
    }

    public void unban(String string) {
        this.filter.unban(string);
    }

    public boolean isEnabled() {
        return this.filter.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.filter.setEnabled(bl);
    }

    public boolean getInRangeAddressesAreAllowed() {
        return this.filter.getInRangeAddressesAreAllowed();
    }

    public void setInRangeAddressesAreAllowed(boolean bl) {
        this.filter.setInRangeAddressesAreAllowed(bl);
    }

    public void markAsUpToDate() {
        this.filter.markAsUpToDate();
    }

    public long getLastUpdateTime() {
        return this.filter.getLastUpdateTime();
    }
}

