/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKeyStats;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseContactImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseHelpers;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseTTTorrent;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseValueImpl;

public class DDBaseImpl
implements DistributedDatabase {
    private static DDBaseImpl singleton;
    protected static AEMonitor class_mon;
    protected static Map transfer_map;
    private static DDBaseTTTorrent torrent_transfer;
    private AzureusCore azureus_core;
    private DHTPlugin dht_use_accessor;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDBaseImpl getSingleton(AzureusCore azureusCore) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DDBaseImpl(azureusCore);
            }
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
        return singleton;
    }

    protected DDBaseImpl(AzureusCore azureusCore) {
        this.azureus_core = azureusCore;
        torrent_transfer = new DDBaseTTTorrent(this);
        this.grabDHT();
    }

    public DDBaseTTTorrent getTTTorrent() {
        return torrent_transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DHTPlugin grabDHT() {
        if (this.dht_use_accessor != null) {
            return this.dht_use_accessor;
        }
        try {
            PluginInterface pluginInterface;
            class_mon.enter();
            if (this.dht_use_accessor == null && (pluginInterface = this.azureus_core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class)) != null) {
                this.dht_use_accessor = (DHTPlugin)pluginInterface.getPlugin();
                if (this.dht_use_accessor.isEnabled()) {
                    this.dht_use_accessor.addListener(new DHTPluginListener(){

                        public void localAddressChanged(DHTPluginContact dHTPluginContact) {
                            List list = DDBaseImpl.this.listeners.getList();
                            dbEvent dbEvent2 = new dbEvent(10);
                            for (int i = 0; i < list.size(); ++i) {
                                ((DistributedDatabaseListener)list.get(i)).event(dbEvent2);
                            }
                        }
                    });
                    try {
                        this.addTransferHandler(torrent_transfer, torrent_transfer);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        return this.dht_use_accessor;
    }

    public boolean isAvailable() {
        DHTPlugin dHTPlugin = this.grabDHT();
        if (dHTPlugin == null) {
            return false;
        }
        return dHTPlugin.isEnabled();
    }

    public boolean isExtendedUseAllowed() {
        DHTPlugin dHTPlugin = this.grabDHT();
        if (dHTPlugin == null) {
            return false;
        }
        return dHTPlugin.isExtendedUseAllowed();
    }

    public DistributedDatabaseContact getLocalContact() {
        DHTPlugin dHTPlugin = this.grabDHT();
        if (dHTPlugin == null) {
            return null;
        }
        return new DDBaseContactImpl(this, dHTPlugin.getLocalAddress());
    }

    protected void throwIfNotAvailable() throws DistributedDatabaseException {
        if (!this.isAvailable()) {
            throw new DistributedDatabaseException("DHT not available");
        }
    }

    protected DHTPlugin getDHT() throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return this.grabDHT();
    }

    protected void log(String string) {
        DHTPlugin dHTPlugin = this.grabDHT();
        if (dHTPlugin != null) {
            dHTPlugin.log(string);
        }
    }

    public DistributedDatabaseKey createKey(Object object) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(object);
    }

    public DistributedDatabaseKey createKey(Object object, String string) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(object, string);
    }

    public DistributedDatabaseValue createValue(Object object) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseValueImpl(new DDBaseContactImpl(this, this.getDHT().getLocalAddress()), object, SystemTime.getCurrentTime(), -1L);
    }

    public DistributedDatabaseContact importContact(InetSocketAddress inetSocketAddress) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact dHTPluginContact = this.getDHT().importContact(inetSocketAddress);
        if (dHTPluginContact == null) {
            throw new DistributedDatabaseException("import of '" + inetSocketAddress + "' failed");
        }
        return new DDBaseContactImpl(this, dHTPluginContact);
    }

    public DistributedDatabaseContact importContact(InetSocketAddress inetSocketAddress, byte by) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact dHTPluginContact = this.getDHT().importContact(inetSocketAddress, by);
        if (dHTPluginContact == null) {
            throw new DistributedDatabaseException("import of '" + inetSocketAddress + "' failed");
        }
        return new DDBaseContactImpl(this, dHTPluginContact);
    }

    public void write(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseValue distributedDatabaseValue) throws DistributedDatabaseException {
        this.write(distributedDatabaseListener, distributedDatabaseKey, new DistributedDatabaseValue[]{distributedDatabaseValue});
    }

    public void write(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseValue[] distributedDatabaseValueArray) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        for (int i = 0; i < distributedDatabaseValueArray.length; ++i) {
            if (((DDBaseValueImpl)distributedDatabaseValueArray[i]).getBytes().length <= DDBaseValueImpl.MAX_VALUE_SIZE) continue;
            throw new DistributedDatabaseException("Value size limited to " + DDBaseValueImpl.MAX_VALUE_SIZE + " bytes");
        }
        if (distributedDatabaseValueArray.length == 0) {
            this.delete(distributedDatabaseListener, distributedDatabaseKey);
        } else if (distributedDatabaseValueArray.length == 1) {
            this.getDHT().put(((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), distributedDatabaseKey.getDescription(), ((DDBaseValueImpl)distributedDatabaseValueArray[0]).getBytes(), (byte)0, new listenerMapper(distributedDatabaseListener, 1, distributedDatabaseKey, 0L, false, false));
        } else {
            byte[] byArray;
            Object object;
            byte[] byArray2 = ((DDBaseKeyImpl)distributedDatabaseKey).getBytes();
            byte[] byArray3 = new byte[512];
            int n = 1;
            int n2 = 0;
            while (n2 < distributedDatabaseValueArray.length) {
                object = (DDBaseValueImpl)distributedDatabaseValueArray[n2];
                byArray = ((DDBaseValueImpl)object).getBytes();
                int n3 = byArray.length;
                if (n + n3 < byArray3.length - 2) {
                    byArray3[n++] = (byte)((n3 & 0xFF00) >> 8);
                    byArray3[n++] = (byte)(n3 & 0xFF);
                    System.arraycopy(byArray, 0, byArray3, n, n3);
                    n += n3;
                    ++n2;
                    continue;
                }
                byArray3[0] = 1;
                byte[] byArray4 = new byte[n];
                System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                byte[] byArray5 = byArray2;
                this.getDHT().put(byArray5, distributedDatabaseKey.getDescription(), byArray4, (byte)4, new listenerMapper(distributedDatabaseListener, 1, distributedDatabaseKey, 0L, false, false));
                n = 1;
                byArray2 = new SHA1Simple().calculateHash(byArray2);
            }
            if (n > 1) {
                byArray3[0] = 0;
                object = new byte[n];
                System.arraycopy(byArray3, 0, object, 0, ((Object)object).length);
                byArray = byArray2;
                this.getDHT().put(byArray, distributedDatabaseKey.getDescription(), (byte[])object, (byte)4, new listenerMapper(distributedDatabaseListener, 1, distributedDatabaseKey, 0L, false, false));
            }
        }
    }

    public void read(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, long l) throws DistributedDatabaseException {
        this.read(distributedDatabaseListener, distributedDatabaseKey, l, 0);
    }

    public void read(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, long l, int n) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        this.getDHT().get(((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), distributedDatabaseKey.getDescription(), (byte)0, 256, l, bl, bl2, new listenerMapper(distributedDatabaseListener, 2, distributedDatabaseKey, l, bl, bl2));
    }

    public void readKeyStats(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, long l) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().get(((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), distributedDatabaseKey.getDescription(), (byte)8, 256, l, false, false, new listenerMapper(distributedDatabaseListener, 6, distributedDatabaseKey, l, false, false));
    }

    public void delete(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().remove(((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), distributedDatabaseKey.getDescription(), new listenerMapper(distributedDatabaseListener, 3, distributedDatabaseKey, 0L, false, false));
    }

    public void delete(DistributedDatabaseListener distributedDatabaseListener, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseContact[] distributedDatabaseContactArray) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact[] dHTPluginContactArray = new DHTPluginContact[distributedDatabaseContactArray.length];
        for (int i = 0; i < distributedDatabaseContactArray.length; ++i) {
            dHTPluginContactArray[i] = ((DDBaseContactImpl)distributedDatabaseContactArray[i]).getContact();
        }
        this.getDHT().remove(dHTPluginContactArray, ((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), distributedDatabaseKey.getDescription(), new listenerMapper(distributedDatabaseListener, 3, distributedDatabaseKey, 0L, false, false));
    }

    public void addTransferHandler(final DistributedDatabaseTransferType distributedDatabaseTransferType, final DistributedDatabaseTransferHandler distributedDatabaseTransferHandler) throws DistributedDatabaseException {
        String string;
        this.throwIfNotAvailable();
        HashWrapper hashWrapper = DDBaseHelpers.getKey(distributedDatabaseTransferType.getClass());
        if (transfer_map.get(hashWrapper) != null) {
            throw new DistributedDatabaseException("Handler for class '" + distributedDatabaseTransferType.getClass().getName() + "' already defined");
        }
        transfer_map.put(hashWrapper, distributedDatabaseTransferHandler);
        if (distributedDatabaseTransferType == torrent_transfer) {
            string = "Torrent Transfer";
        } else {
            String string2 = distributedDatabaseTransferType.getClass().getName();
            int n = string2.indexOf(36);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            } else {
                n = string2.lastIndexOf(46);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
            }
            string = "Plugin Defined (" + string2 + ")";
        }
        this.getDHT().registerHandler(hashWrapper.getHash(), new DHTPluginTransferHandler(){

            public String getName() {
                return string;
            }

            public byte[] handleRead(DHTPluginContact dHTPluginContact, byte[] byArray) {
                try {
                    DDBaseValueImpl dDBaseValueImpl = (DDBaseValueImpl)distributedDatabaseTransferHandler.read(new DDBaseContactImpl(DDBaseImpl.this, dHTPluginContact), distributedDatabaseTransferType, new DDBaseKeyImpl(byArray));
                    if (dDBaseValueImpl == null) {
                        return null;
                    }
                    return dDBaseValueImpl.getBytes();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    return null;
                }
            }

            public void handleWrite(DHTPluginContact dHTPluginContact, byte[] byArray, byte[] byArray2) {
                try {
                    DDBaseContactImpl dDBaseContactImpl = new DDBaseContactImpl(DDBaseImpl.this, dHTPluginContact);
                    distributedDatabaseTransferHandler.write(dDBaseContactImpl, distributedDatabaseTransferType, new DDBaseKeyImpl(byArray), new DDBaseValueImpl(dDBaseContactImpl, byArray2, SystemTime.getCurrentTime(), -1L));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        });
    }

    public DistributedDatabaseTransferType getStandardTransferType(int n) throws DistributedDatabaseException {
        if (n == 1) {
            return torrent_transfer;
        }
        throw new DistributedDatabaseException("unknown type");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl dDBaseContactImpl, final DistributedDatabaseProgressListener distributedDatabaseProgressListener, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey, long l) throws DistributedDatabaseException {
        if (distributedDatabaseTransferType == torrent_transfer) {
            return torrent_transfer.read(dDBaseContactImpl, distributedDatabaseProgressListener, distributedDatabaseTransferType, distributedDatabaseKey, l);
        }
        DHTPluginContact dHTPluginContact = dDBaseContactImpl.getContact();
        byte[] byArray = dHTPluginContact.read(new DHTPluginProgressListener(){

            public void reportSize(long l) {
                distributedDatabaseProgressListener.reportSize(l);
            }

            public void reportActivity(String string) {
                distributedDatabaseProgressListener.reportActivity(string);
            }

            public void reportCompleteness(int n) {
                distributedDatabaseProgressListener.reportCompleteness(n);
            }
        }, DDBaseHelpers.getKey(distributedDatabaseTransferType.getClass()).getHash(), ((DDBaseKeyImpl)distributedDatabaseKey).getBytes(), l);
        if (byArray == null) {
            return null;
        }
        return new DDBaseValueImpl(dDBaseContactImpl, byArray, SystemTime.getCurrentTime(), -1L);
    }

    public void addListener(DistributedDatabaseListener distributedDatabaseListener) {
        this.listeners.add(distributedDatabaseListener);
    }

    public void removeListener(DistributedDatabaseListener distributedDatabaseListener) {
        this.listeners.remove(distributedDatabaseListener);
    }

    static {
        class_mon = new AEMonitor("DDBaseImpl:class");
        transfer_map = new HashMap();
    }

    protected class dbEvent
    implements DistributedDatabaseEvent {
        private int type;
        private DistributedDatabaseKey key;
        private DistributedDatabaseKeyStats key_stats;
        private DistributedDatabaseValue value;
        private DDBaseContactImpl contact;

        protected dbEvent(int n) {
            this.type = n;
        }

        protected dbEvent(int n, DistributedDatabaseKey distributedDatabaseKey) {
            this.type = n;
            this.key = distributedDatabaseKey;
        }

        protected dbEvent(int n, DistributedDatabaseKey distributedDatabaseKey, DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            this.type = n;
            this.key = distributedDatabaseKey;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, dHTPluginContact);
            this.value = new DDBaseValueImpl(this.contact, dHTPluginValue.getValue(), dHTPluginValue.getCreationTime(), dHTPluginValue.getVersion());
        }

        protected dbEvent(int n, DistributedDatabaseKey distributedDatabaseKey, DHTPluginContact dHTPluginContact, DistributedDatabaseKeyStats distributedDatabaseKeyStats) {
            this.type = n;
            this.key = distributedDatabaseKey;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, dHTPluginContact);
            this.key_stats = distributedDatabaseKeyStats;
        }

        protected dbEvent(int n, DistributedDatabaseKey distributedDatabaseKey, DHTPluginContact dHTPluginContact, byte[] byArray, long l, long l2) {
            this.type = n;
            this.key = distributedDatabaseKey;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, dHTPluginContact);
            this.value = new DDBaseValueImpl(this.contact, byArray, l, l2);
        }

        public int getType() {
            return this.type;
        }

        public DistributedDatabaseKey getKey() {
            return this.key;
        }

        public DistributedDatabaseKeyStats getKeyStats() {
            return this.key_stats;
        }

        public DistributedDatabaseValue getValue() {
            return this.value;
        }

        public DistributedDatabaseContact getContact() {
            return this.contact;
        }
    }

    protected class listenerMapper
    implements DHTPluginOperationListener {
        private DistributedDatabaseListener listener;
        private int type;
        private DistributedDatabaseKey key;
        private byte[] key_bytes;
        private long timeout;
        private boolean complete_disabled;
        private boolean exhaustive;
        private boolean high_priority;
        private int continuation_num;

        protected listenerMapper(DistributedDatabaseListener distributedDatabaseListener, int n, DistributedDatabaseKey distributedDatabaseKey, long l, boolean bl, boolean bl2) {
            this.listener = distributedDatabaseListener;
            this.type = n;
            this.key = distributedDatabaseKey;
            this.key_bytes = ((DDBaseKeyImpl)this.key).getBytes();
            this.timeout = l;
            this.exhaustive = bl;
            this.high_priority = bl2;
            this.continuation_num = 1;
        }

        private listenerMapper(DistributedDatabaseListener distributedDatabaseListener, int n, DistributedDatabaseKey distributedDatabaseKey, byte[] byArray, long l, int n2) {
            this.listener = distributedDatabaseListener;
            this.type = n;
            this.key = distributedDatabaseKey;
            this.key_bytes = byArray;
            this.timeout = l;
            this.continuation_num = n2;
        }

        public void diversified() {
        }

        public void starts(byte[] byArray) {
            this.listener.event(new dbEvent(7, this.key));
        }

        public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            if (this.type == 6) {
                if ((dHTPluginValue.getFlags() & 8) == 0) {
                    return;
                }
                try {
                    final DHTPluginKeyStats dHTPluginKeyStats = DDBaseImpl.this.getDHT().decodeStats(dHTPluginValue);
                    DistributedDatabaseKeyStats distributedDatabaseKeyStats = new DistributedDatabaseKeyStats(){

                        public int getEntryCount() {
                            return dHTPluginKeyStats.getEntryCount();
                        }

                        public int getSize() {
                            return dHTPluginKeyStats.getSize();
                        }

                        public int getReadsPerMinute() {
                            return dHTPluginKeyStats.getReadsPerMinute();
                        }

                        public byte getDiversification() {
                            return dHTPluginKeyStats.getDiversification();
                        }
                    };
                    this.listener.event(new dbEvent(this.type, this.key, dHTPluginContact, distributedDatabaseKeyStats));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            } else {
                byte[] byArray = dHTPluginValue.getValue();
                if (dHTPluginValue.getFlags() == 4) {
                    int n;
                    for (int i = 1; i < byArray.length; i += n) {
                        if ((n = (byArray[i++] << 8 & 0xFF00) + (byArray[i++] & 0xFF)) > byArray.length - i) {
                            Debug.out("Invalid length: len = " + n + ", remaining = " + (byArray.length - i));
                            break;
                        }
                        byte[] byArray2 = new byte[n];
                        System.arraycopy(byArray, i, byArray2, 0, n);
                        this.listener.event(new dbEvent(this.type, this.key, dHTPluginContact, byArray2, dHTPluginValue.getCreationTime(), dHTPluginValue.getVersion()));
                    }
                    if (byArray[0] == 1) {
                        byte[] byArray3 = new SHA1Simple().calculateHash(this.key_bytes);
                        this.complete_disabled = true;
                        DDBaseImpl.this.grabDHT().get(byArray3, this.key.getDescription() + " [continuation " + this.continuation_num + "]", (byte)0, 256, this.timeout, this.exhaustive, this.high_priority, new listenerMapper(this.listener, 2, this.key, byArray3, this.timeout, this.continuation_num + 1));
                    }
                } else {
                    this.listener.event(new dbEvent(this.type, this.key, dHTPluginContact, dHTPluginValue));
                }
            }
        }

        public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            this.listener.event(new dbEvent(this.type, this.key, dHTPluginContact, dHTPluginValue));
        }

        public void complete(byte[] byArray, boolean bl) {
            if (!this.complete_disabled) {
                this.listener.event(new dbEvent(bl ? 5 : 4, this.key));
            }
        }
    }
}

