/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.unix.ScriptAfterShutdown;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;

public class PlatformManagerUnixPlugin
implements Plugin {
    private PluginInterface plugin_interface;

    public void initialize(PluginInterface pluginInterface) throws PluginException {
        this.plugin_interface = pluginInterface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String string = "1.0";
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        if (platformManager.hasCapability(PlatformManagerCapabilities.GetVersion)) {
            try {
                string = platformManager.getVersion();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", string);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){
            boolean done = false;

            public void UIDetached(UIInstance uIInstance) {
            }

            public void UIAttached(UIInstance uIInstance) {
                if (!this.done) {
                    this.done = true;
                }
            }
        });
    }

    private void checkStartupScript() {
        block22: {
            String string;
            Object object;
            String string2;
            File file;
            COConfigurationManager.setIntDefault("unix.script.lastaskversion", -1);
            int n = COConfigurationManager.getIntParameter("unix.script.lastaskversion");
            String string3 = System.getProperty("azureus.script.version", "0");
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Pattern pattern = Pattern.compile("SCRIPT_VERSION=([0-9]+)", 2);
            String string4 = System.getProperty("azureus.script", null);
            if (string4 != null && new File(string4).exists()) {
                file = new File(string4);
            } else {
                file = new File(SystemProperties.getApplicationPath(), "azureus");
                if (!file.exists()) {
                    return;
                }
            }
            String string5 = file.getAbsolutePath();
            try {
                string2 = FileUtil.readFileAsString(file, 65535, "utf8");
            }
            catch (IOException iOException) {
                string2 = "";
            }
            if (n2 == 0 && ((Matcher)(object = pattern.matcher(string2))).find()) {
                string = ((Matcher)object).group(1);
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (n2 <= n) {
                return;
            }
            object = this.getClass().getResourceAsStream("startupScript");
            try {
                String string6;
                string = FileUtil.readInputStreamAsString((InputStream)object, 65535, "utf8");
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) break block22;
                String string7 = matcher.group(1);
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string7);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (n3 <= n2) break block22;
                boolean bl = string2.indexOf("SCRIPT_NOT_CHANGED=0") > 0;
                boolean bl2 = true;
                if (bl) {
                    if (n2 >= 1) {
                        string6 = new File(SystemProperties.getApplicationPath(), "azureus.new").getAbsolutePath();
                        FileUtil.writeBytesAsFile(string6, string.getBytes());
                        String string8 = "cp \"" + string6 + "\" \"" + string5 + "\"; chmod +x \"" + string5 + "\"; echo \"Script Update successful\"";
                        ScriptAfterShutdown.addExtraCommand(string8);
                        ScriptAfterShutdown.setRequiresExit(true);
                        bl2 = false;
                    } else {
                        try {
                            FileUtil.writeBytesAsFile(string5, string.getBytes());
                            Runtime.getRuntime().exec(new String[]{this.findCommand("chmod"), "+x", string2});
                            bl2 = false;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (bl2) {
                    string6 = new File(SystemProperties.getApplicationPath(), "azureus.new").getAbsolutePath();
                    FileUtil.writeBytesAsFile(string6, string.getBytes());
                    this.showScriptManualUpdateDialog(string6, string5, n3);
                } else {
                    this.showScriptAutoUpdateDialog();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private String findCommand(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"/bin", "/usr/bin"}) {
            File file = new File(string2, string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    private void showScriptManualUpdateDialog(String string, String string2, final int n) {
        final UIFunctions uIFunctions = UIFunctionsManager.getUIFunctions();
        if (uIFunctions != null) {
            final String string3 = "cp \"" + string + "\" \"" + string2 + "\"";
            uIFunctions.promptUser(MessageText.getString("unix.script.new.title"), MessageText.getString("unix.script.new.text", new String[]{string, string3}), new String[]{MessageText.getString("unix.script.new.button.quit"), MessageText.getString("unix.script.new.button.continue"), MessageText.getString("unix.script.new.button.asknomore")}, 0, null, null, false, 0, new UserPrompterResultListener(){

                public void prompterClosed(int n2) {
                    if (n2 == 0) {
                        System.out.println("The line you should run:\n" + string3);
                        uIFunctions.dispose(false, false);
                    } else if (n2 == 2) {
                        COConfigurationManager.setParameter("unix.script.lastaskversion", n);
                    }
                }
            });
        } else {
            System.out.println("NO UIF");
        }
    }

    private void showScriptAutoUpdateDialog() {
        final UIFunctions uIFunctions = UIFunctionsManager.getUIFunctions();
        if (uIFunctions != null) {
            uIFunctions.promptUser(MessageText.getString("unix.script.new.auto.title"), MessageText.getString("unix.script.new.auto.text", new String[0]), new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0, null, null, false, 0, new UserPrompterResultListener(){

                public void prompterClosed(int n) {
                    if (n == 0) {
                        uIFunctions.dispose(true, false);
                    }
                }
            });
        } else {
            System.out.println("NO UIF");
        }
    }
}

