/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1;

public final class SHA1Hasher {
    private final SHA1 sha1 = new SHA1();

    public byte[] calculateHash(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return this.calculateHash(byteBuffer);
    }

    public byte[] calculateHash(ByteBuffer byteBuffer) {
        this.sha1.reset();
        return this.sha1.digest(byteBuffer);
    }

    public void update(byte[] byArray) {
        this.update(ByteBuffer.wrap(byArray));
    }

    public void update(byte[] byArray, int n, int n2) {
        this.update(ByteBuffer.wrap(byArray, n, n2));
    }

    public void update(ByteBuffer byteBuffer) {
        this.sha1.update(byteBuffer);
    }

    public byte[] getDigest() {
        return this.sha1.digest();
    }

    public HashWrapper getHash() {
        return new HashWrapper(this.sha1.digest());
    }

    public void reset() {
        this.sha1.reset();
    }

    public void saveHashState() {
        this.sha1.saveState();
    }

    public void restoreHashState() {
        this.sha1.restoreState();
    }
}

