/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://azureus.sourceforge.net/";
    public static final String AELITIS_TORRENTS = "http://torrent.vuze.com/torrents/";
    public static final String AELITIS_FILES = "http://torrent.vuze.com/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/w/";
    public static final String VERSION_SERVER_V4 = "version.vuze.com";
    public static final String VERSION_SERVER_V6 = "version6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.vuze.com";
    public static final String NAT_TEST_SERVER = "nettest.vuze.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.vuze.com/";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String PAIRING_URL = "http://pair.vuze.com/pairing";
    public static final String[] AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static Charset BYTE_CHARSET;
    public static Charset DEFAULT_CHARSET;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE;
    public static String APP_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "4.5.0.4";
    public static final String BUILD_VERSION = "@build.version@";
    public static final String AZUREUS_SUBVER = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static final boolean isOSX_10_5_OrHigher;
    public static final boolean isOSX_10_6_OrHigher;
    public static final String JAVA_VERSION;
    public static final String FILE_WILDCARD;

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String string) {
        int n = string.indexOf("_");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String string) {
        return string.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String string) {
        if (!Constants.isCVSVersion(string)) {
            return 0;
        }
        int n = string.indexOf("_B");
        if (n == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(n + 2));
        }
        catch (Throwable throwable) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String string, String string2) {
        try {
            block7: {
                if (string.startsWith(".")) {
                    string = "0" + string;
                }
                if (string2.startsWith(".")) {
                    string2 = "0" + string2;
                }
                string = string.replaceAll("[^0-9.]", ".");
                string2 = string2.replaceAll("[^0-9.]", ".");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
                while (true) {
                    int n;
                    if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                        int n2;
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n == (n2 = Integer.parseInt(stringTokenizer2.nextToken()))) continue;
                        return n - n2;
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n == 0) continue;
                        return 1;
                    }
                    if (!stringTokenizer2.hasMoreTokens()) break block7;
                    n = Integer.parseInt(stringTokenizer2.nextToken());
                    if (n != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return !string.startsWith(".") && !string.endsWith(".") && string.indexOf("..") == -1;
    }

    public static boolean isAzureusDomain(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < AZUREUS_DOMAINS.length; ++i) {
            String string2 = AZUREUS_DOMAINS[i];
            if (string2.equals(string)) {
                return true;
            }
            if (!string.endsWith("." + string2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Constants.BYTE_CHARSET = Charset.forName("ISO-8859-1");
            Constants.DEFAULT_CHARSET = Charset.forName("UTF8");
        }
        catch (Throwable var0) {
            var0.printStackTrace();
        }
        Constants.LOCALE_ENGLISH = new Locale("en", "");
        Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
        Constants.APP_NAME = "Vuze";
        Constants.VERSION_ID = "-AZ4504-".getBytes();
        Constants.FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        Constants.IS_CVS_VERSION = Constants.isCVSVersion("4.5.0.4") != false && Constants.FORCE_NON_CVS == false;
        Constants.OSName = System.getProperty("os.name");
        Constants.isOSX = Constants.OSName.toLowerCase().startsWith("mac os");
        Constants.isLinux = Constants.OSName.equalsIgnoreCase("Linux");
        Constants.isSolaris = Constants.OSName.equalsIgnoreCase("SunOS");
        Constants.isFreeBSD = Constants.OSName.equalsIgnoreCase("FreeBSD");
        Constants.isWindowsXP = Constants.OSName.equalsIgnoreCase("Windows XP");
        Constants.isWindows95 = Constants.OSName.equalsIgnoreCase("Windows 95");
        Constants.isWindows98 = Constants.OSName.equalsIgnoreCase("Windows 98");
        Constants.isWindows2000 = Constants.OSName.equalsIgnoreCase("Windows 2000");
        Constants.isWindowsME = Constants.OSName.equalsIgnoreCase("Windows ME");
        Constants.isWindows9598ME = Constants.isWindows95 != false || Constants.isWindows98 != false || Constants.isWindowsME != false;
        Constants.isSafeMode = false;
        Constants.isWindows = Constants.OSName.toLowerCase().startsWith("windows");
        v0 = Constants.isUnix = Constants.isWindows == false && Constants.isOSX == false;
        if (Constants.isWindows) {
            block24: {
                var0_1 = null;
                try {
                    var0_1 = new Float(System.getProperty("os.version"));
                }
                catch (Throwable var1_3) {
                    // empty catch block
                }
                var1_4 = 0;
                if (var0_1 == null) {
                    Constants.isWindowsVista = false;
                    Constants.isWindowsVistaOrHigher = false;
                    Constants.isWindows7OrHigher = false;
                } else {
                    var2_5 = var0_1.floatValue();
                    Constants.isWindowsVista = var2_5 == 6.0f;
                    Constants.isWindowsVistaOrHigher = var2_5 >= 6.0f;
                    v1 = Constants.isWindows7OrHigher = var2_5 >= 6.1f;
                    if (Constants.isWindowsVista) {
                        var3_8 = null;
                        try {
                            try {
                                var4_9 = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                                var3_8 = new LineNumberReader(new InputStreamReader(var4_9.getInputStream()));
                                while ((var5_11 = var3_8.readLine()) != null) {
                                    if (!var5_11.matches(".*CSDVersion.*")) continue;
                                    var1_4 = (int)var5_11.matches(".*Service Pack [2-9]");
                                    break;
                                }
                                var7_12 = null;
                                if (var3_8 == null) break block24;
                            }
                            catch (Throwable var4_10) {
                                var7_13 = null;
                                if (var3_8 != null) {
                                    try {
                                        var3_8.close();
                                    }
                                    catch (Throwable var8_16) {}
                                }
                                break block24;
                            }
                        }
                        catch (Throwable var6_18) {
                            var7_14 = null;
                            if (var3_8 == null) throw var6_18;
                            ** try [egrp 4[TRYBLOCK] [6 : 520->527)] { 
lbl72:
                            // 1 sources

                            var3_8.close();
                            throw var6_18;
lbl74:
                            // 1 sources

                            catch (Throwable var8_17) {
                                // empty catch block
                            }
                            throw var6_18;
                        }
                        try {}
                        catch (Throwable var8_15) {}
                        var3_8.close();
                    }
                }
            }
            Constants.isWindowsVistaSP2OrHigher = var1_4;
        } else {
            Constants.isWindowsVista = false;
            Constants.isWindowsVistaSP2OrHigher = false;
            Constants.isWindowsVistaOrHigher = false;
            Constants.isWindows7OrHigher = false;
        }
        if (Constants.isOSX) {
            var0_2 = 0;
            var1_4 = 0;
            try {
                var2_6 = System.getProperty("os.version");
                var3_8 = var2_6.split("\\.");
                var0_2 = Integer.parseInt(var3_8[0]);
                if (((String[])var3_8).length > 1) {
                    var1_4 = Integer.parseInt(var3_8[1]);
                }
            }
            catch (Throwable var2_7) {
                // empty catch block
            }
            Constants.isOSX_10_5_OrHigher = var0_2 > 10 || var0_2 == 10 && var1_4 >= 5;
            Constants.isOSX_10_6_OrHigher = var0_2 > 10 || var0_2 == 10 && var1_4 >= 6;
        } else {
            Constants.isOSX_10_5_OrHigher = false;
            Constants.isOSX_10_6_OrHigher = false;
        }
        Constants.JAVA_VERSION = System.getProperty("java.version");
        Constants.FILE_WILDCARD = Constants.isWindows != false ? "*.*" : "*";
    }
}

