/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class AETemporaryFileHandler {
    private static final String PREFIX = "AZU";
    private static final String SUFFIX = ".tmp";
    private static boolean started_up;
    private static File tmp_dir;

    public static synchronized void startup() {
        block10: {
            if (started_up) {
                return;
            }
            started_up = true;
            try {
                tmp_dir = FileUtil.getUserFile("tmp");
                if (tmp_dir.exists()) {
                    File[] fileArray = tmp_dir.listFiles();
                    if (fileArray != null) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            File file = fileArray[i];
                            if (!file.getName().startsWith(PREFIX) || !file.getName().endsWith(SUFFIX)) continue;
                            if (file.isDirectory()) {
                                FileUtil.recursiveDelete(file);
                                continue;
                            }
                            file.delete();
                        }
                    }
                } else {
                    tmp_dir.mkdir();
                }
            }
            catch (Throwable throwable) {
                try {
                    tmp_dir = File.createTempFile(PREFIX, SUFFIX).getParentFile();
                }
                catch (Throwable throwable2) {
                    tmp_dir = new File("");
                }
                if (throwable instanceof NoClassDefFoundError) break block10;
                Debug.printStackTrace(throwable);
            }
        }
    }

    public static File getTempDirectory() {
        AETemporaryFileHandler.startup();
        return tmp_dir;
    }

    public static boolean isTempFile(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String string = file.getParentFile().getCanonicalPath();
            String string2 = tmp_dir.getCanonicalPath();
            if (!string.equals(string2)) {
                return false;
            }
            String string3 = file.getName();
            if (!string3.startsWith(PREFIX)) {
                return false;
            }
            return string3.endsWith(SUFFIX);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return false;
        }
    }

    public static File createTempFile() throws IOException {
        AETemporaryFileHandler.startup();
        return File.createTempFile(PREFIX, SUFFIX, tmp_dir);
    }

    public static File createTempDir() throws IOException {
        AETemporaryFileHandler.startup();
        for (int i = 0; i < 16; ++i) {
            File file = File.createTempFile(PREFIX, SUFFIX, tmp_dir);
            file.delete();
            if (!file.mkdirs()) continue;
            return file;
        }
        throw new IOException("Failed to create temporary directory in " + tmp_dir);
    }
}

