/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeerBase;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentPeerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x300000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x300000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    public static final int MAX_IP_OVERRIDE_PEERS = 64;
    public static final byte COMPACT_MODE_NONE = 0;
    public static final byte COMPACT_MODE_NORMAL = 1;
    public static final byte COMPACT_MODE_AZ = 2;
    public static final byte COMPACT_MODE_AZ_2 = 3;
    public static final byte COMPACT_MODE_XML = 16;
    private static final int QUEUED_PEERS_MAX_SWARM_SIZE = 32;
    private static final int QUEUED_PEERS_MAX = 32;
    private static final int QUEUED_PEERS_ADD_MAX = 3;
    private TRTrackerServerImpl server;
    private HashWrapper hash;
    private Map<HashWrapper, TRTrackerServerPeerImpl> peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>();
    private Map<String, TRTrackerServerPeerImpl> peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>();
    private List<TRTrackerServerPeerImpl> peer_list = new ArrayList<TRTrackerServerPeerImpl>();
    private int peer_list_hole_count;
    private boolean peer_list_compaction_suspended;
    private List biased_peers = null;
    private int min_biased_peers = 0;
    private Map lightweight_seed_map = new HashMap();
    private int seed_count;
    private int removed_count;
    private int ip_override_count;
    private int bad_NAT_count;
    private Random random = new Random(SystemTime.getCurrentTime());
    private long last_scrape_calc_time;
    private Map last_scrape;
    private LinkedHashMap announce_cache = new LinkedHashMap();
    private TRTrackerServerTorrentStatsImpl stats;
    private List listeners = new ArrayList();
    private List peer_listeners;
    private boolean deleted;
    private boolean enabled;
    private boolean map_size_diff_reported;
    private boolean ip_override_limit_exceeded_reported;
    private byte duplicate_peer_checker_index = 0;
    private byte[] duplicate_peer_checker = new byte[0];
    private URL[] redirects;
    private boolean caching_enabled = true;
    private LinkedList queued_peers;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");
    private List explicit_manual_biased_peers;
    private int explicit_next_peer;

    public TRTrackerServerTorrentImpl(TRTrackerServerImpl tRTrackerServerImpl, HashWrapper hashWrapper, boolean bl) {
        this.server = tRTrackerServerImpl;
        this.hash = hashWrapper;
        this.enabled = bl;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMinBiasedPeers(int n) {
        this.min_biased_peers = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPeers(List list) {
        try {
            this.this_mon.enter();
            if (this.peer_map.size() > 0) {
                System.out.println("TRTrackerServerTorrent: ignoring peer import as torrent already active");
                Object var6_2 = null;
                this.this_mon.exit();
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = TRTrackerServerPeerImpl.importPeer((Map)list.get(i));
                if (tRTrackerServerPeerImpl == null) continue;
                try {
                    String string = new String(tRTrackerServerPeerImpl.getIPAsRead(), "ISO-8859-1") + ":" + tRTrackerServerPeerImpl.getTCPPort();
                    this.peer_map.put(tRTrackerServerPeerImpl.getPeerId(), tRTrackerServerPeerImpl);
                    this.peer_list.add(tRTrackerServerPeerImpl);
                    this.peer_reuse_map.put(string, tRTrackerServerPeerImpl);
                    if (tRTrackerServerPeerImpl.isSeed()) {
                        ++this.seed_count;
                    }
                    if (!tRTrackerServerPeerImpl.isBiased()) continue;
                    if (this.biased_peers == null) {
                        this.biased_peers = new ArrayList();
                    }
                    this.biased_peers.add(tRTrackerServerPeerImpl);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var6_3 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TRTrackerServerPeerImpl peerContact(String string, String string2, HashWrapper hashWrapper, int n, int n2, int n3, byte by, byte by2, String string3, String string4, boolean bl, boolean bl2, String string5, long l, long l2, long l3, long l4, int n4, DHTNetworkPosition dHTNetworkPosition) throws TRTrackerServerException {
        TRTrackerServerPeerImpl tRTrackerServerPeerImpl;
        if (!this.enabled) {
            throw new TRTrackerServerException("Torrent temporarily disabled");
        }
        if (!HostNameToIPResolver.isNonDNSName(string4)) {
            try {
                string4 = HostNameToIPResolver.syncResolve(string4).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        TRTrackerServerException tRTrackerServerException = null;
        try {
            try {
                boolean bl3;
                int n5;
                long l5;
                long l6;
                long l7;
                long l8;
                boolean bl4;
                boolean bl5;
                boolean bl6;
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl2;
                long l9;
                int n6;
                block55: {
                    Object object;
                    Object object2;
                    Object object3;
                    byte[] byArray;
                    int n7;
                    block57: {
                        this.this_mon.enter();
                        this.handleRedirects(string, string4, false);
                        n6 = 2;
                        if (string2 != null && string2.length() > 2) {
                            char c = string2.charAt(2);
                            n6 = c == 'm' ? 3 : (c == 'o' ? 4 : 1);
                        }
                        l9 = SystemTime.getCurrentTime();
                        n7 = string5 == null ? 0 : string5.hashCode();
                        tRTrackerServerPeerImpl2 = this.peer_map.get(hashWrapper);
                        bl6 = false;
                        bl5 = false;
                        bl4 = false;
                        l8 = 0L;
                        l7 = 0L;
                        l6 = 0L;
                        l5 = 0L;
                        byArray = string4.getBytes("ISO-8859-1");
                        if (tRTrackerServerPeerImpl2 != null) break block57;
                        String string6 = new String(byArray, "ISO-8859-1") + ":" + n;
                        byte by3 = bl2 ? (byte)3 : 0;
                        bl6 = true;
                        tRTrackerServerPeerImpl = this.peer_reuse_map.get(string6);
                        if (tRTrackerServerPeerImpl != null) {
                            if (bl && !tRTrackerServerPeerImpl.isIPOverride()) {
                                throw new TRTrackerServerException("IP Override denied (existing '" + string6 + "' is not override)");
                            }
                            l8 = tRTrackerServerPeerImpl.getLastContactTime();
                            bl4 = tRTrackerServerPeerImpl.getDownloadCompleted();
                            this.removePeer(tRTrackerServerPeerImpl, 5, null);
                            this.lightweight_seed_map.remove(tRTrackerServerPeerImpl.getPeerId());
                        } else {
                            object3 = (lightweightSeed)this.lightweight_seed_map.remove(hashWrapper);
                            if (object3 != null) {
                                l8 = ((lightweightSeed)object3).getLastContactTime();
                                l7 = l - ((lightweightSeed)object3).getUploaded();
                                if (l7 < 0L) {
                                    l7 = 0L;
                                }
                                by3 = ((lightweightSeed)object3).getNATStatus();
                            } else {
                                l8 = l9;
                            }
                        }
                        if (n6 == 4) break block55;
                        object3 = this.server.getBiasedPeers();
                        int n8 = n5 = object3 != null && object3.contains(string4) ? 1 : 0;
                        if (bl && this.ip_override_count >= 64 && !bl2 && n5 == 0) {
                            if (!this.ip_override_limit_exceeded_reported) {
                                this.ip_override_limit_exceeded_reported = true;
                                Debug.out("Too many ip-override peers for " + ByteFormatter.encodeString(this.hash.getBytes()));
                            }
                            TRTrackerServerPeerImpl tRTrackerServerPeerImpl3 = null;
                            Object var56_53 = null;
                            this.this_mon.exit();
                            return tRTrackerServerPeerImpl3;
                        }
                        tRTrackerServerPeerImpl2 = new TRTrackerServerPeerImpl(hashWrapper, n7, byArray, bl, n, n2, n3, by, by2, l8, bl4, by3, n4, dHTNetworkPosition);
                        if (bl) {
                            if (n5 != 0 && !object3.contains(string3)) {
                                throw new TRTrackerServerException("IP Override denied (you are " + string3 + ")");
                            }
                            ++this.ip_override_count;
                        }
                        this.peer_map.put(hashWrapper, tRTrackerServerPeerImpl2);
                        this.peer_list.add(tRTrackerServerPeerImpl2);
                        this.peer_reuse_map.put(string6, tRTrackerServerPeerImpl2);
                        if (n5 != 0) {
                            tRTrackerServerPeerImpl2.setBiased(true);
                            if (this.biased_peers == null) {
                                this.biased_peers = new ArrayList();
                            }
                            this.biased_peers.add(tRTrackerServerPeerImpl2);
                        }
                        if (this.queued_peers == null) break block55;
                        if (this.peer_map.size() > 32) {
                            this.queued_peers = null;
                            break block55;
                        } else {
                            object2 = this.queued_peers.iterator();
                            while (object2.hasNext()) {
                                QueuedPeer queuedPeer = (QueuedPeer)object2.next();
                                if (!queuedPeer.sameAs(tRTrackerServerPeerImpl2)) continue;
                                object2.remove();
                                break block55;
                            }
                        }
                        break block55;
                    }
                    int n9 = tRTrackerServerPeerImpl2.getKeyHashCode();
                    if (n9 != n7) {
                        throw new TRTrackerServerException("Unauthorised: key mismatch ");
                    }
                    if (bl) {
                        if (tRTrackerServerPeerImpl2.isBiased()) {
                            object = this.server.getBiasedPeers();
                            if (object == null) throw new TRTrackerServerException("IP Override denied (you are " + string3 + ")");
                            if (!object.contains(string3)) {
                                throw new TRTrackerServerException("IP Override denied (you are " + string3 + ")");
                            }
                        }
                        if (!tRTrackerServerPeerImpl2.isIPOverride()) {
                            throw new TRTrackerServerException("IP Override denied (existing entry not override)");
                        }
                    }
                    bl4 = tRTrackerServerPeerImpl2.getDownloadCompleted();
                    l8 = tRTrackerServerPeerImpl2.getLastContactTime();
                    if (n6 == 4) {
                        this.removePeer(tRTrackerServerPeerImpl2, n6, string);
                        bl5 = true;
                    } else {
                        object = tRTrackerServerPeerImpl2.getIPAsRead();
                        int n10 = tRTrackerServerPeerImpl2.getTCPPort();
                        if (tRTrackerServerPeerImpl2.update(byArray, n, n2, n3, by, by2, n4, dHTNetworkPosition)) {
                            object3 = new String((byte[])object, "ISO-8859-1") + ":" + n10;
                            String string7 = new String(byArray, "ISO-8859-1") + ":" + n;
                            object2 = this.peer_reuse_map.get(string7);
                            if (object2 != null) {
                                this.removePeer((TRTrackerServerPeerImpl)object2, 5, null);
                            }
                            if (this.peer_reuse_map.remove(object3) == null) {
                                Debug.out("TRTrackerServerTorrent: IP address change: '" + (String)object3 + "' -> '" + string7 + "': old key not found");
                            }
                            this.peer_reuse_map.put(string7, tRTrackerServerPeerImpl2);
                        }
                    }
                }
                long l10 = l9 + l4 * 1000L * 3L;
                if (tRTrackerServerPeerImpl2 != null) {
                    long l11;
                    tRTrackerServerPeerImpl2.setTimeout(l9, l10);
                    if (!bl6) {
                        l7 = l - tRTrackerServerPeerImpl2.getUploaded();
                        l6 = l2 - tRTrackerServerPeerImpl2.getDownloaded();
                    }
                    if ((l11 = l9 - l8) == 0L) {
                        l11 = 25L;
                    }
                    long l12 = l7 * 1000L / l11;
                    long l13 = l6 * 1000L / l11;
                    if (l12 > 0x300000L) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + tRTrackerServerPeerImpl2.getIPRaw() + "/" + new String(tRTrackerServerPeerImpl2.getPeerId().getHash()) + " reported an upload rate of " + l12 / 1024L + " KiB/s per second"));
                        }
                        l7 = 0L;
                    }
                    if (l13 > 0x300000L) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + tRTrackerServerPeerImpl2.getIPRaw() + "/" + new String(tRTrackerServerPeerImpl2.getPeerId().getHash()) + " reported a download rate of " + l13 / 1024L + " KiB/s per second"));
                        }
                        l6 = 0L;
                    }
                    l5 = n6 == 4 ? 0L : l3 - tRTrackerServerPeerImpl2.getAmountLeft();
                    bl3 = bl6 ? false : tRTrackerServerPeerImpl2.isSeed();
                    tRTrackerServerPeerImpl2.setStats(l, l2, l3);
                    boolean bl7 = tRTrackerServerPeerImpl2.isSeed();
                    if (n6 != 4 && !bl3 && bl7) {
                        ++this.seed_count;
                    }
                    if (!bl5) {
                        try {
                            this.peerEvent(tRTrackerServerPeerImpl2, n6, string);
                        }
                        catch (TRTrackerServerException tRTrackerServerException2) {
                            tRTrackerServerException = tRTrackerServerException2;
                        }
                    }
                }
                this.stats.addAnnounce(l7, l6, l5, tRTrackerServerPeerImpl2 != null && tRTrackerServerPeerImpl2.isBiased());
                if (n6 == 3 && !bl4) {
                    tRTrackerServerPeerImpl2.setDownloadCompleted();
                    this.stats.addCompleted();
                }
                if (tRTrackerServerPeerImpl2 != null && tRTrackerServerPeerImpl2.isSeed()) {
                    int n11 = TRTrackerServerImpl.getSeedLimit();
                    if (n11 != 0 && this.seed_count > n11 && !bl2) {
                        if (bl5) throw new TRTrackerServerException("too many seeds");
                        this.removePeer(tRTrackerServerPeerImpl2, 6, null);
                        throw new TRTrackerServerException("too many seeds");
                    }
                    int n12 = TRTrackerServerImpl.getMaxSeedRetention();
                    if (n12 != 0 && this.seed_count > n12) {
                        n5 = n12 / 20 + 1;
                        try {
                            int n13;
                            this.peer_list_compaction_suspended = true;
                            int n14 = n13 = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                            while (n13 < 2) {
                                for (int i = 0; i < this.peer_list.size(); ++i) {
                                    TRTrackerServerPeerImpl tRTrackerServerPeerImpl4 = this.peer_list.get(i);
                                    if (tRTrackerServerPeerImpl4 == null || !tRTrackerServerPeerImpl4.isSeed() || tRTrackerServerPeerImpl4.isBiased()) continue;
                                    bl3 = tRTrackerServerPeerImpl4.isNATStatusBad();
                                    if ((n13 != 0 || !bl3) && n13 != 1) continue;
                                    this.lightweight_seed_map.put(tRTrackerServerPeerImpl4.getPeerId(), new lightweightSeed(l9, l10, tRTrackerServerPeerImpl4.getUploaded(), tRTrackerServerPeerImpl4.getNATStatus()));
                                    this.removePeer(tRTrackerServerPeerImpl4, i, 6, null);
                                    if (--n5 == 0) break;
                                }
                                if (n5 == 0) break;
                                ++n13;
                            }
                            Object var54_63 = null;
                            this.peer_list_compaction_suspended = false;
                        }
                        catch (Throwable throwable) {
                            Object var54_64 = null;
                            this.peer_list_compaction_suspended = false;
                            throw throwable;
                        }
                        this.checkForPeerListCompaction(false);
                    }
                }
                if (tRTrackerServerException != null) {
                    if (tRTrackerServerPeerImpl2 == null) throw tRTrackerServerException;
                    if (bl5) throw tRTrackerServerException;
                    this.removePeer(tRTrackerServerPeerImpl2, 7, string);
                    throw tRTrackerServerException;
                }
                tRTrackerServerPeerImpl = tRTrackerServerPeerImpl2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TRTrackerServerException("Encoding fails", unsupportedEncodingException);
            }
        }
        catch (Throwable throwable) {
            Object var56_55 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var56_54 = null;
        this.this_mon.exit();
        return tRTrackerServerPeerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void peerQueued(String string, int n, int n2, int n3, byte by, byte by2, long l, boolean bl) {
        block13: {
            block11: {
                if (this.peer_map.size() >= 32) return;
                if (n == 0) {
                    return;
                }
                try {
                    boolean bl2;
                    QueuedPeer queuedPeer;
                    block12: {
                        block14: {
                            QueuedPeer queuedPeer2;
                            this.this_mon.enter();
                            Set set = this.server.getBiasedPeers();
                            boolean bl3 = set != null && set.contains(string);
                            queuedPeer = new QueuedPeer(string, n, n2, n3, by, by2, (int)l, bl, bl3);
                            String string2 = queuedPeer.getIP() + ":" + n;
                            if (this.peer_reuse_map.containsKey(string2)) {
                                Object var19_13 = null;
                                this.this_mon.exit();
                                return;
                            }
                            bl2 = true;
                            if (this.queued_peers == null) break block14;
                            Iterator iterator = this.queued_peers.iterator();
                            while (iterator.hasNext()) {
                                queuedPeer2 = (QueuedPeer)iterator.next();
                                if (!queuedPeer2.sameAs(queuedPeer)) continue;
                                iterator.remove();
                                this.queued_peers.add(queuedPeer);
                                break block11;
                            }
                            if (this.queued_peers.size() >= 32) {
                                queuedPeer2 = null;
                                for (QueuedPeer queuedPeer3 : this.queued_peers) {
                                    if (queuedPeer3.isBiased()) continue;
                                    if (queuedPeer2 == null) {
                                        queuedPeer2 = queuedPeer3;
                                        continue;
                                    }
                                    if (queuedPeer3.getCreateTime() >= queuedPeer2.getCreateTime()) continue;
                                    queuedPeer2 = queuedPeer3;
                                }
                                if (queuedPeer2 == null) {
                                    bl2 = false;
                                    break block12;
                                } else {
                                    this.queued_peers.remove(queuedPeer2);
                                }
                            }
                            break block12;
                        }
                        this.queued_peers = new LinkedList();
                    }
                    if (bl2) {
                        this.queued_peers.addFirst(queuedPeer);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var19_14 = null;
            this.this_mon.exit();
            return;
        }
        Object var19_15 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TRTrackerServerPeerBase tRTrackerServerPeerBase) {
        try {
            this.this_mon.enter();
            if (tRTrackerServerPeerBase instanceof TRTrackerServerPeerImpl) {
                int n;
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = (TRTrackerServerPeerImpl)tRTrackerServerPeerBase;
                if (this.peer_map.containsKey(tRTrackerServerPeerImpl.getPeerId()) && (n = this.peer_list.indexOf(tRTrackerServerPeerImpl)) != -1) {
                    this.removePeer(tRTrackerServerPeerImpl, n, 7, null);
                }
            } else if (this.queued_peers != null) {
                this.queued_peers.remove(tRTrackerServerPeerBase);
                if (this.queued_peers.size() == 0) {
                    this.queued_peers = null;
                }
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl tRTrackerServerPeerImpl, int n, String string) {
        this.removePeer(tRTrackerServerPeerImpl, -1, n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(TRTrackerServerPeerImpl tRTrackerServerPeerImpl, int n, int n2, String string) {
        try {
            TRTrackerServerPeerImpl tRTrackerServerPeerImpl2;
            this.this_mon.enter();
            if (tRTrackerServerPeerImpl.isIPOverride()) {
                --this.ip_override_count;
            }
            this.stats.removeLeft(tRTrackerServerPeerImpl.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((tRTrackerServerPeerImpl2 = this.peer_map.remove(tRTrackerServerPeerImpl.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            } else {
                try {
                    this.peerEvent(tRTrackerServerPeerImpl, n2, string);
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    // empty catch block
                }
            }
            if (n == -1) {
                int n3 = this.peer_list.indexOf(tRTrackerServerPeerImpl);
                if (n3 == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(n3, null);
                }
            } else if (this.peer_list.get(n) == tRTrackerServerPeerImpl) {
                this.peer_list.set(n, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl3 = this.peer_reuse_map.remove(new String(tRTrackerServerPeerImpl.getIPAsRead(), "ISO-8859-1") + ":" + tRTrackerServerPeerImpl.getTCPPort());
                if (tRTrackerServerPeerImpl3 == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.biased_peers != null) {
                this.biased_peers.remove(tRTrackerServerPeerImpl);
            }
            if (tRTrackerServerPeerImpl.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
            Object var8_10 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBiasedPeers(Set set) {
        try {
            this.this_mon.enter();
            Iterator<TRTrackerServerPeerImpl> iterator = this.peer_list.iterator();
            if (iterator.hasNext() && this.biased_peers == null) {
                this.biased_peers = new ArrayList();
            }
            while (iterator.hasNext()) {
                TRTrackerServerPeerBase tRTrackerServerPeerBase = iterator.next();
                if (tRTrackerServerPeerBase == null) continue;
                boolean bl = set.contains(((TRTrackerServerPeerImpl)tRTrackerServerPeerBase).getIPRaw());
                ((TRTrackerServerPeerImpl)tRTrackerServerPeerBase).setBiased(bl);
                if (bl) {
                    if (this.biased_peers.contains(tRTrackerServerPeerBase)) continue;
                    this.biased_peers.add(tRTrackerServerPeerBase);
                    continue;
                }
                this.biased_peers.remove(tRTrackerServerPeerBase);
            }
            if (this.queued_peers != null) {
                for (TRTrackerServerPeerBase tRTrackerServerPeerBase : this.queued_peers) {
                    ((QueuedPeer)tRTrackerServerPeerBase).setBiased(set.contains(((QueuedPeer)tRTrackerServerPeerBase).getIP()));
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public TRTrackerServerTorrent addLink(String string) {
        return this.server.addLink(string, this);
    }

    public void removeLink(String string) {
        this.server.removeLink(string, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map exportAnnounceToMap(String var1_1, HashMap var2_2, TRTrackerServerPeerImpl var3_3, boolean var4_4, int var5_5, long var6_6, long var8_7, boolean var10_8, byte var11_9, byte var12_10, DHTNetworkPosition var13_11) {
        block122: {
            block125: {
                block124: {
                    block120: {
                        block118: {
                            block123: {
                                block121: {
                                    block119: {
                                        block117: {
                                            block111: {
                                                block112: {
                                                    block108: {
                                                        block106: {
                                                            block107: {
                                                                try {
                                                                    this.this_mon.enter();
                                                                    var14_12 = SystemTime.getCurrentTime();
                                                                    var16_13 = var3_3 != null && var3_3.getNATStatus() == 4;
                                                                    var17_14 = this.peer_map.size();
                                                                    var18_15 = TRTrackerServerImpl.getAnnounceCachePeriod();
                                                                    var19_16 = TRTrackerServerImpl.getSendPeerIds();
                                                                    if (var10_8 || var11_9 != 0) {
                                                                        var19_16 = false;
                                                                    }
                                                                    var20_17 = false;
                                                                    var21_18 = TRTrackerServerImpl.getMaxPeersToSend();
                                                                    if (var5_5 < 0) {
                                                                        var5_5 = var17_14;
                                                                    }
                                                                    if (var21_18 > 0 && var5_5 > var21_18) {
                                                                        var5_5 = var21_18;
                                                                    }
                                                                    var22_19 = null;
                                                                    var23_20 = null;
                                                                    var24_21 = null;
                                                                    if (var3_3 != null && this.peer_listeners != null) {
                                                                        for (var25_22 = 0; var25_22 < this.peer_listeners.size(); var25_22 += 1) {
                                                                            try {
                                                                                var26_23 = ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(var25_22)).eventOccurred(this, var3_3, 8, null);
                                                                                if (var26_23 == null) continue;
                                                                                var27_25 = (List)var26_23.get("limited_peers");
                                                                                if (var27_25 != null) {
                                                                                    if (var22_19 == null) {
                                                                                        var22_19 = new ArrayList<Object>();
                                                                                    }
                                                                                    for (var28_32 = 0; var28_32 < var27_25.size(); ++var28_32) {
                                                                                        var29_39 = (Map)var27_25.get(var28_32);
                                                                                        var30_50 = (String)var29_39.get("ip");
                                                                                        var31_57 = ((Long)var29_39.get("port")).intValue();
                                                                                        var32_67 = (String)var30_50 + ":" + var31_57;
                                                                                        var33_75 = this.peer_reuse_map.get(var32_67);
                                                                                        if (var33_75 == null || var22_19.contains(var33_75)) continue;
                                                                                        var22_19.add(var33_75);
                                                                                    }
                                                                                }
                                                                                if ((var28_31 = (List)var26_23.get("biased_peers")) != null) {
                                                                                    if (var23_20 == null) {
                                                                                        var23_20 = new ArrayList<TRTrackerServerSimplePeer>();
                                                                                    }
                                                                                    for (var29_40 = 0; var29_40 < var28_31.size(); ++var29_40) {
                                                                                        var30_50 = (Map)var28_31.get(var29_40);
                                                                                        var31_58 = (String)var30_50.get("ip");
                                                                                        var32_68 = ((Long)var30_50.get("port")).intValue();
                                                                                        var33_75 = var31_58 + ":" + var32_68;
                                                                                        var34_84 = this.peer_reuse_map.get(var33_75);
                                                                                        if (var34_84 == null) {
                                                                                            var34_84 = new temporaryBiasedSeed(var31_58, var32_68);
                                                                                        }
                                                                                        if (var23_20.contains(var34_84)) continue;
                                                                                        var23_20.add(var34_84);
                                                                                    }
                                                                                }
                                                                                var24_21 = (Set)var26_23.get("remove_ips");
                                                                                continue;
                                                                            }
                                                                            catch (Throwable var26_24) {
                                                                                Debug.printStackTrace(var26_24);
                                                                            }
                                                                        }
                                                                    }
                                                                    var25_22 = var3_3 == null ? ((var26_23 = this.server.getBiasedPeers()) == null ? 0 : (int)var26_23.contains(var1_1)) : var3_3.isBiased();
                                                                    if (this.caching_enabled && var22_19 == null && var23_20 == null && !var25_22 && var24_21 == null && !var16_13 && var2_2.size() == 0 && var18_15 > 0 && var5_5 >= 10 && var17_14 >= TRTrackerServerImpl.getAnnounceCachePeerThreshold() && var12_10 != 2) {
                                                                        var13_11 = null;
                                                                        var26_23 = this.announce_cache.keySet().iterator();
                                                                        while (var26_23.hasNext()) {
                                                                            var27_25 = (Integer)var26_23.next();
                                                                            var28_31 = (announceCacheEntry)this.announce_cache.get(var27_25);
                                                                            if (var14_12 - var28_31.getTime() <= (long)var18_15) continue;
                                                                            var26_23.remove();
                                                                        }
                                                                        for (var27_26 = var5_5 / 10; var27_26 > var5_5 / 20; --var27_26) {
                                                                            var28_31 = (announceCacheEntry)this.announce_cache.get(new Integer(var27_26));
                                                                            if (var28_31 == null) continue;
                                                                            if (var14_12 - var28_31.getTime() > (long)var18_15) {
                                                                                this.announce_cache.remove(new Integer(var27_26));
                                                                                continue;
                                                                            }
                                                                            if (var28_31.getSendPeerIds() != var19_16 || var28_31.getCompactMode() != var11_9) continue;
                                                                            var29_41 = var28_31.getData();
                                                                            var44_91 = null;
                                                                            this.this_mon.exit();
                                                                            return var29_41;
                                                                        }
                                                                        var20_17 = true;
                                                                    }
                                                                    var26_23 = new LinkedList<E>();
                                                                    if (var5_5 <= 0 || var22_19 != null) break block106;
                                                                    if (var5_5 >= var17_14) {
                                                                        break block107;
                                                                    }
                                                                    var27_28 = this.peer_list.size();
                                                                    if (this.duplicate_peer_checker.length < var27_28) {
                                                                        this.duplicate_peer_checker = new byte[var27_28 * 2];
                                                                        this.duplicate_peer_checker_index = 1;
                                                                    } else if (this.duplicate_peer_checker.length > var27_28 * 2) {
                                                                        this.duplicate_peer_checker = new byte[3 * var27_28 / 2];
                                                                        this.duplicate_peer_checker_index = 1;
                                                                    } else {
                                                                        this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                                                                        if (this.duplicate_peer_checker_index == 0) {
                                                                            Arrays.fill(this.duplicate_peer_checker, (byte)0);
                                                                            this.duplicate_peer_checker_index = 1;
                                                                        }
                                                                    }
                                                                    var28_33 = false;
                                                                    try {
                                                                        this.peer_list_compaction_suspended = true;
                                                                        var29_43 = 0;
                                                                        v0 = var30_51 = TRTrackerServerNATChecker.getSingleton().isEnabled() != false ? 0 : 1;
lbl104:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            if (var30_51 < 2) {
                                                                                var31_60 = var5_5 * 2;
                                                                                if (var5_5 * 3 > var17_14) {
                                                                                    ++var31_60;
                                                                                }
                                                                                var32_69 = 0;
                                                                                if (this.biased_peers != null) {
                                                                                    if (this.biased_peers.size() > 1) {
                                                                                        var33_77 = this.biased_peers.remove(0);
                                                                                        this.biased_peers.add(this.random.nextInt(this.biased_peers.size() + 1), var33_77);
                                                                                    }
                                                                                    var32_69 = Math.min(this.min_biased_peers, this.biased_peers.size());
                                                                                }
                                                                                break block108;
                                                                            }
                                                                            var41_116 = null;
                                                                            this.peer_list_compaction_suspended = false;
                                                                            if (!var28_33) break block106;
                                                                            this.checkForPeerListCompaction(false);
                                                                            break block106;
                                                                            break;
                                                                        }
                                                                    }
                                                                    catch (Throwable var40_119) {
                                                                        var41_117 = null;
                                                                        this.peer_list_compaction_suspended = false;
                                                                        if (var28_33 == false) throw var40_119;
                                                                        this.checkForPeerListCompaction(false);
                                                                        throw var40_119;
                                                                    }
                                                                }
                                                                catch (Throwable var43_124) {
                                                                    var44_93 = null;
                                                                    this.this_mon.exit();
                                                                    throw var43_124;
                                                                }
                                                            }
                                                            for (var27_27 = 0; var27_27 < this.peer_list.size(); ++var27_27) {
                                                                block110: {
                                                                    block109: {
                                                                        var28_31 = this.peer_list.get(var27_27);
                                                                        if (var28_31 == null || var28_31 == var3_3) continue;
                                                                        if (var14_12 > var28_31.getTimeout()) {
                                                                            this.removePeer((TRTrackerServerPeerImpl)var28_31, var27_27, 5, null);
                                                                            continue;
                                                                        }
                                                                        if (var28_31.getTCPPort() == 0 || var12_10 == 0 && var28_31.getCryptoLevel() == 2 || var24_21 != null && var24_21.contains(new String(var28_31.getIP())) || !var4_4 && var28_31.isSeed()) continue;
                                                                        var29_42 = new HashMap<String, Object>(3);
                                                                        if (var19_16) {
                                                                            var29_42.put("peer id", var28_31.getPeerId().getHash());
                                                                        }
                                                                        if (var11_9 == 0) break block109;
                                                                        var30_50 = var28_31.getIPAddressBytes();
                                                                        if (var30_50 == null) continue;
                                                                        var29_42.put("ip", var30_50);
                                                                        if (var11_9 >= 2) {
                                                                            var29_42.put("azver", new Long(var28_31.getAZVer()));
                                                                            var29_42.put("azudp", new Long(var28_31.getUDPPort()));
                                                                            if (var28_31.isSeed()) {
                                                                                var29_42.put("azhttp", new Long(var28_31.getHTTPPort()));
                                                                            }
                                                                            if (var11_9 >= 16) {
                                                                                var29_42.put("ip", var28_31.getIPAsRead());
                                                                                break block110;
                                                                            } else {
                                                                                var29_42.put("azup", new Long(var28_31.getUpSpeed()));
                                                                                if (var28_31.isBiased()) {
                                                                                    var29_42.put("azbiased", "");
                                                                                }
                                                                                if (var13_11 != null && (var31_59 = var28_31.getNetworkPosition()) != null && var13_11.getPositionType() == var31_59.getPositionType()) {
                                                                                    var29_42.put("azrtt", new Long((long)var31_59.estimateRTT(var13_11)));
                                                                                }
                                                                            }
                                                                        }
                                                                        break block110;
                                                                    }
                                                                    var29_42.put("ip", var28_31.getIPAsRead());
                                                                }
                                                                var29_42.put("port", new Long(var28_31.getTCPPort()));
                                                                if (var12_10 != 0) {
                                                                    var29_42.put("crypto_flag", new Long(var28_31.getCryptoLevel() == 2 ? 1L : 0L));
                                                                }
                                                                if (var28_31.isBiased()) {
                                                                    var26_23.addFirst(var29_42);
                                                                    continue;
                                                                }
                                                                var26_23.addLast(var29_42);
                                                            }
                                                        }
                                                        if (!var4_4 || var22_19 != null || var19_16 || this.seed_count >= 3 || this.queued_peers == null) break block111;
                                                        var27_29 = this.queued_peers.iterator();
                                                        var28_34 = new ArrayList<QueuedPeer>(3);
                                                        break block112;
                                                    }
                                                    for (var33_78 = 0; var33_78 < var31_60 && var29_43 < var5_5; ++var33_78) {
                                                        block114: {
                                                            block113: {
                                                                if (var30_51 == 1 && var33_78 < var32_69) {
                                                                    var35_94 = (TRTrackerServerPeerImpl)this.biased_peers.get(var33_78);
                                                                    var34_86 = -1;
                                                                } else {
                                                                    var34_86 = this.random.nextInt(var27_28);
                                                                    var35_94 = this.peer_list.get(var34_86);
                                                                    if (var35_94 == null || var35_94.isBiased()) continue;
                                                                }
                                                                if (var14_12 > var35_94.getTimeout()) {
                                                                    this.removePeer((TRTrackerServerPeerImpl)var35_94, 5, null);
                                                                    var28_33 = true;
                                                                    continue;
                                                                }
                                                                if (var3_3 == var35_94 || var35_94.getTCPPort() == 0 || var12_10 == 0 && var35_94.getCryptoLevel() == 2 || var24_21 != null && var24_21.contains(new String(var35_94.getIP())) || !var4_4 && var35_94.isSeed()) continue;
                                                                var36_99 = var35_94.isNATStatusBad();
                                                                if ((var30_51 != 0 || var36_99) && var30_51 != 1 || var34_86 != -1 && this.duplicate_peer_checker[var34_86] == this.duplicate_peer_checker_index) continue;
                                                                if (var34_86 != -1) {
                                                                    this.duplicate_peer_checker[var34_86] = this.duplicate_peer_checker_index;
                                                                }
                                                                ++var29_43;
                                                                var37_104 = new HashMap<K, V>(3);
                                                                if (var19_16) {
                                                                    var37_104.put("peer id", var35_94.getPeerId().getHash());
                                                                }
                                                                if (var11_9 == 0) break block113;
                                                                var38_110 = var35_94.getIPAddressBytes();
                                                                if (var38_110 == null) continue;
                                                                var37_104.put("ip", var38_110);
                                                                if (var11_9 >= 2) {
                                                                    var37_104.put("azver", new Long(var35_94.getAZVer()));
                                                                    var37_104.put("azudp", new Long(var35_94.getUDPPort()));
                                                                    if (var35_94.isSeed()) {
                                                                        var37_104.put("azhttp", new Long(var35_94.getHTTPPort()));
                                                                    }
                                                                    if (var11_9 >= 16) {
                                                                        var37_104.put("ip", var35_94.getIPAsRead());
                                                                        break block114;
                                                                    } else {
                                                                        var37_104.put("azup", new Long(var35_94.getUpSpeed()));
                                                                        if (var35_94.isBiased()) {
                                                                            var37_104.put("azbiased", "");
                                                                        }
                                                                        if (var13_11 != null && (var39_115 = var35_94.getNetworkPosition()) != null && var13_11.getPositionType() == var39_115.getPositionType()) {
                                                                            var37_104.put("azrtt", new Long((long)var39_115.estimateRTT(var13_11)));
                                                                        }
                                                                    }
                                                                }
                                                                break block114;
                                                            }
                                                            var37_104.put("ip", var35_94.getIPAsRead());
                                                        }
                                                        var37_104.put("port", new Long(var35_94.getTCPPort()));
                                                        if (var12_10 != 0) {
                                                            var37_104.put("crypto_flag", new Long(var35_94.getCryptoLevel() == 2 ? 1L : 0L));
                                                        }
                                                        if (var35_94.isBiased()) {
                                                            var26_23.addFirst((Serializable)var37_104);
                                                            continue;
                                                        }
                                                        var26_23.addLast((Serializable)var37_104);
                                                    }
                                                    ++var30_51;
                                                    ** while (true)
                                                }
                                                while (var27_29.hasNext() && var5_5 > var26_23.size() && var28_34.size() < 3) {
                                                    block116: {
                                                        block115: {
                                                            var29_44 = (QueuedPeer)var27_29.next();
                                                            if (var29_44.isTimedOut(var14_12)) {
                                                                var27_29.remove();
                                                                continue;
                                                            }
                                                            if (var12_10 == 0 && var29_44.getCryptoLevel() == 2 || var24_21 != null && var24_21.contains(var29_44.getIP())) continue;
                                                            var30_53 = new HashMap<String, Object>(3);
                                                            if (var11_9 == 0) break block115;
                                                            var31_61 = var29_44.getIPAddressBytes();
                                                            if (var31_61 == null) continue;
                                                            var30_53.put("ip", var31_61);
                                                            if (var11_9 >= 2) {
                                                                var30_53.put("azver", new Long(var29_44.getAZVer()));
                                                                var30_53.put("azudp", new Long(var29_44.getUDPPort()));
                                                                if (var29_44.isSeed()) {
                                                                    var30_53.put("azhttp", new Long(var29_44.getHTTPPort()));
                                                                }
                                                                if (var11_9 >= 16) {
                                                                    var30_53.put("ip", var29_44.getIPAsRead());
                                                                }
                                                            }
                                                            break block116;
                                                        }
                                                        var30_53.put("ip", var29_44.getIPAsRead());
                                                    }
                                                    var30_53.put("port", new Long(var29_44.getTCPPort()));
                                                    if (var12_10 != 0) {
                                                        var30_53.put("crypto_flag", new Long(var29_44.getCryptoLevel() == 2 ? 1L : 0L));
                                                    }
                                                    var26_23.addLast(var30_53);
                                                    var28_34.add(var29_44);
                                                    var27_29.remove();
                                                }
                                                for (var29_45 = 0; var29_45 < var28_34.size(); ++var29_45) {
                                                    this.queued_peers.add(var28_34.get(var29_45));
                                                }
                                            }
                                            var27_30 = new TreeMap<String, Object>();
                                            if (var2_2.size() > 0) {
                                                var27_30.putAll(var2_2);
                                            }
                                            if (var22_19 != null) {
                                                for (var28_35 = 0; var28_35 < var22_19.size(); --var5_5, ++var28_35) {
                                                    var29_46 = (TRTrackerServerSimplePeer)var22_19.get(var28_35);
                                                    this.exportPeer((LinkedList)var26_23, var29_46, var19_16, var11_9, var12_10, var13_11);
                                                }
                                            }
                                            if (var23_20 != null) {
                                                for (var28_36 = 0; var28_36 < var23_20.size(); --var5_5, ++var28_36) {
                                                    var29_47 = (TRTrackerServerSimplePeer)var23_20.get(var28_36);
                                                    this.exportPeer((LinkedList)var26_23, var29_47, var19_16, var11_9, var12_10, var13_11);
                                                }
                                            }
                                            if (this.explicit_manual_biased_peers != null && var3_3 != null && !var3_3.isSeed()) {
                                                var28_37 = (Object[])this.explicit_manual_biased_peers.get(this.explicit_next_peer++);
                                                if (this.explicit_next_peer == this.explicit_manual_biased_peers.size()) {
                                                    this.explicit_next_peer = 0;
                                                }
                                                var29_48 = new HashMap<String, Object>(3);
                                                if (var19_16) {
                                                    var30_54 = new byte[20];
                                                    this.random.nextBytes(var30_54);
                                                    var29_48.put("peer id", var30_54);
                                                }
                                                if (var11_9 != 0) {
                                                    var30_55 = (byte[])var28_37[1];
                                                    var29_48.put("ip", var30_55);
                                                    if (var11_9 >= 2) {
                                                        var29_48.put("azver", new Long(0L));
                                                        var29_48.put("azudp", new Long(0L));
                                                        var29_48.put("azup", new Long(0L));
                                                        var29_48.put("azbiased", "");
                                                    }
                                                } else {
                                                    var29_48.put("ip", ((String)var28_37[0]).getBytes());
                                                }
                                                var29_48.put("port", new Long(((Integer)var28_37[2]).intValue()));
                                                if (var12_10 != 0) {
                                                    var29_48.put("crypto_flag", new Long(0L));
                                                }
                                                var26_23.addFirst(var29_48);
                                            }
                                            var28_38 = var26_23.size();
                                            var29_49 = var26_23.iterator();
                                            if (var11_9 != 2) break block117;
                                            var30_56 = new byte[var28_38 * 9];
                                            var31_62 = 0;
                                            break block118;
                                        }
                                        if (var11_9 != 3) break block119;
                                        var30_56 = new ArrayList<E>(var28_38);
                                        break block120;
                                    }
                                    if (var11_9 != 16) break block121;
                                    var30_56 = new ArrayList<E>(var28_38);
                                    while (var29_49.hasNext()) {
                                        var31_64 = (Map)var29_49.next();
                                        var32_72 = new HashMap<String, V>();
                                        var30_56.add(var32_72);
                                        var32_72.put("ip", var31_64.get("ip"));
                                        var32_72.put("tcp", var31_64.get("port"));
                                        var33_81 = ((Long)var31_64.get("azudp")).intValue();
                                        if (var33_81 != 0) {
                                            var32_72.put("udp", new Long(var33_81));
                                        }
                                        if ((var34_89 = (Long)var31_64.get("azhttp")) == null || (var35_98 = var34_89.intValue()) == 0) continue;
                                        var32_72.put("http", new Long(var35_98));
                                    }
                                    var27_30.put("peers", var30_56);
                                    break block122;
                                }
                                var30_56 = null;
                                if (var12_10 != 0) {
                                    var30_56 = new byte[var28_38];
                                }
                                if (var11_9 != 1) break block123;
                                var31_65 = new byte[var28_38 * 6];
                                var32_73 = 0;
                                var33_82 = 0;
                                var34_90 = 0;
                                break block124;
                            }
                            var31_66 = 0;
                            while (var29_49.hasNext()) {
                                var32_74 = (Map)var29_49.next();
                                if (var30_56 != null) {
                                    var33_83 = (Long)var32_74.remove("crypto_flag");
                                    var30_56[var31_66] = var33_83.byteValue();
                                }
                                ++var31_66;
                            }
                            var27_30.put("peers", var26_23);
                            break block125;
                        }
                        while (var29_49.hasNext()) {
                            var32_70 = (Map)var29_49.next();
                            var33_79 = (byte[])var32_70.get("ip");
                            var34_87 = ((Long)var32_70.get("port")).intValue();
                            var35_96 = ((Long)var32_70.get("azudp")).intValue();
                            var36_100 = (Long)var32_70.get("crypto_flag");
                            var37_105 = var36_100 == null ? 0 : var36_100.byteValue();
                            var38_111 = var31_62 * 9;
                            System.arraycopy(var33_79, 0, var30_56, var38_111, 4);
                            var38_111 += 4;
                            var30_56[var38_111++] = (byte)(var34_87 >> 8);
                            var30_56[var38_111++] = (byte)(var34_87 & 255);
                            var30_56[var38_111++] = (byte)(var35_96 >> 8);
                            var30_56[var38_111++] = (byte)(var35_96 & 255);
                            var30_56[var38_111++] = var37_105;
                            ++var31_62;
                        }
                        var27_30.put("peers", var30_56);
                        var27_30.put("azcompact", new Long(1L));
                        break block122;
                    }
                    while (var29_49.hasNext()) {
                        var31_63 = (Map)var29_49.next();
                        var32_71 = new HashMap<String, Object>();
                        var30_56.add(var32_71);
                        var33_80 = (byte[])var31_63.get("ip");
                        var32_71.put("i", var33_80);
                        var34_88 = ((Long)var31_63.get("port")).intValue();
                        var32_71.put("t", new byte[]{(byte)(var34_88 >> 8), (byte)(var34_88 & 255)});
                        var35_97 = ((Long)var31_63.get("azudp")).intValue();
                        if (var35_97 != 0) {
                            if (var35_97 == var34_88) {
                                var32_71.put("u", new byte[0]);
                            } else {
                                var32_71.put("u", new byte[]{(byte)(var35_97 >> 8), (byte)(var35_97 & 255)});
                            }
                        }
                        if ((var36_101 = (Long)var31_63.get("azhttp")) != null && (var37_106 = var36_101.intValue()) != 0) {
                            var32_71.put("h", new byte[]{(byte)(var37_106 >> 8), (byte)(var37_106 & 255)});
                        }
                        v1 = var38_112 = (var37_104 = (Long)var31_63.get("crypto_flag")) == null ? 0 : var37_104.byteValue();
                        if (var38_112 != 0) {
                            var32_71.put("c", new byte[]{var38_112});
                        }
                        v2 = var40_120 = (var39_115 = (Long)var31_63.get("azver")) == null ? 0 : var39_115.byteValue();
                        if (var40_120 != 0) {
                            var32_71.put("v", new Long(var40_120));
                        }
                        if ((var41_116 = (Long)var31_63.get("azup")) != null && var41_116 != 0L) {
                            var32_71.put("s", var41_116);
                        }
                        if ((var42_122 = (Long)var31_63.get("azrtt")) != null) {
                            var32_71.put("r", var42_122);
                        }
                        if (!var31_63.containsKey("azbiased")) continue;
                        var32_71.put("b", new Long(1L));
                    }
                    var27_30.put("peers", var30_56);
                    var27_30.put("azcompact", new Long(2L));
                    break block122;
                }
                while (var29_49.hasNext()) {
                    var35_94 = (Map)var29_49.next();
                    var36_102 = (byte[])var35_94.get("ip");
                    if (var36_102.length > 4) {
                        ++var34_90;
                    } else {
                        ++var33_82;
                        if (var34_90 == 0) {
                            var37_107 = ((Long)var35_94.get("port")).intValue();
                            var38_113 = var32_73 * 6;
                            System.arraycopy(var36_102, 0, var31_65, var38_113, 4);
                            var38_113 += 4;
                            var31_65[var38_113++] = (byte)(var37_107 >> 8);
                            var31_65[var38_113++] = (byte)(var37_107 & 255);
                        }
                    }
                    if (var30_56 != null) {
                        var37_108 = (Long)var35_94.remove("crypto_flag");
                        var30_56[var32_73] = var37_108.byteValue();
                    }
                    ++var32_73;
                }
                if (var34_90 <= 0) {
                    var27_30.put("peers", var31_65);
                } else {
                    var35_94 = new byte[var33_82 * 6];
                    var36_103 = new byte[var34_90 * 18];
                    var29_49 = var26_23.iterator();
                    var37_109 = 0;
                    var38_114 = 0;
                    while (var29_49.hasNext()) {
                        var39_115 = (Map)var29_49.next();
                        var40_121 = (byte[])var39_115.get("ip");
                        var41_118 = ((Long)var39_115.get("port")).intValue();
                        if (var40_121.length > 4) {
                            var42_123 = var38_114 * 18;
                            System.arraycopy(var40_121, 0, var36_103, var42_123, 16);
                            var42_123 += 16;
                            var36_103[var42_123++] = (byte)(var41_118 >> 8);
                            var36_103[var42_123++] = (byte)(var41_118 & 255);
                            ++var38_114;
                            continue;
                        }
                        var42_123 = var37_109 * 6;
                        System.arraycopy(var40_121, 0, var35_94, var42_123, 4);
                        var42_123 += 4;
                        var35_94[var42_123++] = (byte)(var41_118 >> 8);
                        var35_94[var42_123++] = (byte)(var41_118 & 255);
                        ++var37_109;
                    }
                    if (((Object)var35_94).length > 0) {
                        var27_30.put("peers", var35_94);
                    }
                    if (var36_103.length > 0) {
                        var27_30.put("peers6", var36_103);
                    }
                }
            }
            if (var30_56 != null) {
                var27_30.put("crypto_flags", var30_56);
            }
        }
        var27_30.put("interval", new Long(var6_6));
        var27_30.put("min interval", new Long(var8_7));
        if (var16_13) {
            var3_3.setNATStatus((byte)5);
            var27_30.put("warning message", ("Unable to connect to your incoming data port (" + var3_3.getIP() + ":" + var3_3.getTCPPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
        }
        var27_30.put("complete", new Long(this.getSeedCountForScrape((boolean)var25_22)));
        var27_30.put("incomplete", new Long(this.getLeecherCount()));
        var27_30.put("downloaded", new Long(this.stats.getCompletedCount()));
        if (var20_17) {
            this.announce_cache.put(new Integer((var28_38 + 9) / 10), new announceCacheEntry(var27_30, var19_16, var11_9));
        }
        var30_56 = var27_30;
        var44_92 = null;
        this.this_mon.exit();
        return var30_56;
    }

    private void exportPeer(LinkedList linkedList, TRTrackerServerSimplePeer tRTrackerServerSimplePeer, boolean bl, byte by, byte by2, DHTNetworkPosition dHTNetworkPosition) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        if (bl) {
            hashMap.put("peer id", tRTrackerServerSimplePeer.getPeerId().getHash());
        }
        if (by != 0) {
            byte[] byArray = tRTrackerServerSimplePeer.getIPAddressBytes();
            if (byArray == null) {
                return;
            }
            hashMap.put("ip", byArray);
            if (by >= 2) {
                hashMap.put("azver", new Long(tRTrackerServerSimplePeer.getAZVer()));
                hashMap.put("azudp", new Long(tRTrackerServerSimplePeer.getUDPPort()));
                if (tRTrackerServerSimplePeer.isSeed()) {
                    hashMap.put("azhttp", new Long(tRTrackerServerSimplePeer.getHTTPPort()));
                }
                if (by >= 16) {
                    hashMap.put("ip", tRTrackerServerSimplePeer.getIPAsRead());
                } else {
                    DHTNetworkPosition dHTNetworkPosition2;
                    hashMap.put("azup", new Long(tRTrackerServerSimplePeer.getUpSpeed()));
                    if (tRTrackerServerSimplePeer.isBiased()) {
                        hashMap.put("azbiased", "");
                    }
                    if (dHTNetworkPosition != null && (dHTNetworkPosition2 = tRTrackerServerSimplePeer.getNetworkPosition()) != null && dHTNetworkPosition.getPositionType() == dHTNetworkPosition2.getPositionType()) {
                        hashMap.put("azrtt", new Long((long)dHTNetworkPosition2.estimateRTT(dHTNetworkPosition)));
                    }
                }
            }
        } else {
            hashMap.put("ip", tRTrackerServerSimplePeer.getIPAsRead());
        }
        hashMap.put("port", new Long(tRTrackerServerSimplePeer.getTCPPort()));
        if (by2 != 0) {
            hashMap.put("crypto_flag", new Long(tRTrackerServerSimplePeer.getCryptoLevel() == 2 ? 1L : 0L));
        }
        if (tRTrackerServerSimplePeer.isBiased()) {
            linkedList.addFirst(hashMap);
        } else {
            linkedList.addLast(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportScrapeToMap(String string, String string2, boolean bl) throws TRTrackerServerException {
        long l;
        block3: {
            try {
                this.this_mon.enter();
                this.handleRedirects(string, string2, true);
                this.stats.addScrape();
                l = SystemTime.getCurrentTime();
                long l2 = l - this.last_scrape_calc_time;
                if (!bl || this.last_scrape == null || l2 >= (long)TRTrackerServerImpl.getScrapeCachePeriod() || l2 < 0L) break block3;
                Map map = this.last_scrape;
                Object var12_8 = null;
                this.this_mon.exit();
                return map;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        this.last_scrape = new TreeMap();
        this.last_scrape_calc_time = l;
        Set set = this.server.getBiasedPeers();
        boolean bl2 = set == null ? false : set.contains(string2);
        this.last_scrape.put("complete", new Long(this.getSeedCountForScrape(bl2)));
        this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
        this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
        Map map = this.last_scrape;
        Object var12_9 = null;
        this.this_mon.exit();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        try {
            Object object;
            this.this_mon.enter();
            long l = SystemTime.getCurrentTime();
            int n = 0;
            int n2 = 0;
            try {
                this.peer_list_compaction_suspended = true;
                for (int i = 0; i < this.peer_list.size(); ++i) {
                    object = this.peer_list.get(i);
                    if (object == null) continue;
                    if (l > ((TRTrackerServerPeerImpl)object).getTimeout()) {
                        this.removePeer((TRTrackerServerPeerImpl)object, i, 5, null);
                        continue;
                    }
                    if (((TRTrackerServerPeerImpl)object).isSeed()) {
                        ++n2;
                    }
                    if (!((TRTrackerServerPeerImpl)object).isNATStatusBad()) continue;
                    ++n;
                }
                Object var8_8 = null;
                this.peer_list_compaction_suspended = false;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.peer_list_compaction_suspended = false;
                throw throwable;
            }
            this.bad_NAT_count = n;
            this.seed_count = n2;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap<HashWrapper, TRTrackerServerPeerImpl> hashMap = new HashMap<HashWrapper, TRTrackerServerPeerImpl>(this.peer_map);
                object = new HashMap<String, TRTrackerServerPeerImpl>(this.peer_reuse_map);
                this.peer_map = hashMap;
                this.peer_reuse_map = object;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator iterator = this.lightweight_seed_map.values().iterator();
            while (iterator.hasNext()) {
                object = (lightweightSeed)iterator.next();
                if (l <= ((lightweightSeed)object).getTimeout()) continue;
                iterator.remove();
            }
            Object var10_11 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void checkForPeerListCompaction(boolean bl) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (bl || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList<TRTrackerServerPeerImpl> arrayList = new ArrayList<TRTrackerServerPeerImpl>(this.peer_list.size() - this.peer_list_hole_count / 2);
            int n = 0;
            for (int i = 0; i < this.peer_list.size(); ++i) {
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = this.peer_list.get(i);
                if (tRTrackerServerPeerImpl == null) {
                    ++n;
                    continue;
                }
                arrayList.add(tRTrackerServerPeerImpl);
            }
            if (n != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = arrayList;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int n, int n2) {
        this.stats.addXferStats(n, n2);
    }

    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    protected int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    protected int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    protected int getSeedCountForScrape(boolean bl) {
        int n;
        int n2 = this.getSeedCount();
        if (this.biased_peers != null && !bl) {
            n = 0;
            for (TRTrackerServerPeerImpl tRTrackerServerPeerImpl : this.biased_peers) {
                if (!tRTrackerServerPeerImpl.isSeed()) continue;
                --n2;
                ++n;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n > 0) {
                ++n2;
            }
        }
        if ((n = this.getQueuedCount()) > 0) {
            ++n2;
        }
        return n2;
    }

    protected int getLeecherCount() {
        int n = this.peer_map.size() - this.seed_count;
        return n < 0 ? 0 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] tRTrackerServerPeerArray = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(tRTrackerServerPeerArray);
            TRTrackerServerPeer[] tRTrackerServerPeerArray2 = tRTrackerServerPeerArray;
            Object var4_3 = null;
            this.this_mon.exit();
            return tRTrackerServerPeerArray2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected int getQueuedCount() {
        LinkedList linkedList = this.queued_peers;
        if (linkedList == null) {
            return 0;
        }
        return linkedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeerBase[] getQueuedPeers() {
        block3: {
            try {
                this.this_mon.enter();
                if (this.queued_peers != null) break block3;
                TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[]{};
                Object var4_3 = null;
                this.this_mon.exit();
                return tRTrackerServerPeerBaseArray;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[this.queued_peers.size()];
        this.queued_peers.toArray(tRTrackerServerPeerBaseArray);
        TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray2 = tRTrackerServerPeerBaseArray;
        Object var4_4 = null;
        this.this_mon.exit();
        return tRTrackerServerPeerBaseArray2;
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitBiasedPeer(String string, int n) {
        byte[] byArray = HostNameToIPResolver.hostAddressToBytes(string);
        if (byArray != null) {
            try {
                this.this_mon.enter();
                if (this.explicit_manual_biased_peers == null) {
                    this.explicit_manual_biased_peers = new ArrayList();
                }
                this.explicit_manual_biased_peers.add(new Object[]{string, byArray, new Integer(n)});
                Object var5_4 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedirects(URL[] uRLArray) {
        try {
            this.this_mon.enter();
            this.redirects = uRLArray;
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public URL[] getRedirects() {
        return this.redirects;
    }

    protected void handleRedirects(String string, String string2, boolean bl) throws TRTrackerServerException {
        if (this.redirects != null) {
            if (string.indexOf("permredirect") != -1) {
                Debug.out("redirect recursion");
                throw new TRTrackerServerException("redirection recursion not supported");
            }
            URL uRL = this.redirects[string2.hashCode() % this.redirects.length];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = uRL.toString();
            if (bl) {
                int n = string3.indexOf("/announce");
                if (n == -1) {
                    return;
                }
                string3 = string3.substring(0, n) + "/scrape" + string3.substring(n + 9);
            }
            string3 = string3.indexOf(63) == -1 ? string3 + "?" : string3 + "&";
            string3 = string3 + "permredirect=1";
            if (string.length() > 0) {
                string3 = string3 + "&" + string;
            }
            System.out.println("redirect -> " + string3);
            hashMap.put("Location", string3);
            throw new TRTrackerServerException(301, "Moved Permanently", hashMap);
        }
    }

    public void addListener(TRTrackerServerTorrentListener tRTrackerServerTorrentListener) {
        this.listeners.add(tRTrackerServerTorrentListener);
        if (this.deleted) {
            tRTrackerServerTorrentListener.deleted(this);
        }
    }

    public void removeListener(TRTrackerServerTorrentListener tRTrackerServerTorrentListener) {
        this.listeners.remove(tRTrackerServerTorrentListener);
    }

    protected void peerEvent(TRTrackerServerPeer tRTrackerServerPeer, int n, String string) throws TRTrackerServerException {
        if (this.peer_listeners != null) {
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                try {
                    ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, tRTrackerServerPeer, n, string);
                    continue;
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    throw tRTrackerServerException;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void addPeerListener(TRTrackerServerTorrentPeerListener tRTrackerServerTorrentPeerListener) {
        if (this.peer_listeners == null) {
            this.peer_listeners = new ArrayList();
        }
        this.peer_listeners.add(tRTrackerServerTorrentPeerListener);
    }

    public void removePeerListener(TRTrackerServerTorrentPeerListener tRTrackerServerTorrentPeerListener) {
        if (this.peer_listeners != null) {
            this.peer_listeners.remove(tRTrackerServerTorrentPeerListener);
        }
    }

    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
        }
    }

    public String getString() {
        String string;
        if (this.redirects == null) {
            string = "none";
        } else {
            string = "";
            for (int i = 0; i < this.redirects.length; ++i) {
                string = string + (i == 0 ? "" : ",") + this.redirects[i];
            }
        }
        return "seeds=" + this.getSeedCount() + ",leechers=" + this.getLeecherCount() + ", redirect=" + string;
    }

    protected class temporaryBiasedSeed
    implements TRTrackerServerSimplePeer {
        private String ip;
        private int tcp_port;
        private HashWrapper peer_id;

        protected temporaryBiasedSeed(String string, int n) {
            this.ip = string;
            this.tcp_port = n;
            this.peer_id = new HashWrapper(RandomUtils.nextHash());
        }

        public byte[] getIPAsRead() {
            try {
                return this.ip.getBytes("ISO-8859-1");
            }
            catch (Throwable throwable) {
                return this.ip.getBytes();
            }
        }

        public byte[] getIPAddressBytes() {
            try {
                return InetAddress.getByName(this.ip).getAddress();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public HashWrapper getPeerId() {
            return this.peer_id;
        }

        public int getTCPPort() {
            return this.tcp_port;
        }

        public int getUDPPort() {
            return 0;
        }

        public int getHTTPPort() {
            return 0;
        }

        public boolean isSeed() {
            return true;
        }

        public boolean isBiased() {
            return true;
        }

        public byte getCryptoLevel() {
            return 0;
        }

        public byte getAZVer() {
            return 0;
        }

        public int getUpSpeed() {
            return 0;
        }

        public DHTNetworkPosition getNetworkPosition() {
            return null;
        }
    }

    protected static class QueuedPeer
    implements TRTrackerServerPeerBase {
        private static final byte FLAG_SEED = 1;
        private static final byte FLAG_BIASED = 2;
        private short tcp_port;
        private short udp_port;
        private short http_port;
        private byte[] ip;
        private byte crypto_level;
        private byte az_ver;
        private int create_time_secs;
        private int timeout_secs;
        private byte flags;

        protected QueuedPeer(String string, int n, int n2, int n3, byte by, byte by2, int n4, boolean bl, boolean bl2) {
            try {
                this.ip = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.printStackTrace(unsupportedEncodingException);
            }
            this.tcp_port = (short)n;
            this.udp_port = (short)n2;
            this.http_port = (short)n3;
            this.crypto_level = by;
            this.az_ver = by2;
            this.setFlag((byte)1, bl);
            this.setFlag((byte)2, bl2);
            this.create_time_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            this.timeout_secs = n4 * 3;
        }

        protected boolean sameAs(TRTrackerServerPeerImpl tRTrackerServerPeerImpl) {
            return this.tcp_port == tRTrackerServerPeerImpl.getTCPPort() && Arrays.equals(this.ip, tRTrackerServerPeerImpl.getIPAsRead()) && this.isIPOverride() == tRTrackerServerPeerImpl.isIPOverride();
        }

        protected boolean sameAs(QueuedPeer queuedPeer) {
            return this.tcp_port == queuedPeer.tcp_port && Arrays.equals(this.ip, queuedPeer.ip);
        }

        protected byte[] getIPAsRead() {
            return this.ip;
        }

        public String getIP() {
            try {
                return new String(this.ip, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.ip);
            }
        }

        protected boolean isSeed() {
            return this.getFlag((byte)1);
        }

        protected void setBiased(boolean bl) {
            this.setFlag((byte)2, bl);
        }

        protected boolean isBiased() {
            return this.getFlag((byte)2);
        }

        protected boolean isIPOverride() {
            return false;
        }

        protected void setFlag(byte by, boolean bl) {
            this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
        }

        protected boolean getFlag(byte by) {
            return (this.flags & by) != 0;
        }

        protected byte[] getIPAddressBytes() {
            try {
                return HostNameToIPResolver.hostAddressToBytes(new String(this.ip, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.printStackTrace(unsupportedEncodingException);
                return null;
            }
        }

        public int getTCPPort() {
            return this.tcp_port & 0xFFFF;
        }

        public int getUDPPort() {
            return this.udp_port & 0xFFFF;
        }

        public int getHTTPPort() {
            return this.http_port & 0xFFFF;
        }

        protected byte getCryptoLevel() {
            return this.crypto_level;
        }

        protected byte getAZVer() {
            return this.az_ver;
        }

        protected int getCreateTime() {
            return this.create_time_secs;
        }

        protected boolean isTimedOut(long l) {
            int n = (int)(l / 1000L);
            if (n < this.create_time_secs) {
                this.create_time_secs = n;
            }
            return this.create_time_secs + this.timeout_secs < n;
        }

        public int getSecsToLive() {
            int n = (int)(SystemTime.getCurrentTime() / 1000L);
            if (n < this.create_time_secs) {
                this.create_time_secs = n;
            }
            return this.create_time_secs + this.timeout_secs - n;
        }

        protected String getString() {
            return new String(this.ip) + ":" + this.getTCPPort() + "/" + this.getUDPPort() + "/" + this.getCryptoLevel();
        }
    }

    protected static class lightweightSeed {
        long timeout;
        long last_contact_time;
        long uploaded;
        byte nat_status;

        protected lightweightSeed(long l, long l2, long l3, byte by) {
            this.last_contact_time = l;
            this.timeout = l2;
            this.uploaded = l3;
            this.nat_status = by;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }

    static class announceCacheEntry {
        protected Map data;
        protected boolean send_peer_ids;
        protected byte compact_mode;
        protected long time;

        protected announceCacheEntry(Map map, boolean bl, byte by) {
            this.data = map;
            this.send_peer_ids = bl;
            this.compact_mode = by;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected byte getCompactMode() {
            return this.compact_mode;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }
}

