/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class PRHelpers {
    public static int addressToInt(String string) throws UnknownHostException {
        InetAddress inetAddress = HostNameToIPResolver.syncResolve(string);
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        return n;
    }

    public static int addressToInt(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        return n;
    }

    public static long addressToLong(InetAddress inetAddress) {
        return (long)PRHelpers.addressToInt(inetAddress) & 0xFFFFFFFFL;
    }

    public static String intToAddress(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        try {
            String string = InetAddress.getByAddress(byArray).getHostAddress();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            Debug.printStackTrace(unknownHostException);
            return null;
        }
    }

    public static void addressTo4ByteArray(String string, byte[] byArray, int n) throws UnknownHostException {
        InetAddress inetAddress = HostNameToIPResolver.syncResolve(string);
        byte[] byArray2 = inetAddress.getAddress();
        System.arraycopy(byArray2, 0, byArray, n, 4);
    }

    public static String DNSToIPAddress(String string) throws UnknownHostException {
        return HostNameToIPResolver.syncResolve(string).getHostAddress();
    }
}

