/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader;

import java.io.File;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderImpl;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TorrentDownloaderFactory {
    private static TorrentDownloaderImpl getClass(boolean bl) {
        try {
            return (TorrentDownloaderImpl)Class.forName("org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloader" + (bl ? "Logged" : "") + "Impl").newInstance();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return null;
        }
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, String string3, boolean bl) {
        return TorrentDownloaderFactory.create(torrentDownloaderCallBackInterface, string, string2, null, string3, bl);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, String string3) {
        return TorrentDownloaderFactory.create(torrentDownloaderCallBackInterface, string, string2, string3, false);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, Map map, String string3) {
        return TorrentDownloaderFactory.create(torrentDownloaderCallBackInterface, string, string2, map, string3, false);
    }

    private static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, Map map, String string3, boolean bl) {
        return new TorrentDownloadRetrier(torrentDownloaderCallBackInterface, string, string2, map, string3, bl);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, boolean bl) {
        return TorrentDownloaderFactory.create(torrentDownloaderCallBackInterface, string, null, null, bl);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string) {
        return TorrentDownloaderFactory.create(torrentDownloaderCallBackInterface, string, null, null, false);
    }

    public static TorrentDownloader create(String string, String string2, boolean bl) {
        return TorrentDownloaderFactory.create(null, string, null, string2, bl);
    }

    public static TorrentDownloader create(String string, String string2) {
        return TorrentDownloaderFactory.create(null, string, null, string2, false);
    }

    public static TorrentDownloader create(String string, boolean bl) {
        return TorrentDownloaderFactory.create(null, string, null, null, bl);
    }

    public static TorrentDownloader create(String string) {
        return TorrentDownloaderFactory.create(null, string, null, null, false);
    }

    public static void initManager(GlobalManager globalManager, boolean bl, boolean bl2, String string) {
        TorrentDownloaderManager.getInstance().init(globalManager, bl, bl2, string);
    }

    public static TorrentDownloader downloadManaged(String string, String string2, boolean bl) {
        return TorrentDownloaderManager.getInstance().download(string, string2, bl);
    }

    public static TorrentDownloader downloadManaged(String string, String string2) {
        return TorrentDownloaderManager.getInstance().download(string, string2);
    }

    public static TorrentDownloader downloadManaged(String string, boolean bl) {
        return TorrentDownloaderManager.getInstance().download(string, bl);
    }

    public static TorrentDownloader downloadManaged(String string) {
        return TorrentDownloaderManager.getInstance().download(string);
    }

    private static class TorrentDownloadRetrier
    implements TorrentDownloader {
        private final String url;
        private final String referrer;
        private final Map request_properties;
        private final String fileordir;
        private final boolean logged;
        private volatile TorrentDownloaderImpl delegate;
        private volatile boolean cancelled;
        private volatile boolean sdp_set;
        private volatile String sdp_path;
        private volatile String sdp_file;
        private volatile boolean dfoc_set;
        private volatile boolean dfoc;
        private volatile boolean irc_set;
        private volatile boolean irc;

        private TorrentDownloadRetrier(final TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, Map map, String string3, boolean bl) {
            this.url = string;
            this.referrer = string2;
            this.request_properties = map;
            this.fileordir = string3;
            this.logged = bl;
            TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface2 = new TorrentDownloaderCallBackInterface(){
                private TorrentDownloaderCallBackInterface original_callback;
                private boolean no_retry;
                private boolean init_reported;
                private boolean start_reported;
                {
                    this.original_callback = torrentDownloaderCallBackInterface;
                    this.no_retry = this.original_callback == null;
                    this.init_reported = false;
                    this.start_reported = false;
                }

                public void TorrentDownloaderEvent(int n, TorrentDownloader torrentDownloader) {
                    if (torrentDownloader != TorrentDownloadRetrier.this.delegate) {
                        return;
                    }
                    if (n == 0) {
                        if (this.init_reported) {
                            return;
                        }
                        this.init_reported = true;
                    }
                    if (n == 1) {
                        if (this.start_reported) {
                            return;
                        }
                        this.start_reported = true;
                    }
                    if (TorrentDownloadRetrier.this.cancelled) {
                        this.no_retry = true;
                    }
                    if (this.no_retry) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(n, TorrentDownloadRetrier.this);
                        }
                        return;
                    }
                    if (n == 3 || n == 5 || n == 6) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(n, TorrentDownloadRetrier.this);
                        }
                        this.no_retry = true;
                        return;
                    }
                    if (n == 4) {
                        String string = TorrentDownloadRetrier.this.url.toLowerCase().trim();
                        String string2 = null;
                        if (string.startsWith("http")) {
                            string2 = UrlUtils.parseTextForURL(TorrentDownloadRetrier.this.url.substring(5), true);
                        }
                        if (string2 != null) {
                            TorrentDownloadRetrier.this.delegate = TorrentDownloaderFactory.getClass(TorrentDownloadRetrier.this.logged);
                            if (TorrentDownloadRetrier.this.sdp_set) {
                                TorrentDownloadRetrier.this.delegate.setDownloadPath(TorrentDownloadRetrier.this.sdp_path, TorrentDownloadRetrier.this.sdp_file);
                            }
                            if (TorrentDownloadRetrier.this.dfoc_set) {
                                TorrentDownloadRetrier.this.delegate.setDeleteFileOnCancel(TorrentDownloadRetrier.this.dfoc);
                            }
                            if (TorrentDownloadRetrier.this.irc_set) {
                                TorrentDownloadRetrier.this.delegate.setIgnoreReponseCode(TorrentDownloadRetrier.this.irc);
                            }
                            TorrentDownloadRetrier.this.delegate.init(this, string2, TorrentDownloadRetrier.this.referrer, TorrentDownloadRetrier.this.request_properties, TorrentDownloadRetrier.this.fileordir);
                            this.no_retry = true;
                            TorrentDownloadRetrier.this.delegate.start();
                            return;
                        }
                        this.no_retry = true;
                    }
                    if (this.original_callback != null) {
                        this.original_callback.TorrentDownloaderEvent(n, TorrentDownloadRetrier.this);
                    }
                }
            };
            this.delegate = TorrentDownloaderFactory.getClass(this.logged);
            this.delegate.init(torrentDownloaderCallBackInterface2, this.url, this.referrer, this.request_properties, this.fileordir);
        }

        public void start() {
            this.delegate.start();
        }

        public void cancel() {
            this.cancelled = true;
            this.delegate.cancel();
        }

        public void setDownloadPath(String string, String string2) {
            this.sdp_set = true;
            this.sdp_path = string;
            this.sdp_file = string2;
            this.delegate.setDownloadPath(string, string2);
        }

        public int getDownloadState() {
            return this.delegate.getDownloadState();
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public int getPercentDone() {
            return this.delegate.getPercentDone();
        }

        public int getTotalRead() {
            return this.delegate.getTotalRead();
        }

        public String getError() {
            return this.delegate.getError();
        }

        public String getStatus() {
            return this.delegate.getStatus();
        }

        public String getURL() {
            return this.delegate.getURL();
        }

        public int getLastReadCount() {
            return this.delegate.getLastReadCount();
        }

        public byte[] getLastReadBytes() {
            return this.delegate.getLastReadBytes();
        }

        public boolean getDeleteFileOnCancel() {
            return this.delegate.getDeleteFileOnCancel();
        }

        public void setDeleteFileOnCancel(boolean bl) {
            this.dfoc_set = true;
            this.dfoc = bl;
            this.delegate.setDeleteFileOnCancel(bl);
        }

        public boolean isIgnoreReponseCode() {
            return this.delegate.isIgnoreReponseCode();
        }

        public void setIgnoreReponseCode(boolean bl) {
            this.irc_set = true;
            this.irc = bl;
            this.delegate.setIgnoreReponseCode(bl);
        }
    }
}

