/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlotManager;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
ParameterListener,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final boolean TEST_PERIODIC_SEEDING_SCAN_FAIL_HANDLING = false;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int CHECK_REASON_BAD_PIECE_CHECK = 5;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static boolean disconnect_seeds_when_seeding;
    private static boolean enable_seeding_piece_rechecks;
    private static int stalled_piece_timeout;
    private static boolean fast_unchoke_new_peers;
    private static float ban_peer_discard_ratio;
    private static int ban_peer_discard_min_kb;
    private static boolean udp_fallback_for_failed_connection;
    private static boolean udp_fallback_for_dropped_connection;
    private static boolean udp_probe_enabled;
    private static boolean hide_a_piece;
    private static boolean prefer_udp_default;
    private static IpFilter ip_filter;
    private volatile boolean is_running = false;
    private volatile boolean is_destroyed = false;
    private volatile ArrayList<PEPeer> peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private PEPeerManager.StatsReceiver stats_receiver;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStats _stats;
    private int _seeds;
    private int _peers;
    private int _remotesTCPNoLan;
    private int _remotesUDPNoLan;
    private int _tcpPendingConnections;
    private int _tcpConnectingConnections;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStartedSeeding = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL;
    private volatile ArrayList<PEPeerManagerListener> peer_manager_listeners_cow = new ArrayList();
    private final List<Object[]> piece_check_result_list = new ArrayList<Object[]>();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private final int hidden_piece;
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map<Object, Object> user_data;
    private Unchoker unchoker;
    private List<Object[]> external_rate_limiters_cow;
    private int bytes_queued_for_upload;
    private int connections_with_queued_data;
    private int connections_with_queued_data_blocked;
    private int connections_unchoked;
    private List<PEPeer> sweepList = Collections.emptyList();
    private int nextPEXSweepIndex = 0;
    private final UploadHelper upload_helper = new UploadHelper(){

        @Override
        public int getPriority() {
            return 4;
        }

        @Override
        public ArrayList<PEPeer> getAllPeers() {
            return PEPeerControlImpl.this.peer_transports_cow;
        }

        @Override
        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int bad_piece_reported = -1;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_calculation;
    private static final int MAX_UDP_CONNECTIONS = 16;
    private static final int PENDING_NAT_TRAVERSAL_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final String PEER_NAT_TRAVERSE_DONE_KEY;
    private Map<String, PEPeerTransport> pending_nat_traversals = new LinkedHashMap<String, PEPeerTransport>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> entry) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private static final int UDP_RECONNECT_MAX = 16;
    private Map<String, PEPeerTransport> udp_reconnects = new LinkedHashMap<String, PEPeerTransport>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> entry) {
            return this.size() > 16;
        }
    };
    private static final int UDP_RECONNECT_MIN_MILLIS = 10000;
    private long last_udp_reconnect;
    private boolean prefer_udp;
    private static final int PREFER_UDP_BLOOM_SIZE = 10000;
    private volatile BloomFilter prefer_udp_bloom;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public String getName() {
            return "per_dl_up: " + PEPeerControlImpl.this.getDisplayName();
        }

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        public String getName() {
            return "per_dl_down: " + PEPeerControlImpl.this.getDisplayName();
        }

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }
    };
    private final int partition_id;
    private int optimisticDisconnectCount = 0;

    public PEPeerControlImpl(byte[] byArray, PEPeerManagerAdapter pEPeerManagerAdapter, DiskManager diskManager, int n) {
        this._myPeerId = byArray;
        this.adapter = pEPeerManagerAdapter;
        this.disk_mgr = diskManager;
        this.partition_id = n;
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        int n2 = this.hidden_piece = hide_a_piece ? (int)(Math.abs(this.adapter.getRandomSeed()) % (long)this._nbPieces) : -1;
        if (this.hidden_piece >= 0) {
            System.out.println("Hidden piece for " + this.getDisplayName() + " = " + this.hidden_piece);
        }
        this.piecePicker = PiecePickerFactory.create(this);
        COConfigurationManager.addParameterListener("Ip Filter Enabled", (ParameterListener)this);
        ip_filter.addListener(this);
    }

    @Override
    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece diskManagerPiece = this.dm_pieces[i];
            if (diskManagerPiece.isDone() || diskManagerPiece.getNbWritten() <= 0) continue;
            this.addPiece(new PEPieceImpl(this, diskManagerPiece, 0), i, true, null);
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this.is_running = true;
        this.adapter.getPeerManagerRegistration().activate(this);
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).register(this);
    }

    @Override
    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        this.adapter.getPeerManagerRegistration().deactivate();
        this.closeAndRemoveAllPeers("download stopped", false);
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.removePiece(this.pePieces[i], i);
        }
        COConfigurationManager.removeParameterListener("Ip Filter Enabled", this);
        ip_filter.removeListener(this);
        this.piecePicker.destroy();
        ArrayList<PEPeerManagerListener> arrayList = this.peer_manager_listeners_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).destroyed();
        }
        this.sweepList = Collections.emptyList();
        this.pending_nat_traversals.clear();
        this.udp_reconnects.clear();
        this.is_destroyed = true;
    }

    @Override
    public int getPartitionID() {
        return this.partition_id;
    }

    public boolean isDestroyed() {
        return this.is_destroyed;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    @Override
    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    @Override
    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void schedule() {
        try {
            this.updateStats();
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            }
            this.checkBadPieces();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            this.checkSeeds();
            if (!this.seeding_mode) {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        Map map;
        TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = tRTrackerAnnouncerResponse.getPeers();
        if (tRTrackerAnnouncerResponsePeerArray != null) {
            this.addPeersFromTracker(tRTrackerAnnouncerResponse.getPeers());
        }
        if ((map = tRTrackerAnnouncerResponse.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(map);
        }
    }

    @Override
    public void processTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
        if (this.is_running) {
            this.analyseTrackerResponse(tRTrackerAnnouncerResponse);
        }
    }

    private void addExtendedPeersFromTracker(Map map) {
        Map map2 = (Map)map.get("protocols");
        if (map2 != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            for (String string : map2.keySet()) {
                Map map3 = (Map)map2.get(string);
                List list = PEPeerTransportFactory.createExtendedTransports(this, string, map3);
                for (int i = 0; i < list.size(); ++i) {
                    PEPeer pEPeer = (PEPeer)list.get(i);
                    this.addPeer(pEPeer);
                }
            }
        }
    }

    @Override
    public List<PEPeer> getPeers() {
        return this.peer_transports_cow;
    }

    @Override
    public List<PEPeer> getPeers(String string) {
        ArrayList<PEPeer> arrayList = new ArrayList<PEPeer>();
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (!pEPeerTransport.getIp().equals(string)) continue;
            arrayList.add(pEPeerTransport);
        }
        return arrayList;
    }

    @Override
    public int getPendingPeerCount() {
        return this.peer_database.getDiscoveredPeerCount();
    }

    @Override
    public PeerDescriptor[] getPendingPeers() {
        return this.peer_database.getDiscoveredPeers();
    }

    @Override
    public PeerDescriptor[] getPendingPeers(String string) {
        return this.peer_database.getDiscoveredPeers(string);
    }

    @Override
    public void addPeer(PEPeer pEPeer) {
        if (!(pEPeer instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport pEPeerTransport = (PEPeerTransport)pEPeer;
        if (!ip_filter.isInRange(pEPeerTransport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            if (!arrayList.contains(pEPeerTransport)) {
                this.addToPeerTransports(pEPeerTransport);
                pEPeerTransport.start();
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                pEPeerTransport.closeConnection("already connected");
            }
        } else {
            pEPeerTransport.closeConnection("IP address blocked by filters");
        }
    }

    protected byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void removePeer(PEPeer pEPeer) {
        this.removePeer(pEPeer, "remove peer");
    }

    @Override
    public void removePeer(PEPeer pEPeer, String string) {
        if (!(pEPeer instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport pEPeerTransport = (PEPeerTransport)pEPeer;
        this.closeAndRemovePeer(pEPeerTransport, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemovePeer(PEPeerTransport pEPeerTransport, String string, boolean bl) {
        boolean bl2 = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(pEPeerTransport)) {
                ArrayList<PEPeer> arrayList = new ArrayList<PEPeer>(this.peer_transports_cow);
                arrayList.remove(pEPeerTransport);
                this.peer_transports_cow = arrayList;
                bl2 = true;
            }
            Object var7_6 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (bl2) {
            pEPeerTransport.closeConnection(string);
            this.peerRemoved(pEPeerTransport);
        } else if (bl) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveAllPeers(String string, boolean bl) {
        int n;
        PEPeerTransport pEPeerTransport;
        ArrayList<PEPeer> arrayList;
        try {
            this.peer_transports_mon.enter();
            arrayList = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
            pEPeerTransport = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            pEPeerTransport = (PEPeerTransport)arrayList.get(n);
            try {
                pEPeerTransport.closeConnection(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            try {
                this.peerRemoved(pEPeerTransport);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                pEPeerTransport = (PEPeerTransport)arrayList.get(n);
                PEPeerTransport pEPeerTransport2 = pEPeerTransport.reconnect(false, false);
            }
        }
    }

    @Override
    public void addPeer(String string, int n, int n2, boolean bl, Map map) {
        byte by = bl ? (byte)1 : 0;
        PeerItem peerItem = PeerItemFactory.createPeerItem(string, n, PeerItem.convertSourceID("Plugin"), by, n2, (byte)1, 0);
        byte by2 = 1;
        if (!this.isAlreadyConnected(peerItem)) {
            boolean bl2;
            boolean bl3 = TCPNetworkManager.TCP_OUTGOING_ENABLED && n > 0;
            boolean bl4 = bl2 = UDPNetworkManager.UDP_OUTGOING_ENABLED && n2 > 0;
            String string2 = bl3 && (!this.prefer_udp && !prefer_udp_default || !bl2) ? this.makeNewOutgoingConnection("Plugin", string, n, n2, true, bl, by2, map) : (bl2 ? this.makeNewOutgoingConnection("Plugin", string, n, n2, false, bl, by2, map) : "No usable protocol");
            if (string2 != null) {
                Debug.out("Injected peer " + string + ":" + n + " was not added - " + string2);
            }
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray) {
        for (int i = 0; i < tRTrackerAnnouncerResponsePeerArray.length; ++i) {
            byte by;
            TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer = tRTrackerAnnouncerResponsePeerArray[i];
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            boolean bl = false;
            for (by = 0; by < arrayList.size(); ++by) {
                boolean bl2;
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(by);
                if (!tRTrackerAnnouncerResponsePeer.getAddress().equals(pEPeerTransport.getIp())) continue;
                boolean bl3 = bl2 = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || pEPeerTransport.getIp().equals("127.0.0.1");
                if (bl2 && tRTrackerAnnouncerResponsePeer.getPort() != pEPeerTransport.getPort()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.peer_database != null) {
                by = tRTrackerAnnouncerResponsePeer.getProtocol() == 2 ? (byte)1 : 0;
                byte by2 = tRTrackerAnnouncerResponsePeer.getAZVersion() < 3 ? (byte)1 : 2;
                PeerItem peerItem = PeerItemFactory.createPeerItem(tRTrackerAnnouncerResponsePeer.getAddress(), tRTrackerAnnouncerResponsePeer.getPort(), PeerItem.convertSourceID(tRTrackerAnnouncerResponsePeer.getSource()), by, tRTrackerAnnouncerResponsePeer.getUDPPort(), by2, tRTrackerAnnouncerResponsePeer.getUploadSpeed());
                this.peerDiscovered(null, peerItem);
                this.peer_database.addDiscoveredPeer(peerItem);
            }
            if ((by = tRTrackerAnnouncerResponsePeer.getHTTPPort()) == 0 || this.seeding_mode) continue;
            this.adapter.addHTTPSeed(tRTrackerAnnouncerResponsePeer.getAddress(), by);
        }
    }

    private String makeNewOutgoingConnection(String string, String string2, int n, int n2, boolean bl, boolean bl2, byte by, Map map) {
        boolean bl3;
        Boolean bl4;
        if (ip_filter.isInRange(string2, this.getDisplayName(), this.getTorrentHash())) {
            return "IPFilter block";
        }
        int n3 = this.getMaxNewConnectionsAllowed();
        boolean bl5 = false;
        if (map != null && (bl4 = (Boolean)map.get(Peer.PR_PRIORITY_CONNECTION)) != null && bl4.booleanValue()) {
            bl5 = true;
        }
        if (!(n3 != 0 || string == "Plugin" && this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(string2) != 2, bl5))) {
            return "Too many connections";
        }
        boolean bl6 = bl3 = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || string2.equals("127.0.0.1");
        if (!bl3 && PeerIdentityManager.containsIPAddress(this._hash, string2)) {
            return "Already connected to IP";
        }
        if (PeerUtils.ignorePeerPort(n)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + string2 + ":" + n + " as peer port is in ignore list."));
            }
            return "TCP port in ignore list";
        }
        PEPeerTransport pEPeerTransport = PEPeerTransportFactory.createTransport(this, string, string2, n, n2, bl, bl2, by, map);
        this.addToPeerTransports(pEPeerTransport);
        return null;
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece diskManagerPiece = this.dm_pieces[i];
            if (!diskManagerPiece.isNeedsCheck()) continue;
            diskManagerPiece.setChecking();
            DiskManagerCheckRequest diskManagerCheckRequest = this.disk_mgr.createCheckRequest(i, new Integer(1));
            diskManagerCheckRequest.setAdHoc(false);
            this.disk_mgr.enqueueCheckRequest(diskManagerCheckRequest, this);
        }
    }

    private boolean checkEmptyPiece(int n) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pEPieceImpl = this.pePieces[n];
        DiskManagerPiece diskManagerPiece = this.dm_pieces[n];
        if (pEPieceImpl == null || pEPieceImpl.isRequested()) {
            return false;
        }
        if (diskManagerPiece.getNbWritten() > 0 || pEPieceImpl.getNbUnrequested() < pEPieceImpl.getNbBlocks() || pEPieceImpl.getReservedBy() != null) {
            return false;
        }
        pEPieceImpl.reset();
        this.removePiece(pEPieceImpl, n);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int n = this._nbPieces;
        PEPieceImpl[] pEPieceImplArray = this.pePieces;
        for (int i = 0; i < n; ++i) {
            this.checkEmptyPiece(i);
            PEPieceImpl pEPieceImpl = pEPieceImplArray[i];
            if (pEPieceImpl == null) continue;
            long l = pEPieceImpl.getTimeSinceLastActivity() / 1000L;
            int n2 = pEPieceImpl.getSpeed();
            if (n2 > 0 && (double)(l * (long)n2) * 0.25 > 16.0) {
                if (pEPieceImpl.getNbUnrequested() > 2) {
                    pEPieceImpl.setSpeed(n2 - 1);
                } else {
                    pEPieceImpl.setSpeed(0);
                }
            }
            if (l <= 120L) continue;
            pEPieceImpl.setSpeed(0);
            String string = pEPieceImpl.getReservedBy();
            if (string != null) {
                PEPeerTransport pEPeerTransport = this.getTransportFromAddress(string);
                if (this.needsMD5CheckOnCompletion(i)) {
                    this.badPeerDetected(string, i);
                } else if (pEPeerTransport != null) {
                    this.closeAndRemovePeer(pEPeerTransport, "Reserved piece data timeout; 120 seconds", true);
                }
                pEPieceImpl.setReservedBy(null);
            }
            if (!this.piecePicker.isInEndGameMode()) {
                pEPieceImpl.checkRequests();
            }
            this.checkEmptyPiece(i);
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            long l = SystemTime.getCurrentTime();
            for (int i = 0; i < this.pePieces.length; ++i) {
                DiskManagerPiece diskManagerPiece;
                PEPieceImpl pEPieceImpl = this.pePieces[i];
                if (pEPieceImpl == null || (diskManagerPiece = this.dm_pieces[i]).isDone() || !pEPieceImpl.isDownloaded() || l - pEPieceImpl.getLastDownloadTime(l) <= (long)stalled_piece_timeout || this.disk_mgr.hasOutstandingWriteRequestForPiece(i) || this.disk_mgr.hasOutstandingReadRequestForPiece(i) || this.disk_mgr.hasOutstandingCheckRequestForPiece(i)) continue;
                Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                pEPieceImpl.reset();
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            pEPeerTransport.checkInterested();
            if (!pEPeerTransport.isSnubbed()) continue;
            ++n;
        }
        this.setNbPeersSnubbed(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList<Object[]> arrayList;
            try {
                this.piece_check_result_list_mon.enter();
                arrayList = new ArrayList<Object[]>(this.piece_check_result_list);
                this.piece_check_result_list.clear();
                Object[] objectArray = null;
                this.piece_check_result_list_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.piece_check_result_list_mon.exit();
                throw throwable;
            }
            for (Object[] objectArray : arrayList) {
                this.processPieceCheckResult((DiskManagerCheckRequest)objectArray[0], (Integer)objectArray[1]);
            }
        }
    }

    private void checkBadPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && this.bad_piece_reported != -1) {
            DiskManagerCheckRequest diskManagerCheckRequest = this.disk_mgr.createCheckRequest(this.bad_piece_reported, new Integer(5));
            diskManagerCheckRequest.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning reported-bad piece " + this.bad_piece_reported));
            }
            this.bad_piece_reported = -1;
            try {
                this.disk_mgr.enqueueCheckRequest(diskManagerCheckRequest, this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private void checkRescan() {
        long l;
        long l2;
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        long l3 = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > l3) {
            this.rescan_piece_time = l3;
        }
        if (l3 - this.rescan_piece_time < (l2 = (l = (long)this.disk_mgr.getPieceLength()) / 250L)) {
            return;
        }
        while (this.next_rescan_piece != -1) {
            int n = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[n] != null || this.dm_pieces[n].isDone() || !this.dm_pieces[n].isNeeded()) continue;
            DiskManagerCheckRequest diskManagerCheckRequest = this.disk_mgr.createCheckRequest(n, new Integer(3));
            diskManagerCheckRequest.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning piece " + n));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(diskManagerCheckRequest, this);
            }
            catch (Throwable throwable) {
                this.rescan_piece_time = l3;
                Debug.printStackTrace(throwable);
            }
            break;
        }
    }

    @Override
    public void badPieceReported(PEPeerTransport pEPeerTransport, int n) {
        Debug.outNoStack(this.getDisplayName() + ": bad piece #" + n + " reported by " + pEPeerTransport.getIp());
        if (n < 0 || n >= this._nbPieces) {
            return;
        }
        this.bad_piece_reported = n;
    }

    @Override
    public void setStatsReceiver(PEPeerManager.StatsReceiver statsReceiver) {
        this.stats_receiver = statsReceiver;
    }

    @Override
    public void statsRequest(PEPeerTransport pEPeerTransport, Map map) {
        HashMap hashMap = new HashMap();
        this.adapter.statsRequest(pEPeerTransport, map, hashMap);
        if (hashMap.size() > 0) {
            pEPeerTransport.sendStatsReply(hashMap);
        }
    }

    @Override
    public void statsReply(PEPeerTransport pEPeerTransport, Map map) {
        PEPeerManager.StatsReceiver statsReceiver = this.stats_receiver;
        if (statsReceiver != null) {
            statsReceiver.receiveStats(pEPeerTransport, map);
        }
    }

    private void checkFinished(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (bl2) {
            Object object;
            int n;
            this.seeding_mode = true;
            this.prefer_udp_bloom = null;
            this.piecePicker.clearEndGameChunks();
            if (!bl) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (PEPeerTransport)arrayList.get(n);
                object.setSnubbed(false);
            }
            this.setNbPeersSnubbed(0);
            n = COConfigurationManager.getBooleanParameter("Check Pieces on Completion") ? 1 : 0;
            if (n != 0 && !bl) {
                object = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest((DiskManagerCheckRequest)object, this);
            }
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            try {
                this.disk_mgr.saveResumeData(false);
            }
            catch (Throwable throwable) {
                Debug.out("Failed to save resume data", throwable);
            }
            this.adapter.setStateSeeding(bl);
            this.disk_mgr.downloadEnded();
        } else {
            this.seeding_mode = false;
        }
    }

    protected void checkCompletionState() {
        boolean bl;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl2 = bl = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!bl) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeFinished = 0L;
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (bl) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long l = SystemTime.getCurrentTime();
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n;
            List list;
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            if (pEPeerTransport.getPeerState() != 30 || (list = pEPeerTransport.getExpiredRequests()) == null || list.size() <= 0) continue;
            boolean bl = pEPeerTransport.isSeed();
            long l2 = pEPeerTransport.getTimeSinceGoodDataReceived();
            if (l2 < 0L || l2 > 60000L) {
                pEPeerTransport.setSnubbed(true);
            }
            DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)list.get(0);
            long l3 = pEPeerTransport.getTimeSinceLastDataMessageReceived();
            boolean bl2 = l3 < 0L || l3 > (long)(1000 * (bl ? 120 : 60));
            long l4 = l - diskManagerReadRequest.getTimeCreated(l);
            int n2 = n = l4 > 120000L && bl2 ? 0 : 1;
            while (n < list.size()) {
                diskManagerReadRequest = (DiskManagerReadRequest)list.get(n);
                pEPeerTransport.sendCancel(diskManagerReadRequest);
                int n3 = diskManagerReadRequest.getPieceNumber();
                PEPieceImpl pEPieceImpl = this.pePieces[n3];
                if (pEPieceImpl != null) {
                    pEPieceImpl.clearRequested(diskManagerReadRequest.getOffset() / 16384);
                }
                if (!this.piecePicker.isInEndGameMode()) {
                    this.checkEmptyPiece(n3);
                }
                ++n;
            }
        }
    }

    private void updateTrackerAnnounceInterval() {
        int n;
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int n2 = this.getMaxNewConnectionsAllowed();
        boolean bl = this.adapter.isNATHealthy();
        if (bl) {
            n2 = (int)((double)n2 / 1.5);
        }
        if (n2 < 0 || n2 > 100) {
            n2 = 100;
        }
        int n3 = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tRTrackerScraperResponse = this.adapter.getTrackerScrapeResponse();
        if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.isValid()) {
            int n4;
            n = tRTrackerScraperResponse.getSeeds();
            int n5 = tRTrackerScraperResponse.getPeers();
            if (this.seeding_mode) {
                float f = (float)n5 / (float)(n + n5);
                n4 = (int)((float)n5 * f);
            } else {
                n4 = n5 + n;
            }
            if (n4 < n2) {
                n2 = n4;
            }
        }
        if (n2 < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        n = n3 * 100 / (n3 + n2);
        this.adapter.setTrackerRefreshDelayOverrides(n);
    }

    @Override
    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    @Override
    public int getBytesQueuedForUpload() {
        return this.bytes_queued_for_upload;
    }

    @Override
    public int getNbPeersWithUploadQueued() {
        return this.connections_with_queued_data;
    }

    @Override
    public int getNbPeersWithUploadBlocked() {
        return this.connections_with_queued_data_blocked;
    }

    @Override
    public int getNbPeersUnchoked() {
        return this.connections_unchoked;
    }

    @Override
    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    @Override
    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    @Override
    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    @Override
    public long getAvailWentBadTime() {
        return this.piecePicker.getAvailWentBadTime();
    }

    @Override
    public void addPeerTransport(PEPeerTransport pEPeerTransport) {
        if (!ip_filter.isInRange(pEPeerTransport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            if (!arrayList.contains(pEPeerTransport)) {
                this.addToPeerTransports(pEPeerTransport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                pEPeerTransport.closeConnection("already connected");
            }
        } else {
            pEPeerTransport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        int n = this.adapter.getMaxUploads();
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        if (this.seeding_mode) {
            if (this.unchoker == null || !this.unchoker.isSeedingUnchoker()) {
                this.unchoker = UnchokerFactory.getSingleton().getUnchoker(true);
            }
        } else if (this.unchoker == null || this.unchoker.isSeedingUnchoker()) {
            this.unchoker = UnchokerFactory.getSingleton().getUnchoker(false);
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
            boolean bl = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
            this.unchoker.calculateUnchokes(n, arrayList, bl, this.adapter.hasPriorityConnection());
            ArrayList<PEPeer> arrayList2 = this.unchoker.getChokes();
            ArrayList<PEPeer> arrayList3 = this.unchoker.getUnchokes();
            this.addFastUnchokes(arrayList3);
            UnchokerUtil.performChokes(arrayList2, arrayList3);
        } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            ArrayList<PEPeer> arrayList4 = this.unchoker.getImmediateUnchokes(n, arrayList);
            this.addFastUnchokes(arrayList4);
            UnchokerUtil.performChokes(null, arrayList4);
        }
    }

    private void addFastUnchokes(ArrayList arrayList) {
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (pEPeerTransport.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(pEPeerTransport, true) || arrayList.contains(pEPeerTransport)) continue;
            if (pEPeerTransport.isLANLocal()) {
                arrayList.add(pEPeerTransport);
                continue;
            }
            if (!fast_unchoke_new_peers || pEPeerTransport.getData("fast_unchoke_done") != null) continue;
            pEPeerTransport.setData("fast_unchoke_done", "");
            arrayList.add(pEPeerTransport);
        }
    }

    private void sendHave(int n) {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            pEPeerTransport.sendHave(n);
        }
    }

    private void checkSeeds() {
        int n;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding) {
            return;
        }
        ArrayList<PEPeerTransport> arrayList = null;
        ArrayList<PEPeer> arrayList2 = this.peer_transports_cow;
        for (n = 0; n < arrayList2.size(); ++n) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList2.get(n);
            if (pEPeerTransport == null || pEPeerTransport.getPeerState() != 30 || (!this.isSeeding() || !pEPeerTransport.isSeed()) && !pEPeerTransport.isRelativeSeed()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PEPeerTransport>();
            }
            arrayList.add(pEPeerTransport);
        }
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.closeAndRemovePeer((PEPeerTransport)arrayList.get(n), "disconnect other seed when seeding", false);
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (PEPeerTransport pEPeerTransport : arrayList) {
            if (pEPeerTransport.getPeerState() == 30) {
                Connection connection;
                if (!pEPeerTransport.isChokedByMe()) {
                    ++n10;
                }
                if ((connection = pEPeerTransport.getPluginConnection()) != null) {
                    OutgoingMessageQueue outgoingMessageQueue = connection.getOutgoingMessageQueue();
                    int n11 = outgoingMessageQueue.getDataQueuedBytes() + outgoingMessageQueue.getProtocolQueuedBytes();
                    n7 += n11;
                    if (n11 > 0) {
                        ++n8;
                        if (outgoingMessageQueue.isBlocked()) {
                            ++n9;
                        }
                    }
                }
                if (pEPeerTransport.isSeed()) {
                    ++n3;
                } else {
                    ++n4;
                }
                if (!pEPeerTransport.isIncoming() || pEPeerTransport.isLANLocal()) continue;
                if (pEPeerTransport.isTCP()) {
                    ++n5;
                    continue;
                }
                ++n6;
                continue;
            }
            if (!pEPeerTransport.isTCP()) continue;
            int n12 = pEPeerTransport.getConnectionState();
            if (n12 == 0) {
                ++n;
                continue;
            }
            if (n12 != 1) continue;
            ++n2;
        }
        this._seeds = n3;
        this._peers = n4;
        this._remotesTCPNoLan = n5;
        this._remotesUDPNoLan = n6;
        this._tcpPendingConnections = n;
        this._tcpConnectingConnections = n2;
        this.bytes_queued_for_upload = n7;
        this.connections_with_queued_data = n8;
        this.connections_with_queued_data_blocked = n9;
        this.connections_unchoked = n10;
    }

    @Override
    public void requestCanceled(DiskManagerReadRequest diskManagerReadRequest) {
        int n = diskManagerReadRequest.getPieceNumber();
        PEPieceImpl pEPieceImpl = this.pePieces[n];
        if (pEPieceImpl != null) {
            pEPieceImpl.clearRequested(diskManagerReadRequest.getOffset() / 16384);
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    @Override
    public byte[][] getSecrets(int n) {
        return this.adapter.getSecrets(n);
    }

    @Override
    public byte[] getHash() {
        return this._hash.getDataID();
    }

    @Override
    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    @Override
    public byte[] getPeerId() {
        return this._myPeerId;
    }

    @Override
    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    @Override
    public void discarded(PEPeer pEPeer, int n) {
        if (n > 0) {
            this._stats.discarded(pEPeer, n);
            if (ban_peer_discard_ratio > 0.0f && !this.piecePicker.isInEndGameMode() && !this.piecePicker.hasEndGameModeBeenAbandoned()) {
                long l;
                long l2 = pEPeer.getStats().getTotalDataBytesReceived();
                long l3 = l2 - (l = pEPeer.getStats().getTotalBytesDiscarded());
                if (l3 < 0L) {
                    l3 = 0L;
                }
                if (l >= (long)(ban_peer_discard_min_kb * 1024) && (l3 == 0L || (float)l / (float)l3 >= ban_peer_discard_ratio)) {
                    this.badPeerDetected(pEPeer.getIp(), -1);
                }
            }
        }
    }

    @Override
    public void dataBytesReceived(PEPeer pEPeer, int n) {
        if (n > 0) {
            this._stats.dataBytesReceived(pEPeer, n);
            this._averageReceptionSpeed.addValue(n);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer pEPeer, int n) {
        if (n > 0) {
            this._stats.protocolBytesReceived(pEPeer, n);
        }
    }

    @Override
    public void dataBytesSent(PEPeer pEPeer, int n) {
        if (n > 0) {
            this._stats.dataBytesSent(pEPeer, n);
        }
    }

    @Override
    public void protocolBytesSent(PEPeer pEPeer, int n) {
        if (n > 0) {
            this._stats.protocolBytesSent(pEPeer, n);
        }
    }

    @Override
    public void writeCompleted(DiskManagerWriteRequest diskManagerWriteRequest) {
        int n = diskManagerWriteRequest.getPieceNumber();
        DiskManagerPiece diskManagerPiece = this.dm_pieces[n];
        if (!diskManagerPiece.isDone()) {
            PEPieceImpl pEPieceImpl = this.pePieces[n];
            if (pEPieceImpl != null) {
                pEPieceImpl.setWritten((PEPeer)diskManagerWriteRequest.getUserData(), diskManagerWriteRequest.getOffset() / 16384);
            } else {
                diskManagerPiece.setWritten(diskManagerWriteRequest.getOffset() / 16384);
            }
        }
    }

    @Override
    public void writeFailed(DiskManagerWriteRequest diskManagerWriteRequest, Throwable throwable) {
    }

    public DirectByteBuffer[] write(long l, DirectByteBuffer[] directByteBufferArray) throws Exception {
        int n;
        if (l % 16384L != 0L) {
            throw new Exception("data must start at a block offset");
        }
        int n2 = this.disk_mgr.getPieceLength();
        int n3 = 0;
        for (DirectByteBuffer directByteBuffer : directByteBufferArray) {
            n3 += directByteBuffer.remaining((byte)8);
        }
        long l2 = 0L;
        int n4 = 0;
        for (int i = 0; i < n3; i += 16384) {
            int n5;
            int n6;
            DiskManagerPiece diskManagerPiece;
            int n7;
            n = n3 - i;
            if (n > 16384) {
                n = 16384;
            }
            if (n < (n7 = (diskManagerPiece = this.dm_pieces[n6 = (int)(l / (long)n2)]).getBlockSize(n5 = (int)(l - (long)(n6 * n2)) / 16384))) break;
            DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)9, n7);
            this.writeBlock(n6, n5 * 16384, directByteBuffer, null, true);
            l2 += (long)n;
            l += (long)n;
        }
        ArrayList<DirectByteBuffer> arrayList = new ArrayList<DirectByteBuffer>();
        for (n = n4; n < directByteBufferArray.length; ++n) {
            if (directByteBufferArray[n].hasRemaining((byte)8)) {
                arrayList.add(directByteBufferArray[n]);
                continue;
            }
            directByteBufferArray[n].returnToPool();
        }
        return arrayList.toArray(new DirectByteBuffer[arrayList.size()]);
    }

    @Override
    public void writeBlock(int n, int n2, DirectByteBuffer directByteBuffer, PEPeer pEPeer, boolean bl) {
        DiskManagerPiece diskManagerPiece = this.dm_pieces[n];
        int n3 = n2 / 16384;
        if (diskManagerPiece.isWritten(n3)) {
            directByteBuffer.returnToPool();
            return;
        }
        PEPieceImpl pEPieceImpl = this.pePieces[n];
        if (pEPieceImpl != null) {
            pEPieceImpl.setDownloaded(n2);
        }
        DiskManagerWriteRequest diskManagerWriteRequest = this.disk_mgr.createWriteRequest(n, n2, directByteBuffer, pEPeer);
        this.disk_mgr.enqueueWriteRequest(diskManagerWriteRequest, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(n, n2);
        }
        if (bl || this.piecePicker.isInEndGameMode()) {
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            for (int i = 0; i < arrayList.size(); ++i) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
                DiskManagerReadRequest diskManagerReadRequest = this.disk_mgr.createReadRequest(n, n2, diskManagerPiece.getBlockSize(n3));
                pEPeerTransport.sendCancel(diskManagerReadRequest);
            }
        }
    }

    @Override
    public boolean isWritten(int n, int n2) {
        return this.dm_pieces[n].isWritten(n2 / 16384);
    }

    @Override
    public boolean validateReadRequest(PEPeerTransport pEPeerTransport, int n, int n2, int n3) {
        if (this.disk_mgr.checkBlockConsistencyForRead(pEPeerTransport.getClient() + ": " + pEPeerTransport.getIp(), true, n, n2, n3)) {
            DiskManagerPiece diskManagerPiece;
            int n4;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (n4 = (diskManagerPiece = this.dm_pieces[n]).getReadCount() & 0xFFFF) < 65525) {
                diskManagerPiece.setReadCount((short)(++n4));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateHintRequest(PEPeerTransport pEPeerTransport, int n, int n2, int n3) {
        return this.disk_mgr.checkBlockConsistencyForHint(pEPeerTransport.getClient() + ": " + pEPeerTransport.getIp(), n, n2, n3);
    }

    @Override
    public boolean validatePieceReply(PEPeerTransport pEPeerTransport, int n, int n2, DirectByteBuffer directByteBuffer) {
        return this.disk_mgr.checkBlockConsistencyForWrite(pEPeerTransport.getClient() + ": " + pEPeerTransport.getIp(), n, n2, directByteBuffer);
    }

    @Override
    public int getAvailability(int n) {
        return this.piecePicker.getAvailability(n);
    }

    @Override
    public void havePiece(int n, int n2, PEPeer pEPeer) {
        int n3;
        this.piecePicker.addHavePiece(pEPeer, n);
        this._stats.haveNewPiece(n2);
        if (this.superSeedMode) {
            this.superSeedPieces[n].peerHasPiece(pEPeer);
            if (n == pEPeer.getUniqueAnnounce()) {
                pEPeer.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((n3 = this.piecePicker.getAvailability(n) - 1) < 4) {
            if (this.dm_pieces[n].isDone()) {
                --n3;
            }
            if (n3 <= 0) {
                return;
            }
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
                if (pEPeerTransport == pEPeer || pEPeerTransport.getPeerState() != 30 || !pEPeerTransport.isPieceAvailable(n)) continue;
                ((PEPeerStatsImpl)pEPeerTransport.getStats()).statisticalSentPiece(n2 / n3);
            }
        }
    }

    @Override
    public int getPieceLength(int n) {
        return this.disk_mgr.getPieceLength(n);
    }

    @Override
    public int getNbPeers() {
        return this._peers;
    }

    @Override
    public int getNbSeeds() {
        return this._seeds;
    }

    @Override
    public int getNbRemoteTCPConnections() {
        return this._remotesTCPNoLan;
    }

    @Override
    public int getNbRemoteUDPConnections() {
        return this._remotesUDPNoLan;
    }

    @Override
    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    @Override
    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    @Override
    public int getNbPeersStalledPendingLoad() {
        int n = 0;
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (!pEPeerTransport.isStalledPendingLoad()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public long getETA() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_eta_calculation || l - this.last_eta_calculation > 900L) {
            long l2;
            long l3 = this.disk_mgr.getRemainingExcludingDND();
            if (l3 > 0L) {
                int n = 0;
                for (int i = 0; i < this._nbPieces; ++i) {
                    if (!this.dm_pieces[i].isInteresting()) continue;
                    n += this.dm_pieces[i].getNbWritten() * 16384;
                }
                if ((l3 -= (long)n) < 0L) {
                    l3 = 0L;
                }
            }
            if (l3 == 0L) {
                long l4 = (this._timeFinished - this._timeStarted) / 1000L;
                l2 = l4 > 1L ? l4 * -1L : 0L;
            } else {
                long l5;
                long l6 = this._averageReceptionSpeed.getAverage();
                long l7 = l5 = l6 == 0L ? 1827387392L : l3 / l6;
                if (l5 == 0L) {
                    l5 = 1L;
                }
                l2 = l5;
            }
            this.last_eta = l2;
            this.last_eta_calculation = l;
        }
        return this.last_eta;
    }

    @Override
    public boolean isRTA() {
        return this.piecePicker.getRTAProviders().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToPeerTransports(PEPeerTransport pEPeerTransport) {
        long l;
        List<Object[]> list;
        boolean bl;
        block10: {
            block9: {
                bl = false;
                try {
                    this.peer_transports_mon.enter();
                    if (pEPeerTransport.getPeerState() == 50) {
                        Object var6_3 = null;
                        this.peer_transports_mon.exit();
                        return;
                    }
                    if (this.peer_transports_cow.contains(pEPeerTransport)) {
                        Debug.out("Transport added twice");
                        break block9;
                    }
                    if (this.is_running) {
                        ArrayList<PEPeer> arrayList = new ArrayList<PEPeer>(this.peer_transports_cow.size() + 1);
                        arrayList.addAll(this.peer_transports_cow);
                        arrayList.add(pEPeerTransport);
                        this.peer_transports_cow = arrayList;
                        bl = true;
                    }
                    list = this.external_rate_limiters_cow;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.peer_transports_mon.exit();
                    throw throwable;
                }
            }
            Object var6_4 = null;
            this.peer_transports_mon.exit();
            return;
        }
        Object[] objectArray = null;
        this.peer_transports_mon.exit();
        if (!bl) {
            pEPeerTransport.closeConnection("PeerTransport added when manager not running");
            return;
        }
        boolean bl2 = pEPeerTransport.isIncoming();
        this._stats.haveNewConnection(bl2);
        if (bl2 && (l = SystemTime.getCurrentTime()) > this.last_remote_time) {
            this.last_remote_time = l;
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                objectArray = list.get(i);
                pEPeerTransport.addRateLimiter((LimitedRateGroup)objectArray[0], (Boolean)objectArray[1]);
            }
        }
        this.peerAdded(pEPeerTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        ArrayList<PEPeer> arrayList;
        try {
            this.peer_transports_mon.enter();
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                arrayList2.addAll(this.external_rate_limiters_cow);
            }
            arrayList2.add(new Object[]{limitedRateGroup, new Boolean(bl)});
            this.external_rate_limiters_cow = arrayList2;
            arrayList = this.peer_transports_cow;
            Object var6_6 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PEPeer)arrayList.get(i)).addRateLimiter(limitedRateGroup, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        ArrayList<PEPeer> arrayList;
        try {
            this.peer_transports_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                for (int i = 0; i < this.external_rate_limiters_cow.size(); ++i) {
                    Object[] objectArray = this.external_rate_limiters_cow.get(i);
                    if (objectArray[0] == limitedRateGroup) continue;
                    arrayList2.add(objectArray);
                }
                this.external_rate_limiters_cow = arrayList2.size() == 0 ? null : arrayList2;
            }
            arrayList = this.peer_transports_cow;
            Object var8_8 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PEPeerTransport)arrayList.get(i)).removeRateLimiter(limitedRateGroup, bl);
        }
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.adapter.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.adapter.getDownloadRateLimitBytesPerSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerConnectionClosed(PEPeerTransport pEPeerTransport, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            Object object;
            boolean bl6;
            this.peer_transports_mon.enter();
            int n = pEPeerTransport.getUDPListenPort();
            boolean bl7 = UDPNetworkManager.UDP_OUTGOING_ENABLED && pEPeerTransport.getUDPListenPort() > 0;
            boolean bl8 = bl6 = NetworkAdmin.getSingleton().hasIPV6Potential(true) && pEPeerTransport.getAlternativeIPv6() != null;
            if (this.is_running) {
                object = pEPeerTransport.getPeerItemIdentity();
                PeerItem peerItem = this.peer_database.getSelfPeer();
                if (peerItem == null || !peerItem.equals(object)) {
                    boolean bl9;
                    String string = pEPeerTransport.getIp();
                    try {
                        bl9 = InetAddress.getByName(string) instanceof Inet6Address;
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl9 = false;
                        bl6 = false;
                    }
                    String string2 = string + ":" + n;
                    if (pEPeerTransport.isTCP()) {
                        if (bl) {
                            if (bl7 && udp_fallback_for_failed_connection) {
                                this.pending_nat_traversals.put(string2, pEPeerTransport);
                            } else if (bl6 && !bl9) {
                                bl4 = true;
                                bl5 = true;
                            }
                        } else if (bl7 && udp_fallback_for_dropped_connection && bl2 && this.seeding_mode && pEPeerTransport.isInterested() && !pEPeerTransport.isSeed() && !pEPeerTransport.isRelativeSeed() && pEPeerTransport.getStats().getEstimatedSecondsToCompletion() > 60L && FeatureAvailability.isUDPPeerReconnectEnabled()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)pEPeerTransport, LOGID, 1, "Unexpected stream closure detected, attempting recovery"));
                            }
                            this.udp_reconnects.put(string2, pEPeerTransport);
                        } else if (bl2 && pEPeerTransport.isSafeForReconnect() && (!this.seeding_mode || !pEPeerTransport.isSeed() && !pEPeerTransport.isRelativeSeed() && pEPeerTransport.getStats().getEstimatedSecondsToCompletion() >= 60L) && this.getMaxConnections() > 0 && this.getMaxNewConnectionsAllowed() > this.getMaxConnections() / 3 && FeatureAvailability.isGeneralPeerReconnectEnabled()) {
                            bl4 = true;
                        }
                    } else if (bl && udp_fallback_for_failed_connection && pEPeerTransport.getData(PEER_NAT_TRAVERSE_DONE_KEY) == null) {
                        this.pending_nat_traversals.put(string2, pEPeerTransport);
                    }
                }
            }
            if (this.peer_transports_cow.contains(pEPeerTransport)) {
                object = new ArrayList<PEPeer>(this.peer_transports_cow);
                ((ArrayList)object).remove(pEPeerTransport);
                this.peer_transports_cow = object;
                bl3 = true;
            }
            Object var16_16 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (bl3) {
            if (pEPeerTransport.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + pEPeerTransport.getPeerState());
            }
            this.peerRemoved(pEPeerTransport);
        }
        if (bl4) {
            pEPeerTransport.reconnect(false, bl5);
        }
    }

    @Override
    public void peerAdded(PEPeer pEPeer) {
        this.adapter.addPeer(pEPeer);
        ArrayList<PEPeerManagerListener> arrayList = this.peer_manager_listeners_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).peerAdded(this, pEPeer);
        }
    }

    @Override
    public void peerRemoved(PEPeer pEPeer) {
        Object object;
        int n;
        if (this.is_running && !this.seeding_mode && (this.prefer_udp || prefer_udp_default) && (n = pEPeer.getUDPListenPort()) != 0 && n == pEPeer.getTCPListenPort()) {
            object = this.prefer_udp_bloom;
            if (object == null) {
                this.prefer_udp_bloom = BloomFilterFactory.createAddOnly(10000);
                object = this.prefer_udp_bloom;
            }
            if (object.getEntryCount() < 1000) {
                object.add(pEPeer.getIp().getBytes());
            }
        }
        if ((n = pEPeer.getUniqueAnnounce()) != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[n].peerLeft();
        }
        if ((object = pEPeer.getReservedPieceNumbers()) != null) {
            for (Object object2 : object) {
                String string;
                PEPieceImpl pEPieceImpl = this.pePieces[object2];
                if (pEPieceImpl == null || (string = pEPieceImpl.getReservedBy()) == null || !string.equals(pEPeer.getIp())) continue;
                pEPieceImpl.setReservedBy(null);
            }
        }
        this.adapter.removePeer(pEPeer);
        Object object3 = this.peer_manager_listeners_cow;
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            ((PEPeerManagerListener)((ArrayList)object3).get(i)).peerRemoved(this, pEPeer);
        }
    }

    @Override
    public void addPiece(PEPiece pEPiece, int n, PEPeer pEPeer) {
        this.addPiece(pEPiece, n, false, pEPeer);
    }

    protected void addPiece(PEPiece pEPiece, int n, boolean bl, PEPeer pEPeer) {
        this.pePieces[n] = (PEPieceImpl)pEPiece;
        ++this.nbPiecesActive;
        if (this.is_running || bl) {
            this.adapter.addPiece(pEPiece);
        }
        ArrayList<PEPeerManagerListener> arrayList = this.peer_manager_listeners_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                arrayList.get(i).pieceAdded(this, pEPiece, pEPeer);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void removePiece(PEPiece pEPiece, int n) {
        if (pEPiece != null) {
            this.adapter.removePiece(pEPiece);
        }
        this.pePieces[n] = null;
        --this.nbPiecesActive;
        ArrayList<PEPeerManagerListener> arrayList = this.peer_manager_listeners_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                arrayList.get(i).pieceRemoved(this, pEPiece);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    @Override
    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    @Override
    public long getTimeStarted() {
        return this._timeStarted;
    }

    @Override
    public long getTimeStartedSeeding() {
        return this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer directByteBuffer) {
        BrokenMd5Hasher brokenMd5Hasher = new BrokenMd5Hasher();
        brokenMd5Hasher.reset();
        int n = directByteBuffer.position((byte)8);
        brokenMd5Hasher.update(directByteBuffer.getBuffer((byte)8));
        directByteBuffer.position((byte)8, n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.position(0);
        brokenMd5Hasher.finalDigest(byteBuffer);
        byte[] byArray = new byte[16];
        byteBuffer.position(0);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get();
        }
        return byArray;
    }

    private void MD5CheckPiece(PEPiece pEPiece, boolean bl) {
        String[] stringArray = pEPiece.getWriters();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            DirectByteBuffer directByteBuffer;
            int n2 = pEPiece.getBlockSize(i);
            String string = stringArray[i];
            if (string != null && (directByteBuffer = this.disk_mgr.readBlock(pEPiece.getPieceNumber(), n, n2)) != null) {
                byte[] byArray = this.computeMd5Hash(directByteBuffer);
                directByteBuffer.returnToPool();
                directByteBuffer = null;
                pEPiece.addWrite(i, string, byArray, bl);
            }
            n += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{diskManagerCheckRequest, new Integer(bl ? 1 : 0)});
            Object var4_3 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{diskManagerCheckRequest, new Integer(2)});
            Object var3_2 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{diskManagerCheckRequest, new Integer(0)});
            Object var4_3 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable2;
        }
    }

    @Override
    public boolean needsMD5CheckOnCompletion(int n) {
        PEPieceImpl pEPieceImpl = this.pePieces[n];
        if (pEPieceImpl == null) {
            return false;
        }
        return pEPieceImpl.getPieceWrites().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPieceCheckResult(DiskManagerCheckRequest diskManagerCheckRequest, int n) {
        int n2;
        block38: {
            block37: {
                block35: {
                    block36: {
                        n2 = (Integer)diskManagerCheckRequest.getUserData();
                        try {
                            int n3 = diskManagerCheckRequest.getPieceNumber();
                            if (n2 == 2) {
                                if (n == 0) {
                                    Debug.out(this.getDisplayName() + ": Piece #" + n3 + " failed final re-check. Re-downloading...");
                                    if (!this.restart_initiated) {
                                        this.restart_initiated = true;
                                        this.adapter.restartDownload(true);
                                    }
                                }
                                Object var18_5 = null;
                                if (n2 != 3) break block35;
                                break block36;
                            }
                            if (n2 == 4 || n2 == 5) {
                                if (n != 0) break block37;
                                if (n2 == 4) {
                                    Debug.out(this.getDisplayName() + "Piece #" + n3 + " failed recheck while seeding. Re-downloading...");
                                } else {
                                    Debug.out(this.getDisplayName() + "Piece #" + n3 + " failed recheck after being reported as bad. Re-downloading...");
                                }
                                Logger.log(new LogAlert((Object)this, true, 3, "Download '" + this.getDisplayName() + "': piece " + n3 + " has been corrupted, re-downloading"));
                                if (!this.restart_initiated) {
                                    this.restart_initiated = true;
                                    this.adapter.restartDownload(true);
                                }
                                break block37;
                            }
                            PEPieceImpl pEPieceImpl = this.pePieces[n3];
                            if (n == 1) {
                                try {
                                    if (pEPieceImpl != null) {
                                        List list;
                                        if (this.needsMD5CheckOnCompletion(n3)) {
                                            this.MD5CheckPiece(pEPieceImpl, true);
                                        }
                                        if ((list = pEPieceImpl.getPieceWrites()).size() > 0) {
                                            for (int i = 0; i < pEPieceImpl.getNbBlocks(); ++i) {
                                                List list2 = pEPieceImpl.getPieceWrites(i);
                                                byte[] byArray = null;
                                                for (PEPieceWriteImpl pEPieceWriteImpl : list2) {
                                                    if (!pEPieceWriteImpl.isCorrect()) continue;
                                                    byArray = pEPieceWriteImpl.getHash();
                                                }
                                                if (byArray == null) continue;
                                                for (PEPieceWriteImpl pEPieceWriteImpl : list2) {
                                                    if (Arrays.equals(pEPieceWriteImpl.getHash(), byArray)) continue;
                                                    this.badPeerDetected(pEPieceWriteImpl.getSender(), n3);
                                                }
                                            }
                                        }
                                    }
                                    Object var13_26 = null;
                                    this.removePiece(pEPieceImpl, n3);
                                    this.sendHave(n3);
                                    break block38;
                                }
                                catch (Throwable throwable) {
                                    Object var13_27 = null;
                                    this.removePiece(pEPieceImpl, n3);
                                    this.sendHave(n3);
                                    throw throwable;
                                }
                            }
                            if (n != 0) break block38;
                            if (pEPieceImpl != null) {
                                try {
                                    String string;
                                    int n4;
                                    this.MD5CheckPiece(pEPieceImpl, false);
                                    String[] stringArray = pEPieceImpl.getWriters();
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    int[] nArray = new int[stringArray.length];
                                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                                        string = stringArray[n4];
                                        if (string == null) continue;
                                        int n5 = arrayList.indexOf(string);
                                        if (n5 == -1) {
                                            arrayList.add(string);
                                            n5 = arrayList.size() - 1;
                                        }
                                        int n6 = n5;
                                        nArray[n6] = nArray[n6] + 1;
                                    }
                                    n4 = arrayList.size();
                                    if (n4 == 1) {
                                        string = (String)arrayList.get(0);
                                        PEPeerTransport pEPeerTransport = this.getTransportFromAddress(string);
                                        if (pEPeerTransport != null) {
                                            pEPeerTransport.sendBadPiece(n3);
                                        }
                                        this.badPeerDetected(string, n3);
                                        pEPieceImpl.reset();
                                    } else if (n4 > 1) {
                                        int n7;
                                        int n8 = 0;
                                        String string2 = null;
                                        PEPeer pEPeer = null;
                                        for (n7 = 0; n7 < arrayList.size(); ++n7) {
                                            String string3;
                                            PEPeerTransport pEPeerTransport;
                                            int n9 = nArray[n7];
                                            if (n9 <= n8 || (pEPeerTransport = this.getTransportFromAddress(string3 = (String)arrayList.get(n7))) == null || pEPeerTransport.getReservedPieceNumbers() != null || ip_filter.isInRange(string3, this.getDisplayName(), this.getTorrentHash())) continue;
                                            string2 = string3;
                                            n8 = n9;
                                            pEPeer = pEPeerTransport;
                                        }
                                        if (string2 != null) {
                                            pEPieceImpl.setReservedBy(string2);
                                            pEPeer.addReservedPieceNumber(pEPieceImpl.getPieceNumber());
                                            pEPieceImpl.setRequestable();
                                            for (n7 = 0; n7 < pEPieceImpl.getNbBlocks(); ++n7) {
                                                if (stringArray[n7] != null && stringArray[n7].equals(string2)) continue;
                                                pEPieceImpl.reDownloadBlock(n7);
                                            }
                                        } else {
                                            pEPieceImpl.reset();
                                        }
                                    } else {
                                        pEPieceImpl.reset();
                                    }
                                    this.piecePicker.addEndGameChunks(pEPieceImpl);
                                    this._stats.hashFailed(pEPieceImpl.getLength());
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                    pEPieceImpl.reset();
                                }
                                break block38;
                            }
                            Debug.out(this.getDisplayName() + "Piece #" + n3 + " failed check and no active piece, resetting...");
                            this.dm_pieces[n3].reset();
                            break block38;
                        }
                        catch (Throwable throwable) {
                            Object var18_8 = null;
                            if (n2 == 3) {
                                this.rescan_piece_time = SystemTime.getCurrentTime();
                            }
                            if (this.seeding_mode) throw throwable;
                            this.checkFinished(false);
                            throw throwable;
                        }
                    }
                    this.rescan_piece_time = SystemTime.getCurrentTime();
                }
                if (this.seeding_mode) return;
                this.checkFinished(false);
                return;
            }
            Object var18_6 = null;
            if (n2 == 3) {
                this.rescan_piece_time = SystemTime.getCurrentTime();
            }
            if (this.seeding_mode) return;
            this.checkFinished(false);
            return;
        }
        Object var18_7 = null;
        if (n2 == 3) {
            this.rescan_piece_time = SystemTime.getCurrentTime();
        }
        if (this.seeding_mode) return;
        this.checkFinished(false);
    }

    private void badPeerDetected(String string, int n) {
        int n2;
        Object object;
        boolean bl = n >= 0;
        PEPeerTransport pEPeerTransport = this.getTransportFromAddress(string);
        if (bl && pEPeerTransport != null) {
            object = this.peer_manager_listeners_cow.iterator();
            while (object.hasNext()) {
                try {
                    ((PEPeerManagerListener)object.next()).peerSentBadData(this, pEPeerTransport, n);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        object = IpFilterManagerFactory.getSingleton();
        int n3 = object.getBadIps().addWarningForIp(string);
        boolean bl2 = false;
        if (n3 > 2) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                if (ip_filter.ban(string, this.getDisplayName(), false)) {
                    this.checkForBannedConnections();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)pEPeerTransport, LOGID, 3, string + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
                bl2 = true;
            }
        } else if (!bl) {
            bl2 = true;
        }
        if (bl2 && pEPeerTransport != null && (n2 = pEPeerTransport.getPeerState()) != 40 && n2 != 50) {
            this.closeAndRemovePeer(pEPeerTransport, "has sent too many " + (bl ? "bad pieces" : "discarded blocks") + ", " + 2 + " max.", true);
        }
    }

    @Override
    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    @Override
    public PEPiece getPiece(int n) {
        return this.pePieces[n];
    }

    @Override
    public PEPeerStats createPeerStats(PEPeer pEPeer) {
        return new PEPeerStatsImpl(pEPeer);
    }

    @Override
    public DiskManagerReadRequest createDiskManagerRequest(int n, int n2, int n3) {
        return this.disk_mgr.createReadRequest(n, n2, n3);
    }

    @Override
    public boolean requestExists(String string, int n, int n2, int n3) {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        DiskManagerReadRequest diskManagerReadRequest = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            if (!pEPeerTransport.getIp().equals(string)) continue;
            if (diskManagerReadRequest == null) {
                diskManagerReadRequest = this.createDiskManagerRequest(n, n2, n3);
            }
            if (pEPeerTransport.getRequestIndex(diskManagerReadRequest) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean seedPieceRecheck() {
        DiskManagerPiece diskManagerPiece;
        int n;
        Object object;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.dm_pieces.length; ++i) {
            object = this.dm_pieces[i];
            if (!object.isDone()) continue;
            n = object.getReadCount() & 0xFFFF;
            if (n > 65526) {
                if (--n == 65526) {
                    n = 0;
                }
                object.setReadCount((short)n);
                continue;
            }
            if (n <= n2) continue;
            n2 = n;
            n3 = i;
        }
        if (n2 > 0 && n2 >= (diskManagerPiece = this.dm_pieces[n3]).getNbBlocks() * 3) {
            object = this.disk_mgr.createCheckRequest(n3, new Integer(4));
            object.setAdHoc(true);
            object.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + n3 + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest((DiskManagerCheckRequest)object, this);
            diskManagerPiece.setReadCount((short)-1);
            for (n = 0; n < this.dm_pieces.length; ++n) {
                int n4;
                if (n == n3 || (n4 = this.dm_pieces[n].getReadCount() & 0xFFFF) >= 65526) continue;
                this.dm_pieces[n].setReadCount((short)0);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PEPeerManagerListener pEPeerManagerListener) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> arrayList = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            arrayList.addAll(this.peer_manager_listeners_cow);
            arrayList.add(pEPeerManagerListener);
            this.peer_manager_listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PEPeerManagerListener pEPeerManagerListener) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> arrayList = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow);
            arrayList.remove(pEPeerManagerListener);
            this.peer_manager_listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void parameterChanged(String string) {
        if (string.equals("Ip Filter Enabled")) {
            this.checkForBannedConnections();
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            int n;
            ArrayList<PEPeerTransport> arrayList = null;
            ArrayList<PEPeer> arrayList2 = this.peer_transports_cow;
            String string = this.getDisplayName();
            byte[] byArray = this.getTorrentHash();
            for (n = 0; n < arrayList2.size(); ++n) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList2.get(n);
                if (!ip_filter.isInRange(pEPeerTransport.getIp(), string, byArray)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<PEPeerTransport>();
                }
                arrayList.add(pEPeerTransport);
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    this.closeAndRemovePeer((PEPeerTransport)arrayList.get(n), "IPFilter banned IP address", true);
                }
            }
        }
    }

    @Override
    public boolean isSeeding() {
        return this.seeding_mode;
    }

    @Override
    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    @Override
    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    @Override
    public boolean canToggleSuperSeedMode() {
        if (this.superSeedMode) {
            return true;
        }
        return this.superSeedPieces == null && this.getRemaining() == 0L;
    }

    @Override
    public void setSuperSeedMode(boolean bl) {
        if (bl == this.superSeedMode) {
            return;
        }
        boolean bl2 = false;
        if (bl) {
            if (this.superSeedPieces == null && this.getRemaining() == 0L) {
                this.superSeedMode = true;
                this.initialiseSuperSeedMode();
                bl2 = true;
            }
        } else {
            this.superSeedMode = false;
            bl2 = true;
        }
        if (bl2) {
            ArrayList<PEPeer> arrayList = this.peer_transports_cow;
            for (int i = 0; i < arrayList.size(); ++i) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
                this.closeAndRemovePeer(pEPeerTransport, "Turning on super-seeding", false);
            }
        }
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
        }
    }

    private void updatePeersInSuperSeedMode() {
        int n;
        if (!this.superSeedMode) {
            return;
        }
        for (n = 0; n < this.superSeedPieces.length; ++n) {
            this.superSeedPieces[n].updateTime();
        }
        n = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * n) {
            return;
        }
        PEPeer pEPeer = null;
        ArrayList<SuperSeedPeer> arrayList = null;
        ArrayList<PEPeer> arrayList2 = this.peer_transports_cow;
        arrayList = new ArrayList<SuperSeedPeer>(arrayList2.size());
        Iterator<PEPeer> iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new SuperSeedPeer(iterator.next()));
        }
        Collections.sort(arrayList);
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PEPeer pEPeer2 = ((SuperSeedPeer)((Object)iterator.next())).peer;
            if (pEPeer2.getUniqueAnnounce() != -1 || pEPeer2.getPeerState() != 30) continue;
            pEPeer = pEPeer2;
            break;
        }
        if (pEPeer == null || pEPeer.getPeerState() >= 40) {
            return;
        }
        if (pEPeer.getUploadHint() == 0) {
            pEPeer.setUploadHint(31536000);
        }
        boolean bl = false;
        SuperSeedPiece superSeedPiece = null;
        while (!bl) {
            superSeedPiece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (superSeedPiece.getLevel() > 0) {
                superSeedPiece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                this.superSeedMode = false;
                this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                return;
            }
            bl = true;
        }
        if (superSeedPiece == null) {
            return;
        }
        if (pEPeer.isPieceAvailable(superSeedPiece.getPieceNumber())) {
            return;
        }
        pEPeer.setUniqueAnnounce(superSeedPiece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        superSeedPiece.pieceRevealedToPeer();
        ((PEPeerTransport)pEPeer).sendHave(superSeedPiece.getPieceNumber());
    }

    @Override
    public void updateSuperSeedPiece(PEPeer pEPeer, int n) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[n].peerHasPiece(null);
        if (pEPeer.getUniqueAnnounce() == n) {
            pEPeer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    @Override
    public boolean isExtendedMessagingEnabled() {
        return this.adapter.isExtendedMessagingEnabled();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    @Override
    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    @Override
    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String string) {
        block3: {
            try {
                this.this_mon.enter();
                if (this.user_data != null) break block3;
                Object var2_2 = null;
                Object var4_4 = null;
                this.this_mon.exit();
                return var2_2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object object = this.user_data.get(string);
        Object var4_5 = null;
        this.this_mon.exit();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String string, Object object) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap<Object, Object>();
            }
            if (object == null) {
                if (this.user_data.containsKey(string)) {
                    this.user_data.remove(string);
                }
            } else {
                this.user_data.put(string, object);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getConnectTimeout(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            return n;
        }
        if (this.seeding_mode) {
            return n;
        }
        int n4 = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS;
        if (n4 >= 50) {
            return n;
        }
        int n5 = this._seeds + this._peers;
        int n6 = this._tcpConnectingConnections;
        int n7 = this._tcpPendingConnections;
        int n8 = this.peer_database.getDiscoveredPeerCount();
        int n9 = n6 + n7 + n8;
        if (n9 <= (n3 = (n2 = this.getMaxConnections()) / 4) || n2 == n3) {
            return n;
        }
        if (n9 >= n2) {
            return 7500;
        }
        int n10 = n9 - n3;
        int n11 = n2 - n3;
        int n12 = 7500 + (n - 7500) * (n11 - n10) / n11;
        return n12;
    }

    private void doConnectionChecks() {
        long l;
        int n;
        int n2;
        ArrayList<PEPeer> arrayList;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int n3;
            int n4;
            int n5;
            int n6;
            arrayList = this.peer_transports_cow;
            n2 = 0;
            n = 0;
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(n6);
                n5 = pEPeerTransport.getConnectionState();
                if (n5 == 0 || n5 == 1) {
                    ++n2;
                }
                if (pEPeerTransport.isTCP()) continue;
                ++n;
            }
            n6 = this.getMaxSeedConnections();
            if (n6 > 0 && (n4 = this._seeds - n6) > 0) {
                for (n5 = arrayList.size() - 1; n5 >= 0 && n4 > 0; --n5) {
                    PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(n5);
                    if (!pEPeerTransport.isSeed()) continue;
                    this.closeAndRemovePeer(pEPeerTransport, "Too many seeds", false);
                    --n4;
                }
            }
            if ((n3 = this.getMaxNewConnectionsAllowed()) < 0 || n3 > 1000) {
                n3 = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                n5 = this.getMaxConnections() / 20;
                n3 -= n5;
            }
            if (n3 > 0) {
                PeerItem peerItem;
                n5 = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - n2;
                if (n5 > n3) {
                    n2 += n5 - n3;
                }
                int n7 = n3;
                int n8 = TCPNetworkManager.getSingleton().getConnectDisconnectManager().getMaxOutboundPermitted();
                int n9 = UDPNetworkManager.getSingleton().getConnectionManager().getMaxOutboundPermitted();
                while (n2 < TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && (n8 > 0 || n9 > 0) && this.is_running && (peerItem = this.peer_database.getNextOptimisticConnectPeer()) != null && this.is_running) {
                    boolean bl;
                    boolean bl2;
                    PeerItem peerItem2 = this.peer_database.getSelfPeer();
                    if (peerItem2 != null && peerItem2.equals(peerItem) || this.isAlreadyConnected(peerItem)) continue;
                    String string = PeerItem.convertSourceString(peerItem.getSource());
                    boolean bl3 = peerItem.getHandshakeType() == 1;
                    int n10 = peerItem.getTCPPort();
                    int n11 = peerItem.getUDPPort();
                    if (n11 == 0 && udp_probe_enabled) {
                        n11 = n10;
                    }
                    boolean bl4 = bl2 = this.prefer_udp || prefer_udp_default;
                    if (bl2 && n11 == 0) {
                        byte[] byArray = peerItem.getIP().getBytes();
                        BloomFilter bloomFilter = this.prefer_udp_bloom;
                        if (bloomFilter != null && bloomFilter.contains(byArray)) {
                            n11 = n10;
                        }
                    }
                    boolean bl5 = TCPNetworkManager.TCP_OUTGOING_ENABLED && n10 > 0 && n8 > 0;
                    boolean bl6 = bl = UDPNetworkManager.UDP_OUTGOING_ENABLED && n11 > 0 && n9 > 0;
                    if (!(!bl5 || bl2 && bl)) {
                        if (this.makeNewOutgoingConnection(string, peerItem.getAddressString(), n10, n11, true, bl3, peerItem.getCryptoLevel(), null) != null) continue;
                        --n8;
                        ++n2;
                        --n7;
                        continue;
                    }
                    if (!bl || this.makeNewOutgoingConnection(string, peerItem.getAddressString(), n10, n11, false, bl3, peerItem.getCryptoLevel(), null) != null) continue;
                    --n9;
                    ++n2;
                    --n7;
                }
                if (UDPNetworkManager.UDP_OUTGOING_ENABLED && n7 > 0 && n9 > 0 && n < 16) {
                    this.doUDPConnectionChecks(n7);
                }
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            arrayList = this.peer_transports_cow;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(n2);
                if (pEPeerTransport.doTimeoutChecks()) continue;
                pEPeerTransport.doKeepAliveCheck();
                pEPeerTransport.doPerformanceTuningCheck();
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (l = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = l;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L) {
            this.optimisticDisconnectCount = 0;
            if (this.getMaxNewConnectionsAllowed() == 0) {
                this.doOptimisticDisconnect(false, false);
            }
        }
        float f = ((float)(this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL) + 1.0f) / (1.0f * (float)MAINLOOP_SIXTY_SECOND_INTERVAL);
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            n2 = 0;
            this.sweepList = this.peer_transports_cow;
        } else {
            n2 = (int)Math.floor(f * (float)this.sweepList.size());
        }
        for (n = this.nextPEXSweepIndex; n < n2 && n < this.sweepList.size(); ++n) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)this.sweepList.get(n);
            pEPeerTransport.updatePeerExchange();
        }
        this.nextPEXSweepIndex = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doUDPConnectionChecks(int n) {
        ArrayList<PEPeerTransport> arrayList = null;
        try {
            this.peer_transports_mon.enter();
            long l = SystemTime.getCurrentTime();
            if (this.udp_reconnects.size() > 0 && l - this.last_udp_reconnect >= 10000L) {
                this.last_udp_reconnect = l;
                Iterator<PEPeerTransport> iterator = this.udp_reconnects.values().iterator();
                PEPeerTransport pEPeerTransport = iterator.next();
                iterator.remove();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LOGID, 0, "Reconnecting to previous failed peer " + pEPeerTransport.getPeerItemIdentity().getAddressString()));
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<PEPeerTransport>();
                }
                arrayList.add(pEPeerTransport);
                if (--n <= 0) {
                    Object var11_8 = null;
                    this.peer_transports_mon.exit();
                    if (arrayList == null) return;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        PEPeerTransport pEPeerTransport2 = (PEPeerTransport)arrayList.get(i);
                        pEPeerTransport2.reconnect(true, false);
                    }
                    return;
                }
            }
            if (this.pending_nat_traversals.size() == 0) {
                Object var11_9 = null;
                this.peer_transports_mon.exit();
                if (arrayList == null) return;
                for (int i = 0; i < arrayList.size(); ++i) {
                    PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
                    pEPeerTransport.reconnect(true, false);
                }
                return;
            }
            int n2 = 3;
            if (this.seeding_mode) {
                n2 = this._peers > 8 ? 0 : 1;
            } else if (this._seeds > 8) {
                n2 = 0;
            } else if (this._seeds > 4) {
                n2 = 1;
            }
            int n3 = n2 - this.udp_traversal_count;
            Iterator<PEPeerTransport> iterator = this.pending_nat_traversals.values().iterator();
            for (int i = Math.min(n, n3); i > 0 && iterator.hasNext(); --i, ++this.udp_traversal_count) {
                final PEPeerTransport pEPeerTransport = iterator.next();
                iterator.remove();
                PeerNATTraverser.getSingleton().create(this, new InetSocketAddress(pEPeerTransport.getPeerItemIdentity().getAddressString(), pEPeerTransport.getPeerItemIdentity().getUDPPort()), new PeerNATTraversalAdapter(){
                    private boolean done;

                    public void success(InetSocketAddress inetSocketAddress) {
                        this.complete();
                        PEPeerTransport pEPeerTransport2 = pEPeerTransport.reconnect(true, false);
                        if (pEPeerTransport2 != null) {
                            pEPeerTransport2.setData(PEER_NAT_TRAVERSE_DONE_KEY, "");
                        }
                    }

                    public void failed() {
                        this.complete();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            PEPeerControlImpl.this.peer_transports_mon.enter();
                            if (!this.done) {
                                this.done = true;
                                PEPeerControlImpl.this.udp_traversal_count--;
                            }
                            Object var2_1 = null;
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                            throw throwable;
                        }
                    }
                });
            }
            Object var11_10 = null;
            this.peer_transports_mon.exit();
            if (arrayList == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.peer_transports_mon.exit();
            if (arrayList == null) throw throwable;
            for (int i = 0; i < arrayList.size(); ++i) {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
                pEPeerTransport.reconnect(true, false);
            }
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            pEPeerTransport.reconnect(true, false);
        }
        return;
    }

    @Override
    public boolean doOptimisticDisconnect(boolean bl, boolean bl2) {
        long l;
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        PEPeerTransport pEPeerTransport = null;
        PEPeerTransport pEPeerTransport2 = null;
        PEPeerTransport pEPeerTransport3 = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList.size());
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport4 = (PEPeerTransport)arrayList.get(i);
            if (pEPeerTransport4.getConnectionState() != 4) continue;
            long l5 = pEPeerTransport4.getTimeSinceConnectionEstablished();
            long l6 = pEPeerTransport4.getTimeSinceLastDataMessageSent();
            arrayList2.add(l5);
            long l7 = 0L;
            if (this.seeding_mode) {
                if (l6 != -1L) {
                    l7 = l6;
                }
            } else {
                long l8 = pEPeerTransport4.getTimeSinceGoodDataReceived();
                l7 = l8 == -1L ? (l7 += l5) : (l7 += l8);
                if (!pEPeerTransport4.isInteresting()) {
                    l7 = !pEPeerTransport4.isInterested() ? (l7 += l5 + l6) : (l7 += l5 - l6);
                    l7 *= 2L;
                }
                l7 += pEPeerTransport4.getSnubbedTime();
            }
            if (!pEPeerTransport4.isIncoming()) {
                l7 *= 2L;
            }
            if (pEPeerTransport4.isLANLocal()) {
                ++n;
            } else if (l7 > l4) {
                l4 = l7;
                pEPeerTransport3 = pEPeerTransport4;
            }
            if (!this.seeding_mode) {
                PEPeerStats pEPeerStats;
                l7 += pEPeerTransport4.getSnubbedTime();
                if (pEPeerTransport4.getSnubbedTime() > 120L) {
                    l7 = (long)((double)l7 * 1.5);
                }
                if ((pEPeerStats = pEPeerTransport4.getStats()).getTotalDataBytesReceived() + pEPeerStats.getTotalDataBytesSent() > 524288L) {
                    boolean bl3 = true;
                    if (pEPeerTransport4.isSnubbed() && pEPeerStats.getTotalDataBytesReceived() < pEPeerStats.getTotalDataBytesSent()) {
                        l7 = (long)((double)l7 * 1.5);
                        bl3 = false;
                    }
                    if (pEPeerStats.getTotalDataBytesSent() > pEPeerStats.getTotalDataBytesReceived() * 10L) {
                        l7 *= 2L;
                        bl3 = false;
                    }
                    if (pEPeerStats.getTotalDataBytesReceived() > 0L && pEPeerStats.getTotalBytesDiscarded() > 0L) {
                        l7 = (long)((double)l7 * (1.0 + (double)pEPeerStats.getTotalBytesDiscarded() / (double)pEPeerStats.getTotalDataBytesReceived()));
                    }
                    if (bl3) {
                        l7 = (long)((double)l7 * 0.7);
                    }
                }
            }
            if (l7 > l2) {
                l2 = l7;
                pEPeerTransport = pEPeerTransport4;
            }
            if (!pEPeerTransport4.isSeed() && !pEPeerTransport4.isRelativeSeed() || l7 <= l3) continue;
            l3 = l7;
            pEPeerTransport2 = pEPeerTransport4;
        }
        if (arrayList2.size() > 0) {
            Collections.sort(arrayList2);
            l = (Long)arrayList2.get(arrayList2.size() / 2);
        } else {
            l = 0L;
        }
        int n2 = Math.max(this.getMaxConnections() / 30, 2);
        if (!bl && !bl2 && this.optimisticDisconnectCount >= n2 && l < 300000L) {
            return false;
        }
        if (pEPeerTransport != null) {
            if (pEPeerTransport.isLANLocal() && n < 4 && pEPeerTransport3 != null) {
                pEPeerTransport = pEPeerTransport3;
                l2 = l4;
            }
            if (this.getMaxSeedConnections() > 0 && pEPeerTransport2 != null && l2 > 300000L) {
                this.closeAndRemovePeer(pEPeerTransport2, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (pEPeerTransport != null && l2 > 300000L) {
                this.closeAndRemovePeer(pEPeerTransport, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (bl && n < 4) {
                this.closeAndRemovePeer(pEPeerTransport, "making space for LAN peer in doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (bl2) {
                this.closeAndRemovePeer(pEPeerTransport, "force removal of worst peer in doOptimisticDisconnect()", true);
                return true;
            }
        } else if (bl2 && arrayList.size() > 0) {
            PEPeerTransport pEPeerTransport5 = (PEPeerTransport)arrayList.get(new Random().nextInt(arrayList.size()));
            this.closeAndRemovePeer(pEPeerTransport5, "force removal of random peer in doOptimisticDisconnect()", true);
            return true;
        }
        return false;
    }

    @Override
    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport pEPeerTransport) {
        if (pEPeerTransport.getTCPListenPort() > 0) {
            PeerItem peerItem = PeerItemFactory.createPeerItem(pEPeerTransport.getIp(), pEPeerTransport.getTCPListenPort(), (byte)2, pEPeerTransport.getPeerItemIdentity().getHandshakeType(), pEPeerTransport.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peerItem, new PeerExchangerItem.Helper(){

                public boolean isSeed() {
                    return pEPeerTransport.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peerItem) {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            if (!pEPeerTransport.getPeerItemIdentity().equals(peerItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void peerVerifiedAsSelf(PEPeerTransport pEPeerTransport) {
        if (pEPeerTransport.getTCPListenPort() > 0) {
            PeerItem peerItem = PeerItemFactory.createPeerItem(pEPeerTransport.getIp(), pEPeerTransport.getTCPListenPort(), PeerItem.convertSourceID(pEPeerTransport.getPeerSource()), pEPeerTransport.getPeerItemIdentity().getHandshakeType(), pEPeerTransport.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peerItem);
        }
    }

    @Override
    public boolean canIPBeBanned(String string) {
        return true;
    }

    @Override
    public boolean canIPBeBlocked(String string, byte[] byArray) {
        return true;
    }

    @Override
    public long getHiddenBytes() {
        if (this.hidden_piece < 0) {
            return 0L;
        }
        return this.dm_pieces[this.hidden_piece].getLength();
    }

    @Override
    public int getHiddenPiece() {
        return this.hidden_piece;
    }

    @Override
    public void IPBlockedListChanged(IpFilter ipFilter) {
        Iterator<PEPeer> iterator = this.peer_transports_cow.iterator();
        String string = this.getDisplayName();
        byte[] byArray = this.getTorrentHash();
        while (iterator.hasNext()) {
            try {
                PEPeerTransport pEPeerTransport = (PEPeerTransport)iterator.next();
                if (!ipFilter.isInRange(pEPeerTransport.getIp(), string, byArray)) continue;
                pEPeerTransport.closeConnection("IP address blocked by filters");
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void IPBanned(BannedIp bannedIp) {
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.pePieces[i].reDownloadBlocks(bannedIp.getIp());
        }
    }

    @Override
    public int getAverageCompletionInThousandNotation() {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        if (arrayList != null) {
            long l = this.disk_mgr.getTotalLength();
            int n = l == 0L ? 1000 : (int)(1000L * (l - this.disk_mgr.getRemainingExcludingDND()) / l);
            int n2 = n == 1000 ? 0 : n;
            int n3 = n == 1000 ? 0 : 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                PEPeer pEPeer = arrayList.get(i);
                if (pEPeer.getPeerState() != 30 || pEPeer.isSeed()) continue;
                ++n3;
                n2 += pEPeer.getPercentDoneInThousandNotation();
            }
            return n3 > 0 ? n2 / n3 : 0;
        }
        return -1;
    }

    @Override
    public int getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    public int getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    @Override
    public int getMaxNewConnectionsAllowed() {
        int n = this.getMaxConnections();
        int n2 = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), n);
        return n2;
    }

    @Override
    public int getSchedulePriority() {
        return this.isSeeding() ? Integer.MAX_VALUE : this.adapter.getPosition();
    }

    @Override
    public boolean hasPotentialConnections() {
        return this.pending_nat_traversals.size() + this.peer_database.getDiscoveredPeerCount() > 0;
    }

    @Override
    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    @Override
    public PEPeerTransport getTransportFromIdentity(byte[] byArray) {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            if (!Arrays.equals(byArray, pEPeerTransport.getId())) continue;
            return pEPeerTransport;
        }
        return null;
    }

    @Override
    public PEPeerTransport getTransportFromAddress(String string) {
        ArrayList<PEPeer> arrayList = this.peer_transports_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            PEPeerTransport pEPeerTransport = (PEPeerTransport)arrayList.get(i);
            if (!string.equals(pEPeerTransport.getIp())) continue;
            return pEPeerTransport;
        }
        return null;
    }

    @Override
    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    @Override
    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    @Override
    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    @Override
    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    @Override
    public boolean getPreferUDP() {
        return this.prefer_udp;
    }

    @Override
    public void setPreferUDP(boolean bl) {
        this.prefer_udp = bl;
    }

    @Override
    public boolean isPeerSourceEnabled(String string) {
        return this.adapter.isPeerSourceEnabled(string);
    }

    @Override
    public void peerDiscovered(PEPeerTransport pEPeerTransport, PeerItem peerItem) {
        ArrayList<PEPeerManagerListener> arrayList = this.peer_manager_listeners_cow;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                arrayList.get(i).peerDiscovered(this, peerItem, pEPeerTransport);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            public int getType() {
                return 5;
            }

            public int getStatus() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? 5 : 1;
            }

            public String getName() {
                return MessageText.getString("tps.pex.details", new String[]{String.valueOf(PEPeerControlImpl.this.peer_transports_cow.size()), String.valueOf(PEPeerControlImpl.this.peer_database.getExchangedPeerCount()), String.valueOf(PEPeerControlImpl.this.peer_database.getDiscoveredPeerCount())});
            }

            public int getPeers() {
                return PEPeerControlImpl.this.peer_database.getExchangedPeersUsed();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        void var4_6;
        indentWriter.println("PeerManager: seeding=" + this.seeding_mode);
        indentWriter.println("    udp_fb=" + this.pending_nat_traversals.size() + ",udp_tc=" + this.udp_traversal_count + ",pd=[" + this.peer_database.getString() + "]");
        String string = "";
        try {
            this.peer_transports_mon.enter();
            for (PEPeerTransport object22 : this.pending_nat_traversals.values()) {
                string = string + (string.length() == 0 ? "" : ",") + object22.getPeerItemIdentity().getAddressString() + ":" + object22.getPeerItemIdentity().getUDPPort();
            }
            Object var6_8 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (string.length() > 0) {
            indentWriter.println("    pending_udp=" + string);
        }
        List list = PeerNATTraverser.getSingleton().getTraversals(this);
        String string2 = "";
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)iterator.next();
            String string3 = (String)var4_6 + (var4_6.length() == 0 ? "" : ",") + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        }
        if (var4_6.length() > 0) {
            indentWriter.println("    active_udp=" + (String)var4_6);
        }
        if (!this.seeding_mode) {
            void var6_13;
            Object object;
            int n;
            int n2;
            String string4;
            indentWriter.println("  Active Pieces");
            boolean bl = false;
            try {
                indentWriter.indent();
                string4 = "";
                n2 = 0;
                for (n = 0; n < this.pePieces.length; ++n) {
                    object = this.pePieces[n];
                    if (object == null) continue;
                    ++var6_13;
                    string4 = string4 + (string4.length() == 0 ? "" : ",") + "#" + n + " " + this.dm_pieces[n].getString() + ": " + object.getString();
                    if (++n2 != 20) continue;
                    indentWriter.println(string4);
                    string4 = "";
                    n2 = 0;
                }
                if (n2 > 0) {
                    indentWriter.println(string4);
                }
                Object var12_21 = null;
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                indentWriter.exdent();
                throw throwable;
            }
            if (var6_13 == false) {
                indentWriter.println("  Inactive Pieces (excluding done/skipped)");
                try {
                    indentWriter.indent();
                    string4 = "";
                    n2 = 0;
                    for (n = 0; n < this.dm_pieces.length; ++n) {
                        object = this.dm_pieces[n];
                        if (!object.isInteresting()) continue;
                        string4 = string4 + (string4.length() == 0 ? "" : ",") + "#" + n + " " + this.dm_pieces[n].getString();
                        if (++n2 != 20) continue;
                        indentWriter.println(string4);
                        string4 = "";
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        indentWriter.println(string4);
                    }
                    Object var14_24 = null;
                    indentWriter.exdent();
                }
                catch (Throwable throwable) {
                    Object var14_25 = null;
                    indentWriter.exdent();
                    throw throwable;
                }
            }
            this.piecePicker.generateEvidence(indentWriter);
        }
        try {
            this.peer_transports_mon.enter();
            indentWriter.println("Peers: total = " + this.peer_transports_cow.size());
            indentWriter.indent();
            try {
                indentWriter.indent();
                for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
                    pEPeerTransport.generateEvidence(indentWriter);
                }
                Object var16_27 = null;
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                Object var16_28 = null;
                indentWriter.exdent();
                throw throwable;
            }
            Object var18_30 = null;
            this.peer_transports_mon.exit();
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var18_31 = null;
            this.peer_transports_mon.exit();
            indentWriter.exdent();
            throw throwable;
        }
        this.disk_mgr.generateEvidence(indentWriter);
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Disconnect Seed", "Seeding Piece Check Recheck Enable", "peercontrol.stalled.piece.write.timeout", "Peer.Fast.Initial.Unchoke.Enabled", "Ip Filter Ban Discard Ratio", "Ip Filter Ban Discard Min KB", "peercontrol.udp.fallback.connect.fail", "peercontrol.udp.fallback.connect.drop", "peercontrol.udp.probe.enable", "peercontrol.hide.piece", "peercontrol.prefer.udp"}, new ParameterListener(){

            public void parameterChanged(String string) {
                disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
                enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
                stalled_piece_timeout = COConfigurationManager.getIntParameter("peercontrol.stalled.piece.write.timeout", 60000);
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                ban_peer_discard_ratio = COConfigurationManager.getFloatParameter("Ip Filter Ban Discard Ratio");
                ban_peer_discard_min_kb = COConfigurationManager.getIntParameter("Ip Filter Ban Discard Min KB");
                udp_fallback_for_failed_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.fail");
                udp_fallback_for_dropped_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.drop");
                udp_probe_enabled = COConfigurationManager.getBooleanParameter("peercontrol.udp.probe.enable");
                hide_a_piece = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                if (hide_a_piece) {
                    disconnect_seeds_when_seeding = false;
                }
                prefer_udp_default = COConfigurationManager.getBooleanParameter("peercontrol.prefer.udp");
            }
        });
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
        MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
        MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
        MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
        MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
        PEER_NAT_TRAVERSE_DONE_KEY = PEPeerControlImpl.class.getName() + "::nat_trav_done";
    }
}

