/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.impl.control.PEPeerControlImpl;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPeerManagerStatsImpl
implements PEPeerManagerStats {
    private PEPeerManagerAdapter adapter;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private long total_data_bytes_received_lan = 0L;
    private long total_protocol_bytes_received_lan = 0L;
    private long total_data_bytes_sent_lan = 0L;
    private long total_protocol_bytes_sent_lan = 0L;
    private long totalDiscarded;
    private long hash_fail_bytes;
    private int last_data_received_seconds;
    private int last_data_sent_seconds;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private final Average data_send_speed = Average.getInstance(1000, 10);
    private final Average protocol_send_speed = Average.getInstance(1000, 10);
    private final Average overallSpeed = Average.getInstance(5000, 100);
    private int total_incoming;
    private int total_outgoing;

    public PEPeerManagerStatsImpl(PEPeerControlImpl pEPeerControlImpl) {
        this.adapter = pEPeerControlImpl.getAdapter();
    }

    public void discarded(PEPeer pEPeer, int n) {
        this.totalDiscarded += (long)n;
        this.adapter.discarded(pEPeer, n);
    }

    public void hashFailed(int n) {
        this.hash_fail_bytes += (long)n;
    }

    public long getTotalHashFailBytes() {
        return this.hash_fail_bytes;
    }

    public void dataBytesReceived(PEPeer pEPeer, int n) {
        this.total_data_bytes_received += (long)n;
        if (pEPeer.isLANLocal()) {
            this.total_data_bytes_received_lan += (long)n;
        }
        this.data_receive_speed.addValue(n);
        if (n > 0) {
            this.last_data_received_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesReceived(pEPeer, n);
    }

    public void protocolBytesReceived(PEPeer pEPeer, int n) {
        this.total_protocol_bytes_received += (long)n;
        if (pEPeer.isLANLocal()) {
            this.total_protocol_bytes_received_lan += (long)n;
        }
        this.protocol_receive_speed.addValue(n);
        this.adapter.protocolBytesReceived(pEPeer, n);
    }

    public void dataBytesSent(PEPeer pEPeer, int n) {
        this.total_data_bytes_sent += (long)n;
        if (pEPeer.isLANLocal()) {
            this.total_data_bytes_sent_lan += (long)n;
        }
        this.data_send_speed.addValue(n);
        if (n > 0) {
            this.last_data_sent_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesSent(pEPeer, n);
    }

    public void protocolBytesSent(PEPeer pEPeer, int n) {
        this.total_protocol_bytes_sent += (long)n;
        if (pEPeer.isLANLocal()) {
            this.total_protocol_bytes_sent_lan += (long)n;
        }
        this.protocol_send_speed.addValue(n);
        this.adapter.protocolBytesSent(pEPeer, n);
    }

    public void haveNewPiece(int n) {
        this.overallSpeed.addValue(n);
    }

    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    public long getTotalDiscarded() {
        return this.totalDiscarded;
    }

    public void setTotalDiscarded(long l) {
        this.totalDiscarded = l;
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDataBytesSentNoLan() {
        return Math.max(this.total_data_bytes_sent - this.total_data_bytes_sent_lan, 0L);
    }

    public long getTotalProtocolBytesSentNoLan() {
        return Math.max(this.total_protocol_bytes_sent - this.total_protocol_bytes_sent_lan, 0L);
    }

    public long getTotalDataBytesReceivedNoLan() {
        return Math.max(this.total_data_bytes_received - this.total_data_bytes_received_lan, 0L);
    }

    public long getTotalProtocolBytesReceivedNoLan() {
        return Math.max(this.total_protocol_bytes_received - this.total_protocol_bytes_received_lan, 0L);
    }

    public long getTotalAverage() {
        return this.overallSpeed.getAverage() + this.getDataReceiveRate();
    }

    public int getTimeSinceLastDataReceivedInSeconds() {
        if (this.last_data_received_seconds == 0) {
            return -1;
        }
        int n = (int)(SystemTime.getCurrentTime() / 1000L);
        if (n < this.last_data_received_seconds) {
            this.last_data_received_seconds = n;
        }
        return n - this.last_data_received_seconds;
    }

    public int getTimeSinceLastDataSentInSeconds() {
        if (this.last_data_sent_seconds == 0) {
            return -1;
        }
        int n = (int)(SystemTime.getCurrentTime() / 1000L);
        if (n < this.last_data_sent_seconds) {
            this.last_data_sent_seconds = n;
        }
        return n - this.last_data_sent_seconds;
    }

    public void haveNewConnection(boolean bl) {
        if (bl) {
            ++this.total_incoming;
        } else {
            ++this.total_outgoing;
        }
    }

    public int getTotalIncomingConnections() {
        return this.total_incoming;
    }

    public int getTotalOutgoingConnections() {
        return this.total_outgoing;
    }

    public int getPermittedBytesToReceive() {
        return this.adapter.getPermittedBytesToReceive();
    }

    public void permittedReceiveBytesUsed(int n) {
        this.adapter.permittedReceiveBytesUsed(n);
    }

    public int getPermittedBytesToSend() {
        return this.adapter.getPermittedBytesToSend();
    }

    public void permittedSendBytesUsed(int n) {
        this.adapter.permittedSendBytesUsed(n);
    }
}

