/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.logging.impl.FileLoggingAdapter;
import org.gudy.azureus2.core3.util.Debug;

public class FileLogging
implements ILogEventListener {
    public static final String LOG_FILE_NAME = "az.log";
    public static final String BAK_FILE_NAME = "az.log.bak";
    public static LogIDs[] configurableLOGIDs = new LogIDs[]{LogIDs.STDOUT, LogIDs.ALERT, LogIDs.CORE, LogIDs.DISK, LogIDs.GUI, LogIDs.NET, LogIDs.NWMAN, LogIDs.PEER, LogIDs.PLUGIN, LogIDs.TRACKER, LogIDs.CACHE, LogIDs.PIECES};
    private static final String CFG_ENABLELOGTOFILE = "Logging Enable";
    private boolean bLogToFile = false;
    private boolean bLogToFileErrorPrinted = false;
    private String sLogDir = "";
    private int iLogFileMaxMB = 1;
    private ArrayList[] ignoredComponents = new ArrayList[3];
    private ArrayList listeners = new ArrayList();
    private SimpleDateFormat format;
    private PrintWriter logFilePrinter;
    private static final int DEFPADDING = 100;
    private int lastWidth = 100;

    public void initialize() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        boolean bl = System.getProperty("azureus.overridelog") != null;
        for (int i = 0; i < this.ignoredComponents.length; ++i) {
            this.ignoredComponents[i] = new ArrayList();
        }
        if (!bl) {
            configurationManager.addListener(new COConfigurationListener(){

                public void configurationSaved() {
                    FileLogging.this.checkLoggingConfig();
                }
            });
        }
        this.checkLoggingConfig();
        configurationManager.addParameterListener(CFG_ENABLELOGTOFILE, new ParameterListener(){

            public void parameterChanged(String string) {
                FileLogging.this.reloadLogToFileParam();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reloadLogToFileParam() {
        boolean bl;
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        boolean bl2 = bl = System.getProperty("azureus.overridelog") != null || configurationManager.getBooleanParameter(CFG_ENABLELOGTOFILE);
        if (bl == this.bLogToFile) return;
        this.bLogToFile = bl;
        if (this.bLogToFile) {
            Logger.addListener(this);
            return;
        }
        Logger.removeListener(this);
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            this.checkAndSwapLog();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoggingConfig() {
        try {
            int n;
            String string;
            boolean bl;
            ConfigurationManager configurationManager = ConfigurationManager.getInstance();
            boolean bl2 = bl = System.getProperty("azureus.overridelog") != null;
            if (bl) {
                this.sLogDir = System.getProperty("azureus.overridelogdir", ".");
                this.iLogFileMaxMB = 2;
                string = "HH:mm:ss.SSS ";
                for (n = 0; n < this.ignoredComponents.length; ++n) {
                    this.ignoredComponents[n].clear();
                }
                this.reloadLogToFileParam();
            } else {
                this.reloadLogToFileParam();
                this.sLogDir = configurationManager.getStringParameter("Logging Dir", "");
                this.iLogFileMaxMB = configurationManager.getIntParameter("Logging Max Size");
                string = configurationManager.getStringParameter("Logging Timestamp") + " ";
                for (n = 0; n < this.ignoredComponents.length; ++n) {
                    this.ignoredComponents[n].clear();
                    int n2 = this.indexToLogType(n);
                    for (int i = 0; i < configurableLOGIDs.length; ++i) {
                        if (configurationManager.getBooleanParameter("bLog." + n2 + "." + configurableLOGIDs[i], true)) continue;
                        this.ignoredComponents[n].add(configurableLOGIDs[i]);
                    }
                }
            }
            Class<Logger> clazz = Logger.class;
            synchronized (Logger.class) {
                this.format = new SimpleDateFormat(string);
                this.checkAndSwapLog();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String string) {
        if (!this.bLogToFile) {
            return;
        }
        String string2 = this.format.format(new Date());
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (this.logFilePrinter != null) {
                this.logFilePrinter.print(string2);
                this.logFilePrinter.print(string);
                this.logFilePrinter.flush();
            }
            this.checkAndSwapLog();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void checkAndSwapLog() {
        block9: {
            if (!this.bLogToFile) {
                if (this.logFilePrinter != null) {
                    this.logFilePrinter.close();
                    this.logFilePrinter = null;
                }
                return;
            }
            long l = this.iLogFileMaxMB * 1024 * 1024 / 2;
            File file = new File(this.sLogDir + File.separator + LOG_FILE_NAME);
            if (file.length() > l && this.logFilePrinter != null) {
                File file2 = new File(this.sLogDir + File.separator + BAK_FILE_NAME);
                this.logFilePrinter.close();
                this.logFilePrinter = null;
                if (!file2.exists() || file2.delete()) {
                    if (!file.renameTo(file2)) {
                        file.delete();
                    } else {
                        file.delete();
                    }
                }
            }
            if (this.logFilePrinter == null) {
                try {
                    this.logFilePrinter = new PrintWriter(new FileWriter(file, true));
                }
                catch (IOException iOException) {
                    if (this.bLogToFileErrorPrinted) break block9;
                    this.bLogToFileErrorPrinted = true;
                    Debug.out("Unable to write to log file: " + file);
                    Debug.printStackTrace(iOException);
                }
            }
        }
    }

    private int logTypeToIndex(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int indexToLogType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public void log(LogEvent logEvent) {
        Object object;
        int n;
        if (this.ignoredComponents[this.logTypeToIndex(logEvent.entryType)].contains(logEvent.logID)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(logEvent.text.length());
        stringBuffer.append(logEvent.entryType).append(" ");
        this.padAndAppend(stringBuffer, logEvent.logID.toString(), 8, 1);
        if (logEvent.relatedTo != null) {
            this.lastWidth = this.padAndAppend(stringBuffer, logEvent.text, this.lastWidth, 1);
            if (this.lastWidth > 200) {
                this.lastWidth = 200;
            }
            for (n = 0; n < logEvent.relatedTo.length; ++n) {
                object = logEvent.relatedTo[n];
                if (object == null) continue;
                if (n > 0) {
                    stringBuffer.append("; ");
                }
                if (object instanceof LogRelation) {
                    stringBuffer.append(((LogRelation)object).getRelationText());
                    continue;
                }
                stringBuffer.append("RelatedTo[").append(object.toString()).append("]");
            }
        } else {
            stringBuffer.append(logEvent.text);
            this.lastWidth = 100;
        }
        if (logEvent.text == null || !logEvent.text.endsWith("\n")) {
            stringBuffer.append("\r\n");
        }
        n = 1;
        object = this.listeners.iterator();
        while (object.hasNext() && n != 0) {
            FileLoggingAdapter fileLoggingAdapter = (FileLoggingAdapter)object.next();
            n = fileLoggingAdapter.logToFile(logEvent, stringBuffer) ? 1 : 0;
        }
        this.logToFile(stringBuffer.toString());
    }

    private int padAndAppend(StringBuffer stringBuffer, String string, int n, int n2) {
        int n3;
        if (string == null) {
            string = "null";
        }
        stringBuffer.append(string);
        int n4 = string.length();
        for (n3 = n - n4; n3 <= 0; n3 += n2) {
        }
        char[] cArray = new char[n3];
        if (n3 > 5) {
            int n5;
            for (n5 = 0; n5 < n3; n5 += 2) {
                cArray[n5] = 32;
            }
            for (n5 = 1; n5 < n3; n5 += 2) {
                cArray[n5] = 46;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                cArray[i] = 32;
            }
        }
        stringBuffer.append(cArray);
        return n3 + n4;
    }

    public void addListener(FileLoggingAdapter fileLoggingAdapter) {
        if (!this.listeners.contains(fileLoggingAdapter)) {
            this.listeners.add(fileLoggingAdapter);
        }
    }

    public void removeListener(FileLoggingAdapter fileLoggingAdapter) {
        this.listeners.remove(fileLoggingAdapter);
    }

    public List getListeners() {
        return this.listeners;
    }
}

