/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.ipfilter.BadIps;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BadIpsImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.util.FileUtil;

public class IpFilterManagerImpl
implements IpFilterManager,
ParameterListener {
    protected static IpFilterManagerImpl singleton = new IpFilterManagerImpl();
    private RandomAccessFile rafDescriptions = null;

    public IpFilterManagerImpl() {
        COConfigurationManager.addAndFireParameterListener("Ip Filter Enable Description Cache", this);
    }

    public Object addDescription(IpRange ipRange, byte[] byArray) {
        if (this.rafDescriptions == null) {
            return null;
        }
        try {
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            int n = (int)this.rafDescriptions.getFilePointer();
            int n2 = (int)this.rafDescriptions.length();
            if (n2 + 61 >= 0x1FFFFFF) {
                return null;
            }
            if (n != n2) {
                this.rafDescriptions.seek(n2);
                n = (int)this.rafDescriptions.getFilePointer();
            }
            if (byArray.length <= 61) {
                this.rafDescriptions.write(byArray);
            } else {
                this.rafDescriptions.write(byArray, 0, 61);
            }
            int n3 = (int)this.rafDescriptions.getFilePointer();
            int n4 = n + (n3 - n << 25);
            return new Integer(n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getDescription(Object object) {
        if (object instanceof Object[]) {
            return (byte[])((Object[])object)[0];
        }
        if (this.rafDescriptions == null || !(object instanceof Integer)) {
            return "".getBytes();
        }
        try {
            int n = (Integer)object;
            int n2 = n & 0x1FFFFFF;
            int n3 = n >> 25;
            if (n3 < 0) {
                throw new IllegalArgumentException(this.getClass().getName() + ": invalid posInfo [" + n + "], pos [" + n2 + "], len [" + n3 + "]");
            }
            if (this.rafDescriptions.getFilePointer() != (long)n2) {
                this.rafDescriptions.seek(n2);
            }
            byte[] byArray = new byte[n3];
            this.rafDescriptions.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            return "".getBytes();
        }
    }

    public void cacheAllDescriptions() {
        IpRange[] ipRangeArray = this.getIPFilter().getRanges();
        for (int i = 0; i < ipRangeArray.length; ++i) {
            Object object = ((IpRangeImpl)ipRangeArray[i]).getDescRef();
            if (!(object instanceof Integer)) continue;
            byte[] byArray = this.getDescription(object);
            Object[] objectArray = new Object[]{byArray, object};
            ((IpRangeImpl)ipRangeArray[i]).setDescRef(objectArray);
        }
    }

    public void clearDescriptionCache() {
        IpRange[] ipRangeArray = this.getIPFilter().getRanges();
        for (int i = 0; i < ipRangeArray.length; ++i) {
            Object object = ((IpRangeImpl)ipRangeArray[i]).getDescRef();
            if (!(object instanceof Object[])) continue;
            Integer n = (Integer)((Object[])object)[1];
            ((IpRangeImpl)ipRangeArray[i]).setDescRef(n);
        }
    }

    public void deleteAllDescriptions() {
        if (this.rafDescriptions != null) {
            try {
                this.rafDescriptions.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rafDescriptions = null;
        }
        this.parameterChanged(null);
    }

    public static IpFilterManager getSingleton() {
        return singleton;
    }

    public IpFilter getIPFilter() {
        return IpFilterImpl.getInstance();
    }

    public BadIps getBadIps() {
        return BadIpsImpl.getInstance();
    }

    public void parameterChanged(String string) {
        boolean bl = COConfigurationManager.getBooleanParameter("Ip Filter Enable Description Cache");
        if (bl && this.rafDescriptions == null) {
            File file = FileUtil.getUserFile("ipfilter.cache");
            try {
                if (file.exists()) {
                    file.delete();
                }
                this.rafDescriptions = new RandomAccessFile(file, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else if (!bl && this.rafDescriptions != null) {
            try {
                this.rafDescriptions.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rafDescriptions = null;
        }
    }
}

