/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class IpFilterAutoLoaderImpl {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    public static final String CFG_AUTOLOAD_FILE = "Ip Filter Autoload File";
    private static AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    private final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilterImpl) {
        this.ipFilter = ipFilterImpl;
        COConfigurationManager.setLongDefault(CFG_AUTOLOAD_LAST, 0L);
        COConfigurationManager.setStringDefault(CFG_AUTOLOAD_FILE, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadDATFilters(InputStream inputStream) {
        try {
            block41: {
                Object object6222;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                ArrayList<Object> arrayList;
                block39: {
                    String string;
                    class_mon.enter();
                    arrayList = new ArrayList<Object>(1024);
                    inputStreamReader = null;
                    bufferedReader = null;
                    Pattern pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                    int n = -1;
                    inputStreamReader = new InputStreamReader(inputStream, "utf8");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    int n2 = 0;
                    while (n2 < 1000 && (string = bufferedReader.readLine()) != null) {
                        Object object2;
                        if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
                        Object object3 = "";
                        Object object4 = null;
                        Object object5 = null;
                        int n3 = 0;
                        if (n <= 0 || n == 1) {
                            object2 = pattern.matcher(string);
                            if (((Matcher)object2).find()) {
                                if (n != 1) {
                                    n = 1;
                                }
                                object3 = ((Matcher)object2).group(1);
                                object4 = ((Matcher)object2).group(2);
                                object5 = ((Matcher)object2).group(3);
                            } else {
                                Logger.log(new LogEvent(LOGID, 1, "unrecognized line while reading ip filter: " + string));
                            }
                        }
                        if (n != 1) {
                            if (n != 2) {
                                n = 2;
                            }
                            if (((String[])(object2 = string.split(" *[-,] *", 4))).length >= 2 && (object2[0].indexOf(46) < 0 || ((String)object2[1]).indexOf(46) < 0 || ((String)object2[0]).length() > 15 || ((String)object2[1]).length() > 15 || ((String)object2[0]).length() < 7 || ((String)object2[1]).length() < 7)) {
                                ++n2;
                                continue;
                            }
                            if (((String[])object2).length >= 4) {
                                object4 = object2[0];
                                object5 = object2[1];
                                object3 = object2[3];
                                try {
                                    n3 = Integer.parseInt((String)object2[2]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    object3 = (String)object2[2] + " " + (String)object3;
                                }
                                for (int i = 4; i < ((Object)object2).length; ++i) {
                                    object3 = (String)object3 + " " + (String)object2[i];
                                }
                                n2 = 0;
                            } else if (((Object)object2).length == 3) {
                                object4 = object2[0];
                                object5 = object2[1];
                                object3 = object2[2];
                                n2 = 0;
                            } else if (((Object)object2).length == 2) {
                                object4 = object2[0];
                                object5 = object2[1];
                                n2 = 0;
                            } else {
                                ++n2;
                                continue;
                            }
                            if (n3 >= 128) continue;
                        }
                        if (object4 == null || object5 == null) continue;
                        object2 = new IpRangeImpl((String)object3, (String)object4, (String)object5, true);
                        ((IpRangeImpl)object2).setAddedToRangeList(true);
                        arrayList.add(object2);
                    }
                    Object var16_17 = null;
                    if (bufferedReader == null) break block39;
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable object6222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable object6222) {
                        // empty catch block
                    }
                }
                object6222 = arrayList.iterator();
                while (object6222.hasNext()) {
                    ((IpRange)object6222.next()).checkValid();
                }
                this.ipFilter.markAsUpToDate();
                {
                    break block41;
                    catch (IOException iOException) {
                        Object object72222;
                        Debug.out(iOException);
                        Object var16_18 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable object72222) {
                                // empty catch block
                            }
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Throwable object72222) {
                                // empty catch block
                            }
                        }
                        object72222 = arrayList.iterator();
                        while (object72222.hasNext()) {
                            ((IpRange)object72222.next()).checkValid();
                        }
                        this.ipFilter.markAsUpToDate();
                    }
                }
                catch (Throwable throwable) {
                    Object object82222;
                    Object var16_19 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable object82222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Throwable object82222) {
                            // empty catch block
                        }
                    }
                    object82222 = arrayList.iterator();
                    while (object82222.hasNext()) {
                        ((IpRange)object82222.next()).checkValid();
                    }
                    this.ipFilter.markAsUpToDate();
                    throw throwable;
                }
            }
            Object var19_24 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    private int getP2BFileVersion(InputStream inputStream) {
        try {
            int n;
            for (int i = 0; i < 4; ++i) {
                n = inputStream.read();
                if (n == 255) continue;
                return -1;
            }
            byte[] byArray = new byte[]{80, 50, 66};
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                if (by == inputStream.read()) continue;
                return -1;
            }
            n = inputStream.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + n));
            return n;
        }
        catch (IOException iOException) {
            Debug.out(iOException);
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    protected void loadOtherFilters(boolean var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 56[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;

            public void perform(TimerEvent timerEvent2) {
                timerEvent2.cancel();
                String string = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                File file = new File(string);
                if (!file.exists()) {
                    return;
                }
                long l = file.lastModified();
                if (this.lastFileModified == 0L) {
                    this.lastFileModified = l;
                } else if (this.lastFileModified != l) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadFiltersAsync(URL uRL) {
        ResourceDownloader resourceDownloader = ResourceDownloaderFactoryImpl.getSingleton().create(uRL);
        resourceDownloader.addListener(new ResourceDownloaderAdapter(){

            public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(inputStream, FileUtil.getUserFile("ipfilter.dl"));
                        AEThread aEThread = new AEThread("reload ipfilters", true){

                            public void runSupport() {
                                try {
                                    UIFunctions uIFunctions = UIFunctionsManager.getUIFunctions();
                                    if (uIFunctions != null) {
                                        uIFunctions.setStatusText("Reloading Filters..");
                                    }
                                    IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uIFunctions != null) {
                                        uIFunctions.setStatusText(null);
                                    }
                                }
                                catch (Exception exception) {
                                    Debug.out(exception);
                                }
                            }
                        };
                        aEThread.setPriority(4);
                        aEThread.start();
                    }
                    catch (Exception exception) {
                        Debug.out(exception);
                    }
                    Object var5_5 = null;
                    class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    class_mon.exit();
                    throw throwable;
                }
                return true;
            }
        });
        resourceDownloader.asyncDownload();
    }

    public void setNextAutoDownload(boolean bl) {
        long l;
        long l2 = SystemTime.getCurrentTime();
        if (bl) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, l2);
            l = l2;
        } else {
            l = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (l > l2) {
                l = l2;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, l2);
            }
        }
        long l3 = l + 604800000L;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", l3, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                String string = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bufferedInputStream, byte[] byArray, String string) {
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) >= 0) {
                if (n < byArray.length) {
                    byArray[n] = (byte)n2;
                    ++n;
                }
                if (n2 != 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n > 1) {
            try {
                return new String(byArray, 0, n - 1, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }
}

