/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.resume;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class RDResumeHandler {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final boolean TEST_RECHECK_FAILURE_HANDLING = false;
    private static final byte PIECE_NOT_DONE = 0;
    private static final byte PIECE_DONE = 1;
    private static final byte PIECE_RECHECK_REQUIRED = 2;
    private static final byte PIECE_STARTED = 3;
    private static boolean use_fast_resume;
    private static boolean use_fast_resume_recheck_all;
    private DiskManagerImpl disk_manager;
    private DMChecker checker;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean stopped_for_close;
    private volatile boolean check_in_progress;
    private volatile boolean check_resume_was_valid;
    private volatile boolean check_is_full_check;
    private volatile boolean check_interrupted;
    private volatile int check_position;

    public RDResumeHandler(DiskManagerImpl diskManagerImpl, DMChecker dMChecker) {
        this.disk_manager = diskManagerImpl;
        this.checker = dMChecker;
    }

    public void start() {
        if (this.started) {
            Debug.out("RDResumeHandler: reuse not supported");
        }
        this.started = true;
    }

    public void stop(boolean bl) {
        this.stopped_for_close |= bl;
        if (this.check_in_progress) {
            this.check_interrupted = true;
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllPieces(boolean bl) {
        DiskManagerRecheckInstance diskManagerRecheckInstance = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
        final AESemaphore aESemaphore = new AESemaphore("RDResumeHandler::checkAllPieces:runsem", 2);
        final ArrayList arrayList = new ArrayList();
        try {
            try {
                boolean bl2 = false;
                try {
                    int n;
                    int n2;
                    Object object;
                    Object object2;
                    int n3;
                    this.check_in_progress = true;
                    boolean bl3 = use_fast_resume;
                    if (bl) {
                        bl3 = false;
                    }
                    final AESemaphore aESemaphore2 = new AESemaphore("RD:PendingChecks");
                    int n4 = 0;
                    DiskManagerPiece[] diskManagerPieceArray = this.disk_manager.getPieces();
                    DiskManagerFileInfo[] diskManagerFileInfoArray = this.disk_manager.getFiles();
                    HashMap<DiskManagerFileInfo, Long> hashMap = new HashMap<DiskManagerFileInfo, Long>();
                    for (n3 = 0; n3 < diskManagerFileInfoArray.length; ++n3) {
                        try {
                            object2 = new Long(((DiskManagerFileInfoImpl)diskManagerFileInfoArray[n3]).getCacheFile().getLength());
                            hashMap.put(diskManagerFileInfoArray[n3], (Long)object2);
                            continue;
                        }
                        catch (CacheFileManagerException cacheFileManagerException) {
                            Debug.printStackTrace(cacheFileManagerException);
                        }
                    }
                    if (bl3) {
                        Object object3;
                        Object object4;
                        Object object5;
                        n3 = 0;
                        object2 = null;
                        object = null;
                        Object object6 = this.getResumeData();
                        if (object6 != null) {
                            try {
                                object2 = (byte[])object6.get("resume data");
                                if (object2 != null && ((Object)object2).length != diskManagerPieceArray.length) {
                                    Debug.out("Resume data array length mismatch: " + ((Object)object2).length + "/" + diskManagerPieceArray.length);
                                    object2 = null;
                                }
                                object = (Map)object6.get("blocks");
                                int n5 = n3 = ((Long)object6.get("valid")).intValue() == 1 ? 1 : 0;
                                if (RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), (Map)object6)) {
                                    bl2 = true;
                                } else {
                                    object6.put("valid", new Long(0L));
                                    this.saveResumeData((Map)object6);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (object2 == null) {
                            this.check_is_full_check = true;
                            n3 = 0;
                            object2 = new byte[diskManagerPieceArray.length];
                            Arrays.fill((byte[])object2, (byte)2);
                        }
                        this.check_resume_was_valid = n3;
                        boolean bl4 = use_fast_resume_recheck_all;
                        if (!bl4) {
                            long l = 0L;
                            n2 = this.disk_manager.getPieceLength();
                            for (object5 = 0; object5 < diskManagerPieceArray.length; ++object5) {
                                if (object2[object5] == true) continue;
                                l += (long)n2;
                            }
                            if (l < 0x4000000L) {
                                bl4 = true;
                            }
                        }
                        if (Logger.isEnabled()) {
                            int n6 = 0;
                            n = 0;
                            n2 = 0;
                            object5 = 0;
                            for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                                object4 = object2[i];
                                if (object4 == false) {
                                    ++n6;
                                    continue;
                                }
                                if (object4 == true) {
                                    ++n;
                                    continue;
                                }
                                if (object4 == 3) {
                                    ++n2;
                                    continue;
                                }
                                ++object5;
                            }
                            object3 = "valid=" + (n3 != 0) + ",not done=" + n6 + ",done=" + n + ",started=" + n2 + ",recheck=" + object5 + ",rc all=" + bl4 + ",full=" + this.check_is_full_check;
                            Logger.log(new LogEvent(this.disk_manager, LOGID, (String)object3));
                        }
                        for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                            this.check_position = i;
                            DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                            this.disk_manager.setPercentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                            n2 = 0;
                            object5 = object2[i];
                            if (object5 == 1 || n3 == 0 || bl4) {
                                object3 = this.disk_manager.getPieceList(i);
                                for (object4 = (Object)false; object4 < object3.size(); ++object4) {
                                    DMPieceMapEntry dMPieceMapEntry = object3.get((int)object4);
                                    Long l = (Long)hashMap.get(dMPieceMapEntry.getFile());
                                    if (l == null) {
                                        object5 = 0;
                                        n2 = 1;
                                        if (!Logger.isEnabled()) break;
                                        Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is missing, " + "fails re-check."));
                                        break;
                                    }
                                    long l2 = dMPieceMapEntry.getOffset() + (long)dMPieceMapEntry.getLength();
                                    if (l >= l2) continue;
                                    object5 = 0;
                                    n2 = 1;
                                    if (!Logger.isEnabled()) break;
                                    Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is too small, fails re-check. File size = " + l + ", piece needs " + l2));
                                    break;
                                }
                            }
                            if (object5 == 1) {
                                diskManagerPiece.setDone(true);
                                continue;
                            }
                            if (object5 == 0 && !bl4) continue;
                            if (n2 != 0) {
                                diskManagerPiece.setDone(false);
                                continue;
                            }
                            if (object5 != 2 && n3 != 0) continue;
                            aESemaphore.reserve();
                            while (!this.stopped && !diskManagerRecheckInstance.getPermission()) {
                            }
                            if (this.stopped) break;
                            try {
                                object3 = this.disk_manager.createCheckRequest(i, null);
                                object3.setLowPriority(true);
                                this.checker.enqueueCheckRequest((DiskManagerCheckRequest)object3, new DiskManagerCheckRequestListener(){

                                    public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                        if (!bl) {
                                            arrayList.add(diskManagerCheckRequest);
                                        }
                                        this.complete();
                                    }

                                    public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                        this.complete();
                                    }

                                    public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                        this.complete();
                                    }

                                    protected void complete() {
                                        aESemaphore.release();
                                        aESemaphore2.release();
                                    }
                                });
                                ++n4;
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        while (n4 > 0) {
                            aESemaphore2.reserve();
                            --n4;
                        }
                        if (object != null) {
                            for (Map.Entry entry : object.entrySet()) {
                                n2 = Integer.parseInt((String)entry.getKey());
                                DiskManagerPiece diskManagerPiece = diskManagerPieceArray[n2];
                                if (diskManagerPiece.isDone()) continue;
                                object3 = (List)object.get(entry.getKey());
                                Iterator iterator = object3.iterator();
                                while (iterator.hasNext()) {
                                    diskManagerPiece.setWritten(((Long)iterator.next()).intValue());
                                }
                            }
                        }
                    } else {
                        for (n3 = 0; n3 < diskManagerPieceArray.length; ++n3) {
                            this.check_position = n3;
                            this.disk_manager.setPercentDone((n3 + 1) * 1000 / this.disk_manager.getNbPieces());
                            boolean bl5 = false;
                            object = this.disk_manager.getPieceList(n3);
                            for (int i = 0; i < object.size(); ++i) {
                                DMPieceMapEntry dMPieceMapEntry = object.get(i);
                                Long l = (Long)hashMap.get(dMPieceMapEntry.getFile());
                                if (l == null) {
                                    bl5 = true;
                                    break;
                                }
                                long l3 = dMPieceMapEntry.getOffset() + (long)dMPieceMapEntry.getLength();
                                if (l >= l3) continue;
                                bl5 = true;
                                break;
                            }
                            if (bl5) {
                                this.disk_manager.getPiece(n3).setDone(false);
                                continue;
                            }
                            aESemaphore.reserve();
                            while (!this.stopped && !diskManagerRecheckInstance.getPermission()) {
                            }
                            if (this.stopped) break;
                            try {
                                DiskManagerCheckRequest diskManagerCheckRequest = this.disk_manager.createCheckRequest(n3, null);
                                diskManagerCheckRequest.setLowPriority(true);
                                this.checker.enqueueCheckRequest(diskManagerCheckRequest, new DiskManagerCheckRequestListener(){

                                    public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                        if (!bl) {
                                            arrayList.add(diskManagerCheckRequest);
                                        }
                                        this.complete();
                                    }

                                    public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                        this.complete();
                                    }

                                    public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                        this.complete();
                                    }

                                    protected void complete() {
                                        aESemaphore.release();
                                        aESemaphore2.release();
                                    }
                                });
                                ++n4;
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        while (n4 > 0) {
                            aESemaphore2.reserve();
                            --n4;
                        }
                    }
                    if (arrayList.size() > 0) {
                        byte[][] byArray = this.disk_manager.getTorrent().getPieces();
                        ByteArrayHashMap<Integer> byteArrayHashMap = new ByteArrayHashMap<Integer>();
                        for (int i = 0; i < byArray.length; ++i) {
                            byteArrayHashMap.put(byArray[i], i);
                        }
                        for (Object object6 : arrayList) {
                            while (!this.stopped && !diskManagerRecheckInstance.getPermission()) {
                            }
                            if (this.stopped) break;
                            byte[] byArray2 = object6.getHash();
                            if (byArray2 == null) continue;
                            final Integer n7 = (Integer)byteArrayHashMap.get(byArray2);
                            n = object6.getPieceNumber();
                            n2 = this.disk_manager.getPieceLength(n);
                            if (n7 == null || n7 == n || this.disk_manager.getPieceLength(n7) != n2 || this.disk_manager.isDone(n7)) continue;
                            final AESemaphore aESemaphore3 = new AESemaphore("PieceReorder");
                            this.disk_manager.enqueueReadRequest(this.disk_manager.createReadRequest(n, 0, n2), new DiskManagerReadRequestListener(){

                                public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                                    try {
                                        RDResumeHandler.this.disk_manager.enqueueWriteRequest(RDResumeHandler.this.disk_manager.createWriteRequest(n7, 0, directByteBuffer, null), new DiskManagerWriteRequestListener(){

                                            public void writeCompleted(DiskManagerWriteRequest diskManagerWriteRequest) {
                                                try {
                                                    DiskManagerCheckRequest diskManagerCheckRequest = RDResumeHandler.this.disk_manager.createCheckRequest(n7, null);
                                                    diskManagerCheckRequest.setLowPriority(true);
                                                    RDResumeHandler.this.checker.enqueueCheckRequest(diskManagerCheckRequest, new DiskManagerCheckRequestListener(){

                                                        public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                                            aESemaphore3.release();
                                                        }

                                                        public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                                            aESemaphore3.release();
                                                        }

                                                        public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                                            aESemaphore3.release();
                                                        }
                                                    });
                                                }
                                                catch (Throwable throwable) {
                                                    aESemaphore3.release();
                                                }
                                            }

                                            public void writeFailed(DiskManagerWriteRequest diskManagerWriteRequest, Throwable throwable) {
                                                aESemaphore3.release();
                                            }
                                        });
                                    }
                                    catch (Throwable throwable) {
                                        aESemaphore3.release();
                                    }
                                }

                                public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                                    aESemaphore3.release();
                                }

                                public int getPriority() {
                                    return -1;
                                }

                                public void requestExecuted(long l) {
                                }
                            });
                            aESemaphore3.reserve();
                        }
                    }
                    Object var28_54 = null;
                    this.check_in_progress = false;
                }
                catch (Throwable throwable) {
                    Object var28_55 = null;
                    this.check_in_progress = false;
                    throw throwable;
                }
                if (!this.stopped && !bl2) {
                    try {
                        this.saveResumeData(true);
                    }
                    catch (Exception exception) {
                        Debug.out("Failed to dump initial resume data to disk");
                        Debug.printStackTrace(exception);
                    }
                }
                Object var30_57 = null;
                diskManagerRecheckInstance.unregister();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var30_58 = null;
                diskManagerRecheckInstance.unregister();
            }
        }
        catch (Throwable throwable) {
            Object var30_59 = null;
            diskManagerRecheckInstance.unregister();
            throw throwable;
        }
    }

    public void saveResumeData(boolean bl) throws Exception {
        int n;
        Object object;
        if (this.check_in_progress && bl) {
            return;
        }
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.disk_manager.getFiles();
        if (!use_fast_resume) {
            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                diskManagerFileInfoArray[i].flushCache();
            }
            return;
        }
        boolean bl2 = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState());
        DiskManagerPiece[] diskManagerPieceArray = this.disk_manager.getPieces();
        byte[] byArray = new byte[diskManagerPieceArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            object = diskManagerPieceArray[i];
            byArray[i] = this.stopped_for_close && this.check_interrupted && this.check_is_full_check && i >= this.check_position ? 2 : (object.isDone() ? 1 : (object.getNbWritten() > 0 ? 3 : 0));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        object = new HashMap();
        for (int i = 0; i < diskManagerPieceArray.length; ++i) {
            DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
            boolean[] blArray = diskManagerPiece.getWritten();
            if (diskManagerPiece.isDone() || diskManagerPiece.getNbWritten() <= 0 || blArray == null) continue;
            boolean bl3 = true;
            for (int j = 0; j < blArray.length; ++j) {
                if (blArray[j]) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                byArray[i] = 2;
                continue;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int j = 0; j < blArray.length; ++j) {
                if (!blArray[j]) continue;
                arrayList.add(new Long(j));
            }
            object.put("" + i, arrayList);
        }
        hashMap.put("blocks", object);
        long l = this.check_interrupted ? (this.check_resume_was_valid ? 1L : 0L) : (bl ? 0L : 1L);
        hashMap.put("valid", new Long(l));
        for (n = 0; n < diskManagerFileInfoArray.length; ++n) {
            diskManagerFileInfoArray[n].flushCache();
        }
        n = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), hashMap) ? 1 : 0;
        if (!bl2 || n == 0) {
            this.saveResumeData(hashMap);
        }
    }

    protected Map getResumeData() {
        return RDResumeHandler.getResumeData(this.disk_manager.getDownloadManager());
    }

    protected static Map getResumeData(DownloadManager downloadManager) {
        return RDResumeHandler.getResumeData(downloadManager.getDownloadState());
    }

    protected static Map getResumeData(DownloadManagerState downloadManagerState) {
        Map map = downloadManagerState.getResumeData();
        if (map != null) {
            Map map2 = (Map)map.get("data");
            return map2;
        }
        return null;
    }

    protected void saveResumeData(Map map) {
        RDResumeHandler.saveResumeData(this.disk_manager.getDownloadManager().getDownloadState(), map);
    }

    protected static void saveResumeData(DownloadManagerState downloadManagerState, Map map) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put("data", map);
        downloadManagerState.setResumeData(hashMap);
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState downloadManagerState) {
        TOTorrent tOTorrent = downloadManagerState.getTorrent();
        int n = tOTorrent.getNumberOfPieces();
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)1);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        HashMap hashMap2 = new HashMap();
        hashMap.put("blocks", hashMap2);
        hashMap.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(downloadManagerState, hashMap);
    }

    protected static int clearResumeDataSupport(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo, boolean bl, boolean bl2) {
        int n;
        DiskManagerFileInfo[] diskManagerFileInfoArray;
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        Map map = RDResumeHandler.getResumeData(downloadManager);
        if (map == null) {
            return 0;
        }
        int n2 = 0;
        byte[] byArray = (byte[])map.get("resume data");
        int n3 = diskManagerFileInfo.getFirstPieceNumber();
        int n4 = diskManagerFileInfo.getLastPieceNumber();
        if (bl2) {
            int n5;
            diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
            boolean bl3 = false;
            n = 0;
            for (int i = n5 = RDResumeHandler.findFirstFileWithPieceN(n3, diskManagerFileInfoArray); i < diskManagerFileInfoArray.length; ++i) {
                DiskManagerFileInfo diskManagerFileInfo2 = diskManagerFileInfoArray[i];
                if (diskManagerFileInfo2.getLastPieceNumber() < n3 || diskManagerFileInfo2.getIndex() == diskManagerFileInfo.getIndex()) continue;
                if (diskManagerFileInfo2.getFirstPieceNumber() > n4) break;
                if (diskManagerFileInfo2.getFirstPieceNumber() <= n3 && n3 <= diskManagerFileInfo2.getLastPieceNumber()) {
                    bl3 |= !diskManagerFileInfo2.isSkipped();
                }
                if (diskManagerFileInfo2.getFirstPieceNumber() > n4 || n4 > diskManagerFileInfo2.getLastPieceNumber()) continue;
                n |= !diskManagerFileInfo2.isSkipped() ? 1 : 0;
            }
            if (bl3) {
                ++n3;
            }
            if (n != 0) {
                --n4;
            }
        }
        if (byArray != null) {
            for (int i = n3; i <= n4 && i < byArray.length; ++i) {
                if (byArray[i] == 1) {
                    ++n2;
                }
                byArray[i] = bl ? 2 : 0;
            }
        }
        if ((diskManagerFileInfoArray = (Map)map.get("blocks")) != null) {
            Iterator iterator = diskManagerFileInfoArray.keySet().iterator();
            while (iterator.hasNext()) {
                n = Integer.parseInt((String)iterator.next());
                if (n < n3 || n > n4) continue;
                iterator.remove();
            }
        }
        map.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(downloadManagerState, map);
        return n2;
    }

    private static int findFirstFileWithPieceN(int n, DiskManagerFileInfo[] diskManagerFileInfoArray) {
        int n2 = 0;
        int n3 = diskManagerFileInfoArray.length - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            int n5 = diskManagerFileInfoArray[n4].getLastPieceNumber();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            while (n4 > 0 && diskManagerFileInfoArray[n4 - 1].getLastPieceNumber() == n) {
                --n4;
            }
            break block0;
        }
        return n4;
    }

    public static boolean fileMustExist(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        int n;
        Map map = RDResumeHandler.getResumeData(downloadManager);
        byte[] byArray = map != null ? (byte[])map.get("resume data") : null;
        boolean bl = false;
        DiskManagerFileInfo[] diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
        int n2 = diskManagerFileInfo.getFirstPieceNumber();
        int n3 = diskManagerFileInfo.getLastPieceNumber();
        for (int i = n = RDResumeHandler.findFirstFileWithPieceN(n2, diskManagerFileInfoArray); i < diskManagerFileInfoArray.length && !bl; ++i) {
            DiskManagerFileInfo diskManagerFileInfo2 = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo2.getLastPieceNumber() < n2) continue;
            if (diskManagerFileInfo2.getIndex() == diskManagerFileInfo.getIndex() && byArray != null && diskManagerFileInfo.getStorageType() != 2 && diskManagerFileInfo.getStorageType() != 4) {
                for (int j = n2; j <= n3 && !bl; bl |= byArray[j] != 0, ++j) {
                }
            }
            if (diskManagerFileInfo2.getFirstPieceNumber() > n3) break;
            if (diskManagerFileInfo2.getFirstPieceNumber() <= n2 && n2 <= diskManagerFileInfo2.getLastPieceNumber()) {
                bl |= !diskManagerFileInfo2.isSkipped();
            }
            if (diskManagerFileInfo2.getFirstPieceNumber() > n3 || n3 > diskManagerFileInfo2.getLastPieceNumber()) continue;
            bl |= !diskManagerFileInfo2.isSkipped();
        }
        return bl;
    }

    public static int storageTypeChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        return RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, false, true);
    }

    public static void clearResumeData(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, false, false);
    }

    public static void recheckFile(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, true, false);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState downloadManagerState) {
        TOTorrent tOTorrent = downloadManagerState.getTorrent();
        long l = tOTorrent.getNumberOfPieces();
        byte[] byArray = new byte[(int)l];
        Arrays.fill(byArray, (byte)1);
        for (int i = 0; i < 3; ++i) {
            int n = (int)(Math.random() * (double)l);
            byArray[n] = 2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        HashMap hashMap2 = new HashMap();
        hashMap.put("blocks", hashMap2);
        hashMap.put("valid", new Long(0L));
        RDResumeHandler.saveResumeData(downloadManagerState, hashMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState downloadManagerState) {
        Map map = RDResumeHandler.getResumeData(downloadManagerState);
        return RDResumeHandler.isTorrentResumeDataComplete(downloadManagerState, map);
    }

    protected static boolean isTorrentResumeDataComplete(DownloadManagerState downloadManagerState, Map map) {
        try {
            int n = downloadManagerState.getTorrent().getNumberOfPieces();
            if (map != null) {
                boolean bl;
                byte[] byArray = (byte[])map.get("resume data");
                Map map2 = (Map)map.get("blocks");
                boolean bl2 = bl = ((Long)map.get("valid")).intValue() == 1;
                if (map2 == null || map2.size() > 0) {
                    return false;
                }
                if (bl && byArray != null && byArray.length == n) {
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] == 1) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return false;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Resume", "On Resume Recheck All"}, new ParameterListener(){

            public void parameterChanged(String string) {
                use_fast_resume = COConfigurationManager.getBooleanParameter("Use Resume");
                use_fast_resume_recheck_all = COConfigurationManager.getBooleanParameter("On Resume Recheck All");
            }
        });
    }
}

