/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.RealTimeInfo;

public class DiskManagerRecheckScheduler {
    private static boolean friendly_hashing;
    private static boolean smallest_first;
    private List instances = new ArrayList();
    private AEMonitor instance_mon = new AEMonitor("DiskManagerRecheckScheduler");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerRecheckInstance register(DiskManagerHelper diskManagerHelper, boolean bl) {
        try {
            this.instance_mon.enter();
            DiskManagerRecheckInstance diskManagerRecheckInstance = new DiskManagerRecheckInstance(this, diskManagerHelper.getTorrent().getSize(), (int)diskManagerHelper.getTorrent().getPieceLength(), bl);
            this.instances.add(diskManagerRecheckInstance);
            if (smallest_first) {
                Collections.sort(this.instances, new Comparator(){

                    public int compare(Object object, Object object2) {
                        long l = ((DiskManagerRecheckInstance)object).getMetric() - ((DiskManagerRecheckInstance)object2).getMetric();
                        if (l < 0L) {
                            return -1;
                        }
                        if (l == 0L) {
                            return 0;
                        }
                        return 1;
                    }
                });
            }
            DiskManagerRecheckInstance diskManagerRecheckInstance2 = diskManagerRecheckInstance;
            return diskManagerRecheckInstance2;
        }
        finally {
            this.instance_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPermission(DiskManagerRecheckInstance diskManagerRecheckInstance) {
        boolean bl = false;
        int n = 250;
        try {
            this.instance_mon.enter();
            if (this.instances.get(0) == diskManagerRecheckInstance) {
                boolean bl2 = diskManagerRecheckInstance.isLowPriority();
                if (bl2 && RealTimeInfo.isRealTimeTaskActive()) {
                    bl = false;
                } else {
                    if (friendly_hashing) {
                        n = 0;
                    } else if (!bl2) {
                        n = 1;
                    } else {
                        n = diskManagerRecheckInstance.getPieceLength() / 1024 / 10;
                        n = Math.min(n, 409);
                        n = Math.max(n, 12);
                    }
                    bl = true;
                }
            }
        }
        finally {
            this.instance_mon.exit();
        }
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(DiskManagerRecheckInstance diskManagerRecheckInstance) {
        try {
            this.instance_mon.enter();
            this.instances.remove(diskManagerRecheckInstance);
        }
        finally {
            this.instance_mon.exit();
        }
    }

    static {
        ParameterListener parameterListener = new ParameterListener(){

            public void parameterChanged(String string) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
                smallest_first = COConfigurationManager.getBooleanParameter("diskmanager.hashchecking.smallestfirst");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.friendly.hashchecking", "diskmanager.hashchecking.smallestfirst"}, parameterListener);
    }
}

