/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static boolean reorder_storage_mode;
    private static int reorder_storage_mode_min_mb;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private static ThreadPool start_pool;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private boolean checking_enabled = true;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager<DiskManagerListener> listeners_aggregator;
    private ListenerManager<DiskManagerListener> listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

        @Override
        public void dispatch(DiskManagerListener diskManagerListener, int n, Object object) {
            listeners_aggregator.dispatch(diskManagerListener, n, object);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent tOTorrent, DownloadManager downloadManager) {
        this.torrent = tOTorrent;
        this.download_manager = downloadManager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder localeUtilDecoder = null;
        try {
            localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            this.errorMessage = TorrentUtils.exceptionToText(tOTorrentException);
            this.setState(10);
            return;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(throwable);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(localeUtilDecoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(throwable);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                Object var2_1 = null;
                this.start_stop_mon.exit();
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean bl;
                    try {
                        try {
                            try {
                                DiskManagerImpl.this.start_stop_mon.enter();
                                if (DiskManagerImpl.this.stopping) {
                                    throw new Exception("Stopped during startup");
                                }
                                Object var2_1 = null;
                                DiskManagerImpl.this.start_stop_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var2_2 = null;
                                DiskManagerImpl.this.start_stop_mon.exit();
                                throw throwable;
                            }
                            DiskManagerImpl.this.startSupport();
                        }
                        catch (Throwable throwable) {
                            DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (start)";
                            Debug.printStackTrace(throwable);
                            DiskManagerImpl.this.setState(10);
                            Object var4_7 = null;
                            DiskManagerImpl.this.started_sem.release();
                        }
                        Object var4_6 = null;
                        DiskManagerImpl.this.started_sem.release();
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        DiskManagerImpl.this.started_sem.release();
                        throw throwable;
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        bl = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                        Object var6_10 = null;
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        DiskManagerImpl.this.start_stop_mon.exit();
                        throw throwable;
                    }
                    if (bl) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
        Object var2_2 = null;
        this.start_stop_mon.exit();
    }

    private void startSupport() {
        Object object;
        boolean bl = false;
        if (this.download_manager.isPersistent()) {
            object = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            for (int i = 0; i < ((File[])object).length; ++i) {
                String string = object[i].getAbsolutePath();
                if (!this.filesExist(string)) continue;
                bl = true;
                this.alreadyMoved = true;
                this.download_manager.setTorrentSaveDir(string);
                break;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            if (!bl) {
                bl = this.filesExist();
            }
            if (!bl && (object = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (object.download_location != null || object.download_name != null) {
                    File file = object.download_location;
                    if (file == null) {
                        file = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (object.download_name == null) {
                        this.download_manager.setTorrentSaveDir(file.getAbsolutePath());
                    } else {
                        this.download_manager.setTorrentSaveDir(file.getAbsolutePath(), object.download_name);
                    }
                }
                if (object.torrent_location != null || object.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(object.torrent_location, object.torrent_name);
                    }
                    catch (DownloadManagerException downloadManagerException) {
                        Debug.printStackTrace(downloadManagerException);
                    }
                }
            }
        }
        int n = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (n == 0) {
                this.resume_handler.checkAllPieces(false);
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (n != this.files.length) {
                this.resume_handler.checkAllPieces(true);
            }
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(boolean bl) {
        block12: {
            block11: {
                try {
                    this.start_stop_mon.enter();
                    if (this.started) break block11;
                    boolean bl2 = false;
                    Object var4_6 = null;
                    this.start_stop_mon.exit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.start_stop_mon.exit();
                    throw throwable;
                }
            }
            if (!this.starting) break block12;
            this.stopping = true;
            this.checker.stop();
            this.writer.stop();
            this.reader.stop();
            this.resume_handler.stop(bl);
            this.saveState(false);
            boolean bl3 = true;
            Object var4_7 = null;
            this.start_stop_mon.exit();
            return bl3;
        }
        this.started = false;
        this.stopping = false;
        Object var4_8 = null;
        this.start_stop_mon.exit();
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(bl);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable throwable) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(throwable));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception exception) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(exception));
            }
        }
        this.saveState();
        this.listeners.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        try {
            this.start_stop_mon.enter();
            boolean bl = !this.started && !this.starting && !this.stopping;
            Object var3_2 = null;
            this.start_stop_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String string) {
        File file;
        Object var17_16;
        File file2;
        File file3;
        boolean bl;
        DiskManagerFileInfoImpl diskManagerFileInfoImpl;
        if (!this.torrent.isSimpleTorrent()) {
            string = string + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        DMPieceMapperFile[] dMPieceMapperFileArray = this.piece_mapper.getFiles();
        String[] stringArray = this.getStorageTypes();
        int n = 0;
        while (true) {
            if (n >= dMPieceMapperFileArray.length) {
                return true;
            }
            DMPieceMapperFile dMPieceMapperFile = dMPieceMapperFileArray[n];
            File file4 = dMPieceMapperFile.getDataFile();
            long l = dMPieceMapperFile.getLength();
            diskManagerFileInfoImpl = dMPieceMapperFile.getFileInfo();
            bl = false;
            try {
                if (diskManagerFileInfoImpl == null) {
                    int n2 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[n]);
                    diskManagerFileInfoImpl = new DiskManagerFileInfoImpl(this, new File(string + file4.toString()), n, dMPieceMapperFile.getTorrentFile(), n2);
                    bl = true;
                }
                try {
                    CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                    file3 = diskManagerFileInfoImpl.getFile(true);
                    if (!cacheFile.exists()) {
                        file2 = file3;
                        break;
                    }
                    long l2 = diskManagerFileInfoImpl.getCacheFile().getLength();
                    if (l2 > l) {
                        if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                            diskManagerFileInfoImpl.setAccessMode(2);
                            diskManagerFileInfoImpl.getCacheFile().setLength(l);
                            Debug.out("Existing data file length too large [" + l2 + ">" + l + "]: " + file3.getAbsolutePath() + ", truncating");
                        } else {
                            this.errorMessage = "Existing data file length too large [" + l2 + ">" + l + "]: " + file3.getAbsolutePath();
                            boolean bl2 = false;
                            var17_16 = null;
                            if (!bl) return bl2;
                            diskManagerFileInfoImpl.getCacheFile().close();
                            return bl2;
                        }
                    }
                    var17_16 = null;
                    if (bl) {
                        diskManagerFileInfoImpl.getCacheFile().close();
                    }
                }
                catch (Throwable throwable) {
                    var17_16 = null;
                    if (bl) {
                        diskManagerFileInfoImpl.getCacheFile().close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (filesExist:" + file4.toString() + ")";
                return false;
            }
            ++n;
        }
        while (!file2.exists() && (file = file2.getParentFile()) != null) {
            if (!file.exists()) {
                file2 = file;
                continue;
            }
            this.errorMessage = file.isDirectory() ? file2.toString() + " not found." : file.toString() + " is not a directory.";
            boolean bl3 = false;
            var17_16 = null;
            if (!bl) return bl3;
            diskManagerFileInfoImpl.getCacheFile().close();
            return bl3;
        }
        this.errorMessage = file3.toString() + " not found.";
        boolean bl4 = false;
        var17_16 = null;
        if (!bl) return bl4;
        diskManagerFileInfoImpl.getCacheFile().close();
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int allocateFiles() {
        block65: {
            block64: {
                block62: {
                    block61: {
                        block60: {
                            block58: {
                                block66: {
                                    block57: {
                                        var1_1 = new HashSet<String>();
                                        var2_2 = this.piece_mapper.getFiles();
                                        var3_3 = new DiskManagerFileInfoImpl[var2_2.length];
                                        try {
                                            DiskManagerImpl.allocation_scheduler.register(this);
                                            this.setState(2);
                                            this.allocated = 0L;
                                            var4_4 = 0;
                                            var5_5 = this.download_manager.getAbsoluteSaveLocation().getParent();
                                            if (!this.torrent.isSimpleTorrent()) {
                                                var5_5 = var5_5 + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
                                            }
                                            var5_5 = var5_5 + File.separator;
                                            var6_6 = this.getStorageTypes();
                                            var7_7 = this.download_manager.getDownloadState().getAttribute("incompfilesuffix");
                                            for (var8_8 = 0; var8_8 < var2_2.length; ++var8_8) {
                                                block63: {
                                                    block68: {
                                                        block59: {
                                                            block67: {
                                                                if (!this.stopping) break block67;
                                                                this.errorMessage = "File allocation interrupted - download is stopping";
                                                                this.setState(10);
                                                                var9_10 = -1;
                                                                var27_33 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files != null) ** GOTO lbl27
                                                                var28_44 = 0;
lbl25:
                                                                // 2 sources

                                                                while (true) {
                                                                    if (var28_44 < var3_3.length) break block57;
lbl27:
                                                                    // 2 sources

                                                                    return var9_10;
                                                                }
                                                            }
                                                            var9_9 = var2_2[var8_8];
                                                            var10_11 = var9_9.getLength();
                                                            var12_12 = var9_9.getDataFile();
                                                            try {
                                                                var14_15 = DiskManagerUtil.convertDMStorageTypeFromString(var6_6[var8_8]);
                                                                var3_3[var8_8] = var13_13 = new DiskManagerFileInfoImpl(this, new File(var5_5 + var12_12.toString()), var8_8, var9_9.getTorrentFile(), var14_15);
                                                                var9_9.setFileInfo(var13_13);
                                                            }
                                                            catch (CacheFileManagerException var14_16) {
                                                                this.errorMessage = Debug.getNestedExceptionMessage(var14_16) + " (allocateFiles:" + var12_12.toString() + ")";
                                                                this.setState(10);
                                                                var15_18 = -1;
                                                                var27_34 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files == null) {
                                                                    for (var28_45 = 0; var28_45 < var3_3.length; ++var28_45) {
                                                                        if (var3_3[var28_45] == null) continue;
                                                                        try {
                                                                            var3_3[var28_45].getCacheFile().close();
                                                                            continue;
                                                                        }
                                                                        catch (Throwable var29_56) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                return var15_18;
                                                            }
                                                            var14_14 = var13_13.getCacheFile();
                                                            var15_17 = var13_13.getFile(true);
                                                            var16_19 = var15_17.getAbsolutePath();
                                                            if (Constants.isWindows) {
                                                                var16_19 = var16_19.toLowerCase();
                                                            }
                                                            if (var1_1.contains(var16_19)) {
                                                                this.errorMessage = "File occurs more than once in download: " + var15_17.toString();
                                                                this.setState(10);
                                                                var17_21 = -1;
                                                                break block58;
                                                            }
                                                            var1_1.add(var16_19);
                                                            var17_20 = var15_17.getName();
                                                            if (var7_7 != null && var17_20.endsWith(var7_7)) {
                                                                var17_20 = var17_20.substring(0, var17_20.length() - var7_7.length());
                                                            }
                                                            if ((var18_22 = var17_20.lastIndexOf(".")) == -1) {
                                                                var18_22 = 0;
                                                            }
                                                            var13_13.setExtension(var17_20.substring(var18_22));
                                                            var19_23 = COConfigurationManager.getStringParameter("priorityExtensions", "");
                                                            if (!var19_23.equals("")) {
                                                                var20_24 = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                                                                var21_26 = new StringTokenizer(var19_23, ";");
                                                                while (var21_26.hasMoreTokens()) {
                                                                    var22_28 = var21_26.nextToken();
                                                                    if (!(var22_28 = var22_28.trim()).startsWith(".")) {
                                                                        var22_28 = "." + var22_28;
                                                                    }
                                                                    if ((var23_29 = var20_24 != 0 ? var13_13.getExtension().equalsIgnoreCase(var22_28) : var13_13.getExtension().equals(var22_28)) == 0) continue;
                                                                    var13_13.setPriority(1);
                                                                }
                                                            }
                                                            var13_13.setDownloaded(0L);
                                                            var20_24 = var14_14.getStorageType();
                                                            var21_25 = var20_24 == 2 || var20_24 == 4;
                                                            v0 = var22_27 = var21_25 == false || RDResumeHandler.fileMustExist(this.download_manager, var13_13) != false;
                                                            if (!var22_27 && var14_14.exists()) {
                                                                var15_17.delete();
                                                            }
                                                            if (!var14_14.exists()) break block68;
                                                            try {
                                                                var23_30 = var13_13.getCacheFile().getLength();
                                                                if (var23_30 > var10_11) {
                                                                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                                                        var13_13.setAccessMode(2);
                                                                        var14_14.setLength(var10_11);
                                                                        var13_13.setAccessMode(1);
                                                                        Debug.out("Existing data file length too large [" + var23_30 + ">" + var10_11 + "]: " + var15_17.getAbsolutePath() + ", truncating");
                                                                        break block59;
                                                                    }
                                                                    this.errorMessage = "Existing data file length too large [" + var23_30 + ">" + var10_11 + "]: " + var15_17.getAbsolutePath();
                                                                    this.setState(10);
                                                                    var25_66 = -1;
                                                                    break block60;
                                                                }
                                                            }
                                                            catch (Throwable var23_31) {
                                                                this.fileAllocFailed(var15_17, var10_11, false, var23_31);
                                                                this.setState(10);
                                                                var24_68 = -1;
                                                                var27_38 = null;
                                                                DiskManagerImpl.allocation_scheduler.unregister(this);
                                                                if (this.files == null) {
                                                                    for (var28_49 = 0; var28_49 < var3_3.length; ++var28_49) {
                                                                        if (var3_3[var28_49] == null) continue;
                                                                        ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl117:
                                                                        // 1 sources

                                                                        var3_3[var28_49].getCacheFile().close();
                                                                        continue;
lbl119:
                                                                        // 1 sources

                                                                        catch (Throwable var29_60) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                return var24_68;
                                                            }
                                                            {
                                                                if (var23_30 >= var10_11 || var21_25 || this.allocateFile(var13_13, var15_17, var23_30, var10_11)) break block59;
                                                                var25_67 = -1;
                                                            }
                                                            break block61;
                                                        }
                                                        this.allocated += var10_11;
                                                        continue;
                                                    }
                                                    if (!var22_27) continue;
                                                    if (this.download_manager.isDataAlreadyAllocated()) {
                                                        this.errorMessage = "Data file missing: " + var15_17.getAbsolutePath();
                                                        this.setState(10);
                                                        var23_29 = -1;
                                                        break block62;
                                                    }
                                                    try {
                                                        if (this.allocateFile(var13_13, var15_17, -1L, var10_11)) break block63;
                                                        var23_29 = -1;
                                                        break block64;
                                                    }
                                                    catch (Throwable var23_32) {
                                                        this.fileAllocFailed(var15_17, var10_11, true, var23_32);
                                                        this.setState(10);
                                                        var24_69 = -1;
                                                        var27_41 = null;
                                                        DiskManagerImpl.allocation_scheduler.unregister(this);
                                                        if (this.files == null) {
                                                            for (var28_52 = 0; var28_52 < var3_3.length; ++var28_52) {
                                                                if (var3_3[var28_52] == null) continue;
                                                                ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl153:
                                                                // 1 sources

                                                                var3_3[var28_52].getCacheFile().close();
                                                                continue;
lbl155:
                                                                // 1 sources

                                                                catch (Throwable var29_63) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        return var24_69;
                                                    }
                                                }
                                                ++var4_4;
                                            }
                                            this.files = var3_3;
                                            this.fileset = new DiskManagerFileInfoSetImpl(this.files, this);
                                            this.loadFilePriorities();
                                            this.download_manager.setDataAlreadyAllocated(true);
                                            var8_8 = var4_4;
                                            break block65;
                                        }
                                        catch (Throwable var26_70) {
                                            var27_43 = null;
                                            DiskManagerImpl.allocation_scheduler.unregister(this);
                                            if (this.files == null) {
                                                for (var28_54 = 0; var28_54 < var3_3.length; ++var28_54) {
                                                    if (var3_3[var28_54] == null) continue;
                                                    ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl177:
                                                    // 1 sources

                                                    var3_3[var28_54].getCacheFile().close();
                                                    continue;
lbl179:
                                                    // 1 sources

                                                    catch (Throwable var29_65) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            throw var26_70;
                                        }
                                    }
                                    if (var3_3[var28_44] != null) {
                                        ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl186:
                                        // 1 sources

                                        var3_3[var28_44].getCacheFile().close();
                                        break block66;
lbl188:
                                        // 1 sources

                                        catch (Throwable var29_55) {
                                            // empty catch block
                                        }
                                    }
                                }
                                ++var28_44;
                                ** while (true)
                            }
                            var27_35 = null;
                            DiskManagerImpl.allocation_scheduler.unregister(this);
                            if (this.files == null) {
                                for (var28_46 = 0; var28_46 < var3_3.length; ++var28_46) {
                                    if (var3_3[var28_46] == null) continue;
                                    ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl200:
                                    // 1 sources

                                    var3_3[var28_46].getCacheFile().close();
                                    continue;
lbl202:
                                    // 1 sources

                                    catch (Throwable var29_57) {
                                        // empty catch block
                                    }
                                }
                            }
                            return var17_21;
                        }
                        var27_36 = null;
                        DiskManagerImpl.allocation_scheduler.unregister(this);
                        if (this.files == null) {
                            for (var28_47 = 0; var28_47 < var3_3.length; ++var28_47) {
                                if (var3_3[var28_47] == null) continue;
                                ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl213:
                                // 1 sources

                                var3_3[var28_47].getCacheFile().close();
                                continue;
lbl215:
                                // 1 sources

                                catch (Throwable var29_58) {
                                    // empty catch block
                                }
                            }
                        }
                        return var25_66;
                    }
                    var27_37 = null;
                    DiskManagerImpl.allocation_scheduler.unregister(this);
                    if (this.files == null) {
                        for (var28_48 = 0; var28_48 < var3_3.length; ++var28_48) {
                            if (var3_3[var28_48] == null) continue;
                            ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl226:
                            // 1 sources

                            var3_3[var28_48].getCacheFile().close();
                            continue;
lbl228:
                            // 1 sources

                            catch (Throwable var29_59) {
                                // empty catch block
                            }
                        }
                    }
                    return var25_67;
                }
                var27_39 = null;
                DiskManagerImpl.allocation_scheduler.unregister(this);
                if (this.files == null) {
                    for (var28_50 = 0; var28_50 < var3_3.length; ++var28_50) {
                        if (var3_3[var28_50] == null) continue;
                        ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl239:
                        // 1 sources

                        var3_3[var28_50].getCacheFile().close();
                        continue;
lbl241:
                        // 1 sources

                        catch (Throwable var29_61) {
                            // empty catch block
                        }
                    }
                }
                return var23_29;
            }
            var27_40 = null;
            DiskManagerImpl.allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (var28_51 = 0; var28_51 < var3_3.length; ++var28_51) {
                    if (var3_3[var28_51] == null) continue;
                    ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl252:
                    // 1 sources

                    var3_3[var28_51].getCacheFile().close();
                    continue;
lbl254:
                    // 1 sources

                    catch (Throwable var29_62) {
                        // empty catch block
                    }
                }
            }
            return var23_29;
        }
        var27_42 = null;
        DiskManagerImpl.allocation_scheduler.unregister(this);
        if (this.files == null) {
            for (var28_53 = 0; var28_53 < var3_3.length; ++var28_53) {
                if (var3_3[var28_53] == null) continue;
                ** try [egrp 5[TRYBLOCK] [15 : 1204->1219)] { 
lbl265:
                // 1 sources

                var3_3[var28_53].getCacheFile().close();
                continue;
lbl267:
                // 1 sources

                catch (Throwable var29_64) {
                    // empty catch block
                }
            }
        }
        return var8_8;
    }

    /*
     * Loose catch block
     */
    private boolean allocateFile(DiskManagerFileInfoImpl diskManagerFileInfoImpl, File file, long l, long l2) throws Throwable {
        block24: {
            while (this.started && !allocation_scheduler.getPermission(this)) {
            }
            if (!this.started) {
                return false;
            }
            diskManagerFileInfoImpl.setAccessMode(2);
            if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                if (l < 0L) {
                    diskManagerFileInfoImpl.getCacheFile().setLength(0L);
                }
            } else if (l2 > 0L && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
                Object object;
                long l3;
                long l4;
                diskManagerFileInfoImpl.getCacheFile().setLength(l2);
                if (l > 0L) {
                    l4 = l;
                    l3 = l2 - l;
                } else {
                    l4 = 0L;
                    l3 = l2;
                }
                String[] stringArray = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp " + l4 + " " + l3, file.getAbsolutePath()};
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    object = Runtime.getRuntime().exec(stringArray);
                    int n = ((Process)object).getErrorStream().read(byArray);
                    while (n > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                        n = ((Process)object).getErrorStream().read(byArray);
                    }
                    byteArrayOutputStream.close();
                    ((Process)object).waitFor();
                }
                catch (IOException iOException) {
                    String string = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{iOException.getMessage()});
                    Logger.log(new LogAlert((Object)this, false, 3, string));
                }
                if (byteArrayOutputStream.size() > 0) {
                    object = byteArrayOutputStream.toString().trim();
                    if (((String)object).endsWith("is not on an XFS filesystem")) {
                        Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + (String)object + "\""));
                    } else {
                        throw new Exception((String)object);
                    }
                }
                this.allocated += l2;
            } else {
                if (COConfigurationManager.getBooleanParameter("Zero New")) {
                    boolean bl = false;
                    bl = this.writer.zeroFile(diskManagerFileInfoImpl, l2);
                    Object var17_15 = null;
                    if (bl) break block24;
                    try {
                        diskManagerFileInfoImpl.getCacheFile().close();
                        diskManagerFileInfoImpl.getCacheFile().delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.setState(10);
                    {
                        break block24;
                        catch (Throwable throwable) {
                            this.fileAllocFailed(file, l2, l == -1L, throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_16 = null;
                        if (!bl) {
                            try {
                                diskManagerFileInfoImpl.getCacheFile().close();
                                diskManagerFileInfoImpl.getCacheFile().delete();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            this.setState(10);
                        }
                        throw throwable;
                    }
                }
                diskManagerFileInfoImpl.getCacheFile().setLength(l2);
                this.allocated += l2;
            }
        }
        diskManagerFileInfoImpl.setAccessMode(1);
        return true;
    }

    private void fileAllocFailed(File file, long l, boolean bl, Throwable throwable) {
        this.errorMessage = Debug.getNestedExceptionMessage(throwable) + " (allocateFiles " + (bl ? "new" : "existing") + ":" + file.toString() + ")";
        if (this.errorMessage.indexOf("not enough space") != -1) {
            this.errorMessage = l >= 0x100000000L ? MessageText.getString("DiskManager.error.nospace_fat32") : MessageText.getString("DiskManager.error.nospace");
        }
    }

    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    public void enqueueReadRequest(DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        this.reader.readBlock(diskManagerReadRequest, diskManagerReadRequestListener);
    }

    public boolean hasOutstandingReadRequestForPiece(int n) {
        return this.reader.hasOutstandingReadRequestForPiece(n);
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int n) {
        this.percentDone = n;
    }

    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingExcludingDND() {
        long l;
        DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray;
        if (this.skipped_file_set_changed && (diskManagerFileInfoImplArray = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                this.skipped_file_set_size = 0L;
                this.skipped_but_downloaded = 0L;
                for (int i = 0; i < diskManagerFileInfoImplArray.length; ++i) {
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = diskManagerFileInfoImplArray[i];
                    if (!diskManagerFileInfoImpl.isSkipped()) continue;
                    this.skipped_file_set_size += diskManagerFileInfoImpl.getLength();
                    this.skipped_but_downloaded += diskManagerFileInfoImpl.getDownloaded();
                }
                Object var5_5 = null;
                this.file_piece_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.file_piece_mon.exit();
                throw throwable;
            }
        }
        if ((l = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded)) < 0L) {
            l = 0L;
        }
        return l;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long l) {
        this.allocated = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPieceDone(DiskManagerPieceImpl diskManagerPieceImpl, boolean bl) {
        int n = diskManagerPieceImpl.getPieceNumber();
        int n2 = diskManagerPieceImpl.getLength();
        try {
            this.file_piece_mon.enter();
            if (diskManagerPieceImpl.isDone() != bl) {
                diskManagerPieceImpl.setDoneSupport(bl);
                this.remaining = bl ? (this.remaining -= (long)n2) : (this.remaining += (long)n2);
                DMPieceList dMPieceList = this.getPieceList(n);
                for (int i = 0; i < dMPieceList.size(); ++i) {
                    long l;
                    DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceMapEntry.getFile();
                    long l2 = diskManagerFileInfoImpl.getLength();
                    long l3 = l = diskManagerFileInfoImpl.getDownloaded();
                    l = bl ? (l += (long)dMPieceMapEntry.getLength()) : (l -= (long)dMPieceMapEntry.getLength());
                    if (l < 0L) {
                        Debug.out("piece map entry length negative");
                        l = 0L;
                    } else if (l > l2) {
                        Debug.out("piece map entry length too large");
                        l = l2;
                    }
                    if (diskManagerFileInfoImpl.isSkipped()) {
                        this.skipped_but_downloaded += l - l3;
                    }
                    diskManagerFileInfoImpl.setDownloaded(l);
                    if (l != l2) continue;
                    try {
                        Object var23_20;
                        try {
                            String string;
                            File file;
                            File file2;
                            DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
                            String string2 = downloadManagerState.getAttribute("incompfilesuffix");
                            if (string2 != null && string2.length() > 0 && (file2 = downloadManagerState.getFileLink(file = diskManagerFileInfoImpl.getFile(false))) != null && (string = file2.getName()).endsWith(string2) && string.length() > string2.length()) {
                                String string3 = string.substring(0, string.length() - string2.length());
                                File file3 = new File(file2.getParentFile(), string3);
                                if (!file3.exists()) {
                                    diskManagerFileInfoImpl.renameFile(string3, false);
                                    if (file.equals(file3)) {
                                        downloadManagerState.setFileLink(file, null);
                                    } else {
                                        downloadManagerState.setFileLink(file, file3);
                                    }
                                }
                            }
                            var23_20 = null;
                            if (diskManagerFileInfoImpl.getAccessMode() != 2) continue;
                        }
                        catch (Throwable throwable) {
                            var23_20 = null;
                            if (diskManagerFileInfoImpl.getAccessMode() == 2) {
                                diskManagerFileInfoImpl.setAccessMode(1);
                            }
                            throw throwable;
                        }
                        diskManagerFileInfoImpl.setAccessMode(1);
                        {
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(throwable));
                        Debug.printStackTrace(throwable);
                    }
                }
                if (this.getState() == 4) {
                    this.listeners.dispatch(3, diskManagerPieceImpl);
                }
            }
            Object var25_22 = null;
            this.file_piece_mon.exit();
        }
        catch (Throwable throwable) {
            Object var25_23 = null;
            this.file_piece_mon.exit();
            throw throwable;
        }
    }

    public void accessModeChanged(DiskManagerFileInfoImpl diskManagerFileInfoImpl, int n, int n2) {
        this.listeners.dispatch(4, new Object[]{diskManagerFileInfoImpl, new Integer(n), new Integer(n2)});
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int n) {
        return this.pieces[n];
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public int getPieceLength(int n) {
        if (n == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int n) {
        if (this.state_set_via_method == 10) {
            if (n != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + n);
            }
            return;
        }
        if (this.state_set_via_method != n) {
            int[] nArray = new int[]{this.state_set_via_method, n};
            this.state_set_via_method = n;
            this.listeners.dispatch(1, nArray);
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String string) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = string;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    public void setFailed(final DiskManagerFileInfo diskManagerFileInfo, final String string) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = string;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, diskManagerFileInfo);
            }
        }.start();
    }

    public int getCacheMode() {
        return 1;
    }

    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    public DMPieceMap getPieceMap() {
        DMPieceMap dMPieceMap = this.piece_map_use_accessor;
        if (dMPieceMap == null) {
            this.piece_map_use_accessor = dMPieceMap = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return dMPieceMap;
    }

    public DMPieceList getPieceList(int n) {
        DMPieceMap dMPieceMap = this.getPieceMap();
        return dMPieceMap.getPieceList(n);
    }

    public void checkFreePieceList(boolean bl) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long l = SystemTime.getCurrentTime();
        if (!bl) {
            if (l < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = l;
                return;
            }
            if (l - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    public byte[] getPieceHash(int n) throws TOTorrentException {
        return this.torrent.getPieces()[n];
    }

    public DiskManagerReadRequest createReadRequest(int n, int n2, int n3) {
        return this.reader.createReadRequest(n, n2, n3);
    }

    public DiskManagerCheckRequest createCheckRequest(int n, Object object) {
        return this.checker.createCheckRequest(n, object);
    }

    public boolean hasOutstandingCheckRequestForPiece(int n) {
        return this.checker.hasOutstandingCheckRequestForPiece(n);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        this.checker.enqueueCompleteRecheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        this.checker.enqueueCheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener);
    }

    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    public void setPieceCheckingEnabled(boolean bl) {
        this.checking_enabled = bl;
        this.checker.setCheckingEnabled(bl);
    }

    public DirectByteBuffer readBlock(int n, int n2, int n3) {
        return this.reader.readBlock(n, n2, n3);
    }

    public DiskManagerWriteRequest createWriteRequest(int n, int n2, DirectByteBuffer directByteBuffer, Object object) {
        return this.writer.createWriteRequest(n, n2, directByteBuffer, object);
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest diskManagerWriteRequest, DiskManagerWriteRequestListener diskManagerWriteRequestListener) {
        this.writer.writeBlock(diskManagerWriteRequest, diskManagerWriteRequestListener);
    }

    public boolean hasOutstandingWriteRequestForPiece(int n) {
        return this.writer.hasOutstandingWriteRequestForPiece(n);
    }

    public boolean checkBlockConsistencyForWrite(String string, int n, int n2, DirectByteBuffer directByteBuffer) {
        if (n < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " pieceNumber=" + n + " < 0"));
            }
            return false;
        }
        if (n >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " pieceNumber=" + n + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int n3 = this.pieceLength;
        if (n == this.nbPieces - 1) {
            n3 = this.lastPieceLength;
        }
        if (n2 < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " < 0"));
            }
            return false;
        }
        if (n2 > n3) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " > length=" + n3));
            }
            return false;
        }
        int n4 = directByteBuffer.remaining((byte)8);
        if (n4 <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " size=" + n4 + " <= 0"));
            }
            return false;
        }
        if (n2 + n4 > n3) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + string + " offset=" + n2 + " + size=" + n4 + " > length=" + n3));
            }
            return false;
        }
        return true;
    }

    public boolean checkBlockConsistencyForRead(String string, boolean bl, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, string, bl, n, n2, n3);
    }

    public boolean checkBlockConsistencyForHint(String string, int n, int n2, int n3) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, string, n, n2, n3);
    }

    public void saveResumeData(boolean bl) throws Exception {
        this.resume_handler.saveResumeData(bl);
    }

    public void downloadEnded() {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true);
    }

    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean var1_1, boolean var2_2) {
        block12: {
            block10: {
                block11: {
                    try {
                        this.start_stop_mon.enter();
                        v0 = var3_3 = var1_1 == false;
                        if (!var3_3) ** GOTO lbl34
                        if (!this.alreadyMoved) break block10;
                        var4_4 = false;
                        var7_6 = null;
                        this.start_stop_mon.exit();
                        if (var1_1) break block11;
                    }
                    catch (Throwable var6_13) {
                        block13: {
                            var7_8 = null;
                            this.start_stop_mon.exit();
                            if (var1_1) break block13;
                            try {
                                this.saveResumeData(false);
                            }
                            catch (Throwable var8_11) {
                                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(var8_11));
                            }
                        }
                        throw var6_13;
                    }
                    try {
                        this.saveResumeData(false);
                    }
                    catch (Throwable var8_9) {
                        this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(var8_9));
                    }
                }
                return var4_4;
            }
            this.alreadyMoved = true;
lbl34:
            // 2 sources

            if (var1_1) {
                var4_5 = DownloadManagerMoveHandler.onRemoval(this.download_manager);
            } else {
                DownloadManagerMoveHandler.onCompletion(this.download_manager, new DownloadManagerMoveHandler.MoveCallback(){

                    public void perform(SaveLocationChange saveLocationChange) {
                        DiskManagerImpl.this.moveFiles(saveLocationChange, true);
                    }
                });
                var4_5 = null;
            }
            if (var4_5 != null) {
                this.moveFiles(var4_5, true);
            }
            var5_12 = true;
            var7_7 = null;
            this.start_stop_mon.exit();
            if (var1_1) break block12;
            try {
                this.saveResumeData(false);
            }
            catch (Throwable var8_10) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(var8_10));
            }
        }
        return var5_12;
    }

    public void moveDataFiles(File file, String string) {
        SaveLocationChange saveLocationChange = new SaveLocationChange();
        saveLocationChange.download_location = file;
        saveLocationChange.download_name = string;
        this.moveFiles(saveLocationChange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(SaveLocationChange saveLocationChange, boolean bl) {
        boolean bl2 = false;
        if (saveLocationChange.hasDownloadChange()) {
            bl2 = !this.isFileDestinationIsItself(saveLocationChange);
        }
        try {
            block6: {
                try {
                    this.start_stop_mon.enter();
                    boolean bl3 = true;
                    if (bl2) {
                        bl3 = this.moveDataFiles0(saveLocationChange, bl);
                    }
                    if (!saveLocationChange.hasTorrentChange() || !bl3) break block6;
                    this.moveTorrentFile(saveLocationChange);
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                    Object var6_7 = null;
                    this.start_stop_mon.exit();
                }
            }
            Object var6_6 = null;
            this.start_stop_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.start_stop_mon.exit();
            throw throwable;
        }
    }

    private void logMoveFileError(String string, String string2) {
        Logger.log(new LogEvent((Object)this, LOGID, 3, string2));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{string, string2});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange saveLocationChange) {
        File file = this.download_manager.getAbsoluteSaveLocation();
        File file2 = saveLocationChange.normaliseDownloadLocation(file);
        try {
            file = file.getCanonicalFile();
            file2 = file2.getCanonicalFile();
            if (file.equals(file2)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(file2, file)) {
                String string = "Target is sub-directory of files";
                this.logMoveFileError(file2.toString(), string);
                return true;
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        return false;
    }

    private boolean moveDataFiles0(SaveLocationChange saveLocationChange, boolean bl) throws Exception {
        String string;
        File file;
        int n;
        File file2 = saveLocationChange.download_location;
        if (file2 == null) {
            file2 = this.download_manager.getAbsoluteSaveLocation().getParentFile();
        }
        String string2 = file2.toString();
        String string3 = saveLocationChange.download_name;
        if (this.files == null) {
            return false;
        }
        if (this.isFileDestinationIsItself(saveLocationChange)) {
            return false;
        }
        boolean bl2 = this.download_manager.getTorrent().isSimpleTorrent();
        File file3 = this.download_manager.getAbsoluteSaveLocation();
        String string4 = file3.getParentFile().getCanonicalFile().getPath();
        File[] fileArray = new File[this.files.length];
        File[] fileArray2 = new File[this.files.length];
        boolean[] blArray = new boolean[this.files.length];
        for (n = 0; n < this.files.length; ++n) {
            File file4;
            file = this.files[n].getFile(false);
            File file5 = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, file);
            if (!file5.equals(file)) {
                if (bl2) {
                    if (file5.getParentFile().getCanonicalPath().equals(file3.getParentFile().getCanonicalPath())) {
                        file = file5;
                    } else {
                        blArray[n] = true;
                    }
                } else if (file5.getCanonicalPath().startsWith(file3.getCanonicalPath())) {
                    file = file5;
                } else {
                    blArray[n] = true;
                }
            }
            fileArray2[n] = file;
            string = file.getCanonicalFile().getParent();
            if (!string.startsWith(string4)) {
                this.logMoveFileError(string2, "Could not determine relative path for file - " + string);
                throw new IOException("relative path assertion failed: move_from_dir=\"" + string4 + "\", old_parent_path=\"" + string + "\"");
            }
            String string5 = string.substring(string4.length());
            if (string5.startsWith(File.separator)) {
                string5 = string5.substring(1);
            }
            if (string3 == null) {
                file4 = new File(new File(string2, string5), file.getName());
            } else if (bl2) {
                file4 = new File(new File(string2, string5), string3);
            } else {
                String string6;
                int n2 = string5.indexOf(File.separator);
                if (n2 == -1) {
                    string6 = string3;
                } else {
                    String string7 = string5.substring(n2);
                    String string8 = string5.substring(0, n2);
                    string6 = string3 + string7;
                    boolean bl3 = string8.equals(file3.getName());
                    if (!bl3) {
                        Debug.out("Assertion check for renaming file in multi-name torrent " + (bl3 ? "passed" : "failed") + "\n" + "  Old parent path: " + string + "\n" + "  Subpath: " + string5 + "\n" + "  Sub-subpath: " + string7 + "\n" + "  Expected old name: " + string8 + "\n" + "  Torrent pre-move name: " + file3.getName() + "\n" + "  New torrent name: " + string3 + "\n" + "  Old file: " + file + "\n" + "  Linked file: " + file5 + "\n" + "\n" + "  Move-to-dir: " + string2 + "\n" + "  New path: " + string6 + "\n" + "  Old file [name]: " + file.getName() + "\n");
                    }
                }
                file4 = new File(new File(string2, string6), file.getName());
            }
            fileArray[n] = file4;
            if (blArray[n]) continue;
            if (file4.exists()) {
                String string9 = "" + file5.getName() + " already exists in MoveTo destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, string9));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefileexists"), new String[]{file.getName()});
                Debug.out(string9);
                return false;
            }
            FileUtil.mkdirs(file4.getParentFile());
        }
        for (n = 0; n < this.files.length; ++n) {
            file = fileArray[n];
            try {
                this.files[n].moveFile(file, blArray[n]);
                if (!bl) continue;
                this.files[n].setAccessMode(1);
                continue;
            }
            catch (CacheFileManagerException cacheFileManagerException) {
                string = "Failed to move " + fileArray2[n].toString() + " to destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, string));
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{fileArray2[n].toString(), Debug.getNestedExceptionMessage(cacheFileManagerException)});
                for (int i = 0; i < n; ++i) {
                    try {
                        this.files[i].moveFile(fileArray2[i], blArray[i]);
                        continue;
                    }
                    catch (CacheFileManagerException cacheFileManagerException2) {
                        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{fileArray2[i].toString(), Debug.getNestedExceptionMessage(cacheFileManagerException2)});
                    }
                }
                return false;
            }
        }
        if (file3.isDirectory()) {
            TorrentUtils.recursiveEmptyDirDelete(file3, false);
        }
        if (string3 == null) {
            this.download_manager.setTorrentSaveDir(string2);
        } else {
            this.download_manager.setTorrentSaveDir(string2, string3);
        }
        return true;
    }

    private void moveTorrentFile(SaveLocationChange saveLocationChange) {
        if (!saveLocationChange.hasTorrentChange()) {
            return;
        }
        File file = new File(this.download_manager.getTorrentFileName());
        File file2 = saveLocationChange.normaliseTorrentLocation(file);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(saveLocationChange.torrent_location, saveLocationChange.torrent_name);
        }
        catch (DownloadManagerException downloadManagerException) {
            String string = "Failed to move " + file.toString() + " to " + file2.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, string));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{file.toString(), file2.toString()});
            Debug.out(string);
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener diskManagerListener) {
        this.listeners.addListener(diskManagerListener);
        int[] nArray = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(diskManagerListener, 1, nArray);
    }

    public void removeListener(DiskManagerListener diskManagerListener) {
        this.listeners.removeListener(diskManagerListener);
    }

    public boolean hasListener(DiskManagerListener diskManagerListener) {
        return this.listeners.hasListener(diskManagerListener);
    }

    public static void deleteDataFiles(TOTorrent tOTorrent, String string, String string2, boolean bl) {
        block8: {
            if (tOTorrent == null || string2 == null) {
                return;
            }
            try {
                if (tOTorrent.isSimpleTorrent()) {
                    File file = new File(string, string2);
                    file = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, file.getCanonicalFile());
                    FileUtil.deleteWithRecycle(file, bl);
                    break block8;
                }
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && string2.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !bl && platformManager.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String string3 = string + File.separatorChar + string2 + File.separatorChar;
                        if (DiskManagerImpl.countFiles(new File(string3)) == DiskManagerImpl.countDataFiles(tOTorrent, string, string2)) {
                            platformManager.performRecoverableFileDelete(string3);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
                    }
                    catch (PlatformManagerException platformManagerException) {
                        DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(tOTorrent, string, string2, bl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private static int countFiles(File file) {
        if (file.isFile()) {
            return 1;
        }
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                n += DiskManagerImpl.countFiles(fileArray[i]);
            }
        }
        return n;
    }

    private static int countDataFiles(TOTorrent tOTorrent, String string, String string2) {
        try {
            int n = 0;
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                Object object;
                byte[][] byArray = tOTorrentFileArray[i].getPathComponents();
                String string3 = string + File.separator + string2 + File.separator;
                for (int j = 0; j < byArray.length; ++j) {
                    object = localeUtilDecoder.decodeString(byArray[j]);
                    object = FileUtil.convertOSSpecificChars((String)object, j != byArray.length - 1);
                    string3 = string3 + (j == 0 ? "" : File.separator) + (String)object;
                }
                File file = new File(string3).getCanonicalFile();
                object = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, file);
                boolean bl = false;
                if (object != file && !((File)object).getCanonicalPath().startsWith(new File(string).getCanonicalPath())) {
                    bl = true;
                }
                if (bl || !file.exists() || file.isDirectory()) continue;
                ++n;
            }
            return n;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent tOTorrent, String string, String string2, boolean bl) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        String string3 = string + File.separator + string2 + File.separator;
        boolean bl2 = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            boolean bl3;
            Object object;
            byte[][] byArray = tOTorrentFileArray[i].getPathComponents();
            String string4 = string3;
            for (int j = 0; j < byArray.length; ++j) {
                try {
                    object = localeUtilDecoder.decodeString(byArray[j]);
                    object = FileUtil.convertOSSpecificChars((String)object, j != byArray.length - 1);
                    string4 = string4 + (j == 0 ? "" : File.separator) + (String)object;
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            Object object2 = new File(string4);
            object = FMFileManagerFactory.getSingleton().getFileLink(tOTorrent, (File)object2);
            if (object == object2) {
                bl3 = true;
            } else {
                try {
                    if (bl2 || ((File)object).getCanonicalPath().startsWith(new File(string3).getCanonicalPath())) {
                        object2 = object;
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    bl3 = false;
                }
            }
            if (!bl3 || !((File)object2).exists() || ((File)object2).isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle((File)object2, bl);
                continue;
            }
            catch (Exception exception) {
                Debug.out(exception.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(string, string2));
    }

    public void skippedFileSetChanged(DiskManagerFileInfo diskManagerFileInfo) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, diskManagerFileInfo);
    }

    public void priorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
        this.listeners.dispatch(2, diskManagerFileInfo);
    }

    private void loadFilePriorities() {
        DiskManagerUtil.loadFilePriorities(this.download_manager, this.fileset);
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager downloadManager, DiskManagerFileInfo[] diskManagerFileInfoArray) {
        if (diskManagerFileInfoArray == null) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(diskManagerFileInfoArray.length);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo == null) {
                return;
            }
            boolean bl = diskManagerFileInfo.isSkipped();
            int n = diskManagerFileInfo.getPriority();
            int n2 = -1;
            if (bl) {
                n2 = 0;
            } else if (n > 0) {
                n2 = n;
            }
            arrayList.add(i, Long.valueOf(n2));
        }
        downloadManager.setData("file_priorities", arrayList);
    }

    protected static void storeFileDownloaded(DownloadManager downloadManager, DiskManagerFileInfo[] diskManagerFileInfoArray, boolean bl) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        HashMap hashMap = new HashMap();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        hashMap.put("downloaded", arrayList);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            arrayList.add(new Long(diskManagerFileInfoArray[i].getDownloaded()));
        }
        downloadManagerState.setMapAttribute("filedownloaded", hashMap);
        if (bl) {
            downloadManagerState.save();
        }
    }

    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean bl) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, bl);
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    public String getStorageType(int n) {
        return DiskManagerImpl.getStorageType(this.download_manager, n);
    }

    public static String[] getStorageTypes(DownloadManager downloadManager) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        String[] stringArray = downloadManagerState.getListAttribute("storetypes");
        if (stringArray.length == 0) {
            TOTorrentFile[] tOTorrentFileArray = downloadManager.getTorrent().getFiles();
            stringArray = new String[downloadManager.getTorrent().getFiles().length];
            if (reorder_storage_mode) {
                int n = downloadManagerState.getIntAttribute("reordermb");
                if (n < 0) {
                    n = reorder_storage_mode_min_mb;
                    downloadManagerState.setIntAttribute("reordermb", n);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = tOTorrentFileArray[i].getLength() / 0x100000L >= (long)n ? "R" : "L";
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "L";
                }
            }
            downloadManagerState.setListAttribute("storetypes", stringArray);
        }
        return stringArray;
    }

    public static String getStorageType(DownloadManager downloadManager, int n) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        String string = downloadManagerState.getListAttribute("storetypes", n);
        if (string != null) {
            return string;
        }
        return DiskManagerImpl.getStorageTypes(downloadManager)[n];
    }

    public static void setFileLinks(DownloadManager downloadManager, CaseSensitiveFileMap caseSensitiveFileMap) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(downloadManager.getTorrent(), caseSensitiveFileMap);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    public boolean isInteresting(int n) {
        return this.pieces[n].isInteresting();
    }

    public boolean isDone(int n) {
        return this.pieces[n].isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("Disk Manager");
        try {
            indentWriter.indent();
            indentWriter.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            indentWriter.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            indentWriter.println("already_moved=" + this.alreadyMoved);
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static {
        int n = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int n2 = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int n3 = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int n4 = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create("core", n, n2, n3, n4);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + n + "/" + n2 + "/" + n3 + "/" + n4));
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable reorder storage mode", "Reorder storage mode min MB"}, new ParameterListener(){

            public void parameterChanged(String string) {
                reorder_storage_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                reorder_storage_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
            }
        });
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener diskManagerListener, int n, Object object) {
                if (n == 1) {
                    int[] nArray = (int[])object;
                    diskManagerListener.stateChanged(nArray[0], nArray[1]);
                } else if (n == 2) {
                    diskManagerListener.filePriorityChanged((DiskManagerFileInfo)object);
                } else if (n == 3) {
                    diskManagerListener.pieceDoneChanged((DiskManagerPiece)object);
                } else if (n == 4) {
                    Object[] objectArray = (Object[])object;
                    diskManagerListener.fileAccessModeChanged((DiskManagerFileInfo)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2]);
                }
            }
        });
    }
}

