/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.PriorityParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ConfigurationManager
implements AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG_PARAMETER_LISTENERS = false;
    private static ConfigurationManager config_temp = null;
    private static ConfigurationManager config = null;
    private static AEMonitor class_mon = new AEMonitor("ConfigMan:class");
    private Map propertiesMap;
    private List transient_properties = new ArrayList();
    private List<COConfigurationListener> listenerz = new ArrayList<COConfigurationListener>();
    private Map<String, ParameterListener[]> parameterListenerz = new HashMap<String, ParameterListener[]>();
    private static FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            COConfigurationManager.save();
        }
    }, 30000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance() {
        block5: {
            try {
                class_mon.enter();
                if (config != null) break block5;
                if (config_temp == null) {
                    config_temp = new ConfigurationManager();
                    config_temp.load();
                    config_temp.initialise();
                    config = config_temp;
                    break block5;
                }
                if (ConfigurationManager.config_temp.propertiesMap == null) {
                    config_temp.load();
                }
                ConfigurationManager configurationManager = config_temp;
                Object var2_2 = null;
                class_mon.exit();
                return configurationManager;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        ConfigurationManager configurationManager = config;
        Object var2_3 = null;
        class_mon.exit();
        return configurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance(Map map) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(map);
            }
            ConfigurationManager configurationManager = config;
            Object var3_2 = null;
            class_mon.exit();
            return configurationManager;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    private ConfigurationManager() {
    }

    private ConfigurationManager(Map map) {
        if (map.get("Logger.DebugFiles.Enabled") == null) {
            map.put("Logger.DebugFiles.Enabled", new Long(0L));
        }
        this.propertiesMap = map;
    }

    protected void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public void load(String string) {
        Map map = FileUtil.readResilientConfigFile(string, false);
        if (this.propertiesMap == null) {
            this.propertiesMap = map;
        }
    }

    public void load() {
        this.load("azureus.config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) {
        ArrayList<COConfigurationListener> arrayList;
        if (this.propertiesMap == null) {
            return;
        }
        TreeMap treeMap = new TreeMap(this.propertiesMap);
        if (!this.transient_properties.isEmpty()) {
            treeMap.keySet().removeAll(this.transient_properties);
        }
        FileUtil.writeResilientConfigFile(string, treeMap);
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            arrayList = new ArrayList<COConfigurationListener>(this.listenerz);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            COConfigurationListener cOConfigurationListener = (COConfigurationListener)arrayList.get(i);
            if (cOConfigurationListener != null) {
                try {
                    cOConfigurationListener.configurationSaved();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                continue;
            }
            Debug.out("COConfigurationListener is null");
        }
    }

    public void save() {
        this.save("azureus.config");
    }

    public void setDirty() {
        dirty_dispatcher.dispatch();
    }

    public boolean isNewInstall() {
        return ConfigurationChecker.isNewInstall();
    }

    public Set getDefinedParameters() {
        return this.propertiesMap.keySet();
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = this.getIntParameter(string, n);
        return n2 != 0;
    }

    public boolean getBooleanParameter(String string) {
        int n;
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            n = this.getIntParameter(string, configurationDefaults.getIntParameter(string));
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            n = this.getIntParameter(string, 0);
        }
        return n != 0;
    }

    public boolean setParameter(String string, boolean bl) {
        return this.setParameter(string, bl ? 1 : 0);
    }

    private Long getLongParameterRaw(String string) {
        try {
            return (Long)this.propertiesMap.get(string);
        }
        catch (Exception exception) {
            Debug.out("Parameter '" + string + "' has incorrect type", exception);
            return null;
        }
    }

    public int getIntParameter(String string, int n) {
        Long l = this.getLongParameterRaw(string);
        return l != null ? l.intValue() : n;
    }

    public int getIntParameter(String string) {
        int n;
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            n = this.getIntParameter(string, configurationDefaults.getIntParameter(string));
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            n = this.getIntParameter(string, 0);
        }
        return n;
    }

    public long getLongParameter(String string, long l) {
        Long l2 = this.getLongParameterRaw(string);
        return l2 != null ? l2 : l;
    }

    public long getLongParameter(String string) {
        long l;
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            l = this.getLongParameter(string, configurationDefaults.getLongParameter(string));
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            l = this.getLongParameter(string, 0L);
        }
        return l;
    }

    private byte[] getByteParameterRaw(String string) {
        return (byte[])this.propertiesMap.get(string);
    }

    public byte[] getByteParameter(String string) {
        byte[] byArray;
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            byArray = this.getByteParameter(string, configurationDefaults.getByteParameter(string));
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            byArray = this.getByteParameter(string, ConfigurationDefaults.def_bytes);
        }
        return byArray;
    }

    public byte[] getByteParameter(String string, byte[] byArray) {
        byte[] byArray2 = this.getByteParameterRaw(string);
        return byArray2 != null ? byArray2 : byArray;
    }

    private String getStringParameter(String string, byte[] byArray) {
        byte[] byArray2 = this.getByteParameter(string, byArray);
        if (byArray2 == null) {
            byArray2 = this.getByteParameter(string, null);
        }
        if (byArray2 == null) {
            return null;
        }
        return ConfigurationManager.bytesToString(byArray2);
    }

    public String getStringParameter(String string, String string2) {
        String string3 = this.getStringParameter(string, (byte[])null);
        return string3 != null ? string3 : string2;
    }

    public String getStringParameter(String string) {
        String string2;
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            string2 = this.getStringParameter(string, configurationDefaults.getStringParameter(string));
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            string2 = this.getStringParameter(string, "");
        }
        return string2;
    }

    public StringList getStringListParameter(String string) {
        try {
            List list = (List)this.propertiesMap.get(string);
            if (list == null) {
                return new StringListImpl();
            }
            return new StringListImpl(list);
        }
        catch (Exception exception) {
            Debug.out("Parameter '" + string + "' has incorrect type", exception);
            return new StringListImpl();
        }
    }

    public boolean setParameter(String string, StringList stringList) {
        try {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            List list = ((StringListImpl)stringList).getList();
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(ConfigurationManager.stringToBytes((String)list.get(i)));
            }
            this.propertiesMap.put(string, arrayList);
            this.notifyParameterListeners(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return false;
        }
        return true;
    }

    public List getListParameter(String string, List list) {
        try {
            List list2 = (List)this.propertiesMap.get(string);
            if (list2 == null) {
                return list;
            }
            return list2;
        }
        catch (Exception exception) {
            Debug.out("Parameter '" + string + "' has incorrect type", exception);
            return list;
        }
    }

    public boolean setParameter(String string, List list) {
        try {
            this.propertiesMap.put(string, list);
            this.notifyParameterListeners(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return false;
        }
        return true;
    }

    public Map getMapParameter(String string, Map map) {
        try {
            Map map2 = (Map)this.propertiesMap.get(string);
            if (map2 == null) {
                return map;
            }
            return map2;
        }
        catch (Exception exception) {
            Debug.out("Parameter '" + string + "' has incorrect type", exception);
            return map;
        }
    }

    public boolean setParameter(String string, Map map) {
        try {
            this.propertiesMap.put(string, map);
            this.notifyParameterListeners(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String string) throws IOException {
        String string2 = this.getStringParameter(string);
        if (string2.length() > 0) {
            File file = new File(string2);
            if (!file.exists()) {
                FileUtil.mkdirs(file);
            }
            if (!file.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + string2);
            }
        }
        return string2;
    }

    public float getFloatParameter(String string) {
        return this.getFloatParameter(string, 0.0f);
    }

    public float getFloatParameter(String string, float f) {
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            Object v = this.propertiesMap.get(string);
            if (v instanceof Number) {
                return ((Number)v).floatValue();
            }
            String string2 = this.getStringParameter(string);
            if (!string2.equals("")) {
                return Float.parseFloat(string2);
            }
        }
        catch (Exception exception) {
            Debug.out("Parameter '" + string + "' has incorrect type", exception);
        }
        try {
            return configurationDefaults.getFloatParameter(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public boolean setParameter(String string, float f) {
        String string2 = String.valueOf(f);
        return this.setParameter(string, ConfigurationManager.stringToBytes(string2));
    }

    public boolean setParameter(String string, int n) {
        Long l = new Long(n);
        try {
            Long l2 = this.propertiesMap.put(string, l);
            return this.notifyParameterListenersIfChanged(string, l, l2);
        }
        catch (ClassCastException classCastException) {
            this.notifyParameterListeners(string);
            return true;
        }
    }

    public boolean setParameter(String string, long l) {
        Long l2 = new Long(l);
        try {
            Long l3 = this.propertiesMap.put(string, l2);
            return this.notifyParameterListenersIfChanged(string, l2, l3);
        }
        catch (ClassCastException classCastException) {
            this.notifyParameterListeners(string);
            return true;
        }
    }

    public boolean setParameter(String string, byte[] byArray) {
        try {
            byte[] byArray2 = this.propertiesMap.put(string, byArray);
            return this.notifyParameterListenersIfChanged(string, byArray, byArray2);
        }
        catch (ClassCastException classCastException) {
            this.notifyParameterListeners(string);
            return true;
        }
    }

    public boolean setParameter(String string, String string2) {
        return this.setParameter(string, ConfigurationManager.stringToBytes(string2));
    }

    public boolean hasParameter(String string, boolean bl) {
        if (this.propertiesMap.containsKey(string)) {
            return true;
        }
        return !bl && ConfigurationDefaults.getInstance().hasParameter(string);
    }

    public boolean verifyParameter(String string, String string2) {
        List list = ConfigurationDefaults.getInstance().getVerifiers(string);
        if (list != null) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    COConfigurationManager.ParameterVerifier parameterVerifier = (COConfigurationManager.ParameterVerifier)list.get(i);
                    if (parameterVerifier == null) continue;
                    try {
                        if (parameterVerifier.verify(string, string2)) continue;
                        return false;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return true;
    }

    public boolean setRGBParameter(String string, int n, int n2, int n3) {
        boolean bl = false;
        bl |= this.setParameter(string + ".red", n);
        bl |= this.setParameter(string + ".green", n2);
        if (bl |= this.setParameter(string + ".blue", n3)) {
            this.notifyParameterListeners(string);
        }
        return bl;
    }

    public boolean setRGBParameter(String string, int[] nArray, boolean bl) {
        boolean bl2 = false;
        if (nArray == null) {
            bl2 |= this.removeParameter(string + ".override");
            bl2 |= this.removeParameter(string + ".red");
            bl2 |= this.removeParameter(string + ".green");
            bl2 |= this.removeParameter(string + ".blue");
        } else {
            bl2 |= this.setParameter(string + ".override", bl);
            bl2 |= this.setRGBParameter(string, nArray[0], nArray[1], nArray[2]);
        }
        if (bl2) {
            this.notifyParameterListeners(string);
        }
        return bl2;
    }

    public boolean setParameter(String string) throws ConfigurationParameterNotFoundException {
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        try {
            return this.setParameter(string, configurationDefaults.getIntParameter(string));
        }
        catch (Exception exception) {
            return this.setParameter(string, configurationDefaults.getStringParameter(string));
        }
    }

    public Object getParameter(String string) {
        Object object = this.propertiesMap.get(string);
        if (object == null) {
            object = ConfigurationDefaults.getInstance().getParameter(string);
        }
        return object;
    }

    public void setParameterRawNoNotify(String string, Object object) {
        this.propertiesMap.put(string, object);
    }

    public void registerTransientParameter(String string) {
        this.transient_properties.add(string);
    }

    public boolean removeParameter(String string) {
        boolean bl;
        boolean bl2 = bl = this.propertiesMap.remove(string) != null;
        if (bl) {
            this.notifyParameterListeners(string);
        }
        return bl;
    }

    public boolean removeRGBParameter(String string) {
        boolean bl = false;
        bl |= this.removeParameter(string + ".red");
        bl |= this.removeParameter(string + ".green");
        bl |= this.removeParameter(string + ".blue");
        if (bl |= this.removeParameter(string + ".override")) {
            this.notifyParameterListeners(string);
        }
        return bl;
    }

    public boolean doesParameterNonDefaultExist(String string) {
        return this.propertiesMap.containsKey(string);
    }

    private boolean notifyParameterListenersIfChanged(String string, Long l, Long l2) {
        if (l2 == null || 0 != l.compareTo(l2)) {
            this.notifyParameterListeners(string);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String string, byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || !Arrays.equals(byArray, byArray2)) {
            this.notifyParameterListeners(string);
            return true;
        }
        return false;
    }

    public void resetToDefaults() {
        ConfigurationDefaults configurationDefaults = ConfigurationDefaults.getInstance();
        ArrayList arrayList = new ArrayList(configurationDefaults.getAllowedParameters());
        for (String string : arrayList) {
            if (this.propertiesMap.remove(string) == null) continue;
            this.notifyParameterListeners(string);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyParameterListeners(String string) {
        ParameterListener[] parameterListenerArray = this.parameterListenerz;
        synchronized (this.parameterListenerz) {
            ParameterListener[] parameterListenerArray2 = this.parameterListenerz.get(string);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (parameterListenerArray2 == null) {
                return;
            }
            for (ParameterListener parameterListener : parameterListenerArray2) {
                if (parameterListener == null) continue;
                try {
                    parameterListener.parameterChanged(string);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(String string, ParameterListener parameterListener) {
        if (string == null || parameterListener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] parameterListenerArray = this.parameterListenerz.get(string);
            if (parameterListenerArray == null) {
                this.parameterListenerz.put(string, new ParameterListener[]{parameterListener});
            } else {
                int n;
                ParameterListener[] parameterListenerArray2 = new ParameterListener[parameterListenerArray.length + 1];
                if (parameterListener instanceof PriorityParameterListener) {
                    parameterListenerArray2[0] = parameterListener;
                    n = 1;
                } else {
                    parameterListenerArray2[parameterListenerArray.length] = parameterListener;
                    n = 0;
                }
                for (int i = 0; i < parameterListenerArray.length; ++i) {
                    ParameterListener parameterListener2 = parameterListenerArray[i];
                    if (parameterListener2 == parameterListener) {
                        return;
                    }
                    parameterListenerArray2[n++] = parameterListener2;
                }
                this.parameterListenerz.put(string, parameterListenerArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(String string, ParameterListener parameterListener) {
        if (string == null || parameterListener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] parameterListenerArray = this.parameterListenerz.get(string);
            if (parameterListenerArray == null) {
                return;
            }
            if (parameterListenerArray.length == 1) {
                if (parameterListenerArray[0] == parameterListener) {
                    this.parameterListenerz.remove(string);
                }
            } else {
                ParameterListener[] parameterListenerArray2 = new ParameterListener[parameterListenerArray.length - 1];
                int n = 0;
                for (int i = 0; i < parameterListenerArray.length; ++i) {
                    ParameterListener parameterListener2 = parameterListenerArray[i];
                    if (parameterListener2 == parameterListener) continue;
                    if (n == parameterListenerArray2.length) {
                        return;
                    }
                    parameterListenerArray2[n++] = parameterListener2;
                }
                this.parameterListenerz.put(string, parameterListenerArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(COConfigurationListener cOConfigurationListener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.add(cOConfigurationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(COConfigurationListener cOConfigurationListener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.remove(cOConfigurationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Configuration Details");
        try {
            byte[] byArray;
            Object object;
            indentWriter.indent();
            indentWriter.println("version=4.5.0.4, subver=");
            indentWriter.println("System Properties");
            try {
                indentWriter.indent();
                object = System.getProperties();
                for (String string : new TreeSet<Object>(((Properties)object).keySet())) {
                    indentWriter.println(string + "=" + ((Properties)object).get(string));
                }
                byArray = null;
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                indentWriter.exdent();
                throw throwable;
            }
            indentWriter.println("Environment");
            try {
                indentWriter.indent();
                object = System.getenv();
                if (object == null) {
                    indentWriter.println("Not supported");
                } else {
                    for (String string : new TreeSet<Object>(object.keySet())) {
                        indentWriter.println(string + "=" + (String)object.get(string));
                    }
                }
                Object var8_13 = null;
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                indentWriter.exdent();
                throw throwable;
            }
            indentWriter.println("Azureus Config");
            try {
                indentWriter.indent();
                for (Object object2 : new TreeSet(this.propertiesMap.keySet())) {
                    if (((String)object2).startsWith("core.crypto.")) continue;
                    Object v = this.propertiesMap.get(object2);
                    boolean bl = ConfigurationDefaults.getInstance().doesParameterDefaultExist(((String)object2).toString());
                    if (!bl) {
                        object2 = "[NoDef] " + (String)object2;
                    }
                    if (v instanceof Long) {
                        indentWriter.println((String)object2 + "=" + v);
                        continue;
                    }
                    if (v instanceof List) {
                        indentWriter.println((String)object2 + "=" + BDecoder.decodeStrings((List)BEncoder.clone(v)) + "[list]");
                        continue;
                    }
                    if (v instanceof Map) {
                        indentWriter.println((String)object2 + "=" + BDecoder.decodeStrings((Map)BEncoder.clone(v)) + "[map]");
                        continue;
                    }
                    if (v instanceof byte[]) {
                        byArray = (byte[])v;
                        boolean bl2 = false;
                        for (int i = 0; i < byArray.length; ++i) {
                            char c = (char)byArray[i];
                            if (Character.isLetterOrDigit(c) || "`\u00ef\u00bf\u00bd\"\u00ef\u00bf\u00bd$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) != -1) continue;
                            bl2 = true;
                            break;
                        }
                        indentWriter.println((String)object2 + "=" + (bl2 ? ByteFormatter.nicePrint(byArray) : ConfigurationManager.bytesToString((byte[])v)));
                        continue;
                    }
                    indentWriter.println((String)object2 + "=" + v + "[unknown]");
                }
                Object var11_19 = null;
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                indentWriter.exdent();
                throw throwable;
            }
            Object var13_22 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    protected static String bytesToString(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (Throwable throwable) {
            return new String(byArray);
        }
    }

    protected static byte[] stringToBytes(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Throwable throwable) {
            return string.getBytes();
        }
    }
}

