/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import com.aelitis.net.udp.uc.PRUDPRequestHandler;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class PRUDPPacketHandlerSocks
implements PRUDPPacketHandler,
PRUDPPacketHandlerImpl.PacketTransformer {
    private static String socks_host;
    private static int socks_port;
    private static String socks_user;
    private static String socks_password;
    private final InetSocketAddress target;
    private Socket control_socket;
    private InetSocketAddress relay;
    private PRUDPPacketHandler delegate;
    private byte[] packet_out_header;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PRUDPPacketHandlerSocks(InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        this.target = inetSocketAddress;
        boolean bl = false;
        try {
            block24: {
                try {
                    Object object;
                    InetAddress inetAddress;
                    this.delegate = new PRUDPPacketHandlerImpl(0, null, this);
                    this.control_socket = new Socket(Proxy.NO_PROXY);
                    this.control_socket.connect(new InetSocketAddress(socks_host, socks_port));
                    DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.control_socket.getOutputStream(), 256));
                    DataInputStream dataInputStream = new DataInputStream(this.control_socket.getInputStream());
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeByte(2);
                    dataOutputStream.writeByte(0);
                    dataOutputStream.writeByte(2);
                    dataOutputStream.flush();
                    dataInputStream.readByte();
                    byte by = dataInputStream.readByte();
                    if (by != 0 && by != 2) {
                        throw new IOException("SOCKS 5: no valid method [" + by + "]");
                    }
                    if (by == 2) {
                        dataOutputStream.writeByte(1);
                        dataOutputStream.writeByte((byte)socks_user.length());
                        dataOutputStream.write(socks_user.getBytes());
                        dataOutputStream.writeByte((byte)socks_password.length());
                        dataOutputStream.write(socks_password.getBytes());
                        dataOutputStream.flush();
                        dataInputStream.readByte();
                        byte by2 = dataInputStream.readByte();
                        if (by2 != 0) {
                            throw new IOException("SOCKS 5: authentication fails [status=" + by2 + "]");
                        }
                    }
                    String string = this.target.isUnresolved() || this.target.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.target.getHostName()) : this.target.getAddress().getHostName();
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeByte(0);
                    dataOutputStream.writeByte(1);
                    dataOutputStream.write(new byte[4]);
                    dataOutputStream.writeShort((short)this.delegate.getPort());
                    dataOutputStream.flush();
                    dataInputStream.readByte();
                    byte by3 = dataInputStream.readByte();
                    if (by3 != 0) {
                        throw new IOException("SOCKS 5: udp association fails [reply=" + by3 + "]");
                    }
                    dataInputStream.readByte();
                    byte by4 = dataInputStream.readByte();
                    if (by4 == 1) {
                        byte[] byArray = new byte[4];
                        dataInputStream.readFully(byArray);
                        inetAddress = InetAddress.getByAddress(byArray);
                    } else if (by4 == 3) {
                        byte by5 = dataInputStream.readByte();
                        object = new byte[by5 & 0xFF];
                        dataInputStream.readFully((byte[])object);
                        inetAddress = InetAddress.getByName(new String((byte[])object));
                    } else {
                        byte[] byArray = new byte[16];
                        dataInputStream.readFully(byArray);
                        inetAddress = InetAddress.getByAddress(byArray);
                    }
                    int n = dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    if (inetAddress.isAnyLocalAddress()) {
                        inetAddress = this.control_socket.getInetAddress();
                    }
                    this.relay = new InetSocketAddress(inetAddress, n);
                    object = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream2 = new DataOutputStream((OutputStream)object);
                    dataOutputStream2.writeByte(0);
                    dataOutputStream2.writeByte(0);
                    dataOutputStream2.writeByte(0);
                    try {
                        byte[] byArray = HostNameToIPResolver.syncResolve(string).getAddress();
                        dataOutputStream2.writeByte(byArray.length == 4 ? 1 : 4);
                        dataOutputStream2.write(byArray);
                    }
                    catch (Throwable throwable) {
                        dataOutputStream2.writeByte(3);
                        dataOutputStream2.writeByte((byte)string.length());
                        dataOutputStream2.write(string.getBytes());
                    }
                    dataOutputStream2.writeShort((short)this.target.getPort());
                    dataOutputStream2.flush();
                    this.packet_out_header = ((ByteArrayOutputStream)object).toByteArray();
                    bl = true;
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    throw new PRUDPPacketHandlerException("socks setup failed: " + Debug.getNestedExceptionMessage(throwable), throwable);
                }
                Object var15_20 = null;
                if (bl) return;
                try {
                    try {
                        this.control_socket.close();
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                        Object var18_23 = null;
                        this.control_socket = null;
                        break block24;
                    }
                    Object var18_22 = null;
                    this.control_socket = null;
                }
                catch (Throwable throwable) {
                    Object var18_24 = null;
                    this.control_socket = null;
                    throw throwable;
                }
            }
            if (this.delegate == null) return;
            try {
                this.delegate.destroy();
                Object var20_32 = null;
                this.delegate = null;
                return;
            }
            catch (Throwable throwable) {
                Object var20_33 = null;
                this.delegate = null;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            block25: {
                Object var15_21 = null;
                if (bl) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var18_27 = null;
                    this.control_socket = null;
                    throw throwable2;
                }
                try {}
                catch (Throwable throwable3) {
                    Debug.out(throwable3);
                    Object var18_26 = null;
                    this.control_socket = null;
                    break block25;
                }
                this.control_socket.close();
                Object var18_25 = null;
                this.control_socket = null;
            }
            if (this.delegate == null) throw throwable;
            try {}
            catch (Throwable throwable4) {
                Object var20_35 = null;
                this.delegate = null;
                throw throwable4;
            }
            this.delegate.destroy();
            Object var20_34 = null;
            this.delegate = null;
            throw throwable;
        }
    }

    public void transformSend(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        byte[] byArray2 = new byte[n + this.packet_out_header.length];
        System.arraycopy(this.packet_out_header, 0, byArray2, 0, this.packet_out_header.length);
        System.arraycopy(byArray, 0, byArray2, this.packet_out_header.length, n);
        datagramPacket.setData(byArray2);
    }

    public void transformReceive(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, n));
        try {
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            int n2 = 4;
            n2 = by == 1 ? (n2 += 4) : (by == 3 ? (n2 += 1 + (dataInputStream.readByte() & 0xFF)) : (n2 += 16));
            byte[] byArray2 = new byte[n - (n2 += 2)];
            System.arraycopy(byArray, n2, byArray2, 0, n - n2);
            datagramPacket.setData(byArray2);
        }
        catch (IOException iOException) {
            Debug.out(iOException);
        }
    }

    private void checkAddress(InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        if (!inetSocketAddress.equals(this.target)) {
            throw new PRUDPPacketHandlerException("Destination mismatch");
        }
    }

    public void sendAndReceive(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, PRUDPPacketReceiver pRUDPPacketReceiver, long l, int n) throws PRUDPPacketHandlerException {
        this.checkAddress(inetSocketAddress);
        this.delegate.sendAndReceive(pRUDPPacket, this.relay, pRUDPPacketReceiver, l, n);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        this.checkAddress(inetSocketAddress);
        return this.delegate.sendAndReceive(passwordAuthentication, pRUDPPacket, this.relay);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, long l) throws PRUDPPacketHandlerException {
        this.checkAddress(inetSocketAddress);
        return this.delegate.sendAndReceive(passwordAuthentication, pRUDPPacket, this.relay, l);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, long l, int n) throws PRUDPPacketHandlerException {
        this.checkAddress(inetSocketAddress);
        return this.delegate.sendAndReceive(passwordAuthentication, pRUDPPacket, this.relay, l, n);
    }

    public void send(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        this.checkAddress(inetSocketAddress);
        this.delegate.send(pRUDPPacket, this.relay);
    }

    public PRUDPRequestHandler getRequestHandler() {
        return this.delegate.getRequestHandler();
    }

    public void setRequestHandler(PRUDPRequestHandler pRUDPRequestHandler) {
        this.delegate.setRequestHandler(pRUDPRequestHandler);
    }

    public void primordialSend(byte[] byArray, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not imp");
    }

    public void addPrimordialHandler(PRUDPPrimordialHandler pRUDPPrimordialHandler) {
    }

    public void removePrimordialHandler(PRUDPPrimordialHandler pRUDPPrimordialHandler) {
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public void setDelays(int n, int n2, int n3) {
        this.delegate.setDelays(n, n2, n3);
    }

    public void setExplicitBindAddress(InetAddress inetAddress) {
        this.delegate.setExplicitBindAddress(inetAddress);
    }

    public PRUDPPacketHandlerStats getStats() {
        return this.delegate.getStats();
    }

    public PRUDPPacketHandler openSession(InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not supported");
    }

    public void closeSession() throws PRUDPPacketHandlerException {
        if (this.control_socket != null) {
            try {
                this.control_socket.close();
                this.control_socket = null;
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public void destroy() {
        try {
            this.closeSession();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Host", "Proxy.Port", "Proxy.Username", "Proxy.Password"}, new ParameterListener(){

            public void parameterChanged(String string) {
                socks_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                socks_password = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    socks_user = "";
                }
            }
        });
    }
}

