/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerRequest;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.SystemTime;

public class PRUDPPacketHandlerRequestImpl
implements PRUDPPacketHandlerRequest {
    private AESemaphore sem = new AESemaphore("PRUDPPacketHandlerRequest");
    private long timeout;
    private PRUDPPacketReceiver receiver;
    private PRUDPPacketHandlerException exception;
    private PRUDPPacket reply;
    private long send_time;
    private long reply_time;

    protected PRUDPPacketHandlerRequestImpl(PRUDPPacketReceiver pRUDPPacketReceiver, long l) {
        this.receiver = pRUDPPacketReceiver;
        this.timeout = l;
    }

    protected void sent() {
        this.send_time = SystemTime.getCurrentTime();
    }

    protected long getSendTime() {
        return this.send_time;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public long getElapsedTime() {
        if (this.send_time == 0L || this.reply_time == 0L) {
            return -1L;
        }
        long l = this.reply_time - this.send_time;
        if (l < 0L) {
            l = 0L;
        }
        if (l == 0L) {
            l = 12L;
        }
        return l;
    }

    protected void setReply(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, long l) {
        if (this.reply == null) {
            this.reply_time = l;
            this.reply = pRUDPPacket;
        } else {
            pRUDPPacket.setPreviousPacket(this.reply);
            this.reply = pRUDPPacket;
        }
        if (!pRUDPPacket.hasContinuation()) {
            this.sem.release();
        }
        if (this.receiver != null) {
            this.receiver.packetReceived(this, pRUDPPacket, inetSocketAddress);
        }
    }

    protected void setException(PRUDPPacketHandlerException pRUDPPacketHandlerException) {
        if (this.reply == null) {
            this.reply_time = SystemTime.getCurrentTime();
            this.exception = pRUDPPacketHandlerException;
        }
        this.sem.release();
        if (this.receiver != null) {
            this.receiver.error(pRUDPPacketHandlerException);
        }
    }

    protected PRUDPPacket getReply() throws PRUDPPacketHandlerException {
        this.sem.reserve();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.reply;
    }
}

