/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatPMPImpl {
    private NatPMPDevice natDevice;
    private List mappings = new ArrayList();

    public NatPMPImpl(NatPMPDevice natPMPDevice) throws UPnPException {
        try {
            this.natDevice = natPMPDevice;
        }
        catch (Exception exception) {
            throw new UPnPException("Error in getting NatPMP Service!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortMapping(boolean bl, int n, String string) throws UPnPException {
        try {
            this.natDevice.addPortMapping(bl, n, n);
        }
        catch (Exception exception) {
            throw new UPnPException("addPortMapping failed", exception);
        }
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            Iterator iterator = this.mappings.iterator();
            while (iterator.hasNext()) {
                portMapping portMapping2 = (portMapping)iterator.next();
                if (portMapping2.getExternalPort() != n || portMapping2.isTCP() != bl) continue;
                iterator.remove();
            }
            this.mappings.add(new portMapping(n, bl, this.natDevice.getLocalAddress().getHostAddress(), string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortMapping(boolean bl, int n) throws UPnPException {
        try {
            this.natDevice.deletePortMapping(bl, n, n);
        }
        catch (Exception exception) {
            throw new UPnPException("deletePortMapping failed", exception);
        }
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            Iterator iterator = this.mappings.iterator();
            while (iterator.hasNext()) {
                portMapping portMapping2 = (portMapping)iterator.next();
                if (portMapping2.getExternalPort() != n || portMapping2.isTCP() != bl) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPWANConnectionPortMapping[] getPortMappings() throws UPnPException {
        NatPMPImpl natPMPImpl = this;
        synchronized (natPMPImpl) {
            UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray = new UPnPWANConnectionPortMapping[this.mappings.size()];
            this.mappings.toArray(uPnPWANConnectionPortMappingArray);
            return uPnPWANConnectionPortMappingArray;
        }
    }

    public String[] getStatusInfo() throws UPnPException {
        Object var1_1 = null;
        Object var2_2 = null;
        String string = null;
        string = "" + this.natDevice.getEpoch();
        return new String[]{var1_1, var2_2, string};
    }

    public String getExternalIPAddress() {
        return this.natDevice.getExternalIPAddress();
    }

    protected class portMapping
    implements UPnPWANConnectionPortMapping {
        protected int external_port;
        protected boolean tcp;
        protected String internal_host;
        protected String description;

        protected portMapping(int n, boolean bl, String string, String string2) {
            this.external_port = n;
            this.tcp = bl;
            this.internal_host = string;
            this.description = string2;
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getExternalPort() {
            return this.external_port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        public String getDescription() {
            return this.description;
        }

        protected String getString() {
            return this.getDescription() + " [" + this.getExternalPort() + ":" + (this.isTCP() ? "TCP" : "UDP") + "]";
        }
    }
}

