/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class PlayUtils {
    public static final boolean COMPLETE_PLAY_ONLY = true;
    public static final int fileSizeThreshold = 90;
    public static final String playableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac";
    private static boolean triedLoadingEmpPluginClass = false;
    private static Method methodIsExternallyPlayable;
    private static Method methodIsExternallyPlayable2;
    private static PluginInterface piEmp;

    public static boolean prepareForPlay(DownloadManager downloadManager) {
        EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(downloadManager);
        if (enhancedDownloadManager != null) {
            enhancedDownloadManager.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return false;
        }
        try {
            DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.getSingleton();
            EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(tOTorrent.getHash());
            if (enhancedDownloadManager == null) {
                return downloadManagerEnhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(tOTorrent);
            }
            boolean bl = enhancedDownloadManager.getDownloadManager().isDownloadComplete(false);
            if (bl) {
                return true;
            }
            if (!enhancedDownloadManager.supportsProgressiveMode()) {
                return false;
            }
        }
        catch (TOTorrentException tOTorrentException) {
            return false;
        }
        return true;
    }

    public static boolean canUseEMP(TOTorrent tOTorrent, int n) {
        return PlayUtils.canUseEMP(tOTorrent, n, true);
    }

    public static boolean canUseEMP(TOTorrent tOTorrent, int n, boolean bl) {
        if (tOTorrent == null) {
            return false;
        }
        if (PlayUtils.canPlayViaExternalEMP(tOTorrent, n, bl)) {
            return true;
        }
        if (!PlatformTorrentUtils.useEMP(tOTorrent) || !PlatformTorrentUtils.embeddedPlayerAvail()) {
            return false;
        }
        return PlayUtils.canProgressiveOrIsComplete(tOTorrent);
    }

    private static boolean canPlay(DownloadManager downloadManager, int n) {
        if (downloadManager == null) {
            return false;
        }
        TOTorrent tOTorrent = downloadManager.getTorrent();
        return PlayUtils.canUseEMP(tOTorrent, n);
    }

    private static boolean canPlay(TOTorrent tOTorrent, int n) {
        if (!PlatformTorrentUtils.isContent(tOTorrent, false)) {
            return false;
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager downloadManager = globalManager.getDownloadManager(tOTorrent);
        if (downloadManager != null) {
            return downloadManager.getAssumedComplete() || PlayUtils.canUseEMP(tOTorrent, n);
        }
        return PlayUtils.canUseEMP(tOTorrent, n);
    }

    public static boolean canPlayDS(Object object, int n) {
        if (object == null) {
            return false;
        }
        if (object instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo diskManagerFileInfo = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)object;
            return PlayUtils.canPlayDS(diskManagerFileInfo.getDownloadManager(), diskManagerFileInfo.getIndex());
        }
        DownloadManager downloadManager = DataSourceUtils.getDM(object);
        if (downloadManager != null) {
            return PlayUtils.canPlay(downloadManager, n);
        }
        TOTorrent tOTorrent = DataSourceUtils.getTorrent(object);
        if (tOTorrent != null) {
            return PlayUtils.canPlay(tOTorrent, n);
        }
        if (object instanceof VuzeActivitiesEntry) {
            return ((VuzeActivitiesEntry)object).isPlayable();
        }
        if (object instanceof SelectedContentV3) {
            SelectedContentV3 selectedContentV3 = (SelectedContentV3)object;
            return selectedContentV3.canPlay();
        }
        return false;
    }

    private static boolean canStream(DownloadManager downloadManager, int n) {
        org.gudy.azureus2.core3.disk.DiskManagerFileInfo diskManagerFileInfo;
        Object object;
        if (downloadManager == null) {
            return false;
        }
        if (n == -1) {
            object = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(downloadManager);
            if (object == null) {
                return false;
            }
            diskManagerFileInfo = ((EnhancedDownloadManager)object).getPrimaryFile();
        } else {
            diskManagerFileInfo = downloadManager.getDiskManagerFileInfoSet().getFiles()[n];
        }
        if (diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength()) {
            return false;
        }
        object = downloadManager.getTorrent();
        return PlayUtils.canUseEMP((TOTorrent)object, n, false);
    }

    public static boolean canStreamDS(Object object, int n) {
        if (object == null) {
            return false;
        }
        DownloadManager downloadManager = DataSourceUtils.getDM(object);
        if (downloadManager != null) {
            return PlayUtils.canStream(downloadManager, n);
        }
        return false;
    }

    public static String getContentUrl(DownloadManager downloadManager) {
        String string;
        if (downloadManager.isDownloadComplete(false)) {
            EnhancedDownloadManager enhancedDownloadManager = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(downloadManager);
            File file = enhancedDownloadManager != null ? enhancedDownloadManager.getPrimaryFile().getFile(true) : new File(downloadManager.getDownloadState().getPrimaryFile());
            try {
                string = file.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                string = file.getAbsolutePath();
            }
        } else {
            string = PlayUtils.getMediaServerContentURL(downloadManager);
        }
        return string;
    }

    public static String getMediaServerContentURL(DownloadManager downloadManager) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(downloadManager));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static String getMediaServerContentURL(Download download) {
        PluginManager pluginManager = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pluginInterface = pluginManager.getPluginInterfaceByID("azupnpav", false);
        if (pluginInterface == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pluginInterface.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Object object = pluginInterface.getIPC().invoke("getContentURL", new Object[]{download});
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", throwable));
        }
        return null;
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo diskManagerFileInfo) {
        PluginManager pluginManager = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pluginInterface = pluginManager.getPluginInterfaceByID("azupnpav", false);
        if (pluginInterface == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pluginInterface.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Object object = pluginInterface.getIPC().invoke("getContentURL", new Object[]{diskManagerFileInfo});
            if (object instanceof String) {
                return new URL((String)object);
            }
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", throwable));
        }
        return null;
    }

    private static final synchronized boolean loadEmpPluginClass() {
        if (piEmp != null && piEmp.getPluginState().isUnloaded()) {
            piEmp = null;
            triedLoadingEmpPluginClass = false;
            methodIsExternallyPlayable = null;
            methodIsExternallyPlayable2 = null;
        }
        if (!triedLoadingEmpPluginClass) {
            triedLoadingEmpPluginClass = true;
            try {
                piEmp = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (piEmp == null) {
                    return false;
                }
                Class<?> clazz = piEmp.getPlugin().getClass();
                methodIsExternallyPlayable = clazz.getMethod("isExternallyPlayable", TOTorrent.class);
                try {
                    methodIsExternallyPlayable2 = clazz.getMethod("isExternallyPlayable", TOTorrent.class, Integer.TYPE);
                }
                catch (Throwable throwable) {
                    Logger.log(new LogEvent(LogIDs.UI3, "isExternallyPlayable with file_index not found"));
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static File getPrimaryFile(Download download) {
        DiskManagerFileInfo diskManagerFileInfo = PlayUtils.getPrimaryFileInfo(download);
        if (diskManagerFileInfo == null) {
            return null;
        }
        return diskManagerFileInfo.getFile(true);
    }

    public static int getPrimaryFileIndex(DownloadManager downloadManager) {
        return PlayUtils.getPrimaryFileIndex(PluginCoreUtils.wrap(downloadManager));
    }

    public static int getPrimaryFileIndex(Download download) {
        DiskManagerFileInfo diskManagerFileInfo = PlayUtils.getPrimaryFileInfo(download);
        if (diskManagerFileInfo == null) {
            return -1;
        }
        return diskManagerFileInfo.getIndex();
    }

    public static DiskManagerFileInfo getPrimaryFileInfo(Download download) {
        long l = download.getTorrent().getSize();
        DiskManagerFileInfo[] diskManagerFileInfoArray = download.getDiskManagerFileInfo();
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo.isSkipped() || diskManagerFileInfo.isDeleted() || diskManagerFileInfo.getLength() <= 90L * l / 100L) continue;
            return diskManagerFileInfo;
        }
        return null;
    }

    public static boolean isExternallyPlayable(Download download, int n, boolean bl) {
        Object object;
        int n2 = -1;
        if (n == -1) {
            object = PlayUtils.getPrimaryFileInfo(download);
            if (object == null) {
                return false;
            }
            if (object.getDownloaded() != object.getLength() && (bl || PlayUtils.getMediaServerContentURL((DiskManagerFileInfo)object) == null)) {
                return false;
            }
            n2 = PlayUtils.getPrimaryFileIndex(download);
        } else {
            object = download.getDiskManagerFileInfo(n);
            if (object.getDownloaded() != object.getLength() && (bl || PlayUtils.getMediaServerContentURL((DiskManagerFileInfo)object) == null)) {
                return false;
            }
            n2 = n;
        }
        if (n2 == -1) {
            return false;
        }
        object = download.getTorrent().getFiles()[n2].getName();
        int n3 = ((String)object).lastIndexOf(".");
        if (n3 > -1) {
            String string = ((String)object).substring(n3);
            if (string == null) {
                return false;
            }
            if (playableFileExtensions.indexOf(string = string.toLowerCase()) > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExternallyPlayable(TOTorrent tOTorrent, int n, boolean bl) {
        if (tOTorrent == null) {
            return false;
        }
        try {
            Download download = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(tOTorrent.getHash());
            if (download != null) {
                return PlayUtils.isExternallyPlayable(download, n, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent tOTorrent, int n, boolean bl) {
        block8: {
            if (tOTorrent == null) {
                return false;
            }
            if (!PlayUtils.loadEmpPluginClass() || methodIsExternallyPlayable == null) {
                return PlayUtils.isExternallyPlayable(tOTorrent, n, bl);
            }
            try {
                Object object;
                if (n != -1 && methodIsExternallyPlayable2 != null) {
                    try {
                        object = methodIsExternallyPlayable2.invoke(null, tOTorrent, n);
                    }
                    catch (Throwable throwable) {
                        Logger.log(new LogEvent(LogIDs.UI3, "isExternallyPlayable with file_index failed", throwable));
                    }
                }
                if ((object = methodIsExternallyPlayable.invoke(null, tOTorrent)) instanceof Boolean) {
                    return (Boolean)object;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (throwable.getMessage() != null && throwable.getMessage().toLowerCase().endsWith("only")) break block8;
                Debug.out(throwable);
            }
        }
        return false;
    }
}

