/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class NavigationHelper {
    public static final int COMMAND_SWITCH_TO_TAB = 1;
    public static final int COMMAND_CONDITION_CHECK = 2;
    private static CopyOnWriteList listeners = new CopyOnWriteList();
    private static List command_queue;

    protected static void initialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] vuzeFileArray, int n) {
                for (int i = 0; i < vuzeFileArray.length; ++i) {
                    VuzeFile vuzeFile = vuzeFileArray[i];
                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                        if (vuzeFileComponent.getType() != 2 && vuzeFileComponent.getType() != 4) continue;
                        try {
                            List list = (List)vuzeFileComponent.getContent().get("commands");
                            for (int k = 0; k < list.size(); ++k) {
                                String[] stringArray;
                                Map map = (Map)list.get(k);
                                int n2 = ((Long)map.get("type")).intValue();
                                List list2 = (List)map.get("args");
                                if (list2 == null) {
                                    stringArray = new String[]{};
                                } else {
                                    stringArray = new String[list2.size()];
                                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                                        stringArray[i2] = new String((byte[])list2.get(i2), "UTF-8");
                                    }
                                }
                                NavigationHelper.addCommand(n2, stringArray);
                            }
                            vuzeFileComponent.setProcessed();
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addCommand(int n, String[] stringArray) {
        CopyOnWriteList copyOnWriteList = listeners;
        synchronized (copyOnWriteList) {
            if (listeners.size() == 0) {
                if (command_queue == null) {
                    command_queue = new ArrayList();
                }
                command_queue.add(new Object[]{new Integer(n), stringArray});
            }
        }
        for (navigationListener navigationListener2 : listeners) {
            try {
                navigationListener2.processCommand(n, stringArray);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(navigationListener navigationListener2) {
        List list;
        CopyOnWriteList copyOnWriteList = listeners;
        synchronized (copyOnWriteList) {
            listeners.add(navigationListener2);
            list = command_queue;
            command_queue = null;
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                int n = (Integer)objectArray[0];
                String[] stringArray = (String[])objectArray[1];
                try {
                    navigationListener2.processCommand(n, stringArray);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
            HashMap hashMap = new HashMap();
            ArrayList arrayList = new ArrayList();
            hashMap.put("commands", arrayList);
            HashMap<String, Serializable> hashMap2 = new HashMap<String, Serializable>();
            arrayList.add(hashMap2);
            ArrayList arrayList2 = new ArrayList();
            hashMap2.put("type", new Long(1L));
            hashMap2.put("args", arrayList2);
            HashMap<String, Serializable> hashMap3 = new HashMap<String, Serializable>();
            arrayList.add(hashMap3);
            ArrayList arrayList3 = new ArrayList();
            hashMap3.put("type", new Long(1L));
            hashMap3.put("args", arrayList3);
            HashMap<String, Serializable> hashMap4 = new HashMap<String, Serializable>();
            arrayList.add(hashMap4);
            ArrayList arrayList4 = new ArrayList();
            hashMap4.put("type", new Long(2L));
            hashMap4.put("args", arrayList4);
            vuzeFile.addComponent(2, hashMap);
            vuzeFile.write(new File("C:\\temp\\v3ui.vuze"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static interface navigationListener {
        public void processCommand(int var1, String[] var2);
    }
}

