/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.util.MapUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.util.Debug;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONUtils {
    public static Map decodeJSON(String string) {
        try {
            Object object = JSONValue.parse(string);
            if (object instanceof Map) {
                return (Map)object;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("value", object);
            return hashMap;
        }
        catch (Throwable throwable) {
            Debug.out("Warning: Bad JSON String: " + string, throwable);
            return null;
        }
    }

    public static Map encodeToJSONObject(Map map) {
        JSONObject jSONObject = new JSONObject();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object instanceof byte[]) {
                string = string + ".B64";
                object = Base64.encode((byte[])object);
            }
            object = JSONUtils.coerce(object);
            jSONObject.put(string, object);
        }
        return jSONObject;
    }

    public static String encodeToJSON(Map map) {
        return JSONUtils.encodeToJSONObject(map).toString();
    }

    public static String encodeToJSON(Collection collection) {
        return JSONUtils.encodeToJSONArray(collection).toString();
    }

    private static Object coerce(Object object) {
        if (object instanceof Map && !(object instanceof JSONObject)) {
            object = JSONUtils.encodeToJSONObject((Map)object);
        } else if (object instanceof List && !(object instanceof JSONArray)) {
            object = JSONUtils.encodeToJSONArray((List)object);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            object = JSONUtils.encodeToJSONArray(Arrays.asList(objectArray));
        } else if (object instanceof byte[]) {
            try {
                object = new String((byte[])object, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return object;
    }

    private static List encodeToJSONArray(Collection collection) {
        JSONArray jSONArray = new JSONArray(collection);
        for (int i = 0; i < jSONArray.size(); ++i) {
            Object e = jSONArray.get(i);
            jSONArray.set(i, JSONUtils.coerce(e));
        }
        return jSONArray;
    }

    public static void main(String[] stringArray) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        byte[] byArray = new byte[]{0, 1, 2};
        hashMap.put("Hi", byArray);
        String string = JSONUtils.encodeToJSON(hashMap);
        System.out.println(string);
        Map map = JSONUtils.decodeJSON(string);
        byArray = MapUtils.getMapByteArray(map, "Hi", null);
        System.out.println(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            System.out.println("--" + by);
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("Test", "TestValue");
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        hashMap3.put("Test2", "test2value");
        hashMap2.put("TestMap", hashMap3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Long(5L));
        arrayList.add("five");
        hashMap3.put("ListTest", arrayList);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("Test3", "test3value");
        arrayList.add(hashMap4);
        System.out.println(JSONUtils.encodeToJSON(hashMap2));
        System.out.println(JSONUtils.encodeToJSON(arrayList));
    }
}

