/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;

public final class ImportExportUtils {
    public static final void exportString(Map map, String string, String string2) throws IOException {
        if (string2 != null) {
            map.put(string, string2.getBytes("UTF-8"));
        }
    }

    public static final void exportJSONString(Map map, String string, String string2) throws IOException {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    public static final String importString(Map map, String string, String string2) throws IOException {
        String string3 = ImportExportUtils.importString(map, string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static final String importString(Map map, String string) throws IOException {
        if (map == null) {
            return null;
        }
        Object v = map.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof byte[]) {
            return new String((byte[])v, "UTF-8");
        }
        return null;
    }

    public static final long importLong(Map map, String string) throws IOException {
        return ImportExportUtils.importLong(map, string, 0L);
    }

    public static final long importLong(Map map, String string, long l) throws IOException {
        if (map == null) {
            return l;
        }
        Object v = map.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        return l;
    }

    public static final void exportLong(Map map, String string, long l) {
        map.put(string, l);
    }

    public static final void exportInt(Map map, String string, int n) {
        map.put(string, new Long(n));
    }

    public static final int importInt(Map map, String string) throws IOException {
        return (int)ImportExportUtils.importLong(map, string, 0L);
    }

    public static final int importInt(Map map, String string, int n) throws IOException {
        return (int)ImportExportUtils.importLong(map, string, n);
    }

    public static final void exportFloat(Map map, String string, float f) throws IOException {
        ImportExportUtils.exportString(map, string, String.valueOf(f));
    }

    public static final float importFloat(Map map, String string, float f) throws IOException {
        String string2 = ImportExportUtils.importString(map, string);
        if (string2 == null) {
            return f;
        }
        return Float.parseFloat(string2);
    }

    public static final void exportBoolean(Map map, String string, boolean bl) throws IOException {
        map.put(string, new Long(bl ? 1L : 0L));
    }

    public static final boolean importBoolean(Map map, String string) throws IOException {
        return ImportExportUtils.importBoolean(map, string, false);
    }

    public static final boolean importBoolean(Map map, String string, boolean bl) throws IOException {
        if (map == null) {
            return bl;
        }
        Object v = map.get(string);
        if (v instanceof Long) {
            return (Long)v == 1L;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return bl;
    }

    public static final void exportJSONBoolean(Map map, String string, boolean bl) throws IOException {
        map.put(string, new Boolean(bl));
    }

    public static final String importURL(Map map, String string) throws IOException {
        String string2 = ImportExportUtils.importString(map, string);
        if (string2 != null) {
            string2 = (string2 = string2.trim()).length() == 0 ? null : URLDecoder.decode(string2, "UTF-8");
        }
        return string2;
    }

    public static final void exportURL(Map map, String string, String string2) throws IOException {
        ImportExportUtils.exportString(map, string, string2);
    }

    public static final void exportJSONURL(Map map, String string, String string2) throws IOException {
        ImportExportUtils.exportJSONString(map, string, UrlUtils.encode(string2));
    }

    public static final String[] importStringArray(Map map, String string) throws IOException {
        List list = (List)map.get(string);
        if (list == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            Object e = list.get(i);
            if (e instanceof String) {
                stringArray[i] = (String)e;
                continue;
            }
            if (!(e instanceof byte[])) continue;
            stringArray[i] = new String((byte[])e, "UTF-8");
        }
        return stringArray;
    }

    public static final void exportStringArray(Map map, String string, String[] stringArray) throws IOException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(stringArray.length);
        map.put(string, arrayList);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].getBytes("UTF-8"));
        }
    }

    public static final void exportJSONStringArray(Map map, String string, String[] stringArray) throws IOException {
        JSONArray jSONArray = new JSONArray(stringArray.length);
        map.put(string, jSONArray);
        for (int i = 0; i < stringArray.length; ++i) {
            jSONArray.add(stringArray[i]);
        }
    }

    public static final void exportIntArray(Map map, String string, int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            byArray[n2++] = (byte)(n3 >>> 24);
            byArray[n2++] = (byte)(n3 >>> 16);
            byArray[n2++] = (byte)(n3 >>> 8);
            byArray[n2++] = (byte)n3;
        }
        map.put(string, byArray);
    }

    public static final int[] importIntArray(Map map, String string) {
        byte[] byArray = (byte[])map.get(string);
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[byArray.length / 4];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        }
        return nArray;
    }
}

