/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.peerauth;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.BufferedInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class TrackerPeerAuthPlugin
implements Plugin,
DownloadManagerListener {
    private static final String PLUGIN_NAME = "Tracker Peer Auth";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.trackerpeerauth.name";
    private static final int DEFAULT_CHECK_PERIOD = 30000;
    private static final String STATE_ENABLED = "enabled";
    private static final String STATE_DISABLED = "disabled";
    private static final int TIMER_PERIOD = 10000;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_state;
    private LoggerChannel log;
    private Map dt_map = new HashMap();
    private ThreadPool thread_pool = new ThreadPool("TrackerPeerAuthPlugin", 8, true);

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.ta_state = this.plugin_interface.getTorrentManager().getPluginAttribute("state");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager uIManager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addLabelParameter2("Plugin.trackerpeerauth.info");
        final BasicPluginViewModel basicPluginViewModel = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            public void messageLogged(String string, Throwable throwable) {
                if (string.length() > 0) {
                    basicPluginViewModel.getLogArea().appendText(string + "\n");
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                basicPluginViewModel.getLogArea().appendText(stringWriter.toString() + "\n");
            }
        });
        System.out.println("**** tracker peer auth disabled ****");
    }

    public void downloadAdded(final Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && torrent.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
                }

                public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
                    if (downloadAnnounceResult.getResponseType() == 1) {
                        Map map = downloadAnnounceResult.getExtensions();
                        boolean bl = true;
                        int n = 30000;
                        if (map != null) {
                            // empty if block
                        }
                        download.setAttribute(TrackerPeerAuthPlugin.this.ta_state, bl ? TrackerPeerAuthPlugin.STATE_ENABLED : TrackerPeerAuthPlugin.STATE_DISABLED);
                        TrackerPeerAuthPlugin.this.setState(download, bl, n);
                    }
                }
            });
            String string = download.getAttribute(this.ta_state);
            if (string != null) {
                boolean bl = string.equals(STATE_ENABLED);
                this.setState(download, bl, 30000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRemoved(Download download) {
        Map map = this.dt_map;
        synchronized (map) {
            this.dt_map.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Download download, boolean bl, int n) {
        Map map = this.dt_map;
        synchronized (map) {
            if (bl) {
                DownloadTracker downloadTracker = (DownloadTracker)this.dt_map.get(download);
                if (downloadTracker == null) {
                    DownloadTracker downloadTracker2 = new DownloadTracker(download, n);
                    this.dt_map.put(download, downloadTracker2);
                } else {
                    downloadTracker.setCheckPeriod(n);
                }
            } else {
                this.dt_map.remove(download);
            }
        }
    }

    protected void log(Download download, String string) {
        this.log.log("Download '" + download.getName() + "' - " + string);
    }

    protected class DownloadTracker
    implements DownloadPeerListener,
    PeerManagerListener,
    DownloadTrackerListener {
        private static final int BACKOFF_TICK_COUNT = 6;
        private static final int MAX_PEERS_PER_QUERY = 100;
        private static final int OK_BLOOM_INITIAL = 16384;
        private static final int OK_BLOOM_INC = 16384;
        private static final int OK_BLOOM_MAX = 131072;
        private static final int BAD_BLOOM_INITIAL = 4096;
        private static final int BAD_BLOOM_INC = 4096;
        private static final int BAD_BLOOM_MAX = 65536;
        private Download download;
        private BloomFilter ok_bloom = BloomFilterFactory.createAddOnly(16384);
        private BloomFilter bad_bloom = BloomFilterFactory.createAddOnly(4096);
        private long pending_check_peer_count = 0L;
        private boolean check_running;
        private int check_tick_count;
        private int backoff_tick_count;

        protected DownloadTracker(Download download, int n) {
            this.download = download;
            this.download.addTrackerListener(this);
            this.download.addPeerListener(this);
            this.setCheckPeriod(n);
            this.log("enabled, check period=" + n);
        }

        protected void setCheckPeriod(int n) {
            this.check_tick_count = n / 10000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordPeer(String string, byte[] byArray, String string2, int n, boolean bl) {
            if (byArray == null) {
                return;
            }
            byte[] byArray2 = this.getKey(byArray, string2);
            DownloadTracker downloadTracker = this;
            synchronized (downloadTracker) {
                if (bl) {
                    int n2 = this.ok_bloom.getEntryCount();
                    if (n2 > 0 && this.ok_bloom.getSize() / n2 < 10) {
                        int n3 = this.ok_bloom.getSize() + 16384;
                        if (n3 > 131072) {
                            n3 = 131072;
                        }
                        this.log("Expanding ok bloom to " + n3 + " entries");
                        BloomFilter bloomFilter = BloomFilterFactory.createAddOnly(n3);
                        PeerManager peerManager = this.download.getPeerManager();
                        if (peerManager != null) {
                            Peer[] peerArray = peerManager.getPeers();
                            for (int i = 0; i < peerArray.length; ++i) {
                                byte[] byArray3 = this.getKey(peerArray[i]);
                                if (byArray3 == null || !this.ok_bloom.contains(byArray3)) continue;
                                bloomFilter.add(byArray3);
                            }
                        }
                        this.ok_bloom = bloomFilter;
                        this.bad_bloom = BloomFilterFactory.createAddOnly(this.bad_bloom.getSize());
                    }
                    this.ok_bloom.add(byArray2);
                } else {
                    int n4 = this.bad_bloom.getEntryCount();
                    if (n4 > 0 && this.bad_bloom.getSize() / n4 < 10) {
                        int n5 = this.bad_bloom.getSize() + 4096;
                        if (n5 > 65536) {
                            n5 = 65536;
                        }
                        this.log("Expanding bad bloom to " + n5 + " entries");
                        this.bad_bloom = BloomFilterFactory.createAddOnly(n5);
                    }
                    this.bad_bloom.add(byArray2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkPeers(long l) {
            block18: {
                if (this.backoff_tick_count > 0) {
                    --this.backoff_tick_count;
                    return;
                }
                if (l % (long)this.check_tick_count == 0L) {
                    DownloadTracker downloadTracker;
                    DownloadTracker downloadTracker2 = this;
                    synchronized (downloadTracker2) {
                        if (this.pending_check_peer_count <= 0L || this.check_running) {
                            return;
                        }
                        this.pending_check_peer_count = 0L;
                        this.check_running = true;
                    }
                    boolean bl = false;
                    try {
                        PeerManager peerManager = this.download.getPeerManager();
                        if (peerManager != null) {
                            Peer[] peerArray = peerManager.getPeers();
                            final ArrayList<Peer> arrayList = new ArrayList<Peer>();
                            for (int i = 0; i < peerArray.length; ++i) {
                                Peer peer = peerArray[i];
                                byte[] byArray = this.getKey(peer);
                                if (byArray == null || this.ok_bloom.contains(byArray)) continue;
                                if (this.bad_bloom.contains(byArray)) {
                                    this.removePeer(peer);
                                    continue;
                                }
                                arrayList.add(peer);
                            }
                            if (arrayList.size() > 0) {
                                TrackerPeerAuthPlugin.this.thread_pool.run(new AERunnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void runSupport() {
                                        DownloadTracker downloadTracker;
                                        try {
                                            DownloadTracker.this.check(arrayList);
                                            Object var2_1 = null;
                                            downloadTracker = DownloadTracker.this;
                                        }
                                        catch (Throwable throwable) {
                                            Object var2_2 = null;
                                            DownloadTracker downloadTracker2 = DownloadTracker.this;
                                            synchronized (downloadTracker2) {
                                                DownloadTracker.this.check_running = false;
                                            }
                                            throw throwable;
                                        }
                                        synchronized (downloadTracker) {
                                            DownloadTracker.this.check_running = false;
                                        }
                                    }
                                });
                                bl = true;
                            }
                        }
                        Object var11_11 = null;
                        if (bl) break block18;
                        downloadTracker = this;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        if (!bl) {
                            DownloadTracker downloadTracker3 = this;
                            synchronized (downloadTracker3) {
                                this.check_running = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (downloadTracker) {
                        this.check_running = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void check(List var1_1) {
            block28: {
                block25: {
                    block23: {
                        block24: {
                            var2_2 = this.download.getLastAnnounceResult();
                            v0 = var3_3 = var2_2 == null ? null : var2_2.getURL();
                            if (var3_3 == null) {
                                var3_3 = this.download.getTorrent().getAnnounceURL();
                            }
                            var4_4 = null;
                            var5_5 = null;
                            try {
                                try {
                                    var6_6 = var3_3.toString();
                                    var7_8 = var6_6.indexOf("announce");
                                    if (var7_8 == -1) {
                                        this.log("announce URL '" + var6_6 + "' is non-conformant");
                                        var19_9 = null;
                                        if (var4_4 == null) break block23;
                                        break block24;
                                    }
                                    var6_6 = var6_6.substring(0, var7_8) + "testauth" + var6_6.substring(var7_8 + 8);
                                    var3_3 = new URL(var6_6);
                                    var8_17 = new HashMap<String, Object>();
                                    var9_18 = "";
                                    for (var10_19 = 0; var10_19 < var1_1.size() && var10_19 < 100; ++var10_19) {
                                        var11_21 = (Peer)var1_1.get(var10_19);
                                        var12_22 = new ArrayList<Object>();
                                        var12_22.add(this.download.getTorrent().getHash());
                                        var12_22.add(var11_21.getId());
                                        var12_22.add(var11_21.getIp());
                                        var8_17.put("peer" + var10_19, var12_22);
                                        var9_18 = var9_18 + (var10_19 == 0 ? "" : ",") + var11_21.getIp();
                                    }
                                    this.log("Checking " + var6_6 + " : peers=" + var9_18);
                                    var10_20 = BEncoder.encode(var8_17, true);
                                    var11_21 = (HttpURLConnection)var3_3.openConnection();
                                    var12_22 = "authpeers=" + new String(var10_20, "ISO-8859-1");
                                    System.out.println("sending '" + (String)var12_22 + "'");
                                    var11_21.setDoOutput(true);
                                    var11_21.setRequestMethod("POST");
                                    var11_21.setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                                    var11_21.setRequestProperty("Connection", "close");
                                    var11_21.addRequestProperty("Accept-Encoding", "gzip");
                                    var4_4 = new OutputStreamWriter(var11_21.getOutputStream());
                                    var4_4.write((String)var12_22);
                                    var4_4.flush();
                                    var5_5 = new BufferedInputStream(var11_21.getInputStream());
                                    var13_23 = BDecoder.decode(var5_5);
                                    for (var14_24 = 0; var14_24 < var1_1.size() && var14_24 < 100; ++var14_24) {
                                        var15_25 = (Peer)var1_1.get(var14_24);
                                        var16_26 = (Long)var13_23.get("peer" + var14_24);
                                        if (var16_26 == null) {
                                            this.log("No response for peer '" + var15_25.getIp() + "'");
                                            continue;
                                        }
                                        var17_27 = var16_26 != 0L;
                                        this.recordPeer("auth check", var15_25.getId(), var15_25.getIp(), var15_25.getPort(), var17_27);
                                        if (var17_27) continue;
                                        this.removePeer(var15_25);
                                    }
                                    break block25;
                                }
                                catch (Throwable var6_7) {
                                    this.backoff_tick_count = 6;
                                    var6_7.printStackTrace();
                                    var19_11 = null;
                                    if (var4_4 != null) {
                                        try {
                                            var4_4.close();
                                        }
                                        catch (Throwable var20_15) {
                                            // empty catch block
                                        }
                                    }
                                    if (var5_5 == null) return;
                                    try {
                                        var5_5.close();
                                        return;
                                    }
                                    catch (Throwable var20_15) {
                                        return;
                                    }
                                }
                            }
                            catch (Throwable var18_28) {
                                block27: {
                                    var19_12 = null;
                                    if (var4_4 != null) {
                                        ** try [egrp 2[TRYBLOCK] [6 : 752->760)] { 
lbl84:
                                        // 1 sources

                                        var4_4.close();
                                        break block27;
lbl86:
                                        // 1 sources

                                        catch (Throwable var20_16) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var5_5 == null) throw var18_28;
                                ** try [egrp 3[TRYBLOCK] [7 : 767->775)] { 
lbl91:
                                // 1 sources

                                var5_5.close();
                                throw var18_28;
lbl93:
                                // 1 sources

                                catch (Throwable var20_16) {
                                    // empty catch block
                                }
                                throw var18_28;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [6 : 752->760)] { 
lbl98:
                        // 1 sources

                        var4_4.close();
                        break block23;
lbl100:
                        // 1 sources

                        catch (Throwable var20_13) {
                            // empty catch block
                        }
                    }
                    if (var5_5 == null) return;
                    ** try [egrp 3[TRYBLOCK] [7 : 767->775)] { 
lbl105:
                    // 1 sources

                    var5_5.close();
                    return;
lbl107:
                    // 1 sources

                    catch (Throwable var20_13) {
                        // empty catch block
                    }
                    return;
                }
                var19_10 = null;
                if (var4_4 != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 752->760)] { 
lbl114:
                    // 1 sources

                    var4_4.close();
                    break block28;
lbl116:
                    // 1 sources

                    catch (Throwable var20_14) {
                        // empty catch block
                    }
                }
            }
            if (var5_5 == null) return;
            try {}
            catch (Throwable var20_14) {}
            var5_5.close();
            return;
        }

        protected byte[] getKey(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return null;
            }
            return this.getKey(byArray, peer.getIp());
        }

        protected byte[] getKey(byte[] byArray, String string) {
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }

        protected boolean knownToBeOK(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return true;
            }
            byte[] byArray2 = this.getKey(byArray, peer.getIp());
            return this.ok_bloom.contains(byArray2);
        }

        protected boolean knownToBeBad(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return true;
            }
            byte[] byArray2 = this.getKey(byArray, peer.getIp());
            return this.bad_bloom.contains(byArray2);
        }

        protected void peerMightBeBad(Peer peer) {
            if (!this.knownToBeOK(peer)) {
                if (this.knownToBeBad(peer)) {
                    this.removePeer(peer);
                } else {
                    ++this.pending_check_peer_count;
                }
            }
        }

        protected void removePeer(Peer peer) {
            this.log("Disconnecting peer " + peer.getIp() + "/" + peer.getPort() + ": not authorized");
            peer.close("Tracker peer authorization failure", false, false);
        }

        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
        }

        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
            DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = downloadAnnounceResult.getPeers();
            if (downloadAnnounceResultPeerArray != null) {
                for (int i = 0; i < downloadAnnounceResultPeerArray.length; ++i) {
                    DownloadAnnounceResultPeer downloadAnnounceResultPeer = downloadAnnounceResultPeerArray[i];
                    this.recordPeer("Tracker", downloadAnnounceResultPeer.getPeerID(), downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), true);
                }
            }
        }

        public void peerAdded(PeerManager peerManager, Peer peer) {
            if (peer.isIncoming()) {
                this.peerMightBeBad(peer);
            } else {
                this.recordPeer("Outgoing", peer.getId(), peer.getIp(), peer.getPort(), true);
            }
        }

        public void peerRemoved(PeerManager peerManager, Peer peer) {
        }

        public void peerManagerAdded(Download download, PeerManager peerManager) {
            peerManager.addListener(this);
        }

        public void peerManagerRemoved(Download download, PeerManager peerManager) {
            peerManager.removeListener(this);
        }

        protected void log(String string) {
            TrackerPeerAuthPlugin.this.log(this.download, string);
        }
    }
}

