/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderLinear
implements ExternalSeedHTTPDownloader {
    private URL original_url;
    private String user_agent;
    private int last_response;
    private int last_response_retry_after_secs;
    private Downloader downloader;

    public ExternalSeedHTTPDownloaderLinear(URL uRL, String string) {
        this.original_url = uRL;
        this.user_agent = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRange(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        Request request2;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == null) {
                this.downloader = new Downloader(externalSeedHTTPDownloaderListener, bl);
            }
            request2 = this.downloader.addRequest(l, n, externalSeedHTTPDownloaderListener);
        }
        do {
            if (!request2.waitFor(1000)) continue;
            return;
        } while (!externalSeedHTTPDownloaderListener.isCancelled());
        throw new ExternalSeedException("request cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Downloader downloader = null;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader != null) {
                downloader = this.downloader;
                this.downloader = null;
            }
        }
        if (downloader != null) {
            downloader.destroy(new ExternalSeedException("deactivated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destoyed(Downloader downloader) {
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == downloader) {
                this.downloader = null;
            }
        }
    }

    public void download(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    public void downloadSocket(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    public int getLastResponse() {
        return this.last_response;
    }

    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    static /* synthetic */ URL access$000(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.original_url;
    }

    static /* synthetic */ String access$100(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.user_agent;
    }

    static /* synthetic */ int access$202(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear, int n) {
        externalSeedHTTPDownloaderLinear.last_response = n;
        return externalSeedHTTPDownloaderLinear.last_response;
    }

    static /* synthetic */ int access$302(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear, int n) {
        externalSeedHTTPDownloaderLinear.last_response_retry_after_secs = n;
        return externalSeedHTTPDownloaderLinear.last_response_retry_after_secs;
    }

    static /* synthetic */ int access$300(ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear) {
        return externalSeedHTTPDownloaderLinear.last_response_retry_after_secs;
    }

    protected class Request {
        private long offset;
        private int length;
        private ExternalSeedHTTPDownloaderListener listener;
        private AESemaphore sem = new AESemaphore("ES:wait");
        private volatile ExternalSeedException exception;

        protected Request(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) {
            this.offset = l;
            this.length = n;
            this.listener = externalSeedHTTPDownloaderListener;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected int getLength() {
            return this.length;
        }

        protected ExternalSeedHTTPDownloaderListener getListener() {
            return this.listener;
        }

        protected void complete() {
            this.sem.release();
        }

        protected void destroy(ExternalSeedException externalSeedException) {
            this.exception = externalSeedException;
            this.sem.release();
        }

        public boolean waitFor(int n) throws ExternalSeedException {
            if (!this.sem.reserve(n)) {
                return false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return true;
        }
    }

    protected class Downloader
    implements SEPasswordListener {
        private ExternalSeedHTTPDownloaderListener listener;
        private boolean con_fail_is_perm_fail;
        private volatile boolean destroyed;
        private List<Request> requests = new ArrayList<Request>();
        private RandomAccessFile raf = null;
        private File scratch_file = null;

        protected Downloader(ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) {
            this.listener = externalSeedHTTPDownloaderListener;
            this.con_fail_is_perm_fail = bl;
            new AEThread2("ES:downloader", true){

                public void run() {
                    Downloader.this.download();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void download() {
            var1_1 = false;
            var2_2 = "";
            try {
                block35: {
                    block34: {
                        var3_3 = null;
                        try {
                            try {
                                SESecurityManager.setThreadPasswordHandler(this);
                                var4_5 = this;
                                synchronized (var4_5) {
                                    if (this.destroyed) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 33, 1, 2, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var4_5
                                        var16_9 = null;
                                        break block34;
                                    }
                                    this.scratch_file = AETemporaryFileHandler.createTempFile();
                                    this.raf = new RandomAccessFile(this.scratch_file, "rw");
                                }
                                var4_5 = (HttpURLConnection)ExternalSeedHTTPDownloaderLinear.access$000(ExternalSeedHTTPDownloaderLinear.this).openConnection();
                                var4_5.setRequestProperty("Connection", "Keep-Alive");
                                var4_5.setRequestProperty("User-Agent", ExternalSeedHTTPDownloaderLinear.access$100(ExternalSeedHTTPDownloaderLinear.this));
                                var6_15 = this.listener.getPermittedTime();
                                if (var6_15 > 0) {
                                    Java15Utils.setConnectTimeout((URLConnection)var4_5, var6_15);
                                }
                                var4_5.connect();
                                var6_15 = this.listener.getPermittedTime();
                                if (var6_15 < 0) {
                                    throw new IOException("Timeout during connect");
                                }
                                Java15Utils.setReadTimeout((URLConnection)var4_5, var6_15);
                                var1_1 = true;
                                var5_16 = var4_5.getResponseCode();
                                ExternalSeedHTTPDownloaderLinear.access$202(ExternalSeedHTTPDownloaderLinear.this, var5_16);
                                ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, -1);
                                if (var5_16 == 503) {
                                    var7_19 = new Long(var4_5.getHeaderFieldDate("Retry-After", -1L));
                                    if (var7_19 <= -1L) {
                                        ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, var4_5.getHeaderFieldInt("Retry-After", -1));
                                    } else {
                                        ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, (int)((var7_19 - System.currentTimeMillis()) / 1000L));
                                        if (ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) < 0) {
                                            ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, -1);
                                        }
                                    }
                                }
                                var3_3 = var4_5.getInputStream();
                                if (var5_16 != 202 && var5_16 != 200 && var5_16 != 206) {
                                    var2_2 = "Connection failed: " + var4_5.getResponseMessage();
                                    var7_21 = new ExternalSeedException(var2_2);
                                    var7_21.setPermanentFailure(true);
                                    throw var7_21;
                                }
                                var7_20 = new byte[65536];
                                var8_22 = 1;
                                while (!this.destroyed) {
                                    var9_23 = this.listener.getPermittedBytes();
                                    if (var8_22 == 0 || var9_23 < 1) {
                                        var9_23 = 1;
                                        Thread.sleep(100L);
                                    }
                                    if ((var10_24 = var3_3.read(var7_20, 0, Math.min(var9_23, var7_20.length))) <= 0) break;
                                    var11_25 = this;
                                    synchronized (var11_25) {
                                        try {
                                            this.raf.write(var7_20, 0, var10_24);
                                        }
                                        catch (Throwable var12_26) {
                                            var2_2 = "Write failed: " + var12_26.getMessage();
                                            var13_27 = new ExternalSeedException(var2_2, var12_26);
                                            var13_27.setPermanentFailure(true);
                                            throw var13_27;
                                        }
                                    }
                                    this.listener.reportBytesRead(var10_24);
                                    var8_22 = this.checkRequests();
                                }
                                this.checkRequests();
                                break block35;
                            }
                            catch (IOException var4_6) {
                                if (this.con_fail_is_perm_fail && !var1_1) {
                                    var2_2 = "Connection failed: " + var4_6.getMessage();
                                    var5_17 = new ExternalSeedException(var2_2);
                                    var5_17.setPermanentFailure(true);
                                    throw var5_17;
                                }
                                var2_2 = "Connection failed: " + Debug.getNestedExceptionMessage(var4_6);
                                if (ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) >= 0) {
                                    var2_2 = var2_2 + ", Retry-After: " + ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) + " seconds";
                                }
                                var5_18 = new ExternalSeedException(var2_2, var4_6);
                                if (var4_6 instanceof FileNotFoundException == false) throw var5_18;
                                var5_18.setPermanentFailure(true);
                                throw var5_18;
                            }
                            catch (ExternalSeedException var4_7) {
                                throw var4_7;
                            }
                            catch (Throwable var4_8) {
                                if (var4_8 instanceof ExternalSeedException) {
                                    throw (ExternalSeedException)var4_8;
                                }
                                var2_2 = "Connection failed: " + Debug.getNestedExceptionMessage(var4_8);
                                throw new ExternalSeedException("Connection failed", var4_8);
                            }
                        }
                        catch (Throwable var15_28) {
                            var16_11 = null;
                            SESecurityManager.unsetThreadPasswordHandler();
                            if (var3_3 == null) throw var15_28;
                            try {
                                var3_3.close();
                                throw var15_28;
                            }
                            catch (Throwable var17_14) {
                                // empty catch block
                            }
                            throw var15_28;
                        }
                    }
                    SESecurityManager.unsetThreadPasswordHandler();
                    if (var3_3 == null) return;
                    ** try [egrp 7[TRYBLOCK] [15 : 779->786)] { 
lbl110:
                    // 1 sources

                    var3_3.close();
                    return;
lbl112:
                    // 1 sources

                    catch (Throwable var17_12) {
                        // empty catch block
                    }
                    return;
                }
                var16_10 = null;
                SESecurityManager.unsetThreadPasswordHandler();
                if (var3_3 == null) return;
                try {}
                catch (Throwable var17_13) {}
                var3_3.close();
                return;
                return;
            }
            catch (ExternalSeedException var3_4) {
                if (!var1_1 && this.con_fail_is_perm_fail) {
                    var3_4.setPermanentFailure(true);
                }
                this.destroy(var3_4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request addRequest(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) throws ExternalSeedException {
            Request request2;
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    throw new ExternalSeedException("downloader destroyed");
                }
                request2 = new Request(l, n, externalSeedHTTPDownloaderListener);
                this.requests.add(request2);
            }
            this.checkRequests();
            return request2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int checkRequests() {
            try {
                Downloader downloader = this;
                synchronized (downloader) {
                    if (this.raf == null) {
                        return this.requests.size();
                    }
                    long l = this.raf.getFilePointer();
                    Iterator<Request> iterator = this.requests.iterator();
                    while (iterator.hasNext()) {
                        Object var13_11;
                        Request request2 = iterator.next();
                        long l2 = request2.getOffset() + (long)request2.getLength();
                        if (l < l2) continue;
                        ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener = request2.getListener();
                        try {
                            int n;
                            this.raf.seek(request2.getOffset());
                            for (int i = 0; i < request2.getLength(); i += n) {
                                byte[] byArray = externalSeedHTTPDownloaderListener.getBuffer();
                                n = externalSeedHTTPDownloaderListener.getBufferLength();
                                this.raf.read(byArray, 0, n);
                                externalSeedHTTPDownloaderListener.done();
                            }
                            var13_11 = null;
                        }
                        catch (Throwable throwable) {
                            var13_11 = null;
                            this.raf.seek(l);
                            throw throwable;
                        }
                        this.raf.seek(l);
                        request2.complete();
                        iterator.remove();
                    }
                    return this.requests.size();
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                this.destroy(new ExternalSeedException("read failed", throwable));
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(ExternalSeedException externalSeedException) {
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.scratch_file != null) {
                    this.scratch_file.delete();
                }
                for (Request request2 : this.requests) {
                    request2.destroy(externalSeedException);
                }
                this.requests.clear();
            }
            ExternalSeedHTTPDownloaderLinear.this.destoyed(this);
        }

        public PasswordAuthentication getAuthentication(String string, URL uRL) {
            return null;
        }

        public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
        }

        public void clearPasswords() {
        }
    }
}

