/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.torrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.HasBeenOpenedListener;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformTorrentUtils {
    private static final long MIN_SPEED_DEFAULT = 102400L;
    public static final String AELITIS_HOST_CORE = ".aelitis.com";
    public static final String VUZE_HOST_CORE = ".vuze.com";
    public static final boolean DEBUG_CACHING = System.getProperty("az3.debug.caching", "0").equals("1");
    private static final String TOR_AZ_PROP_MAP = "Content";
    private static final String TOR_AZ_PROP_HASH = "Content Hash";
    private static final String TOR_AZ_PROP_TITLE = "Title";
    private static final String TOR_AZ_PROP_DESCRIPTION = "Description";
    private static final String TOR_AZ_PROP_CONTENT_TYPE = "Content Type";
    private static final String TOR_AZ_PROP_AUTHOR = "Author";
    private static final String TOR_AZ_PROP_PUBLISHER = "Publisher";
    private static final String TOR_AZ_PROP_URL = "URL";
    private static final String TOR_AZ_PROP_THUMBNAIL = "Thumbnail";
    private static final String TOR_AZ_PROP_THUMBNAIL_URL = "Thumbnail.url";
    private static final String TOR_AZ_PROP_QUALITY = "Quality";
    private static final String TOR_AZ_PROP_PROGRESSIVE = "Progressive";
    private static final String TOR_AZ_PROP_SPEED = "Speed Bps";
    private static final String TOR_AZ_PROP_MIN_SPEED = "Min Speed Bps";
    private static final String TOR_AZ_PROP_DRM = "DRM";
    private static final String TOR_AZ_PROP_PURCHASED = "Purchased";
    private static final String TOR_AZ_PROP_QOS_CLASS = "QOS Class";
    private static final String TOR_AZ_PROP_CONTENT_NETWORK = "Content Network";
    private static final String TOR_AZ_PROP_EXPIRESON = "Expires On";
    private static final String TOR_AZ_PROP_PRIMARY_FILE = "Primary File Index";
    private static final ArrayList<HasBeenOpenedListener> hasBeenOpenedListeners = new ArrayList(1);
    private static final String TOR_AZ_PROP_USE_EMP = "useEMP";
    private static final String TOR_AZ_PROP_FILE_METADATA = "File MetaData";
    private static final String TOR_AZ_PROP_VIDEO_WIDTH = "Video Width";
    private static final String TOR_AZ_PROP_VIDEO_HEIGHT = "Video Height";
    private static final String TOR_AZ_PROP_VIDEO_RUNNINGTIME = "Running Time";
    private static final String TOR_AZ_PROP_DURATION_MILLIS = "Duration";
    private static final String TOR_AZ_PROP_OPENED = "Opened";
    private static ArrayList<String> listPlatformHosts = null;
    private static final Map mapPlatformTrackerTorrents = new WeakHashMap();
    private static boolean embeddedPlayerAvail = false;

    public static Map getContentMap(TOTorrent tOTorrent) {
        HashMap hashMap;
        Object v;
        if (tOTorrent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap hashMap2 = tOTorrent.getAdditionalMapProperty("azureus_properties");
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            tOTorrent.setAdditionalMapProperty("azureus_properties", hashMap2);
        }
        if ((v = hashMap2.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            hashMap = (HashMap)v;
        } else {
            hashMap = new HashMap();
            hashMap2.put(TOR_AZ_PROP_MAP, hashMap);
        }
        return hashMap;
    }

    static Map getTempContentMap(TOTorrent tOTorrent) {
        HashMap hashMap;
        Object v;
        if (tOTorrent == null) {
            return new HashMap();
        }
        HashMap hashMap2 = tOTorrent.getAdditionalMapProperty("attributes");
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            tOTorrent.setAdditionalMapProperty("attributes", hashMap2);
        }
        if ((v = hashMap2.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            hashMap = (HashMap)v;
        } else {
            hashMap = new HashMap();
            hashMap2.put(TOR_AZ_PROP_MAP, hashMap);
        }
        return hashMap;
    }

    public static String getContentMapString(TOTorrent tOTorrent, String string) {
        if (tOTorrent == null) {
            return null;
        }
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        Object v = map.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof byte[]) {
            try {
                return new String((byte[])v, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return null;
    }

    private static void setContentMapString(TOTorrent tOTorrent, String string, String string2) {
        if (tOTorrent == null) {
            return;
        }
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        map.put(string, string2);
    }

    private static long getContentMapLong(TOTorrent tOTorrent, String string, long l) {
        if (tOTorrent == null) {
            return l;
        }
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        Object v = map.get(string);
        try {
            if (v instanceof Long) {
                return (Long)v;
            }
            if (v instanceof Integer) {
                return ((Integer)v).longValue();
            }
            if (v instanceof String) {
                return Long.parseLong((String)v);
            }
            if (v instanceof byte[]) {
                return Long.parseLong(new String((byte[])v));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static Map getContentMapMap(TOTorrent tOTorrent, String string) {
        if (tOTorrent == null) {
            return null;
        }
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        Object v = map.get(string);
        if (v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    private static void setContentMapLong(TOTorrent tOTorrent, String string, long l) {
        if (tOTorrent == null) {
            return;
        }
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        map.put(string, new Long(l));
    }

    public static void setContentMapMap(TOTorrent tOTorrent, String string, Map map) {
        if (tOTorrent == null) {
            return;
        }
        Map map2 = PlatformTorrentUtils.getContentMap(tOTorrent);
        map2.put(string, map);
    }

    public static String getContentHash(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_HASH);
    }

    public static String getContentTitle(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_TITLE);
    }

    public static void setContentTitle(TOTorrent tOTorrent, String string) {
        PlatformTorrentUtils.setContentMapString(tOTorrent, TOR_AZ_PROP_TITLE, string);
    }

    public static String getContentDescription(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_DESCRIPTION);
    }

    public static void setContentDescription(TOTorrent tOTorrent, String string) {
        PlatformTorrentUtils.setContentMapString(tOTorrent, TOR_AZ_PROP_DESCRIPTION, string);
    }

    public static String getContentType(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_CONTENT_TYPE);
    }

    public static String getContentAuthor(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_AUTHOR);
    }

    public static String getContentPublisher(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_PUBLISHER);
    }

    public static String getContentURL(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_URL);
    }

    public static String getContentQuality(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_QUALITY);
    }

    public static boolean isContentDRM(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_DRM, -1L) >= 0L;
    }

    public static boolean isContentPurchased(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_PURCHASED, 0L) == 1L;
    }

    public static long getQOSClass(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_QOS_CLASS, 0L);
    }

    public static void setQOSClass(TOTorrent tOTorrent, long l) {
        PlatformTorrentUtils.setContentMapLong(tOTorrent, TOR_AZ_PROP_QOS_CLASS, l);
    }

    public static long getContentNetworkID(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentNetworkID(tOTorrent, -1L);
    }

    public static long getContentNetworkID(TOTorrent tOTorrent, long l) {
        long l2 = PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_CONTENT_NETWORK, -1L);
        if (l2 == -1L) {
            return PlatformTorrentUtils.isContent(tOTorrent, false) ? 1L : l;
        }
        return l2;
    }

    public static void setContentNetworkID(TOTorrent tOTorrent, long l) {
        PlatformTorrentUtils.setContentMapLong(tOTorrent, TOR_AZ_PROP_CONTENT_NETWORK, l);
    }

    private static void putOrRemove(Map map, String string, Object object) {
        if (object == null || object.equals(null)) {
            map.remove(string);
        } else {
            map.put(string, object);
        }
    }

    public static void setContentQuality(TOTorrent tOTorrent, String string) {
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        PlatformTorrentUtils.putOrRemove(map, TOR_AZ_PROP_QUALITY, string);
        PlatformTorrentUtils.writeTorrentIfExists(tOTorrent);
    }

    private static void writeTorrentIfExists(TOTorrent tOTorrent) {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
        if (azureusCore == null || !azureusCore.isStarted()) {
            return;
        }
        GlobalManager globalManager = azureusCore.getGlobalManager();
        if (globalManager == null || globalManager.getDownloadManager(tOTorrent) == null) {
            return;
        }
        try {
            TorrentUtils.writeToFile(tOTorrent);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.out(tOTorrentException);
        }
    }

    public static byte[] getContentThumbnail(TOTorrent tOTorrent) {
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        Object v = map.get(TOR_AZ_PROP_THUMBNAIL);
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        return null;
    }

    public static String getContentThumbnailUrl(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapString(tOTorrent, TOR_AZ_PROP_THUMBNAIL_URL);
    }

    public static void setContentThumbnailUrl(TOTorrent tOTorrent, String string) {
        PlatformTorrentUtils.setContentMapString(tOTorrent, TOR_AZ_PROP_THUMBNAIL_URL, string);
    }

    public static void setContentThumbnail(TOTorrent tOTorrent, byte[] byArray) {
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        PlatformTorrentUtils.putOrRemove(map, TOR_AZ_PROP_THUMBNAIL, byArray);
        PlatformTorrentUtils.writeTorrentIfExists(tOTorrent);
    }

    public static boolean isContent(TOTorrent tOTorrent, boolean bl) {
        boolean bl2;
        if (tOTorrent == null) {
            return false;
        }
        boolean bl3 = bl2 = PlatformTorrentUtils.getContentHash(tOTorrent) != null;
        if (!bl2 || bl2 && !bl) {
            return bl2;
        }
        return PlatformTorrentUtils.isPlatformTracker(tOTorrent);
    }

    public static boolean isContent(Torrent torrent, boolean bl) {
        if (torrent instanceof TorrentImpl) {
            return PlatformTorrentUtils.isContent(((TorrentImpl)torrent).getTorrent(), bl);
        }
        return false;
    }

    public static List<String> getPlatformHosts() {
        if (listPlatformHosts == null) {
            listPlatformHosts = new ArrayList();
            for (int i = 0; i < Constants.AZUREUS_DOMAINS.length; ++i) {
                listPlatformHosts.add(Constants.AZUREUS_DOMAINS[i].toLowerCase());
            }
        }
        return listPlatformHosts;
    }

    public static void addPlatformHost(String string) {
        List<String> list = PlatformTorrentUtils.getPlatformHosts();
        if (!list.contains(string = string.toLowerCase())) {
            list.add(string);
            mapPlatformTrackerTorrents.clear();
        }
    }

    public static boolean isPlatformHost(String string) {
        Object[] objectArray = PlatformTorrentUtils.getPlatformHosts().toArray();
        string = string.toLowerCase();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            if (string2.equals(string)) {
                return true;
            }
            if (!string.endsWith("." + string2)) continue;
            return true;
        }
        if (Constants.isCVSVersion()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                return inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPlatformTracker(TOTorrent tOTorrent) {
        try {
            boolean bl;
            if (tOTorrent == null) {
                return false;
            }
            Object v = mapPlatformTrackerTorrents.get(tOTorrent);
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            URL uRL = tOTorrent.getAnnounceURL();
            if (uRL != null && !PlatformTorrentUtils.isPlatformHost(uRL.getHost())) {
                mapPlatformTrackerTorrents.put(tOTorrent, new Boolean(false));
                return false;
            }
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
            for (bl = false; bl < tOTorrentAnnounceURLSetArray.length; bl += 1) {
                URL[] uRLArray = tOTorrentAnnounceURLSetArray[bl].getAnnounceURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    if (PlatformTorrentUtils.isPlatformHost(uRLArray[i].getHost())) continue;
                    mapPlatformTrackerTorrents.put(tOTorrent, new Boolean(false));
                    return false;
                }
            }
            bl = uRL != null;
            mapPlatformTrackerTorrents.put(tOTorrent, new Boolean(bl));
            return bl;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            mapPlatformTrackerTorrents.put(tOTorrent, new Boolean(false));
            return false;
        }
    }

    public static boolean isPlatformTracker(Torrent torrent) {
        if (torrent instanceof TorrentImpl) {
            return PlatformTorrentUtils.isPlatformTracker(((TorrentImpl)torrent).getTorrent());
        }
        return false;
    }

    public static boolean isAdvancedViewOnly(DownloadManager downloadManager) {
        Boolean bl = (Boolean)downloadManager.getUserData("isAdvancedViewOnly");
        if (bl != null) {
            return bl;
        }
        boolean bl2 = true;
        if (!downloadManager.getDownloadState().getFlag(16L)) {
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) {
                bl2 = false;
            } else {
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray;
                URL uRL = tOTorrent.getAnnounceURL();
                if (uRL != null && !(tOTorrentAnnounceURLSetArray = uRL.getHost()).endsWith(AELITIS_HOST_CORE) && !tOTorrentAnnounceURLSetArray.endsWith(VUZE_HOST_CORE)) {
                    bl2 = false;
                }
                if (bl2) {
                    tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
                    block0: for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                        URL[] uRLArray = tOTorrentAnnounceURLSetArray[i].getAnnounceURLs();
                        for (int j = 0; j < uRLArray.length; ++j) {
                            String string = uRLArray[j].getHost();
                            if (string.endsWith(AELITIS_HOST_CORE) || string.endsWith(VUZE_HOST_CORE)) continue;
                            bl2 = false;
                            continue block0;
                        }
                    }
                }
            }
        }
        downloadManager.setUserData("isAdvancedViewOnly", new Boolean(bl2));
        return bl2;
    }

    public static boolean isContentProgressive(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_PROGRESSIVE, 0L) == 1L;
    }

    public static long getContentStreamSpeedBps(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_SPEED, 0L);
    }

    public static long getContentMinimumSpeedBps(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_MIN_SPEED, 102400L);
    }

    public static boolean useEMP(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_USE_EMP, 0L) == 1L;
    }

    public static void setUseEMP(TOTorrent tOTorrent, boolean bl) {
        PlatformTorrentUtils.setContentMapLong(tOTorrent, TOR_AZ_PROP_USE_EMP, bl ? 1L : 0L);
    }

    public static void setFileMetaData(TOTorrent tOTorrent, Map map) {
        PlatformTorrentUtils.setContentMapMap(tOTorrent, TOR_AZ_PROP_FILE_METADATA, map);
    }

    public static Map getFileMetaData(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapMap(tOTorrent, TOR_AZ_PROP_FILE_METADATA);
    }

    public static long getExpiresOn(TOTorrent tOTorrent) {
        Map map = PlatformTorrentUtils.getContentMap(tOTorrent);
        Long l = (Long)map.get(TOR_AZ_PROP_EXPIRESON);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static int getContentPrimaryFileIndex(TOTorrent tOTorrent) {
        return (int)PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_PRIMARY_FILE, -1L);
    }

    private static long getContentVideoWidth(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_VIDEO_WIDTH, -1L);
    }

    private static long getContentVideoHeight(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_VIDEO_HEIGHT, -1L);
    }

    public static long getContentVideoRunningTime(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_VIDEO_RUNNINGTIME, -1L);
    }

    public static long getContentDurationMillis(TOTorrent tOTorrent) {
        return PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_DURATION_MILLIS, -1L);
    }

    public static void setContentDurationMillis(TOTorrent tOTorrent, long l) {
        PlatformTorrentUtils.setContentMapLong(tOTorrent, TOR_AZ_PROP_DURATION_MILLIS, l);
    }

    public static int[] getContentVideoResolution(TOTorrent tOTorrent) {
        long l = PlatformTorrentUtils.getContentVideoWidth(tOTorrent);
        if (l <= 0L) {
            return null;
        }
        long l2 = PlatformTorrentUtils.getContentVideoHeight(tOTorrent);
        if (l2 <= 0L) {
            return null;
        }
        return new int[]{(int)l, (int)l2};
    }

    public static void log(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.MD");
        aEDiagnosticsLogger.log(string);
        if (DEBUG_CACHING) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    public static void log(TOTorrent tOTorrent, String string) {
        String string2 = "";
        try {
            string2 = tOTorrent.getHashWrapper().toBase32String();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformTorrentUtils.log(string2 + "] " + string);
    }

    public static boolean embeddedPlayerAvail() {
        if (embeddedPlayerAvail) {
            return true;
        }
        try {
            PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", true);
            if (pluginInterface != null) {
                embeddedPlayerAvail = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return embeddedPlayerAvail;
    }

    public static String getContentTitle2(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return null;
        }
        String string = downloadManager.getDownloadState().getDisplayName();
        if ((string == null || string.length() == 0) && (string = PlatformTorrentUtils.getContentTitle(downloadManager.getTorrent())) == null) {
            string = downloadManager.getDisplayName();
        }
        return string;
    }

    public static void setHasBeenOpened(DownloadManager downloadManager, boolean bl) {
        TOTorrent tOTorrent = downloadManager.getTorrent();
        if (tOTorrent == null) {
            return;
        }
        if (bl == PlatformTorrentUtils.getHasBeenOpened(downloadManager)) {
            return;
        }
        PlatformTorrentUtils.setContentMapLong(tOTorrent, TOR_AZ_PROP_OPENED, bl ? 1L : 0L);
        PlatformTorrentUtils.writeTorrentIfExists(tOTorrent);
        Object[] objectArray = hasBeenOpenedListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                HasBeenOpenedListener hasBeenOpenedListener = (HasBeenOpenedListener)objectArray[i];
                hasBeenOpenedListener.hasBeenOpenedChanged(downloadManager, bl);
                continue;
            }
            catch (Exception exception) {
                Debug.out(exception);
            }
        }
    }

    public static boolean getHasBeenOpened(DownloadManager downloadManager) {
        boolean bl;
        TOTorrent tOTorrent = downloadManager.getTorrent();
        if (tOTorrent == null) {
            return true;
        }
        boolean bl2 = bl = PlatformTorrentUtils.getContentMapLong(tOTorrent, TOR_AZ_PROP_OPENED, -1L) > 0L;
        return bl || PlatformTorrentUtils.isAdvancedViewOnly(downloadManager);
    }

    public static void addHasBeenOpenedListener(HasBeenOpenedListener hasBeenOpenedListener) {
        hasBeenOpenedListeners.add(hasBeenOpenedListener);
    }
}

