/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.util.JSONUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SHA1Simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionResultImpl
implements SubscriptionResult {
    private final SubscriptionHistoryImpl history;
    private byte[] key1;
    private byte[] key2;
    private boolean read;
    private boolean deleted;
    private String result_json;

    protected SubscriptionResultImpl(SubscriptionHistoryImpl subscriptionHistoryImpl, Result result) {
        Object object;
        this.history = subscriptionHistoryImpl;
        Map map = result.toJSONMap();
        this.result_json = JSONUtils.encodeToJSON(map);
        this.read = false;
        String string = result.getEngine().getId() + ":" + result.getName();
        try {
            object = new SHA1Simple().calculateHash(string.getBytes("UTF-8"));
            this.key1 = new byte[10];
            System.arraycopy(object, 0, this.key1, 0, 10);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        object = result.getUID();
        if (object != null && ((String)object).length() > 0) {
            String string2 = result.getEngine().getId() + ":" + (String)object;
            try {
                byte[] byArray = new SHA1Simple().calculateHash(string2.getBytes("UTF-8"));
                this.key2 = new byte[10];
                System.arraycopy(byArray, 0, this.key2, 0, 10);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl subscriptionHistoryImpl, Map map) {
        this.history = subscriptionHistoryImpl;
        this.key1 = (byte[])map.get("key");
        this.key2 = (byte[])map.get("key2");
        this.read = ((Long)map.get("read")).intValue() == 1;
        Long l = (Long)map.get("deleted");
        if (l != null) {
            this.deleted = true;
        } else {
            try {
                this.result_json = new String((byte[])map.get("result_json"), "UTF-8");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected boolean updateFrom(SubscriptionResultImpl subscriptionResultImpl) {
        if (this.deleted) {
            return false;
        }
        if (this.getJSON().equals(subscriptionResultImpl.getJSON())) {
            return false;
        }
        this.key2 = subscriptionResultImpl.getKey2();
        this.result_json = subscriptionResultImpl.getJSON();
        return true;
    }

    @Override
    public String getID() {
        return Base32.encode(this.key1);
    }

    protected byte[] getKey1() {
        return this.key1;
    }

    protected byte[] getKey2() {
        return this.key2;
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public void setRead(boolean bl) {
        if (this.read != bl) {
            this.read = bl;
            this.history.updateResult(this);
        }
    }

    protected void setReadInternal(boolean bl) {
        this.read = bl;
    }

    @Override
    public void delete() {
        if (!this.deleted) {
            this.deleted = true;
            this.history.updateResult(this);
        }
    }

    protected void deleteInternal() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    protected Map toBEncodedMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", this.key1);
        if (this.key2 != null) {
            hashMap.put("key2", this.key2);
        }
        hashMap.put("read", new Long(this.read ? 1L : 0L));
        if (this.deleted) {
            hashMap.put("deleted", new Long(1L));
        } else {
            try {
                hashMap.put("result_json", this.result_json.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return hashMap;
    }

    @Override
    public Map toJSONMap() {
        Map map = JSONUtils.decodeJSON(this.result_json);
        map.put("subs_is_read", new Boolean(this.read));
        map.put("subs_id", this.getID());
        Result.adjustRelativeTerms(map);
        String string = (String)map.get("l");
        if (string != null) {
            string = DisplayFormatters.trimDigits(string, 3);
            map.put("l", string);
        }
        return map;
    }

    private String getJSON() {
        return this.result_json;
    }

    @Override
    public String getDownloadLink() {
        Map map = this.toJSONMap();
        String string = (String)map.get("dbl");
        if (string == null) {
            string = (String)map.get("dl");
        }
        return string;
    }

    @Override
    public String getPlayLink() {
        return (String)this.toJSONMap().get("pl");
    }

    public String getAssetHash() {
        return (String)this.toJSONMap().get("h");
    }

    @Override
    public Map<Integer, Object> toPropertyMap() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Map map = this.toJSONMap();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        String string7 = (String)map.get("n");
        hashMap.put(20, this.getID());
        hashMap.put(1, string7);
        String string8 = (String)map.get("ts");
        if (string8 != null) {
            hashMap.put(2, new Date(Long.parseLong(string8)));
        }
        if ((string6 = (String)map.get("lb")) != null) {
            hashMap.put(3, Long.parseLong(string6));
        }
        if ((string5 = (String)map.get("dbl")) == null) {
            string5 = (String)map.get("dl");
        }
        if (string5 != null) {
            hashMap.put(12, string5);
        }
        if ((string4 = (String)map.get("h")) != null) {
            hashMap.put(21, string4);
        }
        if ((string3 = (String)map.get("s")) != null) {
            hashMap.put(5, Long.parseLong(string3));
        }
        if ((string2 = (String)map.get("p")) != null) {
            hashMap.put(4, Long.parseLong(string2));
        }
        if ((string = (String)map.get("r")) != null) {
            hashMap.put(17, (long)(100.0f * Float.parseFloat(string)));
        }
        return hashMap;
    }
}

