/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class SubscriptionUtils {
    public static SubscriptionDownloadDetails[] getAllCachedDownloadDetails(AzureusCore azureusCore) {
        List list = azureusCore.getGlobalManager().getDownloadManagers();
        ArrayList<SubscriptionDownloadDetails> arrayList = new ArrayList<SubscriptionDownloadDetails>();
        SubscriptionManager subscriptionManager = SubscriptionManagerFactory.getSingleton();
        for (int i = 0; i < list.size(); ++i) {
            DownloadManager downloadManager = (DownloadManager)list.get(i);
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) continue;
            try {
                Subscription[] subscriptionArray = subscriptionManager.getKnownSubscriptions(tOTorrent.getHash());
                if (subscriptionArray == null || subscriptionArray.length <= 0) continue;
                arrayList.add(new SubscriptionDownloadDetails(downloadManager, subscriptionArray));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList.toArray(new SubscriptionDownloadDetails[arrayList.size()]);
    }

    public static class SubscriptionDownloadDetails {
        private DownloadManager download;
        private Subscription[] subscriptions;

        protected SubscriptionDownloadDetails(DownloadManager downloadManager, Subscription[] subscriptionArray) {
            this.download = downloadManager;
            this.subscriptions = subscriptionArray;
        }

        public DownloadManager getDownload() {
            return this.download;
        }

        public Subscription[] getSubscriptions() {
            return this.subscriptions;
        }
    }
}

