/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderDefinitions;
import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class BTPeerIDByteDecoder {
    static final boolean LOG_UNKNOWN;
    private static HashSet logged_discrepancies;
    private static AEDiagnosticsLogger logger;
    static boolean client_logging_allowed;
    private static HashSet logged_ids;

    private static String logUnknownClient0(byte[] byArray) throws IOException {
        String string = new String(byArray, 0, 20, "ISO-8859-1");
        string = string.replace('\f', ' ');
        string = string.replace('\n', ' ');
        return "[" + string + "] " + ByteFormatter.encodeString(byArray) + " ";
    }

    private static String asUTF8ByteString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            return ByteFormatter.encodeString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static void logClientDiscrepancy(String string, String string2, String string3, String string4, byte[] byArray) {
        if (!client_logging_allowed) {
            return;
        }
        String string5 = string3 + " [" + string4 + "]: ";
        string5 = string5 + "\"" + string + "\" / \"" + string2 + "\" ";
        string5 = string5 + "[" + BTPeerIDByteDecoder.asUTF8ByteString(string2) + "]";
        boolean bl = Constants.isCVSVersion();
        if ((bl || LOG_UNKNOWN) && !logged_discrepancies.add(string5)) {
            return;
        }
        if (byArray != null) {
            string5 = string5 + ", Peer ID: " + ByteFormatter.encodeString(byArray);
        }
        if (bl) {
            Debug.outNoStack("Conflicting peer identification: " + string5);
        }
        if (!LOG_UNKNOWN) {
            return;
        }
        BTPeerIDByteDecoder.logClientDiscrepancyToFile(string5);
    }

    private static synchronized void logClientDiscrepancyToFile(String string) {
        if (logger == null) {
            logger = AEDiagnostics.getLogger("clientid");
        }
        try {
            logger.log(string);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    static void logUnknownClient(byte[] byArray) {
        BTPeerIDByteDecoder.logUnknownClient(byArray, true);
    }

    static void logUnknownClient(byte[] byArray, boolean bl) {
        boolean bl2;
        if (!client_logging_allowed) {
            return;
        }
        boolean bl3 = bl2 = bl && Constants.isCVSVersion();
        if ((bl2 || LOG_UNKNOWN) && !logged_ids.add(BTPeerIDByteDecoder.makePeerIDReadableAndUsable(byArray))) {
            return;
        }
        if (bl2) {
            Debug.outNoStack("Unable to decode peer correctly - peer ID bytes: " + BTPeerIDByteDecoder.makePeerIDReadableAndUsable(byArray));
        }
        if (!LOG_UNKNOWN) {
            return;
        }
        try {
            BTPeerIDByteDecoder.logClientDiscrepancyToFile(BTPeerIDByteDecoder.logUnknownClient0(byArray));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    static void logUnknownClient(String string) {
        try {
            BTPeerIDByteDecoder.logUnknownClient(string.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static String decode0(byte[] byArray) {
        Object object;
        String string = MessageText.getString("PeerSocket.unknown");
        String string2 = MessageText.getString("PeerSocket.fake_client");
        String string3 = MessageText.getString("PeerSocket.bad_peer_id");
        String string4 = null;
        try {
            string4 = new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        String string5 = null;
        if (BTPeerIDByteDecoderUtils.isPossibleSpoofClient(string4)) {
            string5 = BTPeerIDByteDecoder.decodeBitSpiritClient(string4, byArray);
            if (string5 != null) {
                return string5;
            }
            string5 = BTPeerIDByteDecoder.decodeBitCometClient(string4, byArray);
            if (string5 != null) {
                return string5;
            }
            return "BitSpirit? (" + string3 + ")";
        }
        if (BTPeerIDByteDecoderUtils.isAzStyle(string4) && (string5 = BTPeerIDByteDecoderDefinitions.getAzStyleClientName(string4)) != null) {
            String string6 = BTPeerIDByteDecoderDefinitions.getAzStyleClientVersion(string5, string4);
            if (string5.startsWith("ZipTorrent") && string4.startsWith("bLAde", 8)) {
                String string7 = string6 == null ? string5 : string6;
                return string + " [" + string2 + ": " + string7 + "]";
            }
            if ("\u00b5Torrent 6.0.0 Beta".equals(string6)) {
                return "Mainline 6.0 Beta";
            }
            if (string5.startsWith("libTorrent (Rakshasa)")) {
                String string8 = string6 == null ? string5 : string6;
                return string8 + " / rTorrent*";
            }
            if (string6 != null) {
                return string6;
            }
            return string5;
        }
        if (BTPeerIDByteDecoderUtils.isShadowStyle(string4) && (string5 = BTPeerIDByteDecoderDefinitions.getShadowStyleClientName(string4)) != null) {
            String string9 = BTPeerIDByteDecoderUtils.getShadowStyleVersionNumber(string4);
            if (string9 != null) {
                return string5 + " " + string9;
            }
            return string5;
        }
        string5 = BTPeerIDByteDecoderDefinitions.getMainlineStyleClientName(string4);
        if (string5 != null && (object = BTPeerIDByteDecoderUtils.getMainlineStyleVersionNumber(string4)) != null) {
            String string10 = string5 + " " + (String)object;
            return string10;
        }
        string5 = BTPeerIDByteDecoder.decodeBitSpiritClient(string4, byArray);
        if (string5 != null) {
            return string5;
        }
        string5 = BTPeerIDByteDecoder.decodeBitCometClient(string4, byArray);
        if (string5 != null) {
            return string5;
        }
        object = BTPeerIDByteDecoderDefinitions.getSubstringStyleClient(string4);
        if (object != null) {
            string5 = ((BTPeerIDByteDecoderDefinitions.ClientData)object).client_name;
            String string11 = BTPeerIDByteDecoderDefinitions.getSubstringStyleClientVersion((BTPeerIDByteDecoderDefinitions.ClientData)object, string4, byArray);
            if (string11 != null) {
                return string11;
            }
            return string5;
        }
        string5 = BTPeerIDByteDecoder.identifyAwkwardClient(byArray);
        if (string5 != null) {
            return string5;
        }
        return null;
    }

    public static String decode(byte[] byArray) {
        String string;
        if (byArray.length > 0) {
            try {
                string = BTPeerIDByteDecoder.decode0(byArray);
                if (string != null) {
                    return string;
                }
            }
            catch (Throwable throwable) {
                Debug.out("Failed to decode peer id " + ByteFormatter.encodeString(byArray) + ": " + Debug.getNestedExceptionMessageAndStack(throwable));
            }
            try {
                string = new String(byArray, "ISO-8859-1");
                boolean bl = BTPeerIDByteDecoderUtils.isAzStyle(string);
                boolean bl2 = BTPeerIDByteDecoderUtils.isShadowStyle(string);
                BTPeerIDByteDecoder.logUnknownClient(byArray, !bl && !bl2);
                if (bl) {
                    return BTPeerIDByteDecoderDefinitions.formatUnknownAzStyleClient(string);
                }
                if (bl2) {
                    return BTPeerIDByteDecoderDefinitions.formatUnknownShadowStyleClient(string);
                }
            }
            catch (Throwable throwable) {
                Debug.out("Failed to decode peer id " + ByteFormatter.encodeString(byArray) + ": " + Debug.getNestedExceptionMessageAndStack(throwable));
            }
        }
        string = BTPeerIDByteDecoder.getPrintablePeerID(byArray);
        return MessageText.getString("PeerSocket.unknown") + " [" + string + "]";
    }

    public static String identifyAwkwardClient(byte[] byArray) {
        byte by;
        byte by2 = 0;
        by2 = 20;
        for (by = 0; by < 20; ++by) {
            if (byArray[by] == 0) continue;
            by2 = by;
            break;
        }
        if (by2 == 0) {
            int n;
            by = 1;
            for (n = 0; n < 16; ++n) {
                if (byArray[n] != 0) continue;
                by = 0;
                break;
            }
            if (by != 0) {
                for (n = 16; n < 20; ++n) {
                    if (byArray[n] == (byArray[n % 16] ^ byArray[15 - n % 16])) continue;
                    by = 0;
                    break;
                }
                if (by != 0) {
                    return "Shareaza";
                }
            }
        }
        by = 3;
        if (by2 == 9 && byArray[9] == by && byArray[10] == by && byArray[11] == by) {
            return "Snark";
        }
        if (by2 == 12 && byArray[12] == 97 && byArray[13] == 97) {
            return "Experimental 3.2.1b2";
        }
        if (by2 == 12 && byArray[12] == 0 && byArray[13] == 0) {
            return "Experimental 3.1";
        }
        if (by2 == 12) {
            return "Mainline";
        }
        return null;
    }

    private static String decodeBitSpiritClient(String string, byte[] byArray) {
        if (!string.substring(2, 4).equals("BS")) {
            return null;
        }
        String string2 = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(byArray[1]);
        if ("0".equals(string2)) {
            string2 = "1";
        }
        return "BitSpirit v" + string2;
    }

    private static String decodeBitCometClient(String string, byte[] byArray) {
        String string2 = null;
        if (string.startsWith("exbc")) {
            string2 = "";
        } else if (string.startsWith("FUTB")) {
            string2 = "(Solidox Mod) ";
        } else if (string.startsWith("xUTB")) {
            string2 = "(Mod 2) ";
        } else {
            return null;
        }
        boolean bl = string.substring(6, 10).equals("LORD");
        String string3 = bl ? "BitLord " : "BitComet ";
        String string4 = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(byArray[4]);
        int n = bl && !string4.equals("0") ? 1 : 2;
        return string3 + string2 + string4 + "." + BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(byArray[5], n);
    }

    protected static String getPrintablePeerID(byte[] byArray) {
        return BTPeerIDByteDecoder.getPrintablePeerID(byArray, '-');
    }

    protected static String getPrintablePeerID(byte[] byArray, char c) {
        String string = "";
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        try {
            for (int i = 0; i < byArray2.length; ++i) {
                int n = 0xFF & byArray2[i];
                if (n >= 32 && n <= 127) continue;
                byArray2[i] = (byte)c;
            }
            string = new String(byArray2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private static String makePeerIDReadableAndUsable(byte[] byArray) {
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            if (n >= 32 && n <= 127 && n != 10 && n != 9 && n != 13) continue;
            bl = false;
            break;
        }
        if (bl) {
            try {
                return new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "";
            }
        }
        return ByteFormatter.encodeString(byArray);
    }

    static byte[] peerIDStringToBytes(String string) throws Exception {
        if (string.length() > 40) {
            string = string.replaceAll("[ ]", "");
        }
        byte[] byArray = null;
        if (string.length() == 40) {
            byArray = ByteFormatter.decodeString(string);
            String string2 = BTPeerIDByteDecoder.makePeerIDReadableAndUsable(byArray);
            if (!string.equals(string2)) {
                throw new RuntimeException("Use alternative format for peer ID - from " + string + " to " + string2);
            }
        } else if (string.length() == 20) {
            byArray = string.getBytes("ISO-8859-1");
        } else {
            throw new IllegalArgumentException(string);
        }
        return byArray;
    }

    private static void assertDecode(String string, String string2) throws Exception {
        BTPeerIDByteDecoder.assertDecode(string, BTPeerIDByteDecoder.peerIDStringToBytes(string2));
    }

    private static void assertDecode(String string, byte[] byArray) throws Exception {
        String string2 = BTPeerIDByteDecoder.getPrintablePeerID(byArray, '*');
        System.out.println("   Peer ID: " + string2 + "   Client: " + string);
        String string3 = BTPeerIDByteDecoder.decode(byArray);
        if (string.equals(string3)) {
            return;
        }
        throw new RuntimeException("assertion failure - expected \"" + string + "\", got \"" + string3 + "\": " + string2);
    }

    public static void main(String[] stringArray) throws Exception {
        client_logging_allowed = false;
        String string = MessageText.getString("PeerSocket.fake_client");
        String string2 = MessageText.getString("PeerSocket.unknown");
        String string3 = MessageText.getString("PeerSocket.bad_peer_id");
        System.out.println("Testing AZ style clients...");
        BTPeerIDByteDecoder.assertDecode("Ares 2.0.5.3", "-AG2053-Em6o1EmvwLtD");
        BTPeerIDByteDecoder.assertDecode("Ares 1.6.7.0", "-AR1670-3Ql6wM3hgtCc");
        BTPeerIDByteDecoder.assertDecode("Artemis 2.5.2.0", "-AT2520-vEEt0wO6v0cr");
        BTPeerIDByteDecoder.assertDecode("Azureus 2.2.0.0", "-AZ2200-6wfG2wk6wWLc");
        BTPeerIDByteDecoder.assertDecode("BT Next Evolution 1.0.9", "-NE1090002IKyMn4g7Ko");
        BTPeerIDByteDecoder.assertDecode("BitRocket 0.3(32)", "-BR0332-!XVceSn(*KIl");
        BTPeerIDByteDecoder.assertDecode("Mainline 6.0 Beta", "2D555436 3030422D A78DC290 C3F7BDE0 15EC3CC7");
        BTPeerIDByteDecoder.assertDecode("FlashGet 1.80", "2D464730 31383075 F8005782 1359D64B B3DFD265");
        BTPeerIDByteDecoder.assertDecode("GetRight 6.3", "-GR6300-13s3iFKmbArc");
        BTPeerIDByteDecoder.assertDecode("Halite 0.2.9", "-HL0290-xUO*9ugvENUE");
        BTPeerIDByteDecoder.assertDecode("KTorrent 1.1 RC1", "-KT11R1-693649213030");
        BTPeerIDByteDecoder.assertDecode("KTorrent 3.0", "2D4B543330302D006A7139727958377731756A4B");
        BTPeerIDByteDecoder.assertDecode("libTorrent (Rakshasa) 0.11.2 / rTorrent*", "2D6C74304232302D0D739B93E6BE21FEBB557B20");
        BTPeerIDByteDecoder.assertDecode("libtorrent (Rasterbar) 0.13.0", "-LT0D00-eZ0PwaDDr-~v");
        BTPeerIDByteDecoder.assertDecode("linkage 0.1.4", "-LK0140-ATIV~nbEQAMr");
        BTPeerIDByteDecoder.assertDecode("LimeWire", "2D4C57303030312D31E0B3A0B46F7D4E954F4103");
        BTPeerIDByteDecoder.assertDecode("Lphant 3.02", "2D4C5030 3330322D 00383336 35363935 37373030");
        BTPeerIDByteDecoder.assertDecode("Shareaza 2.1.3.2", "2D535A323133322D000000000000000000000000");
        BTPeerIDByteDecoder.assertDecode("SymTorrent 1.17", "-ST0117-01234567890!");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.6", "-TR0006-01234567890!");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.72 (Dev)", "-TR072Z-zihst5yvg22f");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.72", "-TR0072-8vd6hrmp04an");
        BTPeerIDByteDecoder.assertDecode("TuoTu 2.1.0", "-TT210w-dq!nWf~Qcext");
        BTPeerIDByteDecoder.assertDecode("\u00b5Torrent 1.7.0 Beta", "2D555431 3730422D 92844644 1DB0A094 A01C01E5");
        BTPeerIDByteDecoder.assertDecode("\u54c7\u560e (Vagaa) 2.6.4.4", "2D5647323634342D4FD62CDA69E235717E3BB94B");
        BTPeerIDByteDecoder.assertDecode("Wyzo 0.3.0.0", "-WY0300-6huHF5Pr7Vde");
        BTPeerIDByteDecoder.assertDecode("CacheLogic 25.1-26", "-PC251Q-6huHF5Pr7Vde");
        System.out.println();
        System.out.println("Testing Shadow style clients...");
        BTPeerIDByteDecoder.assertDecode("ABC", "A--------YMyoBPXYy2L");
        BTPeerIDByteDecoder.assertDecode("ABC 2.6.9", "413236392D2D2D2D345077199FAEC4A673BECA01");
        BTPeerIDByteDecoder.assertDecode("ABC 3.1", "A310--001v5Gysr4NxNK");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.12", "T03C-----6tYolxhVUFS");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.18", "T03I--008gY6iB6Aq27C");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.9", "T0390----5uL5NvjBe2z");
        BTPeerIDByteDecoder.assertDecode("Tribler 1", "R100--003hR6s07XWcov");
        BTPeerIDByteDecoder.assertDecode("Tribler 3.7", "R37---003uApHy851-Pq");
        System.out.println();
        System.out.println("Testing simple substring clients...");
        BTPeerIDByteDecoder.assertDecode("Azureus 1", "417A7572 65757300 00000000 000000A0 76F0AEF7");
        BTPeerIDByteDecoder.assertDecode("Azureus 2.0.3.2", "2D2D2D2D2D417A757265757354694E7A2A6454A7");
        BTPeerIDByteDecoder.assertDecode("G3 Torrent", "2D473341 6E6F6E79 6D6F7573 70E8D9CB 30250AD4");
        BTPeerIDByteDecoder.assertDecode("Hurricane Electric", "6172636C696768742E68652EA5860C157A5ADC35");
        BTPeerIDByteDecoder.assertDecode("Pando", "Pando-6B511B691CAC2E");
        BTPeerIDByteDecoder.assertDecode("\u00b5Torrent 1.7.0 RC", "2D55543137302D00AF8BC5ACCC4631481EB3EB60");
        System.out.println();
        System.out.println("Testing versioned substring clients...");
        BTPeerIDByteDecoder.assertDecode("Bitlet 0.1", "4269744C657430319AEA4E02A09E318D70CCF47D");
        BTPeerIDByteDecoder.assertDecode("BitsOnWheels", "-BOWP05-EPICNZOGQPHP");
        BTPeerIDByteDecoder.assertDecode("Burst! 1.1.3", "Mbrst1-1-32e3c394b43");
        BTPeerIDByteDecoder.assertDecode("Opera (Build 7685)", "OP7685f2c1495b1680bf");
        BTPeerIDByteDecoder.assertDecode("Opera (Build 10063)", "O100634008270e29150a");
        BTPeerIDByteDecoder.assertDecode("Rufus 0.6.9", "00455253 416E6F6E 796D6F75 7382BE42 75024AE3");
        BTPeerIDByteDecoder.assertDecode("BitTorrent DNA 1.0", "444E413031303030DD01C9B2DA689E6E02803E91");
        BTPeerIDByteDecoder.assertDecode("BTuga Revolution 2.1", "BTM21abcdefghijklmno");
        BTPeerIDByteDecoder.assertDecode("AllPeers 0.70rc30", "4150302E3730726333302D3E3EB87B31F241DBFE");
        BTPeerIDByteDecoder.assertDecode("External Webseed", "45787420EC7CC30033D7801FEEB713FBB0557AC4");
        BTPeerIDByteDecoder.assertDecode("QVOD (Build 0054)", "QVOD00541234567890AB");
        BTPeerIDByteDecoder.assertDecode("Top-BT 1.0.0", "TB100----abcdefghijk");
        System.out.println();
        System.out.println("Testing BitComet/Lord/Spirit clients...");
        BTPeerIDByteDecoder.assertDecode("BitComet 0.56", "6578626300387A4463102D6E9AD6723B339F35A9");
        BTPeerIDByteDecoder.assertDecode("BitLord 0.56", "6578626300384C4F52443200048ECED57BD71028");
        BTPeerIDByteDecoder.assertDecode("BitSpirit? (" + string3 + ")", "4D342D302D322D2D6898D9D0CAF25E4555445030");
        BTPeerIDByteDecoder.assertDecode("BitSpirit v2", "000242539B7ED3E058A8384AA748485454504254");
        BTPeerIDByteDecoder.assertDecode("BitSpirit v3", "00034253 07248896 44C59530 8A5FF2CA 55445030");
        System.out.println();
        System.out.println("Testing new mainline style clients...");
        BTPeerIDByteDecoder.assertDecode("Mainline 5.0.7", "M5-0-7--9aa757efd5be");
        BTPeerIDByteDecoder.assertDecode("Amazon AWS S3", "S3-1-0-0--0123456789");
        System.out.println();
        System.out.println("Testing various specialised clients...");
        BTPeerIDByteDecoder.assertDecode("Mainline", "0000000000000000000000004C53441933104277");
        BTPeerIDByteDecoder.assertDecode(string2 + " [" + string + ": ZipTorrent 1.6.0.0]", "-ZT1600-bLAdeY9rdjbe");
        System.out.println();
        System.out.println("Testing unknown (random byte?) clients...");
        BTPeerIDByteDecoder.assertDecode(string2 + " [--------1}-/---A---<]", "0000000000000000317DA32F831FF041A515FE3C");
        BTPeerIDByteDecoder.assertDecode(string2 + " [------- --  ------@(]", "000000DF05020020100020200008000000004028");
        BTPeerIDByteDecoder.assertDecode(string2 + " [-----------D-y-I--aO]", "0000000000000000F106CE44F179A2498FAC614F");
        BTPeerIDByteDecoder.assertDecode(string2 + " [--c--_-5-\\----t-#---]", "E7F163BB0E5FCD35005C09A11BC274C42385A1A0");
        System.out.println();
        System.out.println("Testing unknown AZ style clients...");
        String string4 = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"BD", "0.3.0.0"});
        BTPeerIDByteDecoder.assertDecode(string4, "-BD0300-1SGiRZ8uWpWH");
        string4 = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"wF", "2.2.0.0"});
        BTPeerIDByteDecoder.assertDecode(string4, "2D7746323230302D9DFF296B56AFC2DF751C609C");
        string4 = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"X1", "0.0.6.4"});
        BTPeerIDByteDecoder.assertDecode(string4, "2D5831303036342D12FB8A5B954153A114267F1F");
        string4 = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"bF", "2q00"});
        BTPeerIDByteDecoder.assertDecode(string4, "2D6246327130302D9DFF296B56AFC2DF751C609C");
        System.out.println();
        System.out.println("Testing unknown Shadow style clients...");
        String string5 = MessageText.getString("PeerSocket.unknown_shadow_style", new String[]{"B", "1.2"});
        BTPeerIDByteDecoder.assertDecode(string5, "B12------xgTofhetSVQ");
        System.out.println();
        System.out.println("Done.");
    }

    static {
        String string = System.getProperty("log.unknown.peerids");
        LOG_UNKNOWN = string == null || string.equals("1");
        logged_discrepancies = new HashSet();
        logger = null;
        client_logging_allowed = true;
        logged_ids = new HashSet();
    }
}

